/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.ml.impl.logs;

import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.platform.ml.impl.logs.ConverterObjectDescription;
import com.intellij.platform.ml.logs.MLSessionComponentLogger;
import com.intellij.platform.ml.logs.MLSessionComponentRegister;
import com.intellij.platform.ml.logs.schema.ObjectDescription;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001\fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0010\u0010\t\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/platform/ml/impl/logs/ComponentAsFusEventRegister;", "Lcom/intellij/platform/ml/logs/MLSessionComponentRegister;", "baseEventGroup", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "(Lcom/intellij/internal/statistic/eventLog/EventLogGroup;)V", "registerComponent", "Lcom/intellij/platform/ml/logs/MLSessionComponentLogger;", "name", "", "eventFields", "", "Lcom/intellij/platform/ml/logs/schema/EventField;", "Logger", "intellij.platform.ml.impl"})
@ApiStatus.Internal
public final class ComponentAsFusEventRegister
implements MLSessionComponentRegister {
    @NotNull
    private final EventLogGroup baseEventGroup;

    public ComponentAsFusEventRegister(@NotNull EventLogGroup baseEventGroup) {
        Intrinsics.checkNotNullParameter((Object)baseEventGroup, (String)"baseEventGroup");
        this.baseEventGroup = baseEventGroup;
    }

    @NotNull
    public MLSessionComponentLogger registerComponent(@NotNull String name, @NotNull List<? extends com.intellij.platform.ml.logs.schema.EventField<?>> eventFields) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(eventFields, (String)"eventFields");
        ConverterObjectDescription objectDescription = new ConverterObjectDescription(new ObjectDescription(eventFields));
        EventField[] eventFieldArray = objectDescription.getFields();
        VarargEventId varargEventId = this.baseEventGroup.registerVarargEvent(name, null, Arrays.copyOf(eventFieldArray, eventFieldArray.length));
        return new Logger(varargEventId, objectDescription);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u0007\u001a\u00020\b2\u0010\u0010\t\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\nH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/platform/ml/impl/logs/ComponentAsFusEventRegister$Logger;", "Lcom/intellij/platform/ml/logs/MLSessionComponentLogger;", "varargEventId", "Lcom/intellij/internal/statistic/eventLog/events/VarargEventId;", "objectDescription", "Lcom/intellij/platform/ml/impl/logs/ConverterObjectDescription;", "(Lcom/intellij/internal/statistic/eventLog/events/VarargEventId;Lcom/intellij/platform/ml/impl/logs/ConverterObjectDescription;)V", "log", "", "eventPairs", "", "Lcom/intellij/platform/ml/logs/schema/EventPair;", "intellij.platform.ml.impl"})
    @SourceDebugExtension(value={"SMAP\nComponentAsFusEventRegister.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComponentAsFusEventRegister.kt\ncom/intellij/platform/ml/impl/logs/ComponentAsFusEventRegister$Logger\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,258:1\n37#2,2:259\n*S KotlinDebug\n*F\n+ 1 ComponentAsFusEventRegister.kt\ncom/intellij/platform/ml/impl/logs/ComponentAsFusEventRegister$Logger\n*L\n59#1:259,2\n*E\n"})
    private static final class Logger
    implements MLSessionComponentLogger {
        @NotNull
        private final VarargEventId varargEventId;
        @NotNull
        private final ConverterObjectDescription objectDescription;

        public Logger(@NotNull VarargEventId varargEventId, @NotNull ConverterObjectDescription objectDescription) {
            Intrinsics.checkNotNullParameter((Object)varargEventId, (String)"varargEventId");
            Intrinsics.checkNotNullParameter((Object)((Object)objectDescription), (String)"objectDescription");
            this.varargEventId = varargEventId;
            this.objectDescription = objectDescription;
        }

        public void log(@NotNull List<? extends com.intellij.platform.ml.logs.schema.EventPair<?>> eventPairs) {
            Intrinsics.checkNotNullParameter(eventPairs, (String)"eventPairs");
            List<EventPair<?>> ijEventPairs = this.objectDescription.buildEventPairs(eventPairs);
            Collection $this$toTypedArray$iv = ijEventPairs;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            EventPair[] eventPairArray = thisCollection$iv.toArray(new EventPair[0]);
            this.varargEventId.log(Arrays.copyOf(eventPairArray, eventPairArray.length));
        }
    }
}

