/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.embedding;

import com.intellij.embedding.MasqueradingLexer;
import com.intellij.embedding.TemplateMasqueradingLexer;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.impl.DelegateMarker;
import com.intellij.lang.impl.PsiBuilderAdapter;
import com.intellij.lang.impl.PsiBuilderImpl;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MasqueradingPsiBuilderAdapter
extends PsiBuilderAdapter {
    private static final Logger LOG = Logger.getInstance(MasqueradingPsiBuilderAdapter.class);
    private List<MyShiftedToken> myShrunkSequence;
    private CharSequence myShrunkCharSequence;
    private int myLexPosition;
    private final PsiBuilderImpl myBuilderDelegate;
    private final MasqueradingLexer myLexer;

    public MasqueradingPsiBuilderAdapter(@NotNull PsiBuilder delegate) {
        if (delegate == null) {
            MasqueradingPsiBuilderAdapter.$$$reportNull$$$0(0);
        }
        super(delegate);
        LOG.assertTrue(this.myDelegate instanceof PsiBuilderImpl);
        this.myBuilderDelegate = (PsiBuilderImpl)this.myDelegate;
        LOG.assertTrue(this.myBuilderDelegate.getLexer() instanceof MasqueradingLexer);
        this.myLexer = (MasqueradingLexer)this.myBuilderDelegate.getLexer();
        this.initShrunkSequence();
    }

    public MasqueradingPsiBuilderAdapter(@NotNull Project project2, @NotNull ParserDefinition parserDefinition, @NotNull MasqueradingLexer lexer, @NotNull ASTNode chameleon, @NotNull CharSequence text2) {
        if (project2 == null) {
            MasqueradingPsiBuilderAdapter.$$$reportNull$$$0(1);
        }
        if (parserDefinition == null) {
            MasqueradingPsiBuilderAdapter.$$$reportNull$$$0(2);
        }
        if (lexer == null) {
            MasqueradingPsiBuilderAdapter.$$$reportNull$$$0(3);
        }
        if (chameleon == null) {
            MasqueradingPsiBuilderAdapter.$$$reportNull$$$0(4);
        }
        if (text2 == null) {
            MasqueradingPsiBuilderAdapter.$$$reportNull$$$0(5);
        }
        this((PsiBuilder)new PsiBuilderImpl(project2, parserDefinition, (Lexer)lexer, chameleon, text2));
    }

    @NotNull
    public CharSequence getOriginalText() {
        CharSequence charSequence = this.myShrunkCharSequence;
        if (charSequence == null) {
            MasqueradingPsiBuilderAdapter.$$$reportNull$$$0(6);
        }
        return charSequence;
    }

    public void advanceLexer() {
        ++this.myLexPosition;
        this.skipWhitespace();
        this.synchronizePositions(false);
    }

    private void synchronizePositions(boolean exact) {
        int delegatePosition;
        PsiBuilder delegate = this.getDelegate();
        if (this.myLexPosition >= this.myShrunkSequence.size() || delegate.eof()) {
            this.myLexPosition = this.myShrunkSequence.size();
            while (!delegate.eof()) {
                delegate.advanceLexer();
            }
            return;
        }
        if (delegate.getCurrentOffset() > this.myShrunkSequence.get((int)this.myLexPosition).realStart) {
            LOG.error("delegate is ahead of my builder!", new Attachment[]{new Attachment("offset = " + delegate.getCurrentOffset(), this.getOriginalText().toString()), new Attachment("myShrunkSequence", this.myShrunkSequence.toString())});
            return;
        }
        int keepUpPosition = this.getKeepUpPosition(exact);
        while (!delegate.eof() && (delegatePosition = delegate.getCurrentOffset()) < keepUpPosition) {
            delegate.advanceLexer();
        }
    }

    private int getKeepUpPosition(boolean exact) {
        int lexPosition;
        if (exact) {
            return this.myShrunkSequence.get((int)this.myLexPosition).realStart;
        }
        for (lexPosition = this.myLexPosition; lexPosition > 0 && (this.myShrunkSequence.get((int)(lexPosition - 1)).shrunkStart == this.myShrunkSequence.get((int)lexPosition).shrunkStart || this.isWhiteSpaceOnPos(lexPosition - 1)); --lexPosition) {
        }
        if (lexPosition == 0) {
            return this.myShrunkSequence.get((int)lexPosition).realStart;
        }
        return this.myShrunkSequence.get((int)(lexPosition - 1)).realStart + 1;
    }

    public IElementType lookAhead(int steps) {
        if (this.eof()) {
            return null;
        }
        int cur = this.myLexPosition;
        while (steps > 0) {
            ++cur;
            while (cur < this.myShrunkSequence.size() && this.isWhiteSpaceOnPos(cur)) {
                ++cur;
            }
            --steps;
        }
        return cur < this.myShrunkSequence.size() ? this.myShrunkSequence.get((int)cur).elementType : null;
    }

    public IElementType rawLookup(int steps) {
        int cur = this.myLexPosition + steps;
        return cur >= 0 && cur < this.myShrunkSequence.size() ? this.myShrunkSequence.get((int)cur).elementType : null;
    }

    public void rawAdvanceLexer(int steps) {
        if (steps < 0) {
            throw new IllegalArgumentException("Steps must be a positive integer - lexer can only be advanced. Use Marker.rollbackTo if you want to rollback PSI building.");
        }
        if (steps == 0) {
            return;
        }
        this.myLexPosition += steps;
        if (this.myLexPosition > this.myShrunkSequence.size() || this.myLexPosition < 0) {
            this.myLexPosition = this.myShrunkSequence.size();
        }
        this.skipWhitespace();
        this.synchronizePositions(false);
    }

    public int rawTokenTypeStart(int steps) {
        int cur = this.myLexPosition + steps;
        if (cur < 0) {
            return -1;
        }
        if (cur >= this.myShrunkSequence.size()) {
            return this.getOriginalText().length();
        }
        return this.myShrunkSequence.get((int)cur).shrunkStart;
    }

    public int rawTokenIndex() {
        return this.myLexPosition;
    }

    public int getCurrentOffset() {
        return this.myLexPosition < this.myShrunkSequence.size() ? this.myShrunkSequence.get((int)this.myLexPosition).shrunkStart : this.myShrunkCharSequence.length();
    }

    @Nullable
    public IElementType getTokenType() {
        if (this.eof()) {
            return null;
        }
        this.skipWhitespace();
        return this.myLexPosition < this.myShrunkSequence.size() ? this.myShrunkSequence.get((int)this.myLexPosition).elementType : null;
    }

    @Nullable
    public String getTokenText() {
        if (this.eof()) {
            return null;
        }
        this.skipWhitespace();
        if (this.myLexPosition >= this.myShrunkSequence.size()) {
            return null;
        }
        MyShiftedToken token = this.myShrunkSequence.get(this.myLexPosition);
        return this.myShrunkCharSequence.subSequence(token.shrunkStart, token.shrunkEnd).toString();
    }

    public boolean eof() {
        boolean isEof;
        boolean bl = isEof = this.myLexPosition >= this.myShrunkSequence.size();
        if (!isEof) {
            return false;
        }
        this.synchronizePositions(true);
        return true;
    }

    @NotNull
    public PsiBuilder.Marker mark() {
        PsiBuilder.Marker originalPositionMarker = null;
        if (this.myLexPosition != 0) {
            originalPositionMarker = super.mark();
            this.synchronizePositions(true);
        }
        PsiBuilder.Marker mark = super.mark();
        if (this.myLexPosition == 0 && this.myDelegate.getTokenType() == TemplateMasqueradingLexer.MINUS_TYPE) {
            this.myDelegate.advanceLexer();
        }
        return new MyMarker(mark, originalPositionMarker, this.myLexPosition);
    }

    private void skipWhitespace() {
        while (this.myLexPosition < this.myShrunkSequence.size() && this.isWhiteSpaceOnPos(this.myLexPosition)) {
            ++this.myLexPosition;
        }
    }

    private boolean isWhiteSpaceOnPos(int pos) {
        return this.myBuilderDelegate.isWhitespaceOrComment(this.myShrunkSequence.get((int)pos).elementType);
    }

    protected void initShrunkSequence() {
        this.initTokenListAndCharSequence(this.myLexer);
        this.myLexPosition = 0;
    }

    private void initTokenListAndCharSequence(MasqueradingLexer lexer) {
        lexer.start(this.getDelegate().getOriginalText());
        this.myShrunkSequence = new ArrayList<MyShiftedToken>();
        StringBuilder charSequenceBuilder = new StringBuilder();
        int realPos = 0;
        int shrunkPos = 0;
        while (lexer.getTokenType() != null) {
            IElementType masqueTokenType = lexer.getMasqueTokenType();
            String masqueTokenText = lexer.getMasqueTokenText();
            int realLength = lexer.getTokenEnd() - lexer.getTokenStart();
            if (masqueTokenType != null) {
                assert (masqueTokenText != null);
                int masqueLength = masqueTokenText.length();
                this.myShrunkSequence.add(new MyShiftedToken(masqueTokenType, realPos, realPos + realLength, shrunkPos, shrunkPos + masqueLength));
                charSequenceBuilder.append(masqueTokenText);
                shrunkPos += masqueLength;
            }
            realPos += realLength;
            lexer.advance();
        }
        this.myShrunkCharSequence = charSequenceBuilder.toString();
    }

    private void logPos() {
        StringBuilder sb = new StringBuilder();
        sb.append("\nmyLexPosition=" + this.myLexPosition + "/" + this.myShrunkSequence.size());
        if (this.myLexPosition < this.myShrunkSequence.size()) {
            MyShiftedToken token = this.myShrunkSequence.get(this.myLexPosition);
            sb.append("\nshrunk:" + token.shrunkStart + "," + token.shrunkEnd);
            sb.append("\nreal:" + token.realStart + "," + token.realEnd);
            sb.append("\nTT:" + this.getTokenText());
        }
        sb.append("\ndelegate:");
        sb.append("eof=" + this.myDelegate.eof());
        if (!this.myDelegate.eof()) {
            sb.append("\nposition:" + this.myDelegate.getCurrentOffset() + "," + (this.myDelegate.getCurrentOffset() + this.myDelegate.getTokenText().length()));
            sb.append("\nTT:" + this.myDelegate.getTokenText());
        }
        LOG.info(sb.toString());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parserDefinition";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lexer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chameleon";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/embedding/MasqueradingPsiBuilderAdapter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/embedding/MasqueradingPsiBuilderAdapter";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getOriginalText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 6 -> new IllegalStateException(string2);
        };
    }

    private record MyShiftedToken(IElementType elementType, int realStart, int realEnd, int shrunkStart, int shrunkEnd) {
    }

    private class MyMarker
    extends DelegateMarker {
        private final int myBuilderPosition;
        private final PsiBuilder.Marker myOriginalPositionMarker;

        MyMarker(PsiBuilder.Marker delegate, PsiBuilder.Marker originalPositionMarker, int builderPosition) {
            super(delegate);
            this.myBuilderPosition = builderPosition;
            this.myOriginalPositionMarker = originalPositionMarker;
        }

        public void rollbackTo() {
            if (this.myOriginalPositionMarker != null) {
                this.myOriginalPositionMarker.rollbackTo();
            } else {
                super.rollbackTo();
            }
            MasqueradingPsiBuilderAdapter.this.myLexPosition = this.myBuilderPosition;
        }

        public void doneBefore(@NotNull IElementType type2, @NotNull PsiBuilder.Marker before2) {
            if (type2 == null) {
                MyMarker.$$$reportNull$$$0(0);
            }
            if (before2 == null) {
                MyMarker.$$$reportNull$$$0(1);
            }
            if (this.myOriginalPositionMarker != null) {
                this.myOriginalPositionMarker.drop();
            }
            super.doneBefore(type2, MyMarker.getDelegateOrThis(before2));
        }

        public void doneBefore(@NotNull IElementType type2, @NotNull PsiBuilder.Marker before2, @NotNull String errorMessage) {
            if (type2 == null) {
                MyMarker.$$$reportNull$$$0(2);
            }
            if (before2 == null) {
                MyMarker.$$$reportNull$$$0(3);
            }
            if (errorMessage == null) {
                MyMarker.$$$reportNull$$$0(4);
            }
            if (this.myOriginalPositionMarker != null) {
                this.myOriginalPositionMarker.drop();
            }
            super.doneBefore(type2, MyMarker.getDelegateOrThis(before2), errorMessage);
        }

        public void drop() {
            if (this.myOriginalPositionMarker != null) {
                this.myOriginalPositionMarker.drop();
            }
            super.drop();
        }

        public void done(@NotNull IElementType type2) {
            if (type2 == null) {
                MyMarker.$$$reportNull$$$0(5);
            }
            if (this.myOriginalPositionMarker != null) {
                this.myOriginalPositionMarker.drop();
            }
            super.done(type2);
        }

        public void collapse(@NotNull IElementType type2) {
            if (type2 == null) {
                MyMarker.$$$reportNull$$$0(6);
            }
            if (this.myOriginalPositionMarker != null) {
                this.myOriginalPositionMarker.drop();
            }
            super.collapse(type2);
        }

        public void error(@NotNull String message2) {
            if (message2 == null) {
                MyMarker.$$$reportNull$$$0(7);
            }
            if (this.myOriginalPositionMarker != null) {
                this.myOriginalPositionMarker.drop();
            }
            super.error(message2);
        }

        @NotNull
        private static PsiBuilder.Marker getDelegateOrThis(@NotNull PsiBuilder.Marker marker) {
            if (marker == null) {
                MyMarker.$$$reportNull$$$0(8);
            }
            if (marker instanceof DelegateMarker) {
                PsiBuilder.Marker marker2 = ((DelegateMarker)marker).getDelegate();
                if (marker2 == null) {
                    MyMarker.$$$reportNull$$$0(9);
                }
                return marker2;
            }
            PsiBuilder.Marker marker3 = marker;
            if (marker3 == null) {
                MyMarker.$$$reportNull$$$0(10);
            }
            return marker3;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 9, 10 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "before";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "errorMessage";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "marker";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/embedding/MasqueradingPsiBuilderAdapter$MyMarker";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/embedding/MasqueradingPsiBuilderAdapter$MyMarker";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDelegateOrThis";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "doneBefore";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "done";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "collapse";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "error";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "getDelegateOrThis";
                    break;
                }
                case 9: 
                case 10: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 9, 10 -> new IllegalStateException(string2);
            };
        }
    }
}

