/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower.calls;

import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.lower.calls.CallsTransformer;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/calls/ExceptionHelperCallsTransformer;", "Lorg/jetbrains/kotlin/ir/backend/js/lower/calls/CallsTransformer;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "referenceFunction", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "fqn", "Lorg/jetbrains/kotlin/name/FqName;", "helperMapping", "", "transformFunctionAccess", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "call", "doNotIntrinsify", "", "backend.js"})
@SourceDebugExtension(value={"SMAP\nExceptionHelperCallsTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExceptionHelperCallsTransformer.kt\norg/jetbrains/kotlin/ir/backend/js/lower/calls/ExceptionHelperCallsTransformer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,37:1\n1#2:38\n*E\n"})
public final class ExceptionHelperCallsTransformer
implements CallsTransformer {
    @NotNull
    private final JsIrBackendContext context;
    @NotNull
    private final Map<IrSimpleFunctionSymbol, IrSimpleFunctionSymbol> helperMapping;

    public ExceptionHelperCallsTransformer(@NotNull JsIrBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        Pair[] pairArray = new Pair[6];
        IrSimpleFunctionSymbol irSimpleFunctionSymbol = this.context.getIrBuiltIns().getCheckNotNullSymbol();
        FqName fqName = IrTypeUtilsKt.getKotlinPackageFqn().child(Name.identifier((String)"ensureNotNull"));
        Intrinsics.checkNotNullExpressionValue((Object)fqName, (String)"child(...)");
        pairArray[0] = TuplesKt.to((Object)irSimpleFunctionSymbol, (Object)this.referenceFunction(fqName));
        IrSimpleFunctionSymbol irSimpleFunctionSymbol2 = this.context.getIrBuiltIns().getThrowCceSymbol();
        FqName fqName2 = IrTypeUtilsKt.getKotlinPackageFqn().child(Name.identifier((String)"THROW_CCE"));
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"child(...)");
        pairArray[1] = TuplesKt.to((Object)irSimpleFunctionSymbol2, (Object)this.referenceFunction(fqName2));
        IrSimpleFunctionSymbol irSimpleFunctionSymbol3 = this.context.getIrBuiltIns().getThrowIseSymbol();
        FqName fqName3 = IrTypeUtilsKt.getKotlinPackageFqn().child(Name.identifier((String)"THROW_ISE"));
        Intrinsics.checkNotNullExpressionValue((Object)fqName3, (String)"child(...)");
        pairArray[2] = TuplesKt.to((Object)irSimpleFunctionSymbol3, (Object)this.referenceFunction(fqName3));
        IrSimpleFunctionSymbol irSimpleFunctionSymbol4 = this.context.getIrBuiltIns().getIllegalArgumentExceptionSymbol();
        FqName fqName4 = IrTypeUtilsKt.getKotlinPackageFqn().child(Name.identifier((String)"THROW_IAE"));
        Intrinsics.checkNotNullExpressionValue((Object)fqName4, (String)"child(...)");
        pairArray[3] = TuplesKt.to((Object)irSimpleFunctionSymbol4, (Object)this.referenceFunction(fqName4));
        IrSimpleFunctionSymbol irSimpleFunctionSymbol5 = this.context.getIrBuiltIns().getNoWhenBranchMatchedExceptionSymbol();
        FqName fqName5 = IrTypeUtilsKt.getKotlinPackageFqn().child(Name.identifier((String)"noWhenBranchMatchedException"));
        Intrinsics.checkNotNullExpressionValue((Object)fqName5, (String)"child(...)");
        pairArray[4] = TuplesKt.to((Object)irSimpleFunctionSymbol5, (Object)this.referenceFunction(fqName5));
        pairArray[5] = TuplesKt.to((Object)this.context.getIrBuiltIns().getLinkageErrorSymbol(), (Object)this.context.getIntrinsics().getLinkageErrorSymbol());
        this.helperMapping = MapsKt.mapOf((Pair[])pairArray);
    }

    private final IrSimpleFunctionSymbol referenceFunction(FqName fqn) {
        SimpleFunctionDescriptor simpleFunctionDescriptor;
        block3: {
            block2: {
                simpleFunctionDescriptor = (SimpleFunctionDescriptor)CollectionsKt.singleOrNull(this.context.getFunctions(fqn));
                if (simpleFunctionDescriptor == null) break block2;
                SimpleFunctionDescriptor it = simpleFunctionDescriptor;
                boolean bl = false;
                IrSimpleFunctionSymbol irSimpleFunctionSymbol = this.context.getSymbolTable().getDescriptorExtension().referenceSimpleFunction((Object)it);
                simpleFunctionDescriptor = irSimpleFunctionSymbol;
                if (irSimpleFunctionSymbol != null) break block3;
            }
            throw new AssertionError((Object)("Function not found: " + fqn));
        }
        return simpleFunctionDescriptor;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public IrFunctionAccessExpression transformFunctionAccess(@NotNull IrFunctionAccessExpression call2, boolean doNotIntrinsify) {
        IrFunctionAccessExpression irFunctionAccessExpression;
        Intrinsics.checkNotNullParameter((Object)call2, (String)"call");
        IrSimpleFunctionSymbol irSimpleFunctionSymbol = this.helperMapping.get(call2.getSymbol());
        if (irSimpleFunctionSymbol != null) {
            IrSimpleFunctionSymbol it = irSimpleFunctionSymbol;
            boolean bl = false;
            IrCall irCall = IrUtilsKt.irCall$default((IrFunctionAccessExpression)call2, (IrSimpleFunctionSymbol)it, (boolean)false, (boolean)false, null, null, (int)60, null);
            irSimpleFunctionSymbol = irCall;
            if (irCall != null) {
                irFunctionAccessExpression = (IrFunctionAccessExpression)irSimpleFunctionSymbol;
                return irFunctionAccessExpression;
            }
        }
        irFunctionAccessExpression = call2;
        return irFunctionAccessExpression;
    }
}

