/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.InlineClassesUtils;
import org.jetbrains.kotlin.ir.backend.js.utils.MiscKt;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\bf\u0018\u00002\u00020\u0001J\u0012\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0016R\u0012\u0010\u000b\u001a\u00020\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0012\u0010\u000f\u001a\u00020\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000e\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0011\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/JsCommonInlineClassesUtils;", "Lorg/jetbrains/kotlin/backend/common/InlineClassesUtils;", "getInlinedClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "type", "Lorg/jetbrains/kotlin/ir/types/IrType;", "isTypeInlined", "", "shouldValueParameterBeBoxed", "parameter", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "boxIntrinsic", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "getBoxIntrinsic", "()Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "unboxIntrinsic", "getUnboxIntrinsic", "backend.js"})
public interface JsCommonInlineClassesUtils
extends InlineClassesUtils {
    @Nullable
    public IrClass getInlinedClass(@NotNull IrType var1);

    default public boolean isTypeInlined(@NotNull IrType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return this.getInlinedClass(type) != null;
    }

    default public boolean shouldValueParameterBeBoxed(@NotNull IrValueParameter parameter) {
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        IrDeclarationParent irDeclarationParent = parameter.getParent();
        IrSimpleFunction irSimpleFunction = irDeclarationParent instanceof IrSimpleFunction ? (IrSimpleFunction)irDeclarationParent : null;
        if (irSimpleFunction == null) {
            return false;
        }
        IrSimpleFunction function2 = irSimpleFunction;
        IrDeclarationParent irDeclarationParent2 = function2.getParent();
        IrClass irClass = irDeclarationParent2 instanceof IrClass ? (IrClass)irDeclarationParent2 : null;
        if (irClass == null) {
            return false;
        }
        IrClass klass = irClass;
        if (!this.isClassInlineLike(klass)) {
            return false;
        }
        return MiscKt.isDispatchReceiver((IrValueDeclaration)parameter) && IrUtilsKt.isOverridableOrOverrides((IrFunction)((IrFunction)function2));
    }

    @NotNull
    public IrSimpleFunctionSymbol getBoxIntrinsic();

    @NotNull
    public IrSimpleFunctionSymbol getUnboxIntrinsic();
}

