/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.BackendContext;
import org.jetbrains.kotlin.backend.common.ModuleLoweringPass;
import org.jetbrains.kotlin.backend.common.lower.Closure;
import org.jetbrains.kotlin.backend.common.lower.ClosureAnnotator;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.common.phaser.PhaseDescription;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.lower.ScriptFixLambdasTransformer;
import org.jetbrains.kotlin.backend.jvm.lower.ScriptFixLambdasTransformerContext;
import org.jetbrains.kotlin.backend.jvm.lower.ScriptLoweringKt;
import org.jetbrains.kotlin.backend.jvm.lower.ScriptToClassTransformer;
import org.jetbrains.kotlin.backend.jvm.lower.ScriptToClassTransformerContext;
import org.jetbrains.kotlin.backend.jvm.lower.ScriptsToClassesLowering;
import org.jetbrains.kotlin.backend.jvm.lower.ScriptsToClassesSymbolRemapper;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory2;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReporterWithContext;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrFileEntry;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBodyBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrClassBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrFieldBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrFunctionBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrPropertyBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrValueParameterBuilder;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragmentsKt;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrScript;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.declarations.impl.IrClassImpl;
import org.jetbrains.kotlin.ir.descriptors.IrBasedDescriptorsKt;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstantArray;
import org.jetbrains.kotlin.ir.expressions.IrConstantObject;
import org.jetbrains.kotlin.ir.expressions.IrConstantPrimitive;
import org.jetbrains.kotlin.ir.expressions.IrConstantValue;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrContinue;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrDynamicExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicMemberExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicOperatorExpression;
import org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorCallExpression;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetSingletonValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInlinedFunctionBlock;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrRawFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrReturnableBlock;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrSuspendableExpression;
import org.jetbrains.kotlin.ir.expressions.IrSuspensionPoint;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.expressions.impl.BuildersKt;
import org.jetbrains.kotlin.ir.expressions.impl.IrClassReferenceImpl;
import org.jetbrains.kotlin.ir.symbols.IrAnonymousInitializerSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrScriptSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueParameterSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.symbols.impl.IrAnonymousInitializerSymbolImpl;
import org.jetbrains.kotlin.ir.symbols.impl.IrConstructorSymbolImpl;
import org.jetbrains.kotlin.ir.symbols.impl.IrValueParameterSymbolImpl;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.types.impl.IrSimpleTypeImpl;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.PatchDeclarationParentsKt;
import org.jetbrains.kotlin.ir.util.SimpleTypeRemapper;
import org.jetbrains.kotlin.ir.util.SymbolRemapper;
import org.jetbrains.kotlin.ir.util.TypeRemapper;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformer;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.NameUtils;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmBackendErrors;
import org.jetbrains.kotlin.utils.SortUtilsKt;

@PhaseDescription(name="ScriptsToClasses", description="Put script declarations into classes")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u001e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0019H\u0002JH\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112.\u0010\u001d\u001a*\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020!0\u001f0\u001ej\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020!0\u001f`\"H\u0002J\f\u0010)\u001a\u00020\t*\u00020\rH\u0002J \u0010*\u001a\u00020\t*\u00020\r2\u0006\u0010+\u001a\u00020,2\n\b\u0002\u0010-\u001a\u0004\u0018\u00010.H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001b\u0010#\u001a\u00020$8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b'\u0010(\u001a\u0004\b%\u0010&\u00a8\u0006/"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/ScriptsToClassesLowering;", "Lorg/jetbrains/kotlin/backend/common/ModuleLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "lower", "", "irModule", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "prepareScriptClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "irScript", "Lorg/jetbrains/kotlin/ir/declarations/IrScript;", "collectCapturingClasses", "", "Lorg/jetbrains/kotlin/ir/declarations/impl/IrClassImpl;", "typeRemapper", "Lorg/jetbrains/kotlin/ir/util/SimpleTypeRemapper;", "finalizeScriptClass", "symbolRemapper", "Lorg/jetbrains/kotlin/backend/jvm/lower/ScriptsToClassesSymbolRemapper;", "createConstructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "irScriptClass", "implicitReceiversFieldsWithParameters", "Ljava/util/ArrayList;", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "Lkotlin/collections/ArrayList;", "scriptingJvmPackage", "Lorg/jetbrains/kotlin/ir/declarations/IrExternalPackageFragment;", "getScriptingJvmPackage", "()Lorg/jetbrains/kotlin/ir/declarations/IrExternalPackageFragment;", "scriptingJvmPackage$delegate", "Lkotlin/Lazy;", "addScriptMainFun", "addSimplePropertyFrom", "from", "Lorg/jetbrains/kotlin/ir/declarations/IrValueDeclaration;", "initializer", "Lorg/jetbrains/kotlin/ir/expressions/IrExpressionBody;", "backend.jvm.lower"})
@SourceDebugExtension(value={"SMAP\nScriptLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScriptLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/ScriptsToClassesLowering\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 declarationBuilders.kt\norg/jetbrains/kotlin/ir/builders/declarations/DeclarationBuildersKt\n+ 5 ScriptLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/ScriptLoweringKt\n+ 6 ScriptLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/ScriptLoweringKt$addAnonymousInitializer$1\n+ 7 ExpressionHelpers.kt\norg/jetbrains/kotlin/ir/builders/ExpressionHelpersKt\n+ 8 IrBuilder.kt\norg/jetbrains/kotlin/ir/builders/IrBlockBodyBuilder\n+ 9 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,1129:1\n1#2:1130\n1557#3:1131\n1628#3,3:1132\n1863#3,2:1139\n1863#3,2:1141\n1863#3,2:1143\n1557#3:1145\n1628#3,2:1146\n1630#3:1159\n1863#3:1160\n1864#3:1186\n1557#3:1187\n1628#3,3:1188\n1863#3,2:1191\n50#4,4:1135\n80#4:1148\n74#4,10:1149\n50#4,4:1193\n351#4,9:1197\n249#4:1218\n243#4:1219\n237#4,10:1220\n351#4,9:1230\n127#4:1239\n121#4,10:1240\n74#4,4:1250\n1090#5,3:1161\n1093#5,9:1165\n1090#6:1164\n416#7,10:1174\n72#8,2:1184\n350#9,12:1206\n*S KotlinDebug\n*F\n+ 1 ScriptLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/ScriptsToClassesLowering\n*L\n70#1:1131\n70#1:1132,3\n116#1:1139,2\n117#1:1141,2\n120#1:1143,2\n222#1:1145\n222#1:1146,2\n222#1:1159\n257#1:1160\n257#1:1186\n331#1:1187\n331#1:1188,3\n348#1:1191,2\n89#1:1135,4\n223#1:1148\n223#1:1149,10\n364#1:1193,4\n373#1:1197,9\n389#1:1218\n389#1:1219\n389#1:1220,10\n395#1:1230,9\n422#1:1239\n422#1:1240,10\n426#1:1250,4\n274#1:1161,3\n274#1:1165,9\n274#1:1164\n276#1:1174,10\n276#1:1184,2\n383#1:1206,12\n*E\n"})
public final class ScriptsToClassesLowering
implements ModuleLoweringPass {
    @NotNull
    private final JvmBackendContext context;
    @NotNull
    private final Lazy scriptingJvmPackage$delegate;

    public ScriptsToClassesLowering(@NotNull JvmBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.scriptingJvmPackage$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> ScriptsToClassesLowering.scriptingJvmPackage_delegate$lambda$26(this));
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    /*
     * WARNING - void declaration
     */
    public void lower(@NotNull IrModuleFragment irModule) {
        Intrinsics.checkNotNullParameter((Object)irModule, (String)"irModule");
        List scripts = new ArrayList();
        Map scriptDependencies = new LinkedHashMap();
        for (IrFile irFile : irModule.getFiles()) {
            ListIterator<IrClass> iterator2 = irFile.getDeclarations().listIterator();
            while (iterator2.hasNext()) {
                List list;
                IrDeclaration declaration = (IrDeclaration)iterator2.next();
                if (!(declaration instanceof IrScript)) continue;
                IrClass scriptClass = this.prepareScriptClass(irFile, (IrScript)declaration);
                scripts.add(declaration);
                List it = list = ((IrScript)declaration).getImportedScripts();
                boolean bl = false;
                Object object = it;
                List list2 = !(object == null || object.isEmpty()) ? list : null;
                if (list2 != null) {
                    void $this$mapTo$iv$iv;
                    it = list2;
                    boolean bl2 = false;
                    object = scriptDependencies;
                    IrDeclaration irDeclaration = declaration;
                    Iterable $this$map$iv = it;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it2;
                        IrScriptSymbol irScriptSymbol = (IrScriptSymbol)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl3 = false;
                        collection.add((IrScript)it2.getOwner());
                    }
                    List list3 = (List)destination$iv$iv;
                    object.put(irDeclaration, list3);
                }
                iterator2.set(scriptClass);
            }
        }
        ScriptsToClassesSymbolRemapper symbolRemapper2 = new ScriptsToClassesSymbolRemapper();
        List orderedScripts = CollectionsKt.reversed((Iterable)SortUtilsKt.topologicalSort$default((Iterable)scripts, null, arg_0 -> ScriptsToClassesLowering.lower$lambda$3(scriptDependencies, arg_0), (int)2, null));
        for (IrScript irScript : orderedScripts) {
            this.finalizeScriptClass(irScript, symbolRemapper2);
            IrClassSymbol irClassSymbol = irScript.getTargetClass();
            Intrinsics.checkNotNull((Object)irClassSymbol);
            PatchDeclarationParentsKt.patchDeclarationParents((IrElement)((IrElement)irClassSymbol.getOwner()), (IrDeclarationParent)irScript.getParent());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final IrClass prepareScriptClass(IrFile irFile, IrScript irScript) {
        IrClass irClass;
        Name name;
        void it;
        IrFileEntry fileEntry = irFile.getFileEntry();
        IrFactory $this$buildClass$iv = this.context.getIrFactory();
        boolean $i$f$buildClass = false;
        IrClassBuilder $this$buildClass_u24lambda_u241$iv = new IrClassBuilder();
        boolean bl = false;
        IrClassBuilder $this$prepareScriptClass_u24lambda_u245 = $this$buildClass_u24lambda_u241$iv;
        boolean bl2 = false;
        $this$prepareScriptClass_u24lambda_u245.setStartOffset(0);
        $this$prepareScriptClass_u24lambda_u245.setEndOffset(fileEntry.getMaxOffset());
        $this$prepareScriptClass_u24lambda_u245.setOrigin((IrDeclarationOrigin)IrDeclarationOrigin.Companion.getSCRIPT_CLASS());
        Name name2 = irScript.getName();
        IrClassBuilder irClassBuilder = $this$prepareScriptClass_u24lambda_u245;
        boolean bl3 = false;
        if (it.isSpecial()) {
            String string = it.asStringStripSpecialMarkers();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asStringStripSpecialMarkers(...)");
            name = NameUtils.getScriptNameForFile((String)StringsKt.removePrefix((String)string, (CharSequence)"script-"));
        } else {
            name = it;
        }
        irClassBuilder.setName(name);
        $this$prepareScriptClass_u24lambda_u245.setKind(ClassKind.CLASS);
        $this$prepareScriptClass_u24lambda_u245.setVisibility(DescriptorVisibilities.PUBLIC);
        $this$prepareScriptClass_u24lambda_u245.setModality(Modality.FINAL);
        IrClass irScriptClass = irClass = DeclarationBuildersKt.buildClass((IrFactory)$this$buildClass$iv, (IrClassBuilder)$this$buildClass_u24lambda_u241$iv);
        boolean bl4 = false;
        Collection collection = irScriptClass.getSuperTypes();
        IrType irType = irScript.getBaseClass();
        if (irType == null) {
            irType = this.context.getIrBuiltIns().getAnyNType();
        }
        irScriptClass.setSuperTypes(CollectionsKt.plus((Collection)collection, (Object)irType));
        irScriptClass.setParent((IrDeclarationParent)irFile);
        irScriptClass.setMetadata(irScript.getMetadata());
        irScript.setTargetClass(irScriptClass.getSymbol());
        return irClass;
    }

    private final Set<IrClassImpl> collectCapturingClasses(IrScript irScript, SimpleTypeRemapper typeRemapper) {
        IrScriptSymbol it;
        boolean $i$f$forEach;
        Iterable $this$forEach$iv;
        Set set;
        ClosureAnnotator annotator = new ClosureAnnotator((IrElement)irScript, (IrDeclaration)irScript);
        Set capturingClasses = new LinkedHashSet();
        Set it2 = set = (Set)new LinkedHashSet();
        boolean bl = false;
        IrValueParameter irValueParameter = irScript.getThisReceiver();
        org.jetbrains.kotlin.utils.CollectionsKt.addIfNotNull((Collection)it2, (Object)(irValueParameter != null ? irValueParameter.getType() : null));
        Set scriptsReceivers = set;
        List list = irScript.getEarlierScripts();
        if (list != null) {
            $this$forEach$iv = list;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (IrScriptSymbol)element$iv;
                boolean bl2 = false;
                IrValueParameter irValueParameter2 = ((IrScript)it.getOwner()).getThisReceiver();
                org.jetbrains.kotlin.utils.CollectionsKt.addIfNotNull((Collection)scriptsReceivers, (Object)(irValueParameter2 != null ? irValueParameter2.getType() : null));
            }
        }
        List list2 = irScript.getImportedScripts();
        if (list2 != null) {
            $this$forEach$iv = list2;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (IrScriptSymbol)element$iv;
                boolean bl3 = false;
                IrClassSymbol irClassSymbol = ((IrScript)it.getOwner()).getTargetClass();
                Intrinsics.checkNotNull((Object)irClassSymbol);
                IrValueParameter irValueParameter3 = ((IrClass)irClassSymbol.getOwner()).getThisReceiver();
                Intrinsics.checkNotNull((Object)irValueParameter3);
                scriptsReceivers.add(irValueParameter3.getType());
            }
        }
        Iterable $this$forEach$iv2 = irScript.getImplicitReceiversParameters();
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            IrValueParameter it3 = (IrValueParameter)element$iv;
            boolean bl4 = false;
            scriptsReceivers.add(it3.getType());
            scriptsReceivers.add(typeRemapper.remapType(it3.getType()));
        }
        IrElementVisitorVoid collector2 = new IrElementVisitorVoid(annotator, irScript, this, capturingClasses, scriptsReceivers){
            final /* synthetic */ ClosureAnnotator $annotator;
            final /* synthetic */ IrScript $irScript;
            final /* synthetic */ ScriptsToClassesLowering this$0;
            final /* synthetic */ Set<IrClassImpl> $capturingClasses;
            final /* synthetic */ Set<IrType> $scriptsReceivers;
            {
                this.$annotator = $annotator;
                this.$irScript = $irScript;
                this.this$0 = $receiver;
                this.$capturingClasses = $capturingClasses;
                this.$scriptsReceivers = $scriptsReceivers;
            }

            public void visitElement(IrElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                IrVisitorsKt.acceptChildrenVoid((IrElement)element, (IrElementVisitorVoid)this);
            }

            /*
             * WARNING - void declaration
             */
            public void visitClass(IrClass declaration) {
                Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                if (declaration instanceof IrClassImpl && !((IrClassImpl)declaration).isInner()) {
                    boolean bl;
                    IrDeclarationParent irDeclarationParent;
                    Object object;
                    block20: {
                        void $this$any$iv;
                        Closure closure = this.$annotator.getClassClosure(declaration);
                        object = closure.getCapturedValues();
                        irDeclarationParent = this.$scriptsReceivers;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (T element$iv : $this$any$iv) {
                                IrValueSymbol it = (IrValueSymbol)element$iv;
                                boolean bl2 = false;
                                if (!irDeclarationParent.contains(it.getOwner().getType())) continue;
                                bl = true;
                                break block20;
                            }
                            bl = false;
                        }
                    }
                    if (bl) {
                        if (IrUtilsKt.isInterface((IrClass)declaration)) {
                            collectCapturingClasses.collector.1.visitClass$reportError$default(this.this$0, declaration, JvmBackendErrors.INSTANCE.getSCRIPT_CAPTURING_INTERFACE(), null, 8, null);
                        } else if (IrUtilsKt.isEnumClass((IrClass)declaration)) {
                            collectCapturingClasses.collector.1.visitClass$reportError$default(this.this$0, declaration, JvmBackendErrors.INSTANCE.getSCRIPT_CAPTURING_ENUM(), null, 8, null);
                        } else if (IrUtilsKt.isEnumEntry((IrClass)declaration)) {
                            collectCapturingClasses.collector.1.visitClass$reportError$default(this.this$0, declaration, JvmBackendErrors.INSTANCE.getSCRIPT_CAPTURING_ENUM_ENTRY(), null, 8, null);
                        } else if (((IrClassImpl)declaration).isCompanion()) {
                            collectCapturingClasses.collector.1.visitClass$reportError(this.this$0, declaration, (KtDiagnosticFactory1<String>)JvmBackendErrors.INSTANCE.getSCRIPT_CAPTURING_OBJECT(), SpecialNames.DEFAULT_NAME_FOR_COMPANION_OBJECT);
                        } else if (((IrClassImpl)declaration).getKind().isSingleton()) {
                            collectCapturingClasses.collector.1.visitClass$reportError$default(this.this$0, declaration, JvmBackendErrors.INSTANCE.getSCRIPT_CAPTURING_OBJECT(), null, 8, null);
                        } else if (IrUtilsKt.isClass((IrClass)declaration)) {
                            if (!Intrinsics.areEqual((Object)declaration.getParent(), (Object)this.$irScript)) {
                                irDeclarationParent = declaration.getParent();
                                IrClass irClass = irDeclarationParent instanceof IrClass ? (IrClass)irDeclarationParent : null;
                                boolean bl3 = irClass != null ? !irClass.isInner() : false;
                                if (bl3) {
                                    KtDiagnosticReporterWithContext.DiagnosticContextImpl diagnosticContextImpl = this.this$0.getContext().getKtDiagnosticReporter().at((IrDeclaration)declaration);
                                    KtDiagnosticFactory2 ktDiagnosticFactory2 = JvmBackendErrors.INSTANCE.getSCRIPT_CAPTURING_NESTED_CLASS();
                                    String string = ((IrClassImpl)declaration).getName().asString();
                                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
                                    IrDeclarationParent irDeclarationParent2 = declaration.getParent();
                                    IrDeclarationWithName irDeclarationWithName = irDeclarationParent2 instanceof IrDeclarationWithName ? (IrDeclarationWithName)irDeclarationParent2 : null;
                                    if (irDeclarationWithName == null || (irDeclarationWithName = irDeclarationWithName.getName()) == null) {
                                        irDeclarationWithName = SpecialNames.NO_NAME_PROVIDED;
                                    }
                                    object = irDeclarationWithName.asString();
                                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"asString(...)");
                                    diagnosticContextImpl.report(ktDiagnosticFactory2, (Object)string, object);
                                }
                            } else {
                                this.$capturingClasses.add((IrClassImpl)declaration);
                            }
                        }
                    }
                }
                IrElementVisitorVoid.DefaultImpls.visitClass((IrElementVisitorVoid)this, (IrClass)declaration);
            }

            public void visitElement(IrElement element, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitElement((IrElementVisitorVoid)this, (IrElement)element, (Void)data);
            }

            public void visitDeclaration(IrDeclarationBase declaration, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitDeclaration((IrElementVisitorVoid)this, (IrDeclarationBase)declaration, (Void)data);
            }

            public void visitDeclaration(IrDeclarationBase declaration) {
                IrElementVisitorVoid.DefaultImpls.visitDeclaration((IrElementVisitorVoid)this, (IrDeclarationBase)declaration);
            }

            public void visitValueParameter(IrValueParameter declaration, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitValueParameter((IrElementVisitorVoid)this, (IrValueParameter)declaration, (Void)data);
            }

            public void visitValueParameter(IrValueParameter declaration) {
                IrElementVisitorVoid.DefaultImpls.visitValueParameter((IrElementVisitorVoid)this, (IrValueParameter)declaration);
            }

            public void visitClass(IrClass declaration, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitClass((IrElementVisitorVoid)this, (IrClass)declaration, (Void)data);
            }

            public void visitAnonymousInitializer(IrAnonymousInitializer declaration, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer((IrElementVisitorVoid)this, (IrAnonymousInitializer)declaration, (Void)data);
            }

            public void visitAnonymousInitializer(IrAnonymousInitializer declaration) {
                IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer((IrElementVisitorVoid)this, (IrAnonymousInitializer)declaration);
            }

            public void visitTypeParameter(IrTypeParameter declaration, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitTypeParameter((IrElementVisitorVoid)this, (IrTypeParameter)declaration, (Void)data);
            }

            public void visitTypeParameter(IrTypeParameter declaration) {
                IrElementVisitorVoid.DefaultImpls.visitTypeParameter((IrElementVisitorVoid)this, (IrTypeParameter)declaration);
            }

            public void visitFunction(IrFunction declaration, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitFunction((IrElementVisitorVoid)this, (IrFunction)declaration, (Void)data);
            }

            public void visitFunction(IrFunction declaration) {
                IrElementVisitorVoid.DefaultImpls.visitFunction((IrElementVisitorVoid)this, (IrFunction)declaration);
            }

            public void visitConstructor(IrConstructor declaration, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitConstructor((IrElementVisitorVoid)this, (IrConstructor)declaration, (Void)data);
            }

            public void visitConstructor(IrConstructor declaration) {
                IrElementVisitorVoid.DefaultImpls.visitConstructor((IrElementVisitorVoid)this, (IrConstructor)declaration);
            }

            public void visitEnumEntry(IrEnumEntry declaration, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitEnumEntry((IrElementVisitorVoid)this, (IrEnumEntry)declaration, (Void)data);
            }

            public void visitEnumEntry(IrEnumEntry declaration) {
                IrElementVisitorVoid.DefaultImpls.visitEnumEntry((IrElementVisitorVoid)this, (IrEnumEntry)declaration);
            }

            public void visitErrorDeclaration(IrErrorDeclaration declaration, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration((IrElementVisitorVoid)this, (IrErrorDeclaration)declaration, (Void)data);
            }

            public void visitErrorDeclaration(IrErrorDeclaration declaration) {
                IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration((IrElementVisitorVoid)this, (IrErrorDeclaration)declaration);
            }

            public void visitField(IrField declaration, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitField((IrElementVisitorVoid)this, (IrField)declaration, (Void)data);
            }

            public void visitField(IrField declaration) {
                IrElementVisitorVoid.DefaultImpls.visitField((IrElementVisitorVoid)this, (IrField)declaration);
            }

            public void visitLocalDelegatedProperty(IrLocalDelegatedProperty declaration, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty((IrElementVisitorVoid)this, (IrLocalDelegatedProperty)declaration, (Void)data);
            }

            public void visitLocalDelegatedProperty(IrLocalDelegatedProperty declaration) {
                IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty((IrElementVisitorVoid)this, (IrLocalDelegatedProperty)declaration);
            }

            public void visitModuleFragment(IrModuleFragment declaration, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitModuleFragment((IrElementVisitorVoid)this, (IrModuleFragment)declaration, (Void)data);
            }

            public void visitModuleFragment(IrModuleFragment declaration) {
                IrElementVisitorVoid.DefaultImpls.visitModuleFragment((IrElementVisitorVoid)this, (IrModuleFragment)declaration);
            }

            public void visitProperty(IrProperty declaration, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitProperty((IrElementVisitorVoid)this, (IrProperty)declaration, (Void)data);
            }

            public void visitProperty(IrProperty declaration) {
                IrElementVisitorVoid.DefaultImpls.visitProperty((IrElementVisitorVoid)this, (IrProperty)declaration);
            }

            public void visitScript(IrScript declaration, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitScript((IrElementVisitorVoid)this, (IrScript)declaration, (Void)data);
            }

            public void visitScript(IrScript declaration) {
                IrElementVisitorVoid.DefaultImpls.visitScript((IrElementVisitorVoid)this, (IrScript)declaration);
            }

            public void visitSimpleFunction(IrSimpleFunction declaration, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitSimpleFunction((IrElementVisitorVoid)this, (IrSimpleFunction)declaration, (Void)data);
            }

            public void visitSimpleFunction(IrSimpleFunction declaration) {
                IrElementVisitorVoid.DefaultImpls.visitSimpleFunction((IrElementVisitorVoid)this, (IrSimpleFunction)declaration);
            }

            public void visitTypeAlias(IrTypeAlias declaration, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitTypeAlias((IrElementVisitorVoid)this, (IrTypeAlias)declaration, (Void)data);
            }

            public void visitTypeAlias(IrTypeAlias declaration) {
                IrElementVisitorVoid.DefaultImpls.visitTypeAlias((IrElementVisitorVoid)this, (IrTypeAlias)declaration);
            }

            public void visitVariable(IrVariable declaration, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitVariable((IrElementVisitorVoid)this, (IrVariable)declaration, (Void)data);
            }

            public void visitVariable(IrVariable declaration) {
                IrElementVisitorVoid.DefaultImpls.visitVariable((IrElementVisitorVoid)this, (IrVariable)declaration);
            }

            public void visitPackageFragment(IrPackageFragment declaration, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitPackageFragment((IrElementVisitorVoid)this, (IrPackageFragment)declaration, (Void)data);
            }

            public void visitPackageFragment(IrPackageFragment declaration) {
                IrElementVisitorVoid.DefaultImpls.visitPackageFragment((IrElementVisitorVoid)this, (IrPackageFragment)declaration);
            }

            public void visitExternalPackageFragment(IrExternalPackageFragment declaration, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment((IrElementVisitorVoid)this, (IrExternalPackageFragment)declaration, (Void)data);
            }

            public void visitExternalPackageFragment(IrExternalPackageFragment declaration) {
                IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment((IrElementVisitorVoid)this, (IrExternalPackageFragment)declaration);
            }

            public void visitFile(IrFile declaration, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitFile((IrElementVisitorVoid)this, (IrFile)declaration, (Void)data);
            }

            public void visitFile(IrFile declaration) {
                IrElementVisitorVoid.DefaultImpls.visitFile((IrElementVisitorVoid)this, (IrFile)declaration);
            }

            public void visitExpression(IrExpression expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitExpression((IrElementVisitorVoid)this, (IrExpression)expression2, (Void)data);
            }

            public void visitExpression(IrExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitExpression((IrElementVisitorVoid)this, (IrExpression)expression2);
            }

            public void visitBody(IrBody body, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitBody((IrElementVisitorVoid)this, (IrBody)body, (Void)data);
            }

            public void visitBody(IrBody body) {
                IrElementVisitorVoid.DefaultImpls.visitBody((IrElementVisitorVoid)this, (IrBody)body);
            }

            public void visitExpressionBody(IrExpressionBody body, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitExpressionBody((IrElementVisitorVoid)this, (IrExpressionBody)body, (Void)data);
            }

            public void visitExpressionBody(IrExpressionBody body) {
                IrElementVisitorVoid.DefaultImpls.visitExpressionBody((IrElementVisitorVoid)this, (IrExpressionBody)body);
            }

            public void visitBlockBody(IrBlockBody body, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitBlockBody((IrElementVisitorVoid)this, (IrBlockBody)body, (Void)data);
            }

            public void visitBlockBody(IrBlockBody body) {
                IrElementVisitorVoid.DefaultImpls.visitBlockBody((IrElementVisitorVoid)this, (IrBlockBody)body);
            }

            public void visitDeclarationReference(IrDeclarationReference expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitDeclarationReference((IrElementVisitorVoid)this, (IrDeclarationReference)expression2, (Void)data);
            }

            public void visitDeclarationReference(IrDeclarationReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitDeclarationReference((IrElementVisitorVoid)this, (IrDeclarationReference)expression2);
            }

            public void visitMemberAccess(IrMemberAccessExpression<?> expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitMemberAccess((IrElementVisitorVoid)this, expression2, (Void)data);
            }

            public void visitMemberAccess(IrMemberAccessExpression<?> expression2) {
                IrElementVisitorVoid.DefaultImpls.visitMemberAccess((IrElementVisitorVoid)this, expression2);
            }

            public void visitFunctionAccess(IrFunctionAccessExpression expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionAccess((IrElementVisitorVoid)this, (IrFunctionAccessExpression)expression2, (Void)data);
            }

            public void visitFunctionAccess(IrFunctionAccessExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionAccess((IrElementVisitorVoid)this, (IrFunctionAccessExpression)expression2);
            }

            public void visitConstructorCall(IrConstructorCall expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitConstructorCall((IrElementVisitorVoid)this, (IrConstructorCall)expression2, (Void)data);
            }

            public void visitConstructorCall(IrConstructorCall expression2) {
                IrElementVisitorVoid.DefaultImpls.visitConstructorCall((IrElementVisitorVoid)this, (IrConstructorCall)expression2);
            }

            public void visitSingletonReference(IrGetSingletonValue expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitSingletonReference((IrElementVisitorVoid)this, (IrGetSingletonValue)expression2, (Void)data);
            }

            public void visitSingletonReference(IrGetSingletonValue expression2) {
                IrElementVisitorVoid.DefaultImpls.visitSingletonReference((IrElementVisitorVoid)this, (IrGetSingletonValue)expression2);
            }

            public void visitGetObjectValue(IrGetObjectValue expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitGetObjectValue((IrElementVisitorVoid)this, (IrGetObjectValue)expression2, (Void)data);
            }

            public void visitGetObjectValue(IrGetObjectValue expression2) {
                IrElementVisitorVoid.DefaultImpls.visitGetObjectValue((IrElementVisitorVoid)this, (IrGetObjectValue)expression2);
            }

            public void visitGetEnumValue(IrGetEnumValue expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitGetEnumValue((IrElementVisitorVoid)this, (IrGetEnumValue)expression2, (Void)data);
            }

            public void visitGetEnumValue(IrGetEnumValue expression2) {
                IrElementVisitorVoid.DefaultImpls.visitGetEnumValue((IrElementVisitorVoid)this, (IrGetEnumValue)expression2);
            }

            public void visitRawFunctionReference(IrRawFunctionReference expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference((IrElementVisitorVoid)this, (IrRawFunctionReference)expression2, (Void)data);
            }

            public void visitRawFunctionReference(IrRawFunctionReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference((IrElementVisitorVoid)this, (IrRawFunctionReference)expression2);
            }

            public void visitContainerExpression(IrContainerExpression expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitContainerExpression((IrElementVisitorVoid)this, (IrContainerExpression)expression2, (Void)data);
            }

            public void visitContainerExpression(IrContainerExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitContainerExpression((IrElementVisitorVoid)this, (IrContainerExpression)expression2);
            }

            public void visitBlock(IrBlock expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitBlock((IrElementVisitorVoid)this, (IrBlock)expression2, (Void)data);
            }

            public void visitBlock(IrBlock expression2) {
                IrElementVisitorVoid.DefaultImpls.visitBlock((IrElementVisitorVoid)this, (IrBlock)expression2);
            }

            public void visitComposite(IrComposite expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitComposite((IrElementVisitorVoid)this, (IrComposite)expression2, (Void)data);
            }

            public void visitComposite(IrComposite expression2) {
                IrElementVisitorVoid.DefaultImpls.visitComposite((IrElementVisitorVoid)this, (IrComposite)expression2);
            }

            public void visitReturnableBlock(IrReturnableBlock expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitReturnableBlock((IrElementVisitorVoid)this, (IrReturnableBlock)expression2, (Void)data);
            }

            public void visitReturnableBlock(IrReturnableBlock expression2) {
                IrElementVisitorVoid.DefaultImpls.visitReturnableBlock((IrElementVisitorVoid)this, (IrReturnableBlock)expression2);
            }

            public void visitInlinedFunctionBlock(IrInlinedFunctionBlock inlinedBlock, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitInlinedFunctionBlock((IrElementVisitorVoid)this, (IrInlinedFunctionBlock)inlinedBlock, (Void)data);
            }

            public void visitInlinedFunctionBlock(IrInlinedFunctionBlock inlinedBlock) {
                IrElementVisitorVoid.DefaultImpls.visitInlinedFunctionBlock((IrElementVisitorVoid)this, (IrInlinedFunctionBlock)inlinedBlock);
            }

            public void visitSyntheticBody(IrSyntheticBody body, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitSyntheticBody((IrElementVisitorVoid)this, (IrSyntheticBody)body, (Void)data);
            }

            public void visitSyntheticBody(IrSyntheticBody body) {
                IrElementVisitorVoid.DefaultImpls.visitSyntheticBody((IrElementVisitorVoid)this, (IrSyntheticBody)body);
            }

            public void visitBreakContinue(IrBreakContinue jump, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitBreakContinue((IrElementVisitorVoid)this, (IrBreakContinue)jump, (Void)data);
            }

            public void visitBreakContinue(IrBreakContinue jump) {
                IrElementVisitorVoid.DefaultImpls.visitBreakContinue((IrElementVisitorVoid)this, (IrBreakContinue)jump);
            }

            public void visitBreak(IrBreak jump, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitBreak((IrElementVisitorVoid)this, (IrBreak)jump, (Void)data);
            }

            public void visitBreak(IrBreak jump) {
                IrElementVisitorVoid.DefaultImpls.visitBreak((IrElementVisitorVoid)this, (IrBreak)jump);
            }

            public void visitContinue(IrContinue jump, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitContinue((IrElementVisitorVoid)this, (IrContinue)jump, (Void)data);
            }

            public void visitContinue(IrContinue jump) {
                IrElementVisitorVoid.DefaultImpls.visitContinue((IrElementVisitorVoid)this, (IrContinue)jump);
            }

            public void visitCall(IrCall expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitCall((IrElementVisitorVoid)this, (IrCall)expression2, (Void)data);
            }

            public void visitCall(IrCall expression2) {
                IrElementVisitorVoid.DefaultImpls.visitCall((IrElementVisitorVoid)this, (IrCall)expression2);
            }

            public void visitCallableReference(IrCallableReference<?> expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitCallableReference((IrElementVisitorVoid)this, expression2, (Void)data);
            }

            public void visitCallableReference(IrCallableReference<?> expression2) {
                IrElementVisitorVoid.DefaultImpls.visitCallableReference((IrElementVisitorVoid)this, expression2);
            }

            public void visitFunctionReference(IrFunctionReference expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionReference((IrElementVisitorVoid)this, (IrFunctionReference)expression2, (Void)data);
            }

            public void visitFunctionReference(IrFunctionReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionReference((IrElementVisitorVoid)this, (IrFunctionReference)expression2);
            }

            public void visitPropertyReference(IrPropertyReference expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitPropertyReference((IrElementVisitorVoid)this, (IrPropertyReference)expression2, (Void)data);
            }

            public void visitPropertyReference(IrPropertyReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitPropertyReference((IrElementVisitorVoid)this, (IrPropertyReference)expression2);
            }

            public void visitLocalDelegatedPropertyReference(IrLocalDelegatedPropertyReference expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference((IrElementVisitorVoid)this, (IrLocalDelegatedPropertyReference)expression2, (Void)data);
            }

            public void visitLocalDelegatedPropertyReference(IrLocalDelegatedPropertyReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference((IrElementVisitorVoid)this, (IrLocalDelegatedPropertyReference)expression2);
            }

            public void visitClassReference(IrClassReference expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitClassReference((IrElementVisitorVoid)this, (IrClassReference)expression2, (Void)data);
            }

            public void visitClassReference(IrClassReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitClassReference((IrElementVisitorVoid)this, (IrClassReference)expression2);
            }

            public void visitConst(IrConst<?> expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitConst((IrElementVisitorVoid)this, expression2, (Void)data);
            }

            public void visitConst(IrConst<?> expression2) {
                IrElementVisitorVoid.DefaultImpls.visitConst((IrElementVisitorVoid)this, expression2);
            }

            public void visitConstantValue(IrConstantValue expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitConstantValue((IrElementVisitorVoid)this, (IrConstantValue)expression2, (Void)data);
            }

            public void visitConstantValue(IrConstantValue expression2) {
                IrElementVisitorVoid.DefaultImpls.visitConstantValue((IrElementVisitorVoid)this, (IrConstantValue)expression2);
            }

            public void visitConstantPrimitive(IrConstantPrimitive expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitConstantPrimitive((IrElementVisitorVoid)this, (IrConstantPrimitive)expression2, (Void)data);
            }

            public void visitConstantPrimitive(IrConstantPrimitive expression2) {
                IrElementVisitorVoid.DefaultImpls.visitConstantPrimitive((IrElementVisitorVoid)this, (IrConstantPrimitive)expression2);
            }

            public void visitConstantObject(IrConstantObject expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitConstantObject((IrElementVisitorVoid)this, (IrConstantObject)expression2, (Void)data);
            }

            public void visitConstantObject(IrConstantObject expression2) {
                IrElementVisitorVoid.DefaultImpls.visitConstantObject((IrElementVisitorVoid)this, (IrConstantObject)expression2);
            }

            public void visitConstantArray(IrConstantArray expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitConstantArray((IrElementVisitorVoid)this, (IrConstantArray)expression2, (Void)data);
            }

            public void visitConstantArray(IrConstantArray expression2) {
                IrElementVisitorVoid.DefaultImpls.visitConstantArray((IrElementVisitorVoid)this, (IrConstantArray)expression2);
            }

            public void visitDelegatingConstructorCall(IrDelegatingConstructorCall expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall((IrElementVisitorVoid)this, (IrDelegatingConstructorCall)expression2, (Void)data);
            }

            public void visitDelegatingConstructorCall(IrDelegatingConstructorCall expression2) {
                IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall((IrElementVisitorVoid)this, (IrDelegatingConstructorCall)expression2);
            }

            public void visitDynamicExpression(IrDynamicExpression expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicExpression((IrElementVisitorVoid)this, (IrDynamicExpression)expression2, (Void)data);
            }

            public void visitDynamicExpression(IrDynamicExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicExpression((IrElementVisitorVoid)this, (IrDynamicExpression)expression2);
            }

            public void visitDynamicOperatorExpression(IrDynamicOperatorExpression expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression((IrElementVisitorVoid)this, (IrDynamicOperatorExpression)expression2, (Void)data);
            }

            public void visitDynamicOperatorExpression(IrDynamicOperatorExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression((IrElementVisitorVoid)this, (IrDynamicOperatorExpression)expression2);
            }

            public void visitDynamicMemberExpression(IrDynamicMemberExpression expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression((IrElementVisitorVoid)this, (IrDynamicMemberExpression)expression2, (Void)data);
            }

            public void visitDynamicMemberExpression(IrDynamicMemberExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression((IrElementVisitorVoid)this, (IrDynamicMemberExpression)expression2);
            }

            public void visitEnumConstructorCall(IrEnumConstructorCall expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall((IrElementVisitorVoid)this, (IrEnumConstructorCall)expression2, (Void)data);
            }

            public void visitEnumConstructorCall(IrEnumConstructorCall expression2) {
                IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall((IrElementVisitorVoid)this, (IrEnumConstructorCall)expression2);
            }

            public void visitErrorExpression(IrErrorExpression expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitErrorExpression((IrElementVisitorVoid)this, (IrErrorExpression)expression2, (Void)data);
            }

            public void visitErrorExpression(IrErrorExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitErrorExpression((IrElementVisitorVoid)this, (IrErrorExpression)expression2);
            }

            public void visitErrorCallExpression(IrErrorCallExpression expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression((IrElementVisitorVoid)this, (IrErrorCallExpression)expression2, (Void)data);
            }

            public void visitErrorCallExpression(IrErrorCallExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression((IrElementVisitorVoid)this, (IrErrorCallExpression)expression2);
            }

            public void visitFieldAccess(IrFieldAccessExpression expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitFieldAccess((IrElementVisitorVoid)this, (IrFieldAccessExpression)expression2, (Void)data);
            }

            public void visitFieldAccess(IrFieldAccessExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitFieldAccess((IrElementVisitorVoid)this, (IrFieldAccessExpression)expression2);
            }

            public void visitGetField(IrGetField expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitGetField((IrElementVisitorVoid)this, (IrGetField)expression2, (Void)data);
            }

            public void visitGetField(IrGetField expression2) {
                IrElementVisitorVoid.DefaultImpls.visitGetField((IrElementVisitorVoid)this, (IrGetField)expression2);
            }

            public void visitSetField(IrSetField expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitSetField((IrElementVisitorVoid)this, (IrSetField)expression2, (Void)data);
            }

            public void visitSetField(IrSetField expression2) {
                IrElementVisitorVoid.DefaultImpls.visitSetField((IrElementVisitorVoid)this, (IrSetField)expression2);
            }

            public void visitFunctionExpression(IrFunctionExpression expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionExpression((IrElementVisitorVoid)this, (IrFunctionExpression)expression2, (Void)data);
            }

            public void visitFunctionExpression(IrFunctionExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionExpression((IrElementVisitorVoid)this, (IrFunctionExpression)expression2);
            }

            public void visitGetClass(IrGetClass expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitGetClass((IrElementVisitorVoid)this, (IrGetClass)expression2, (Void)data);
            }

            public void visitGetClass(IrGetClass expression2) {
                IrElementVisitorVoid.DefaultImpls.visitGetClass((IrElementVisitorVoid)this, (IrGetClass)expression2);
            }

            public void visitInstanceInitializerCall(IrInstanceInitializerCall expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall((IrElementVisitorVoid)this, (IrInstanceInitializerCall)expression2, (Void)data);
            }

            public void visitInstanceInitializerCall(IrInstanceInitializerCall expression2) {
                IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall((IrElementVisitorVoid)this, (IrInstanceInitializerCall)expression2);
            }

            public void visitLoop(IrLoop loop, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitLoop((IrElementVisitorVoid)this, (IrLoop)loop, (Void)data);
            }

            public void visitLoop(IrLoop loop) {
                IrElementVisitorVoid.DefaultImpls.visitLoop((IrElementVisitorVoid)this, (IrLoop)loop);
            }

            public void visitWhileLoop(IrWhileLoop loop, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitWhileLoop((IrElementVisitorVoid)this, (IrWhileLoop)loop, (Void)data);
            }

            public void visitWhileLoop(IrWhileLoop loop) {
                IrElementVisitorVoid.DefaultImpls.visitWhileLoop((IrElementVisitorVoid)this, (IrWhileLoop)loop);
            }

            public void visitDoWhileLoop(IrDoWhileLoop loop, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop((IrElementVisitorVoid)this, (IrDoWhileLoop)loop, (Void)data);
            }

            public void visitDoWhileLoop(IrDoWhileLoop loop) {
                IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop((IrElementVisitorVoid)this, (IrDoWhileLoop)loop);
            }

            public void visitReturn(IrReturn expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitReturn((IrElementVisitorVoid)this, (IrReturn)expression2, (Void)data);
            }

            public void visitReturn(IrReturn expression2) {
                IrElementVisitorVoid.DefaultImpls.visitReturn((IrElementVisitorVoid)this, (IrReturn)expression2);
            }

            public void visitStringConcatenation(IrStringConcatenation expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitStringConcatenation((IrElementVisitorVoid)this, (IrStringConcatenation)expression2, (Void)data);
            }

            public void visitStringConcatenation(IrStringConcatenation expression2) {
                IrElementVisitorVoid.DefaultImpls.visitStringConcatenation((IrElementVisitorVoid)this, (IrStringConcatenation)expression2);
            }

            public void visitSuspensionPoint(IrSuspensionPoint expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint((IrElementVisitorVoid)this, (IrSuspensionPoint)expression2, (Void)data);
            }

            public void visitSuspensionPoint(IrSuspensionPoint expression2) {
                IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint((IrElementVisitorVoid)this, (IrSuspensionPoint)expression2);
            }

            public void visitSuspendableExpression(IrSuspendableExpression expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression((IrElementVisitorVoid)this, (IrSuspendableExpression)expression2, (Void)data);
            }

            public void visitSuspendableExpression(IrSuspendableExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression((IrElementVisitorVoid)this, (IrSuspendableExpression)expression2);
            }

            public void visitThrow(IrThrow expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitThrow((IrElementVisitorVoid)this, (IrThrow)expression2, (Void)data);
            }

            public void visitThrow(IrThrow expression2) {
                IrElementVisitorVoid.DefaultImpls.visitThrow((IrElementVisitorVoid)this, (IrThrow)expression2);
            }

            public void visitTry(IrTry aTry, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitTry((IrElementVisitorVoid)this, (IrTry)aTry, (Void)data);
            }

            public void visitTry(IrTry aTry) {
                IrElementVisitorVoid.DefaultImpls.visitTry((IrElementVisitorVoid)this, (IrTry)aTry);
            }

            public void visitCatch(IrCatch aCatch, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitCatch((IrElementVisitorVoid)this, (IrCatch)aCatch, (Void)data);
            }

            public void visitCatch(IrCatch aCatch) {
                IrElementVisitorVoid.DefaultImpls.visitCatch((IrElementVisitorVoid)this, (IrCatch)aCatch);
            }

            public void visitTypeOperator(IrTypeOperatorCall expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitTypeOperator((IrElementVisitorVoid)this, (IrTypeOperatorCall)expression2, (Void)data);
            }

            public void visitTypeOperator(IrTypeOperatorCall expression2) {
                IrElementVisitorVoid.DefaultImpls.visitTypeOperator((IrElementVisitorVoid)this, (IrTypeOperatorCall)expression2);
            }

            public void visitValueAccess(IrValueAccessExpression expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitValueAccess((IrElementVisitorVoid)this, (IrValueAccessExpression)expression2, (Void)data);
            }

            public void visitValueAccess(IrValueAccessExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitValueAccess((IrElementVisitorVoid)this, (IrValueAccessExpression)expression2);
            }

            public void visitGetValue(IrGetValue expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitGetValue((IrElementVisitorVoid)this, (IrGetValue)expression2, (Void)data);
            }

            public void visitGetValue(IrGetValue expression2) {
                IrElementVisitorVoid.DefaultImpls.visitGetValue((IrElementVisitorVoid)this, (IrGetValue)expression2);
            }

            public void visitSetValue(IrSetValue expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitSetValue((IrElementVisitorVoid)this, (IrSetValue)expression2, (Void)data);
            }

            public void visitSetValue(IrSetValue expression2) {
                IrElementVisitorVoid.DefaultImpls.visitSetValue((IrElementVisitorVoid)this, (IrSetValue)expression2);
            }

            public void visitVararg(IrVararg expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitVararg((IrElementVisitorVoid)this, (IrVararg)expression2, (Void)data);
            }

            public void visitVararg(IrVararg expression2) {
                IrElementVisitorVoid.DefaultImpls.visitVararg((IrElementVisitorVoid)this, (IrVararg)expression2);
            }

            public void visitSpreadElement(IrSpreadElement spread, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitSpreadElement((IrElementVisitorVoid)this, (IrSpreadElement)spread, (Void)data);
            }

            public void visitSpreadElement(IrSpreadElement spread) {
                IrElementVisitorVoid.DefaultImpls.visitSpreadElement((IrElementVisitorVoid)this, (IrSpreadElement)spread);
            }

            public void visitWhen(IrWhen expression2, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitWhen((IrElementVisitorVoid)this, (IrWhen)expression2, (Void)data);
            }

            public void visitWhen(IrWhen expression2) {
                IrElementVisitorVoid.DefaultImpls.visitWhen((IrElementVisitorVoid)this, (IrWhen)expression2);
            }

            public void visitBranch(IrBranch branch, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitBranch((IrElementVisitorVoid)this, (IrBranch)branch, (Void)data);
            }

            public void visitBranch(IrBranch branch) {
                IrElementVisitorVoid.DefaultImpls.visitBranch((IrElementVisitorVoid)this, (IrBranch)branch);
            }

            public void visitElseBranch(IrElseBranch branch, Void data) {
                IrElementVisitorVoid.DefaultImpls.visitElseBranch((IrElementVisitorVoid)this, (IrElseBranch)branch, (Void)data);
            }

            public void visitElseBranch(IrElseBranch branch) {
                IrElementVisitorVoid.DefaultImpls.visitElseBranch((IrElementVisitorVoid)this, (IrElseBranch)branch);
            }

            private static final void visitClass$reportError(ScriptsToClassesLowering this$0, IrClass $declaration, KtDiagnosticFactory1<String> factory, Name name) {
                KtDiagnosticReporterWithContext.DiagnosticContextImpl diagnosticContextImpl = this$0.getContext().getKtDiagnosticReporter().at((IrDeclaration)$declaration);
                Name name2 = name;
                if (name2 == null) {
                    name2 = ((IrClassImpl)$declaration).getName();
                }
                String string = name2.asString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
                diagnosticContextImpl.report(factory, (Object)string);
            }

            static /* synthetic */ void visitClass$reportError$default(ScriptsToClassesLowering scriptsToClassesLowering, IrClass irClass, KtDiagnosticFactory1 ktDiagnosticFactory1, Name name, int n, Object object) {
                if ((n & 8) != 0) {
                    name = null;
                }
                collectCapturingClasses.collector.1.visitClass$reportError(scriptsToClassesLowering, irClass, (KtDiagnosticFactory1<String>)ktDiagnosticFactory1, name);
            }
        };
        for (IrStatement statement : irScript.getStatements()) {
            if (!(statement instanceof IrClassImpl)) continue;
            collector2.visitClass((IrClass)statement);
        }
        return capturingClasses;
    }

    /*
     * WARNING - void declaration
     */
    private final void finalizeScriptClass(IrScript irScript, ScriptsToClassesSymbolRemapper symbolRemapper2) {
        block10: {
            IrField irField;
            IrFieldBuilder $this$finalizeScriptClass_u24lambda_u2412_u24lambda_u2411;
            IrVariable irVariable;
            void $this$mapTo$iv$iv;
            if (irScript.getThisReceiver() == null) {
                IrSimpleTypeImpl type = new IrSimpleTypeImpl((IrClassifierSymbol)irScript.getSymbol(), false, CollectionsKt.emptyList(), CollectionsKt.emptyList(), null, 16, null);
                irScript.setThisReceiver(ScriptLoweringKt.access$createThisReceiverParameter((IrDeclarationParent)irScript, this.context, (IrDeclarationOrigin)IrDeclarationOrigin.Companion.getINSTANCE_RECEIVER(), (IrType)type));
            }
            IrClassSymbol irClassSymbol = irScript.getTargetClass();
            Intrinsics.checkNotNull((Object)irClassSymbol);
            IrClass irScriptClass = (IrClass)irClassSymbol.getOwner();
            SimpleTypeRemapper typeRemapper = new SimpleTypeRemapper((SymbolRemapper)symbolRemapper2);
            Set<IrClassImpl> capturingClasses = this.collectCapturingClasses(irScript, typeRemapper);
            IrField earlierScriptField = ScriptLoweringKt.access$addEarlierScriptField(irScriptClass, irScript);
            ArrayList implicitReceiversFieldsWithParameters = ScriptLoweringKt.access$makeImplicitReceiversFieldsWithParameters(irScriptClass, typeRemapper, irScript);
            ScriptToClassTransformer scriptTransformer = new ScriptToClassTransformer(irScript, irScriptClass, (TypeRemapper)typeRemapper, this.context, capturingClasses, earlierScriptField, implicitReceiversFieldsWithParameters);
            ScriptFixLambdasTransformer lambdaPatcher = new ScriptFixLambdasTransformer(irScriptClass);
            ScriptLoweringKt.access$patchDeclarationsDispatchReceiver(irScript, this.context, scriptTransformer.getScriptClassReceiver().getType());
            irScriptClass.setThisReceiver(scriptTransformer.getScriptClassReceiver());
            Iterable $this$map$iv = irScript.getExplicitCallParameters();
            boolean $i$f$map22 = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void parameter;
                irVariable = (IrVariable)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                IrClass $this$addField$iv = irScriptClass;
                boolean $i$f$addField = false;
                IrFactory $this$buildField$iv$iv = $this$addField$iv.getFactory();
                boolean $i$f$buildField = false;
                IrFieldBuilder $this$buildField_u24lambda_u244$iv$iv = new IrFieldBuilder();
                boolean bl2 = false;
                $this$finalizeScriptClass_u24lambda_u2412_u24lambda_u2411 = $this$buildField_u24lambda_u244$iv$iv;
                boolean bl3 = false;
                $this$finalizeScriptClass_u24lambda_u2412_u24lambda_u2411.setStartOffset(parameter.getStartOffset());
                $this$finalizeScriptClass_u24lambda_u2412_u24lambda_u2411.setEndOffset(parameter.getEndOffset());
                $this$finalizeScriptClass_u24lambda_u2412_u24lambda_u2411.setOrigin((IrDeclarationOrigin)IrDeclarationOrigin.Companion.getSCRIPT_CALL_PARAMETER());
                $this$finalizeScriptClass_u24lambda_u2412_u24lambda_u2411.setName(parameter.getName());
                $this$finalizeScriptClass_u24lambda_u2412_u24lambda_u2411.setType(parameter.getType());
                $this$finalizeScriptClass_u24lambda_u2412_u24lambda_u2411.setVisibility(DescriptorVisibilities.LOCAL);
                $this$finalizeScriptClass_u24lambda_u2412_u24lambda_u2411.setFinal(true);
                IrFactory field$iv = $this$buildField$iv$iv = DeclarationBuildersKt.buildField((IrFactory)$this$buildField$iv$iv, (IrFieldBuilder)$this$buildField_u24lambda_u244$iv$iv);
                boolean bl4 = false;
                field$iv.setParent((IrDeclarationParent)$this$addField$iv);
                $this$addField$iv.getDeclarations().add(field$iv);
                IrFactory field = $this$buildField$iv$iv;
                collection.add(TuplesKt.to((Object)parameter, (Object)field));
            }
            List explicitParametersWithFields = (List)destination$iv$iv;
            IrConstructor irConstructor = irScript.getConstructor();
            IrElement $i$f$map22 = irConstructor != null ? ScriptsToClassesLowering.finalizeScriptClass$patchDeclarationForClass((IrElement)irConstructor, irScriptClass, scriptTransformer, lambdaPatcher) : null;
            IrConstructor irConstructor2 = $i$f$map22 instanceof IrConstructor ? (IrConstructor)$i$f$map22 : null;
            if (irConstructor2 == null) {
                irConstructor2 = this.createConstructor(irScriptClass, irScript, implicitReceiversFieldsWithParameters);
            }
            Iterable constructor = $this$map$iv = irConstructor2;
            boolean bl = false;
            int explicitParamsStartIndex = irScript.getEarlierScriptsParameter() == null ? 0 : 1;
            List explicitParameters = constructor.getValueParameters().subList(explicitParamsStartIndex, irScript.getExplicitCallParameters().size() + explicitParamsStartIndex);
            constructor.setBody((IrBody)ScriptLoweringKt.access$makeScriptClassConstructorBody((IrBuilderWithScope)LowerUtilsKt.createIrBuilder$default((BackendContext)((BackendContext)this.context), (IrSymbol)((IrSymbol)constructor.getSymbol()), (int)0, (int)0, (int)6, null), irScript, irScriptClass, explicitParameters, earlierScriptField, explicitParametersWithFields, implicitReceiversFieldsWithParameters));
            irScriptClass.getDeclarations().add(constructor);
            constructor.setParent((IrDeclarationParent)irScriptClass);
            boolean hasMain = false;
            Iterable $this$forEach$iv = irScript.getStatements();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                void $this$finalizeScriptClass_u24lambda_u2416_u24lambda_u2415_u24lambda_u2414;
                void this_$iv$iv;
                IrFieldBuilder irFieldBuilder;
                IrVariable copy;
                IrStatement scriptStatement = (IrStatement)element$iv;
                boolean bl5 = false;
                irVariable = scriptStatement;
                if (irVariable instanceof IrVariable) {
                    IrElement irElement = ScriptsToClassesLowering.finalizeScriptClass$patchDeclarationForClass((IrElement)scriptStatement, irScriptClass, scriptTransformer, lambdaPatcher);
                    Intrinsics.checkNotNull((Object)irElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrVariable");
                    copy = (IrVariable)irElement;
                    ScriptsToClassesLowering.addSimplePropertyFrom$default(this, irScriptClass, (IrValueDeclaration)copy, null, 2, null);
                    continue;
                }
                if (irVariable instanceof IrDeclaration) {
                    IrElement irElement = ScriptsToClassesLowering.finalizeScriptClass$patchDeclarationForClass((IrElement)scriptStatement, irScriptClass, scriptTransformer, lambdaPatcher);
                    Intrinsics.checkNotNull((Object)irElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrDeclaration");
                    copy = (IrDeclaration)irElement;
                    irScriptClass.getDeclarations().add(copy);
                    if (!(copy instanceof IrSimpleFunction) || !Intrinsics.areEqual((Object)((IrSimpleFunction)copy).getName().asString(), (Object)"main")) continue;
                    hasMain = true;
                    continue;
                }
                IrElement irElement = ScriptsToClassesLowering.finalizeScriptClass$patchTopLevelStatementForClass((IrElement)scriptStatement, irScriptClass, scriptTransformer, lambdaPatcher);
                Intrinsics.checkNotNull((Object)irElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.IrStatement");
                IrStatement transformedStatement = (IrStatement)irElement;
                IrClass $this$addAnonymousInitializer_u24default$iv = irScriptClass;
                boolean $i$f$addAnonymousInitializer = false;
                IrFunctionBuilder $this$addAnonymousInitializer_u24lambda_u2412$iv = new IrFunctionBuilder();
                boolean bl6 = false;
                IrFunctionBuilder bl4 = $this$addAnonymousInitializer_u24lambda_u2412$iv;
                boolean bl7 = false;
                IrFunctionBuilder irFunctionBuilder = bl4;
                $this$addAnonymousInitializer_u24lambda_u2412$iv.setReturnType((IrType)IrUtilsKt.getDefaultType((IrClass)$this$addAnonymousInitializer_u24default$iv));
                IrFieldBuilder anonymousInitializer$iv = $this$finalizeScriptClass_u24lambda_u2412_u24lambda_u2411 = IrFactory.createAnonymousInitializer$default((IrFactory)$this$addAnonymousInitializer_u24default$iv.getFactory(), (int)$this$addAnonymousInitializer_u24lambda_u2412$iv.getStartOffset(), (int)$this$addAnonymousInitializer_u24lambda_u2412$iv.getEndOffset(), (IrDeclarationOrigin)$this$addAnonymousInitializer_u24lambda_u2412$iv.getOrigin(), (IrAnonymousInitializerSymbol)((IrAnonymousInitializerSymbol)new IrAnonymousInitializerSymbolImpl(null, 1, null)), (boolean)false, (int)16, null);
                boolean bl8 = false;
                $this$addAnonymousInitializer_u24default$iv.getDeclarations().add(anonymousInitializer$iv);
                anonymousInitializer$iv.setParent((IrDeclarationParent)$this$addAnonymousInitializer_u24default$iv);
                IrFieldBuilder irInitializer = irFieldBuilder = $this$finalizeScriptClass_u24lambda_u2412_u24lambda_u2411;
                boolean bl9 = false;
                IrBuilderWithScope $this$irBlockBody_u24default$iv = (IrBuilderWithScope)LowerUtilsKt.createIrBuilder$default((BackendContext)((BackendContext)this.context), (IrSymbol)((IrSymbol)irInitializer.getSymbol()), (int)0, (int)0, (int)6, null);
                int startOffset$iv = $this$irBlockBody_u24default$iv.getStartOffset();
                int endOffset$iv = $this$irBlockBody_u24default$iv.getEndOffset();
                boolean $i$f$irBlockBody = false;
                $this$finalizeScriptClass_u24lambda_u2412_u24lambda_u2411 = new IrBlockBodyBuilder($this$irBlockBody_u24default$iv.getContext(), $this$irBlockBody_u24default$iv.getScope(), startOffset$iv, endOffset$iv);
                boolean $i$f$blockBody = false;
                void var29_45 = this_$iv$iv;
                IrFieldBuilder irFieldBuilder2 = irInitializer;
                boolean bl10 = false;
                if (transformedStatement instanceof IrComposite) {
                    for (IrStatement statement : ((IrComposite)transformedStatement).getStatements()) {
                        $this$finalizeScriptClass_u24lambda_u2416_u24lambda_u2415_u24lambda_u2414.unaryPlus(statement);
                    }
                } else {
                    $this$finalizeScriptClass_u24lambda_u2416_u24lambda_u2415_u24lambda_u2414.unaryPlus(transformedStatement);
                }
                irFieldBuilder2.setBody(this_$iv$iv.doBuild());
            }
            if (!hasMain) {
                this.addScriptMainFun(irScriptClass);
            }
            Collection collection = irScriptClass.getAnnotations();
            IrDeclarationParent irDeclarationParent = irScriptClass.getParent();
            Intrinsics.checkNotNull((Object)irDeclarationParent, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrFile");
            irScriptClass.setAnnotations(CollectionsKt.plus((Collection)collection, (Iterable)((IrFile)irDeclarationParent).getAnnotations()));
            IrPropertySymbol irPropertySymbol = irScript.getResultProperty();
            if (irPropertySymbol == null || (irPropertySymbol = (IrProperty)irPropertySymbol.getOwner()) == null) break block10;
            IrPropertySymbol irResultProperty = irPropertySymbol;
            boolean bl11 = false;
            this.context.getState().getScriptSpecific().setResultFieldName(irResultProperty.getName().getIdentifier());
            this.context.getState().getScriptSpecific().setResultType((irField = irResultProperty.getBackingField()) != null && (irField = irField.getType()) != null ? IrBasedDescriptorsKt.toIrBasedKotlinType$default((IrType)irField, null, (int)1, null) : null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final IrConstructor createConstructor(IrClass irScriptClass, IrScript irScript, ArrayList<Pair<IrField, IrValueParameter>> implicitReceiversFieldsWithParameters) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$createConstructor_u24lambda_u2425_u24lambda_u2424;
        IrValueParameter it;
        List list;
        IrFunctionBuilder irFunctionBuilder;
        IrFunctionBuilder $this$createConstructor_u24lambda_u2418 = irFunctionBuilder = new IrFunctionBuilder();
        boolean bl = false;
        $this$createConstructor_u24lambda_u2418.setPrimary(true);
        IrValueParameter irValueParameter = irScriptClass.getThisReceiver();
        Intrinsics.checkNotNull((Object)irValueParameter);
        IrType irType = irValueParameter.getType();
        Intrinsics.checkNotNull((Object)irType, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.types.IrSimpleType");
        $this$createConstructor_u24lambda_u2418.setReturnType((IrType)((IrSimpleType)irType));
        IrFunctionBuilder $this$createConstructor_u24lambda_u2419 = irFunctionBuilder;
        boolean bl2 = false;
        IrFunctionBuilder irConstructor = irFunctionBuilder = irScriptClass.getFactory().createConstructor($this$createConstructor_u24lambda_u2419.getStartOffset(), $this$createConstructor_u24lambda_u2419.getEndOffset(), $this$createConstructor_u24lambda_u2419.getOrigin(), SpecialNames.INIT, $this$createConstructor_u24lambda_u2419.getVisibility(), $this$createConstructor_u24lambda_u2419.isInline(), $this$createConstructor_u24lambda_u2419.isExpect(), $this$createConstructor_u24lambda_u2419.getReturnType(), (IrConstructorSymbol)new IrConstructorSymbolImpl(null, null, 3, null), $this$createConstructor_u24lambda_u2419.isPrimary(), $this$createConstructor_u24lambda_u2419.isExternal(), $this$createConstructor_u24lambda_u2419.getContainerSource());
        boolean bl3 = false;
        int parametersIndex = 0;
        List list2 = list = CollectionsKt.createListBuilder();
        IrFunctionBuilder irFunctionBuilder2 = irConstructor;
        boolean bl4 = false;
        IrValueParameter irValueParameter2 = irScript.getEarlierScriptsParameter();
        if (irValueParameter2 != null) {
            it = irValueParameter2;
            boolean bl5 = false;
            $this$createConstructor_u24lambda_u2425_u24lambda_u2424.add(it);
            ++parametersIndex;
        }
        Iterable iterable = irScript.getExplicitCallParameters();
        void var15_16 = $this$createConstructor_u24lambda_u2425_u24lambda_u2424;
        boolean $i$f$map = false;
        it = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            IrValueParameter irValueParameter3;
            IrVariable irVariable = (IrVariable)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl6 = false;
            int n = parametersIndex;
            parametersIndex = n + 1;
            IrValueParameter it3 = irValueParameter3 = this.context.getIrFactory().createValueParameter(it2.getStartOffset(), it2.getEndOffset(), (IrDeclarationOrigin)IrDeclarationOrigin.Companion.getSCRIPT_CALL_PARAMETER(), it2.getName(), it2.getType(), false, (IrValueParameterSymbol)new IrValueParameterSymbolImpl(null, null, 3, null), n, null, false, false, false);
            boolean bl7 = false;
            it3.setParent((IrDeclarationParent)irScript);
            collection.add(irValueParameter3);
        }
        var15_16.addAll((List)destination$iv$iv);
        Iterable $this$forEach$iv = implicitReceiversFieldsWithParameters;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair pair = (Pair)element$iv;
            boolean bl8 = false;
            IrValueParameter param = (IrValueParameter)pair.component2();
            $this$createConstructor_u24lambda_u2425_u24lambda_u2424.add(param);
        }
        $this$createConstructor_u24lambda_u2425_u24lambda_u2424.addAll(irScript.getProvidedPropertiesParameters());
        irFunctionBuilder2.setValueParameters(CollectionsKt.build((List)list));
        irConstructor.setParent((IrDeclarationParent)irScript);
        return irFunctionBuilder;
    }

    private final IrExternalPackageFragment getScriptingJvmPackage() {
        Lazy lazy = this.scriptingJvmPackage$delegate;
        return (IrExternalPackageFragment)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private final void addScriptMainFun(IrClass $this$addScriptMainFun) {
        void $this$addScriptMainFun_u24lambda_u2437_u24lambda_u2436_u24lambda_u2435_u24lambda_u2434;
        void $this$addScriptMainFun_u24lambda_u2437_u24lambda_u2436_u24lambda_u2435;
        void $this$addScriptMainFun_u24lambda_u2437_u24lambda_u2436;
        IrFactory irFactory;
        IrValueParameter irValueParameter;
        IrClassSymbol javaLangClass = this.context.getIr().getSymbols().getJavaLangClass();
        IrSimpleFunction kClassJavaPropertyGetter = this.context.getIr().getSymbols().getKClassJavaPropertyGetter();
        IrFactory $this$buildClass$iv = this.context.getIrFactory();
        boolean $i$f$buildClass = false;
        IrClassBuilder $this$buildClass_u24lambda_u241$iv = new IrClassBuilder();
        boolean bl = false;
        IrClassBuilder $this$addScriptMainFun_u24lambda_u2427 = $this$buildClass_u24lambda_u241$iv;
        boolean bl2 = false;
        $this$addScriptMainFun_u24lambda_u2427.setName(Name.identifier((String)"RunnerKt"));
        $this$addScriptMainFun_u24lambda_u2427.setKind(ClassKind.CLASS);
        $this$addScriptMainFun_u24lambda_u2427.setModality(Modality.FINAL);
        IrFactory $this$addScriptMainFun_u24lambda_u2430 = $this$buildClass$iv = DeclarationBuildersKt.buildClass((IrFactory)$this$buildClass$iv, (IrClassBuilder)$this$buildClass_u24lambda_u241$iv);
        boolean bl3 = false;
        $this$addScriptMainFun_u24lambda_u2430.setParent((IrDeclarationParent)this.getScriptingJvmPackage());
        IrUtilsKt.createImplicitParameterDeclarationWithWrappedDescriptor((IrClass)$this$addScriptMainFun_u24lambda_u2430);
        IrSimpleFunction $this$addScriptMainFun_u24lambda_u2430_u24lambda_u2429 = bl = DeclarationBuildersKt.addFunction$default((IrClass)$this$addScriptMainFun_u24lambda_u2430, (String)"runCompiledScript", (IrType)this.context.getIrBuiltIns().getUnitType(), null, null, (boolean)true, (boolean)false, (boolean)false, (boolean)false, null, (int)0, (int)0, (int)2028, null);
        boolean bl4 = false;
        DeclarationBuildersKt.addValueParameter$default((IrFunction)((IrFunction)$this$addScriptMainFun_u24lambda_u2430_u24lambda_u2429), (String)"scriptClass", (IrType)((IrType)IrTypesKt.getStarProjectedType((IrClassSymbol)javaLangClass)), null, (int)4, null);
        IrFunction $this$addValueParameter$iv = (IrFunction)$this$addScriptMainFun_u24lambda_u2430_u24lambda_u2429;
        boolean $i$f$addValueParameter = false;
        IrValueParameterBuilder $this$addValueParameter_u24lambda_u2432$iv = new IrValueParameterBuilder();
        boolean bl5 = false;
        IrValueParameterBuilder $this$addScriptMainFun_u24lambda_u2430_u24lambda_u2429_u24lambda_u2428 = $this$addValueParameter_u24lambda_u2432$iv;
        boolean bl6 = false;
        $this$addScriptMainFun_u24lambda_u2430_u24lambda_u2429_u24lambda_u2428.setName(Name.identifier((String)"args"));
        IrValueParameter irValueParameter2 = new IrValueParameter[]{this.context.getIrBuiltIns().getStringType()};
        $this$addScriptMainFun_u24lambda_u2430_u24lambda_u2429_u24lambda_u2428.setType((IrType)IrTypesKt.typeWith((IrClassifierSymbol)((IrClassifierSymbol)this.context.getIrBuiltIns().getArrayClass()), (IrType[])irValueParameter2));
        $this$addScriptMainFun_u24lambda_u2430_u24lambda_u2429_u24lambda_u2428.setOrigin((IrDeclarationOrigin)IrDeclarationOrigin.Companion.getDEFINED());
        $this$addScriptMainFun_u24lambda_u2430_u24lambda_u2429_u24lambda_u2428.setVarargElementType(this.context.getIrBuiltIns().getAnyNType());
        if ($this$addValueParameter_u24lambda_u2432$iv.getIndex() == -1) {
            $this$addValueParameter_u24lambda_u2432$iv.setIndex($this$addValueParameter$iv.getValueParameters().size());
        }
        IrValueParameter valueParameter$iv = irValueParameter = DeclarationBuildersKt.buildValueParameter((IrFactory)$this$addValueParameter$iv.getFactory(), (IrValueParameterBuilder)$this$addValueParameter_u24lambda_u2432$iv, (IrDeclarationParent)((IrDeclarationParent)$this$addValueParameter$iv));
        boolean bl7 = false;
        $this$addValueParameter$iv.setValueParameters(CollectionsKt.plus((Collection)$this$addValueParameter$iv.getValueParameters(), (Object)valueParameter$iv));
        IrClassSymbol scriptRunnerPackageClass = $this$buildClass$iv.getSymbol();
        Sequence $this$single$iv = IrUtilsKt.getFunctions((IrClassSymbol)scriptRunnerPackageClass);
        boolean $i$f$single = false;
        Object single$iv = null;
        boolean found$iv = false;
        for (Object element$iv : $this$single$iv) {
            IrSimpleFunctionSymbol it = (IrSimpleFunctionSymbol)element$iv;
            boolean bl8 = false;
            if (!Intrinsics.areEqual((Object)((IrSimpleFunction)it.getOwner()).getName().asString(), (Object)"runCompiledScript")) continue;
            if (found$iv) {
                throw new IllegalArgumentException("Sequence contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw new NoSuchElementException("Sequence contains no element matching the predicate.");
        }
        IrSimpleFunctionSymbol scriptRunHelper = single$iv;
        IrClassReferenceImpl scriptClassRef = BuildersKt.IrClassReferenceImpl((int)$this$addScriptMainFun.getStartOffset(), (int)$this$addScriptMainFun.getEndOffset(), (IrType)((IrType)IrTypesKt.getStarProjectedType((IrClassSymbol)this.context.getIrBuiltIns().getKClassClass())), (IrClassifierSymbol)((IrClassifierSymbol)this.context.getIrBuiltIns().getKClassClass()), (IrType)((IrType)IrUtilsKt.getDefaultType((IrClass)$this$addScriptMainFun)));
        IrClass $this$addFunction$iv = $this$addScriptMainFun;
        boolean $i$f$addFunction = false;
        IrFactory $this$addFunction$iv$iv = $this$addFunction$iv.getFactory();
        boolean $i$f$addFunction2 = false;
        IrFactory $this$buildFun$iv$iv$iv = $this$addFunction$iv$iv;
        boolean $i$f$buildFun = false;
        IrFunctionBuilder $this$buildFun_u24lambda_u2420$iv$iv$iv = new IrFunctionBuilder();
        boolean bl9 = false;
        IrFunctionBuilder $this$addScriptMainFun_u24lambda_u2432 = $this$buildFun_u24lambda_u2420$iv$iv$iv;
        boolean $i$a$-addFunction-ScriptsToClassesLowering$addScriptMainFun$22 = false;
        $this$addScriptMainFun_u24lambda_u2432.setName(Name.identifier((String)"main"));
        $this$addScriptMainFun_u24lambda_u2432.setVisibility(DescriptorVisibilities.PUBLIC);
        $this$addScriptMainFun_u24lambda_u2432.setReturnType(this.context.getIrBuiltIns().getUnitType());
        $this$addScriptMainFun_u24lambda_u2432.setModality(Modality.FINAL);
        IrFactory function$iv$iv = $this$buildFun$iv$iv$iv = DeclarationBuildersKt.buildFunction((IrFactory)$this$buildFun$iv$iv$iv, (IrFunctionBuilder)$this$buildFun_u24lambda_u2420$iv$iv$iv);
        boolean bl10 = false;
        ((IrDeclarationContainer)$this$addFunction$iv).getDeclarations().add(function$iv$iv);
        function$iv$iv.setParent((IrDeclarationParent)((IrDeclarationContainer)$this$addFunction$iv));
        IrFactory mainFun = irFactory = $this$buildFun$iv$iv$iv;
        boolean bl11 = false;
        IrFunction $this$addValueParameter$iv2 = (IrFunction)mainFun;
        boolean $i$f$addValueParameter22 = false;
        IrValueParameterBuilder $this$addValueParameter_u24lambda_u2432$iv2 = new IrValueParameterBuilder();
        $i$a$-run-DeclarationBuildersKt$addValueParameter$1$iv = false;
        IrValueParameterBuilder $this$addScriptMainFun_u24lambda_u2437_u24lambda_u2433 = $this$addValueParameter_u24lambda_u2432$iv2;
        boolean bl12 = false;
        $this$addScriptMainFun_u24lambda_u2437_u24lambda_u2433.setName(Name.identifier((String)"args"));
        IrType[] $i$a$-addFunction-ScriptsToClassesLowering$addScriptMainFun$22 = new IrType[]{this.context.getIrBuiltIns().getStringType()};
        $this$addScriptMainFun_u24lambda_u2437_u24lambda_u2433.setType((IrType)IrTypesKt.typeWith((IrClassifierSymbol)((IrClassifierSymbol)this.context.getIrBuiltIns().getArrayClass()), (IrType[])$i$a$-addFunction-ScriptsToClassesLowering$addScriptMainFun$22));
        if ($this$addValueParameter_u24lambda_u2432$iv2.getIndex() == -1) {
            $this$addValueParameter_u24lambda_u2432$iv2.setIndex($this$addValueParameter$iv2.getValueParameters().size());
        }
        IrValueParameter valueParameter$iv2 = irValueParameter2 = DeclarationBuildersKt.buildValueParameter((IrFactory)$this$addValueParameter$iv2.getFactory(), (IrValueParameterBuilder)$this$addValueParameter_u24lambda_u2432$iv2, (IrDeclarationParent)((IrDeclarationParent)$this$addValueParameter$iv2));
        $i$a$-also-DeclarationBuildersKt$addValueParameter$1$1$iv = false;
        $this$addValueParameter$iv2.setValueParameters(CollectionsKt.plus((Collection)$this$addValueParameter$iv2.getValueParameters(), (Object)valueParameter$iv2));
        IrValueParameter args = irValueParameter2;
        DeclarationIrBuilder $i$f$addValueParameter22 = LowerUtilsKt.createIrBuilder$default((BackendContext)((BackendContext)this.context), (IrSymbol)((IrSymbol)mainFun.getSymbol()), (int)0, (int)0, (int)6, null);
        IrFactory irFactory2 = mainFun;
        boolean bl13 = false;
        IrCall irCall = ExpressionHelpersKt.irCall((IrBuilderWithScope)((IrBuilderWithScope)$this$addScriptMainFun_u24lambda_u2437_u24lambda_u2436), (IrSimpleFunctionSymbol)scriptRunHelper);
        $this$addScriptMainFun_u24lambda_u2437_u24lambda_u2433 = irCall;
        IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$addScriptMainFun_u24lambda_u2437_u24lambda_u2436;
        boolean bl14 = false;
        valueParameter$iv2 = irValueParameter2 = ExpressionHelpersKt.irGet((IrBuilderWithScope)((IrBuilderWithScope)$this$addScriptMainFun_u24lambda_u2437_u24lambda_u2436), (IrType)((IrType)IrTypesKt.getStarProjectedType((IrClassSymbol)javaLangClass)), null, (IrFunctionSymbol)((IrFunctionSymbol)kClassJavaPropertyGetter.getSymbol()));
        int n = 0;
        void var22_49 = $this$addScriptMainFun_u24lambda_u2437_u24lambda_u2436_u24lambda_u2435;
        boolean bl15 = false;
        $this$addScriptMainFun_u24lambda_u2437_u24lambda_u2436_u24lambda_u2435_u24lambda_u2434.setExtensionReceiver((IrExpression)scriptClassRef);
        Unit unit = Unit.INSTANCE;
        var22_49.putValueArgument(n, (IrExpression)irValueParameter2);
        $this$addScriptMainFun_u24lambda_u2437_u24lambda_u2436_u24lambda_u2435.putValueArgument(1, (IrExpression)BuildersKt.IrGetValueImpl$default((int)-1, (int)-1, (IrType)args.getType(), (IrValueSymbol)((IrValueSymbol)args.getSymbol()), null, (int)16, null));
        irFactory2.setBody((IrBody)ExpressionHelpersKt.irExprBody((IrBuilderWithScope)irBuilderWithScope, (IrExpression)((IrExpression)irCall)));
    }

    /*
     * WARNING - void declaration
     */
    private final void addSimplePropertyFrom(IrClass $this$addSimplePropertyFrom, IrValueDeclaration from, IrExpressionBody initializer) {
        void field;
        IrField irField;
        void $this$addSimplePropertyFrom_u24lambda_u2441_u24lambda_u2439;
        IrFactory irFactory;
        IrClass $this$addProperty$iv = $this$addSimplePropertyFrom;
        boolean $i$f$addProperty = false;
        IrFactory $this$buildProperty$iv$iv = $this$addProperty$iv.getFactory();
        boolean $i$f$buildProperty = false;
        IrPropertyBuilder $this$buildProperty_u24lambda_u248$iv$iv = new IrPropertyBuilder();
        boolean bl = false;
        IrPropertyBuilder $this$addSimplePropertyFrom_u24lambda_u2438 = $this$buildProperty_u24lambda_u248$iv$iv;
        boolean $i$a$-addProperty-ScriptsToClassesLowering$addSimplePropertyFrom$22 = false;
        $this$addSimplePropertyFrom_u24lambda_u2438.updateFrom((IrDeclaration)from);
        $this$addSimplePropertyFrom_u24lambda_u2438.setName(from.getName());
        IrFactory property$iv = $this$buildProperty$iv$iv = DeclarationBuildersKt.buildProperty((IrFactory)$this$buildProperty$iv$iv, (IrPropertyBuilder)$this$buildProperty_u24lambda_u248$iv$iv);
        boolean bl2 = false;
        $this$addProperty$iv.getDeclarations().add(property$iv);
        property$iv.setParent((IrDeclarationParent)$this$addProperty$iv);
        IrFactory property = irFactory = $this$buildProperty$iv$iv;
        boolean bl3 = false;
        IrFactory $this$buildField$iv = this.context.getIrFactory();
        boolean $i$f$buildField22 = false;
        IrFieldBuilder $this$buildField_u24lambda_u244$iv = new IrFieldBuilder();
        boolean bl4 = false;
        IrFieldBuilder $i$a$-addProperty-ScriptsToClassesLowering$addSimplePropertyFrom$22 = $this$buildField_u24lambda_u244$iv;
        IrFactory irFactory2 = property;
        boolean bl5 = false;
        $this$addSimplePropertyFrom_u24lambda_u2441_u24lambda_u2439.setName(from.getName());
        $this$addSimplePropertyFrom_u24lambda_u2441_u24lambda_u2439.setType(from.getType());
        $this$addSimplePropertyFrom_u24lambda_u2441_u24lambda_u2439.setVisibility(DescriptorVisibilities.PROTECTED);
        IrField $i$f$buildField22 = irField = DeclarationBuildersKt.buildField((IrFactory)$this$buildField$iv, (IrFieldBuilder)$this$buildField_u24lambda_u244$iv);
        boolean bl6 = false;
        field.setParent((IrDeclarationParent)$this$addSimplePropertyFrom);
        if (initializer != null) {
            field.setInitializer(initializer);
        }
        irFactory2.setBackingField(irField);
        DeclarationBuildersKt.addDefaultGetter((IrProperty)property, (IrClass)$this$addSimplePropertyFrom, (IrBuiltIns)this.context.getIrBuiltIns());
    }

    static /* synthetic */ void addSimplePropertyFrom$default(ScriptsToClassesLowering scriptsToClassesLowering, IrClass irClass, IrValueDeclaration irValueDeclaration, IrExpressionBody irExpressionBody, int n, Object object) {
        if ((n & 2) != 0) {
            irExpressionBody = null;
        }
        scriptsToClassesLowering.addSimplePropertyFrom(irClass, irValueDeclaration, irExpressionBody);
    }

    private static final Iterable lower$lambda$3(Map $scriptDependencies, IrScript $this$topologicalSort) {
        Intrinsics.checkNotNullParameter((Object)$this$topologicalSort, (String)"$this$topologicalSort");
        List list = (List)$scriptDependencies.get($this$topologicalSort);
        return list != null ? (Iterable)list : (Iterable)CollectionsKt.emptyList();
    }

    private static final <E extends IrElement> IrElement finalizeScriptClass$patchDeclarationForClass(E $this$finalizeScriptClass_u24patchDeclarationForClass, IrClass irScriptClass, ScriptToClassTransformer scriptTransformer, ScriptFixLambdasTransformer lambdaPatcher) {
        IrValueParameter irValueParameter = irScriptClass.getThisReceiver();
        ScriptToClassTransformerContext rootContext = ScriptToClassTransformerContext.Companion.makeRootContext((IrValueParameterSymbol)(irValueParameter != null ? irValueParameter.getSymbol() : null), false, $this$finalizeScriptClass_u24patchDeclarationForClass instanceof IrDeclaration ? (IrDeclaration)$this$finalizeScriptClass_u24patchDeclarationForClass : null);
        return $this$finalizeScriptClass_u24patchDeclarationForClass.transform((IrElementTransformer)scriptTransformer, (Object)rootContext).transform((IrElementTransformer)lambdaPatcher, (Object)new ScriptFixLambdasTransformerContext(false, null, 3, null));
    }

    private static final <E extends IrElement> IrElement finalizeScriptClass$patchTopLevelStatementForClass(E $this$finalizeScriptClass_u24patchTopLevelStatementForClass, IrClass irScriptClass, ScriptToClassTransformer scriptTransformer, ScriptFixLambdasTransformer lambdaPatcher) {
        IrValueParameter irValueParameter = irScriptClass.getThisReceiver();
        ScriptToClassTransformerContext rootContext = ScriptToClassTransformerContext.Companion.makeRootContext$default(ScriptToClassTransformerContext.Companion, (IrValueParameterSymbol)(irValueParameter != null ? irValueParameter.getSymbol() : null), true, null, 4, null);
        return $this$finalizeScriptClass_u24patchTopLevelStatementForClass.transform((IrElementTransformer)scriptTransformer, (Object)rootContext).transform((IrElementTransformer)lambdaPatcher, (Object)new ScriptFixLambdasTransformerContext(false, null, 3, null));
    }

    private static final IrExternalPackageFragment scriptingJvmPackage_delegate$lambda$26(ScriptsToClassesLowering this$0) {
        return IrPackageFragmentsKt.createEmptyExternalPackageFragment((ModuleDescriptor)this$0.context.getState().getModule(), (FqName)new FqName("kotlin.script.experimental.jvm"));
    }
}

