/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.ClassLoweringPass;
import org.jetbrains.kotlin.backend.common.phaser.PhaseDescription;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.lower.InheritedDefaultMethodsOnClassesLoweringKt;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;

@PhaseDescription(name="ReplaceDefaultImplsOverriddenSymbols", description="Replace overridden symbols for methods inherited from interfaces to classes")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u000e\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/ReplaceDefaultImplsOverriddenSymbols;", "Lorg/jetbrains/kotlin/backend/common/ClassLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "lower", "", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "visitSimpleFunction", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "backend.jvm.lower"})
@SourceDebugExtension(value={"SMAP\nInheritedDefaultMethodsOnClassesLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InheritedDefaultMethodsOnClassesLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/ReplaceDefaultImplsOverriddenSymbols\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,308:1\n1557#2:309\n1628#2,3:310\n*S KotlinDebug\n*F\n+ 1 InheritedDefaultMethodsOnClassesLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/ReplaceDefaultImplsOverriddenSymbols\n*L\n137#1:309\n137#1:310,3\n*E\n"})
public final class ReplaceDefaultImplsOverriddenSymbols
implements ClassLoweringPass {
    @NotNull
    private final JvmBackendContext context;

    public ReplaceDefaultImplsOverriddenSymbols(@NotNull JvmBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    public void lower(@NotNull IrClass irClass) {
        Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
        for (IrDeclaration declaration : irClass.getDeclarations()) {
            if (!(declaration instanceof IrSimpleFunction)) continue;
            this.visitSimpleFunction((IrSimpleFunction)declaration);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void visitSimpleFunction(@NotNull IrSimpleFunction declaration) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Iterable iterable = declaration.getOverriddenSymbols();
        IrSimpleFunction irSimpleFunction = declaration;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void symbol;
            IrSimpleFunctionSymbol irSimpleFunctionSymbol = (IrSimpleFunctionSymbol)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(InheritedDefaultMethodsOnClassesLoweringKt.findInterfaceImplementation((IrSimpleFunction)symbol.getOwner(), this.context.getConfig().getJvmDefaultMode()) != null ? this.context.getCachedDeclarations().getDefaultImplsRedirection((IrSimpleFunction)symbol.getOwner()).getSymbol() : symbol);
        }
        irSimpleFunction.setOverriddenSymbols((List)destination$iv$iv);
    }
}

