/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.intellij.internal.statistic.eventLog.EmptyStatisticsEventLoggerProvider;
import com.intellij.internal.statistic.eventLog.StatisticsEventLogProvidersHolder;
import com.intellij.internal.statistic.eventLog.StatisticsEventLoggerProvider;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.internal.statistic.utils.PluginType;
import com.intellij.internal.statistic.utils.StatisticsRecorderUtil;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.util.PlatformUtils;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.APP})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0001\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005H\u0002J\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\nH\u0002J\u000e\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0006J\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u000eJ\b\u0010\u000f\u001a\u00020\u0010H\u0002J \u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0007H\u0002R \u0010\u0003\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/internal/statistic/eventLog/StatisticsEventLogProvidersHolder;", "", "()V", "eventLoggerProviders", "Ljava/util/concurrent/atomic/AtomicReference;", "", "", "Lcom/intellij/internal/statistic/eventLog/StatisticsEventLoggerProvider;", "calculateEventLogProvider", "getAllEventLogProviders", "Lkotlin/sequences/Sequence;", "getEventLogProvider", "recorderId", "getEventLogProviders", "", "isJetBrainsProduct", "", "isProviderApplicable", "extension", "intellij.platform.statistics"})
@SourceDebugExtension(value={"SMAP\nStatisticsEventLogProvidersHolder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StatisticsEventLogProvidersHolder.kt\ncom/intellij/internal/statistic/eventLog/StatisticsEventLogProvidersHolder\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,69:1\n674#2:70\n704#2,4:71\n*S KotlinDebug\n*F\n+ 1 StatisticsEventLogProvidersHolder.kt\ncom/intellij/internal/statistic/eventLog/StatisticsEventLogProvidersHolder\n*L\n34#1:70\n34#1:71,4\n*E\n"})
public final class StatisticsEventLogProvidersHolder {
    @NotNull
    private final AtomicReference<Map<String, StatisticsEventLoggerProvider>> eventLoggerProviders = new AtomicReference<Map<String, StatisticsEventLoggerProvider>>(this.calculateEventLogProvider());

    public StatisticsEventLogProvidersHolder() {
        if (ApplicationManager.getApplication().getExtensionArea().hasExtensionPoint(StatisticsEventLoggerProvider.Companion.getEP_NAME())) {
            StatisticsEventLoggerProvider.Companion.getEP_NAME().addChangeListener(() -> StatisticsEventLogProvidersHolder._init_$lambda$0(this), null);
        }
    }

    @NotNull
    public final StatisticsEventLoggerProvider getEventLogProvider(@NotNull String recorderId) {
        Intrinsics.checkNotNullParameter((Object)recorderId, (String)"recorderId");
        StatisticsEventLoggerProvider statisticsEventLoggerProvider = this.eventLoggerProviders.get().get(recorderId);
        if (statisticsEventLoggerProvider == null) {
            statisticsEventLoggerProvider = new EmptyStatisticsEventLoggerProvider(recorderId);
        }
        return statisticsEventLoggerProvider;
    }

    @NotNull
    public final Collection<StatisticsEventLoggerProvider> getEventLogProviders() {
        return this.eventLoggerProviders.get().values();
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, StatisticsEventLoggerProvider> calculateEventLogProvider() {
        void $this$associateByTo$iv$iv;
        Sequence<StatisticsEventLoggerProvider> $this$associateBy$iv = this.getAllEventLogProviders();
        boolean $i$f$associateBy = false;
        Sequence<StatisticsEventLoggerProvider> sequence = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            StatisticsEventLoggerProvider statisticsEventLoggerProvider = (StatisticsEventLoggerProvider)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            map.put(it.getRecorderId(), element$iv$iv);
        }
        return destination$iv$iv;
    }

    private final Sequence<StatisticsEventLoggerProvider> getAllEventLogProviders() {
        List providers = StatisticsEventLoggerProvider.Companion.getEP_NAME().getExtensionsIfPointIsRegistered();
        if (providers.isEmpty()) {
            return SequencesKt.emptySequence();
        }
        boolean isJetBrainsProduct = this.isJetBrainsProduct();
        return SequencesKt.distinctBy((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)providers), (Function1)((Function1)new Function1<StatisticsEventLoggerProvider, Boolean>(this, isJetBrainsProduct){
            final /* synthetic */ StatisticsEventLogProvidersHolder this$0;
            final /* synthetic */ boolean $isJetBrainsProduct;
            {
                this.this$0 = $receiver;
                this.$isJetBrainsProduct = $isJetBrainsProduct;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull StatisticsEventLoggerProvider it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return StatisticsEventLogProvidersHolder.access$isProviderApplicable(this.this$0, this.$isJetBrainsProduct, it.getRecorderId(), it);
            }
        })), (Function1)getAllEventLogProviders.2.INSTANCE);
    }

    private final boolean isJetBrainsProduct() {
        CharSequence charSequence;
        ApplicationInfo appInfo = ApplicationInfo.getInstance();
        return appInfo == null || (charSequence = (CharSequence)appInfo.getShortCompanyName()) == null || charSequence.length() == 0 ? true : PlatformUtils.isJetBrainsProduct();
    }

    /*
     * Unable to fully structure code
     */
    private final boolean isProviderApplicable(boolean isJetBrainsProduct, String recorderId, StatisticsEventLoggerProvider extension) {
        block8: {
            block9: {
                if (!Intrinsics.areEqual((Object)recorderId, (Object)extension.getRecorderId())) break block8;
                if (!isJetBrainsProduct || !StatisticsRecorderUtil.isBuildInRecorder(recorderId)) {
                    return true;
                }
                pluginInfo = PluginInfoDetectorKt.getPluginInfo(extension.getClass());
                switch (recorderId.hashCode()) {
                    case 2369585: {
                        if (!recorderId.equals("MLSE")) {
                            break;
                        }
                        ** GOTO lbl16
                    }
                    case -2133792482: {
                        if (!recorderId.equals("IJ_MAP")) {
                            break;
                        }
                        ** GOTO lbl16
                    }
                    case 2463: {
                        if (!recorderId.equals("ML")) break;
lbl16:
                        // 3 sources

                        v0 = pluginInfo.isDevelopedByJetBrains();
                        break block9;
                    }
                }
                v0 = pluginInfo.getType() == PluginType.PLATFORM || pluginInfo.getType() == PluginType.FROM_SOURCES || pluginInfo.isAllowedToInjectIntoFUS() != false;
            }
            return v0;
        }
        return false;
    }

    private static final void _init_$lambda$0(StatisticsEventLogProvidersHolder this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.eventLoggerProviders.set(this$0.calculateEventLogProvider());
    }

    public static final /* synthetic */ boolean access$isProviderApplicable(StatisticsEventLogProvidersHolder $this, boolean isJetBrainsProduct, String recorderId, StatisticsEventLoggerProvider extension) {
        return $this.isProviderApplicable(isJetBrainsProduct, recorderId, extension);
    }
}

