/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.smartUpdate;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.openapi.updateSettings.impl.PluginUpdateFacadeKt;
import com.intellij.openapi.updateSettings.impl.UpdateChecker;
import com.intellij.smartUpdate.IdeUpdateStepKt;
import com.intellij.smartUpdate.PluginsUpdateStep;
import com.intellij.smartUpdate.SmartUpdateBundle;
import com.intellij.smartUpdate.SmartUpdateDialogKt;
import com.intellij.smartUpdate.SmartUpdateStep;
import com.intellij.ui.SpinningProgressIcon;
import com.intellij.ui.components.JBLabel;
import java.awt.Component;
import java.util.Collection;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\u0004H\u0003J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J(\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0013H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\u0014"}, d2={"Lcom/intellij/smartUpdate/PluginsUpdateStep;", "Lcom/intellij/smartUpdate/SmartUpdateStep;", "()V", "id", "", "getId", "()Ljava/lang/String;", "stepName", "getStepName", "getDescription", "getDetailsComponent", "Ljavax/swing/JComponent;", "project", "Lcom/intellij/openapi/project/Project;", "performUpdateStep", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "onSuccess", "Lkotlin/Function0;", "intellij.smart.update"})
public final class PluginsUpdateStep
implements SmartUpdateStep {
    @NotNull
    private final String id;
    @NotNull
    private final String stepName = SmartUpdateBundle.INSTANCE.message("update.plugins", new Object[0]);

    public PluginsUpdateStep() {
        this.id = "plugins.update";
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    @NotNull
    public String getStepName() {
        return this.stepName;
    }

    @Override
    public void performUpdateStep(@NotNull Project project, @Nullable AnActionEvent e, @NotNull Function0<Unit> onSuccess) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(onSuccess, (String)"onSuccess");
        Function0 doUpdate2 = (Function0)new Function0<Unit>(onSuccess, e, project){
            final /* synthetic */ Function0<Unit> $onSuccess;
            final /* synthetic */ AnActionEvent $e;
            final /* synthetic */ Project $project;
            {
                this.$onSuccess = $onSuccess;
                this.$e = $e;
                this.$project = $project;
                super(0);
            }

            public final void invoke() {
                Collection updates = PluginUpdateFacadeKt.getPendingUpdates();
                Collection collection = updates;
                if (collection == null || collection.isEmpty()) {
                    this.$onSuccess.invoke();
                } else {
                    AnActionEvent anActionEvent = this.$e;
                    Component component = anActionEvent != null && (anActionEvent = anActionEvent.getDataContext()) != null ? (Component)anActionEvent.getData(PlatformDataKeys.CONTEXT_COMPONENT) : null;
                    JComponent component2 = component instanceof JComponent ? (JComponent)component : null;
                    PluginUpdateFacadeKt.installUpdates((Collection)updates, (JComponent)component2, arg_0 -> performUpdateStep.doUpdate.1.invoke$lambda$0(this.$project, this.$onSuccess, arg_0));
                }
            }

            private static final void invoke$lambda$0(Project $project, Function0 $onSuccess, Boolean restartRequired) {
                Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
                Intrinsics.checkNotNullParameter((Object)$onSuccess, (String)"$onSuccess");
                Intrinsics.checkNotNullParameter((Object)restartRequired, (String)"restartRequired");
                if (restartRequired.booleanValue()) {
                    IdeUpdateStepKt.restartIde($project, SmartUpdateBundle.INSTANCE.message("dialog.title.plugin.updates.ready.to.install", new Object[0]), (Function0<Unit>)((Function0)performUpdateStep.doUpdate.1.1.INSTANCE));
                } else {
                    $onSuccess.invoke();
                }
            }
        };
        if (e == null) {
            UpdateChecker.INSTANCE.getUpdates().doWhenProcessed(() -> PluginsUpdateStep.performUpdateStep$lambda$0(doUpdate2));
        } else {
            doUpdate2.invoke();
        }
    }

    @Override
    @NotNull
    public JComponent getDetailsComponent(@NotNull Project project) {
        JBLabel jBLabel;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        JBLabel $this$getDetailsComponent_u24lambda_u241 = jBLabel = SmartUpdateDialogKt.hintLabel(SmartUpdateBundle.INSTANCE.message("checking.for.updates", new Object[0]));
        boolean bl = false;
        $this$getDetailsComponent_u24lambda_u241.setIcon((Icon)new SpinningProgressIcon(null, 0, 3, null));
        JBLabel label = jBLabel;
        UpdateChecker.INSTANCE.getUpdates().doWhenProcessed(() -> PluginsUpdateStep.getDetailsComponent$lambda$2(label, this));
        return (JComponent)label;
    }

    @Nls
    private final String getDescription() {
        String string;
        Object[] updates = PluginUpdateFacadeKt.getPendingUpdates();
        Object[] objectArray = updates;
        if (objectArray == null || objectArray.isEmpty()) {
            return SmartUpdateBundle.INSTANCE.message("no.updates.available", new Object[0]);
        }
        if (updates.size() == 1) {
            objectArray = new Object[1];
            Intrinsics.checkNotNullExpressionValue((Object)((PluginDownloader)CollectionsKt.first((Iterable)((Iterable)updates))).getPluginName(), (String)"getPluginName(...)");
            string = SmartUpdateBundle.INSTANCE.message("update.plugin", objectArray);
        } else {
            objectArray = new Object[]{updates.size()};
            string = SmartUpdateBundle.INSTANCE.message("update.several.plugins", objectArray);
        }
        return string;
    }

    private static final void performUpdateStep$lambda$0(Function0 $tmp0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke();
    }

    private static final void getDetailsComponent$lambda$2(JBLabel $label, PluginsUpdateStep this$0) {
        Intrinsics.checkNotNullParameter((Object)$label, (String)"$label");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        $label.setText(this$0.getDescription());
        $label.setIcon(null);
    }
}

