/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.core;

import com.intellij.history.ActivityId;
import com.intellij.history.ByteContent;
import com.intellij.history.core.ChangeList;
import com.intellij.history.core.Content;
import com.intellij.history.core.LabelImpl;
import com.intellij.history.core.changes.Change;
import com.intellij.history.core.changes.ChangeSet;
import com.intellij.history.core.changes.ChangeVisitor;
import com.intellij.history.core.changes.ContentChange;
import com.intellij.history.core.changes.CreateDirectoryChange;
import com.intellij.history.core.changes.CreateEntryChange;
import com.intellij.history.core.changes.CreateFileChange;
import com.intellij.history.core.changes.DeleteChange;
import com.intellij.history.core.changes.MoveChange;
import com.intellij.history.core.changes.PutLabelChange;
import com.intellij.history.core.changes.PutSystemLabelChange;
import com.intellij.history.core.changes.ROStatusChange;
import com.intellij.history.core.changes.RenameChange;
import com.intellij.history.core.changes.StructuralChange;
import com.intellij.history.core.tree.Entry;
import com.intellij.history.core.tree.RootEntry;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u000e\b\u0016\u0018\u00002\u00020\u0001:\u0001PB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0019H\u0007J\u0018\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u00102\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dJ\u0006\u0010\u001e\u001a\u00020\u0012J\u001e\u0010\u001f\u001a\u00020\u00122\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%J\u0016\u0010&\u001a\u00020\u00122\u0006\u0010 \u001a\u00020!2\u0006\u0010'\u001a\u00020(J\u0016\u0010)\u001a\u00020\u00122\u0006\u0010 \u001a\u00020!2\u0006\u0010*\u001a\u00020+J#\u0010,\u001a\u00020\u00122\r\u0010-\u001a\t\u0018\u00010!\u00a2\u0006\u0002\b.2\n\b\u0002\u0010/\u001a\u0004\u0018\u000100H\u0007J\u0010\u00101\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u00102\u001a\u00020\u00122\u0006\u00103\u001a\u00020\u000bH\u0002J\u0006\u00104\u001a\u00020\u0012J \u00105\u001a\u0002062\u0006\u00107\u001a\u0002082\u0006\u0010 \u001a\u00020!2\u0006\u00109\u001a\u00020\u0017H\u0002J\u0016\u0010:\u001a\u00020\u00122\u0006\u0010 \u001a\u00020!2\u0006\u0010;\u001a\u00020!J\u0010\u0010<\u001a\u00020=2\u0006\u0010\u0016\u001a\u00020>H\u0002J\u0010\u0010?\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020>H\u0007J#\u0010@\u001a\u00020=2\u000b\u0010-\u001a\u00070!\u00a2\u0006\u0002\b.2\u0006\u0010A\u001a\u00020!2\u0006\u0010B\u001a\u00020CJ\u001b\u0010D\u001a\u00020=2\u000b\u0010-\u001a\u00070!\u00a2\u0006\u0002\b.2\u0006\u0010A\u001a\u00020!J\u0016\u0010E\u001a\u00020\u00122\u0006\u0010 \u001a\u00020!2\u0006\u0010F\u001a\u00020(J\u000e\u0010G\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u0010J\u0016\u0010H\u001a\u00020\u00122\u0006\u0010 \u001a\u00020!2\u0006\u0010I\u001a\u00020!J.\u0010J\u001a\u00020!2\u0006\u00107\u001a\u0002082\u0006\u0010K\u001a\u00020%2\u0006\u0010 \u001a\u00020!2\u0006\u0010L\u001a\u00020(2\u0006\u0010M\u001a\u00020(J.\u0010N\u001a\u00020!2\u0006\u00107\u001a\u0002082\u0006\u0010O\u001a\u00020%2\u0006\u0010 \u001a\u00020!2\u0006\u0010L\u001a\u00020(2\u0006\u0010M\u001a\u00020(R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u00038G\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006Q"}, d2={"Lcom/intellij/history/core/LocalHistoryFacade;", "", "changeList", "Lcom/intellij/history/core/ChangeList;", "(Lcom/intellij/history/core/ChangeList;)V", "getChangeList$intellij_platform_lvcs_impl", "()Lcom/intellij/history/core/ChangeList;", "changeListInTests", "getChangeListInTests", "changes", "", "Lcom/intellij/history/core/changes/ChangeSet;", "getChanges$intellij_platform_lvcs_impl", "()Ljava/lang/Iterable;", "listeners", "", "Lcom/intellij/history/core/LocalHistoryFacade$Listener;", "accept", "", "v", "Lcom/intellij/history/core/changes/ChangeVisitor;", "addChange", "c", "Lcom/intellij/history/core/changes/Change;", "addChangeInTests", "Lcom/intellij/history/core/changes/StructuralChange;", "addListener", "l", "parent", "Lcom/intellij/openapi/Disposable;", "beginChangeSet", "contentChanged", "path", "", "oldContent", "Lcom/intellij/history/core/Content;", "oldTimestamp", "", "created", "isDirectory", "", "deleted", "deletedEntry", "Lcom/intellij/history/core/tree/Entry;", "endChangeSet", "name", "Lcom/intellij/openapi/util/NlsContexts$Label;", "activityId", "Lcom/intellij/history/ActivityId;", "fireChangeAdded", "fireChangeSetFinished", "changeSet", "forceBeginChangeSet", "getByteContentBefore", "Lcom/intellij/history/ByteContent;", "root", "Lcom/intellij/history/core/tree/RootEntry;", "change", "moved", "oldParent", "putLabel", "Lcom/intellij/history/core/LabelImpl;", "Lcom/intellij/history/core/changes/PutLabelChange;", "putLabelInTests", "putSystemLabel", "projectId", "color", "", "putUserLabel", "readOnlyStatusChanged", "oldStatus", "removeListener", "renamed", "oldName", "revertUpToChange", "changeId", "revertTarget", "warnOnFileNotFound", "revertUpToChangeSet", "changeSetId", "Listener", "intellij.platform.lvcs.impl"})
public class LocalHistoryFacade {
    @NotNull
    private final ChangeList changeList;
    @NotNull
    private final List<Listener> listeners;

    public LocalHistoryFacade(@NotNull ChangeList changeList) {
        Intrinsics.checkNotNullParameter((Object)changeList, (String)"changeList");
        this.changeList = changeList;
        List list = ContainerUtil.createLockFreeCopyOnWriteList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"createLockFreeCopyOnWriteList(...)");
        this.listeners = list;
    }

    @NotNull
    public final ChangeList getChangeList$intellij_platform_lvcs_impl() {
        return this.changeList;
    }

    @TestOnly
    @NotNull
    public final ChangeList getChangeListInTests() {
        return this.changeList;
    }

    @NotNull
    public final Iterable<ChangeSet> getChanges$intellij_platform_lvcs_impl() {
        return this.changeList.iterChanges();
    }

    public final void beginChangeSet() {
        this.changeList.beginChangeSet();
    }

    public final void forceBeginChangeSet() {
        ChangeSet lastChangeSet = this.changeList.forceBeginChangeSet();
        if (lastChangeSet != null) {
            this.fireChangeSetFinished(lastChangeSet);
        }
    }

    @JvmOverloads
    public final void endChangeSet(@Nullable String name, @Nullable ActivityId activityId) {
        ChangeSet lastChangeSet = this.changeList.endChangeSet(name, activityId);
        if (lastChangeSet != null) {
            this.fireChangeSetFinished(lastChangeSet);
        }
    }

    public static /* synthetic */ void endChangeSet$default(LocalHistoryFacade localHistoryFacade, String string, ActivityId activityId, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: endChangeSet");
        }
        if ((n & 2) != 0) {
            activityId = null;
        }
        localHistoryFacade.endChangeSet(string, activityId);
    }

    public final void created(@NotNull String path, boolean isDirectory) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.addChange(isDirectory ? (CreateEntryChange)new CreateDirectoryChange(this.changeList.nextId(), path) : (CreateEntryChange)new CreateFileChange(this.changeList.nextId(), path));
    }

    public final void contentChanged(@NotNull String path, @NotNull Content oldContent, long oldTimestamp) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)oldContent, (String)"oldContent");
        this.addChange(new ContentChange(this.changeList.nextId(), path, oldContent, oldTimestamp));
    }

    public final void renamed(@NotNull String path, @NotNull String oldName) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)oldName, (String)"oldName");
        this.addChange(new RenameChange(this.changeList.nextId(), path, oldName));
    }

    public final void readOnlyStatusChanged(@NotNull String path, boolean oldStatus) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.addChange(new ROStatusChange(this.changeList.nextId(), path, oldStatus));
    }

    public final void moved(@NotNull String path, @NotNull String oldParent) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)oldParent, (String)"oldParent");
        this.addChange(new MoveChange(this.changeList.nextId(), path, oldParent));
    }

    public final void deleted(@NotNull String path, @NotNull Entry deletedEntry) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)deletedEntry, (String)"deletedEntry");
        this.addChange(new DeleteChange(this.changeList.nextId(), path, deletedEntry));
    }

    @NotNull
    public final LabelImpl putSystemLabel(@NotNull String name, @NotNull String projectId, int color) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)projectId, (String)"projectId");
        return this.putLabel(new PutSystemLabelChange(this.changeList.nextId(), name, projectId, color));
    }

    @NotNull
    public final LabelImpl putUserLabel(@NotNull String name, @NotNull String projectId) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)projectId, (String)"projectId");
        return this.putLabel(new PutLabelChange(this.changeList.nextId(), name, projectId));
    }

    private final void addChange(Change c) {
        this.beginChangeSet();
        this.changeList.addChange(c);
        this.fireChangeAdded(c);
        LocalHistoryFacade.endChangeSet$default(this, null, null, 2, null);
    }

    @TestOnly
    public final void addChangeInTests(@NotNull StructuralChange c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        this.addChange(c);
    }

    private final LabelImpl putLabel(PutLabelChange c) {
        this.addChange(c);
        return new LabelImpl(c, this){
            final /* synthetic */ PutLabelChange $c;
            final /* synthetic */ LocalHistoryFacade this$0;
            {
                this.$c = $c;
                this.this$0 = $receiver;
            }

            public long getLabelChangeId() {
                return this.$c.getId();
            }

            @NotNull
            public ByteContent getByteContent(@NotNull RootEntry root, @NotNull String path) {
                Intrinsics.checkNotNullParameter((Object)root, (String)"root");
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                return LocalHistoryFacade.access$getByteContentBefore(this.this$0, root, path, this.$c);
            }
        };
    }

    @TestOnly
    public final void putLabelInTests(@NotNull PutLabelChange c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        this.putLabel(c);
    }

    private final ByteContent getByteContentBefore(RootEntry root, String path, Change change) {
        RootEntry rootEntry2 = root.copy();
        Intrinsics.checkNotNullExpressionValue((Object)rootEntry2, (String)"copy(...)");
        RootEntry rootCopy = rootEntry2;
        String newPath = this.revertUpToChange(rootCopy, change.getId(), path, false, false);
        Entry entry = rootCopy.findEntry(newPath);
        if (entry == null) {
            return new ByteContent(false, null);
        }
        if (entry.isDirectory()) {
            return new ByteContent(true, null);
        }
        return new ByteContent(false, entry.getContent().getBytesIfAvailable());
    }

    public final void accept(@NotNull ChangeVisitor v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        this.changeList.accept(v);
    }

    @NotNull
    public final String revertUpToChangeSet(@NotNull RootEntry root, long changeSetId, @NotNull String path, boolean revertTarget, boolean warnOnFileNotFound) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String entryPath = path;
        for (ChangeSet changeSet : this.getChanges$intellij_platform_lvcs_impl()) {
            if (!revertTarget && changeSet.getId() == changeSetId) break;
            List<Change> list = changeSet.getChanges();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getChanges(...)");
            for (Change change : CollectionsKt.reversed((Iterable)list)) {
                if (!(change instanceof StructuralChange) || !change.affectsPath(entryPath)) continue;
                ((StructuralChange)change).revertOn(root, warnOnFileNotFound);
                Intrinsics.checkNotNullExpressionValue((Object)((StructuralChange)change).revertPath(entryPath), (String)"revertPath(...)");
            }
            if (!revertTarget || changeSet.getId() != changeSetId) continue;
            break;
        }
        return entryPath;
    }

    @NotNull
    public final String revertUpToChange(@NotNull RootEntry root, long changeId, @NotNull String path, boolean revertTarget, boolean warnOnFileNotFound) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String entryPath = path;
        block0: for (ChangeSet changeSet : this.getChanges$intellij_platform_lvcs_impl()) {
            List<Change> list = changeSet.getChanges();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getChanges(...)");
            for (Change change : CollectionsKt.reversed((Iterable)list)) {
                if (!revertTarget && change.getId() == changeId) break block0;
                if (change instanceof StructuralChange && change.affectsPath(entryPath)) {
                    ((StructuralChange)change).revertOn(root, warnOnFileNotFound);
                    Intrinsics.checkNotNullExpressionValue((Object)((StructuralChange)change).revertPath(entryPath), (String)"revertPath(...)");
                }
                if (!revertTarget || change.getId() != changeId) continue;
                break block0;
            }
        }
        return entryPath;
    }

    public final void addListener(@NotNull Listener l, @Nullable Disposable parent) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        this.listeners.add(l);
        if (parent != null) {
            Disposer.register((Disposable)parent, () -> LocalHistoryFacade.addListener$lambda$0(this, l));
        }
    }

    public final void removeListener(@NotNull Listener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        this.listeners.remove(l);
    }

    private final void fireChangeAdded(Change c) {
        for (Listener each : this.listeners) {
            each.changeAdded(c);
        }
    }

    private final void fireChangeSetFinished(ChangeSet changeSet) {
        for (Listener each : this.listeners) {
            each.changeSetFinished(changeSet);
        }
    }

    @JvmOverloads
    public final void endChangeSet(@Nullable String name) {
        LocalHistoryFacade.endChangeSet$default(this, name, null, 2, null);
    }

    private static final void addListener$lambda$0(LocalHistoryFacade this$0, Listener $l) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$l, (String)"$l");
        this$0.listeners.remove($l);
    }

    public static final /* synthetic */ ByteContent access$getByteContentBefore(LocalHistoryFacade $this, RootEntry root, String path, Change change) {
        return $this.getByteContentBefore(root, path, change);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/history/core/LocalHistoryFacade$Listener;", "", "()V", "changeAdded", "", "c", "Lcom/intellij/history/core/changes/Change;", "changeSetFinished", "changeSet", "Lcom/intellij/history/core/changes/ChangeSet;", "intellij.platform.lvcs.impl"})
    public static abstract class Listener {
        public void changeAdded(@NotNull Change c) {
            Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        }

        public void changeSetFinished(@NotNull ChangeSet changeSet) {
            Intrinsics.checkNotNullParameter((Object)changeSet, (String)"changeSet");
        }
    }
}

