/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.artifacts.instructions;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.PrintWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.BuildOutputConsumer;
import org.jetbrains.jps.builders.BuildRootDescriptor;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.ProjectBuildException;
import org.jetbrains.jps.incremental.artifacts.ArtifactBuildTarget;
import org.jetbrains.jps.incremental.artifacts.ArtifactOutputToSourceMapping;
import org.jetbrains.jps.incremental.artifacts.instructions.DestinationInfo;
import org.jetbrains.jps.incremental.artifacts.instructions.SourceFileFilter;
import org.jetbrains.jps.incremental.relativizer.PathRelativizerService;

public abstract class ArtifactRootDescriptor
extends BuildRootDescriptor {
    protected final File myRoot;
    private final SourceFileFilter myFilter;
    private final int myRootIndex;
    private final ArtifactBuildTarget myTarget;
    private final DestinationInfo myDestinationInfo;

    protected ArtifactRootDescriptor(File root, @NotNull SourceFileFilter filter, int index, ArtifactBuildTarget target, @NotNull DestinationInfo destinationInfo) {
        if (filter == null) {
            ArtifactRootDescriptor.$$$reportNull$$$0(0);
        }
        if (destinationInfo == null) {
            ArtifactRootDescriptor.$$$reportNull$$$0(1);
        }
        this.myRoot = root;
        this.myFilter = filter;
        this.myRootIndex = index;
        this.myTarget = target;
        this.myDestinationInfo = destinationInfo;
    }

    public String toString() {
        return this.getFullPath();
    }

    protected abstract String getFullPath();

    public void writeConfiguration(PrintWriter out, PathRelativizerService relativizer) {
        out.println(relativizer.toRelative(this.getFullPath()));
        out.println("->" + relativizer.toRelative(this.myDestinationInfo.getOutputPath()));
    }

    @NotNull
    public ArtifactBuildTarget getTarget() {
        ArtifactBuildTarget artifactBuildTarget = this.myTarget;
        if (artifactBuildTarget == null) {
            ArtifactRootDescriptor.$$$reportNull$$$0(2);
        }
        return artifactBuildTarget;
    }

    @Override
    @NotNull
    public FileFilter createFileFilter() {
        FileFilter fileFilter = file -> this.myFilter.accept(file.getAbsolutePath());
        if (fileFilter == null) {
            ArtifactRootDescriptor.$$$reportNull$$$0(3);
        }
        return fileFilter;
    }

    @Override
    @NotNull
    public final File getRootFile() {
        File file = this.myRoot;
        if (file == null) {
            ArtifactRootDescriptor.$$$reportNull$$$0(4);
        }
        return file;
    }

    @Override
    @NotNull
    public String getRootId() {
        String string = String.valueOf(this.myRootIndex);
        if (string == null) {
            ArtifactRootDescriptor.$$$reportNull$$$0(5);
        }
        return string;
    }

    public abstract void copyFromRoot(String var1, int var2, String var3, CompileContext var4, BuildOutputConsumer var5, ArtifactOutputToSourceMapping var6) throws IOException, ProjectBuildException;

    public SourceFileFilter getFilter() {
        return this.myFilter;
    }

    public DestinationInfo getDestinationInfo() {
        return this.myDestinationInfo;
    }

    public int getRootIndex() {
        return this.myRootIndex;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destinationInfo";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/incremental/artifacts/instructions/ArtifactRootDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/incremental/artifacts/instructions/ArtifactRootDescriptor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTarget";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createFileFilter";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootFile";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

