/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.cache.loader;

import com.intellij.execution.process.ProcessIOExecutorService;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import io.netty.channel.Channel;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.api.CanceledStatus;
import org.jetbrains.jps.api.CmdlineRemoteProto;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.BuildTargetType;
import org.jetbrains.jps.builders.JpsBuildBundle;
import org.jetbrains.jps.builders.java.JavaBuilderUtil;
import org.jetbrains.jps.cache.JpsCachesLoaderUtil;
import org.jetbrains.jps.cache.client.JpsNettyClient;
import org.jetbrains.jps.cache.client.JpsServerAuthUtil;
import org.jetbrains.jps.cache.client.JpsServerClient;
import org.jetbrains.jps.cache.client.JpsServerConnectionUtil;
import org.jetbrains.jps.cache.loader.JpsCacheLoader;
import org.jetbrains.jps.cache.loader.JpsCompilationOutputLoader;
import org.jetbrains.jps.cache.loader.JpsMetadataLoader;
import org.jetbrains.jps.cache.loader.JpsOutputLoader;
import org.jetbrains.jps.cache.model.BuildTargetState;
import org.jetbrains.jps.cache.model.JpsLoaderContext;
import org.jetbrains.jps.cache.statistics.JpsCacheLoadingSystemStats;
import org.jetbrains.jps.cache.statistics.ProjectBuildStatistic;
import org.jetbrains.jps.cache.statistics.SystemOpsStatistic;
import org.jetbrains.jps.cmdline.BuildRunner;
import org.jetbrains.jps.cmdline.ProjectDescriptor;
import org.jetbrains.jps.incremental.CompileScope;
import org.jetbrains.jps.incremental.IncProjectBuilder;
import org.jetbrains.jps.incremental.MessageHandler;
import org.jetbrains.jps.incremental.TargetTypeRegistry;
import org.jetbrains.jps.incremental.Utils;
import org.jetbrains.jps.incremental.fs.BuildFSState;
import org.jetbrains.jps.incremental.storage.BuildTargetsState;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.java.JpsJavaProjectExtension;
import org.jetbrains.jps.util.JpsPathUtil;

public final class JpsOutputLoaderManager {
    private static final Logger LOG = Logger.getInstance(JpsOutputLoaderManager.class);
    private static final String FS_STATE_FILE = "fs_state.dat";
    private static final int PROJECT_MODULE_DOWNLOAD_SIZE_BYTES = 512000;
    private static final int AVERAGE_CACHE_SIZE_BYTES = 524288000;
    private static final int PROJECT_MODULE_SIZE_DISK_BYTES = 921600;
    private static final int COMMITS_COUNT_THRESHOLD = 600;
    private final AtomicBoolean hasRunningTask;
    private List<JpsOutputLoader<?>> myJpsOutputLoadersLoaders;
    private final JpsMetadataLoader myMetadataLoader;
    private ProjectBuildStatistic myOriginalBuildStatistic;
    private final CanceledStatus myCanceledStatus;
    private final JpsServerClient myServerClient;
    private boolean isCacheDownloaded;
    private final boolean isForceCachesDownload;
    private final boolean isCleanupAsynchronously;
    private final String myBuildOutDir;
    private final String myProjectPath;
    private final String myCommitHash;
    private final int myMaxDownloadDuration;
    private final int myCommitsCountBetweenCompilation;
    private final JpsNettyClient myNettyClient;

    public JpsOutputLoaderManager(@NotNull JpsProject project, @NotNull CanceledStatus canceledStatus, @NotNull String projectPath, @NotNull Channel channel, @NotNull UUID sessionId, @NotNull CmdlineRemoteProto.Message.ControllerMessage.CacheDownloadSettings cacheDownloadSettings) {
        if (project == null) {
            JpsOutputLoaderManager.$$$reportNull$$$0(0);
        }
        if (canceledStatus == null) {
            JpsOutputLoaderManager.$$$reportNull$$$0(1);
        }
        if (projectPath == null) {
            JpsOutputLoaderManager.$$$reportNull$$$0(2);
        }
        if (channel == null) {
            JpsOutputLoaderManager.$$$reportNull$$$0(3);
        }
        if (sessionId == null) {
            JpsOutputLoaderManager.$$$reportNull$$$0(4);
        }
        if (cacheDownloadSettings == null) {
            JpsOutputLoaderManager.$$$reportNull$$$0(5);
        }
        this.myNettyClient = new JpsNettyClient(channel, sessionId);
        this.myCanceledStatus = canceledStatus;
        this.myProjectPath = projectPath;
        this.hasRunningTask = new AtomicBoolean();
        this.myBuildOutDir = JpsOutputLoaderManager.getBuildDirPath(project);
        this.myServerClient = JpsServerClient.getServerClient(cacheDownloadSettings.getServerUrl());
        this.myMetadataLoader = new JpsMetadataLoader(projectPath, this.myServerClient);
        this.myCommitHash = cacheDownloadSettings.getDownloadCommit();
        this.myCommitsCountBetweenCompilation = cacheDownloadSettings.getCommitsCountLatestBuild();
        this.myMaxDownloadDuration = cacheDownloadSettings.getMaxDownloadDuration() * 60;
        this.isForceCachesDownload = cacheDownloadSettings.getForceDownload();
        this.isCleanupAsynchronously = cacheDownloadSettings.getCleanupAsynchronously();
        JpsServerAuthUtil.setRequestHeaders(cacheDownloadSettings.getAuthHeadersMap());
        JpsCacheLoadingSystemStats.setDeletionSpeed(cacheDownloadSettings.getDeletionSpeed());
        JpsCacheLoadingSystemStats.setDecompressionSpeed(cacheDownloadSettings.getDecompressionSpeed());
    }

    public void load(@NotNull BuildRunner buildRunner, boolean isForceUpdate, @NotNull List<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope> scopes, @NotNull Runnable beforeDownload) {
        if (buildRunner == null) {
            JpsOutputLoaderManager.$$$reportNull$$$0(6);
        }
        if (scopes == null) {
            JpsOutputLoaderManager.$$$reportNull$$$0(7);
        }
        if (beforeDownload == null) {
            JpsOutputLoaderManager.$$$reportNull$$$0(8);
        }
        if (!this.canRunNewLoading()) {
            return;
        }
        if (this.isCleanupAsynchronously) {
            JpsCachesLoaderUtil.runCleanUpAsynchronously();
        }
        if (this.isForceCachesDownload || this.isDownloadQuickerThanLocalBuild(buildRunner, this.myCommitsCountBetweenCompilation, scopes)) {
            LOG.info("Before download task execution...");
            beforeDownload.run();
            this.myNettyClient.sendDescriptionStatusMessage(JpsBuildBundle.message("progress.text.fetching.cache.for.commit", this.myCommitHash));
            if (isForceUpdate) {
                this.myMetadataLoader.dropCurrentProjectMetadata();
                File outDir = new File(this.myBuildOutDir);
                if (outDir.exists()) {
                    LOG.info("Start removing old caches before downloading");
                    this.myNettyClient.sendDescriptionStatusMessage(JpsBuildBundle.message("progress.text.removing.old.caches", new Object[0]));
                    JpsCachesLoaderUtil.delete(outDir, this.isCleanupAsynchronously);
                }
                LOG.info("Compilation output folder empty");
            }
            this.startLoadingForCommit(this.myCommitHash);
        } else {
            String message = JpsBuildBundle.message("progress.text.local.build.is.quicker", new Object[0]);
            LOG.warn(message);
            this.myNettyClient.sendDescriptionStatusMessage(message);
        }
        this.hasRunningTask.set(false);
    }

    public void updateBuildStatistic(@NotNull ProjectDescriptor projectDescriptor) {
        if (projectDescriptor == null) {
            JpsOutputLoaderManager.$$$reportNull$$$0(9);
        }
        if (this.isForceCachesDownload) {
            return;
        }
        if (!this.hasRunningTask.get() && this.isCacheDownloaded) {
            BuildTargetsState targetsState = projectDescriptor.getTargetsState();
            this.myOriginalBuildStatistic.getBuildTargetTypeStatistic().forEach((buildTargetType, originalBuildTime) -> {
                targetsState.setAverageBuildTime((BuildTargetType<?>)buildTargetType, (long)originalBuildTime);
                LOG.info("Saving old build statistic for " + buildTargetType.getTypeId() + " with value " + originalBuildTime);
            });
            Long originalBuildStatisticProjectRebuildTime = this.myOriginalBuildStatistic.getProjectRebuildTime();
            targetsState.setLastSuccessfulRebuildDuration(originalBuildStatisticProjectRebuildTime);
            LOG.info("Saving old project rebuild time " + originalBuildStatisticProjectRebuildTime);
        }
    }

    public static void saveLatestBuiltCommitId(@NotNull CmdlineRemoteProto.Message.BuilderMessage.BuildEvent.Status status, @NotNull Channel channel, @NotNull UUID sessionId) {
        if (status == null) {
            JpsOutputLoaderManager.$$$reportNull$$$0(10);
        }
        if (channel == null) {
            JpsOutputLoaderManager.$$$reportNull$$$0(11);
        }
        if (sessionId == null) {
            JpsOutputLoaderManager.$$$reportNull$$$0(12);
        }
        if (status == CmdlineRemoteProto.Message.BuilderMessage.BuildEvent.Status.CANCELED || status == CmdlineRemoteProto.Message.BuilderMessage.BuildEvent.Status.ERRORS || status == CmdlineRemoteProto.Message.BuilderMessage.BuildEvent.Status.UP_TO_DATE) {
            return;
        }
        LOG.info("Saving latest project built commit");
        JpsNettyClient.saveLatestBuiltCommit(channel, sessionId);
    }

    private boolean isDownloadQuickerThanLocalBuild(BuildRunner buildRunner, int commitsCountBetweenCompilation, List<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope> scopes) {
        SystemOpsStatistic systemOpsStatistic = JpsServerConnectionUtil.measureConnectionSpeed(this.myNettyClient);
        if (systemOpsStatistic == null) {
            LOG.info("Connection speed is too small to download caches");
            return false;
        }
        Pair<Long, Integer> buildTimeAndProjectModulesCount = this.estimateProjectBuildTime(buildRunner, scopes);
        if (buildTimeAndProjectModulesCount == null) {
            LOG.info("Rebuild or unexpected behaviour at build time calculation. Local build will be executed");
            return false;
        }
        long approximateBuildTime = (Long)buildTimeAndProjectModulesCount.first;
        int projectModulesCount = (Integer)buildTimeAndProjectModulesCount.second;
        if (approximateBuildTime == 0L && commitsCountBetweenCompilation > 600) {
            LOG.info("Can't calculate approximate project build time, but there are " + commitsCountBetweenCompilation + " not compiled commits and it seems that it will be faster to download caches.");
            return true;
        }
        if (approximateBuildTime == 0L) {
            LOG.info("Can't calculate approximate project build time");
            return false;
        }
        long approximateDownloadTime = this.calculateApproximateDownloadTimeMs(systemOpsStatistic, projectModulesCount);
        if (approximateDownloadTime == 0L) {
            LOG.info("Can't calculate approximate download time");
            return false;
        }
        return approximateDownloadTime < approximateBuildTime;
    }

    private long calculateApproximateDownloadTimeMs(SystemOpsStatistic systemOpsStatistic, int projectModulesCount) {
        long deletionSpeed;
        long decompressionSpeed;
        double magicCoefficient = 1.3;
        if (JpsCacheLoadingSystemStats.getDecompressionSpeedBytesPesSec() > 0L) {
            decompressionSpeed = JpsCacheLoadingSystemStats.getDecompressionSpeedBytesPesSec();
            LOG.info("Using previously saved statistic about decompression speed: " + StringUtil.formatFileSize((long)decompressionSpeed) + "/s");
        } else {
            decompressionSpeed = systemOpsStatistic.getDecompressionSpeedBytesPesSec();
        }
        if (JpsCacheLoadingSystemStats.getDeletionSpeedBytesPerSec() > 0L) {
            deletionSpeed = JpsCacheLoadingSystemStats.getDeletionSpeedBytesPerSec();
            LOG.info("Using previously saved statistic about deletion speed: " + StringUtil.formatFileSize((long)deletionSpeed) + "/s");
        } else {
            deletionSpeed = systemOpsStatistic.getDeletionSpeedBytesPerSec();
        }
        long approximateSizeToDelete = (long)projectModulesCount * 921600L;
        long approximateDownloadSize = (long)projectModulesCount * 512000L + 524288000L;
        long expectedDownloadTimeSec = approximateDownloadSize / systemOpsStatistic.getConnectionSpeedBytesPerSec();
        long expectedDecompressionTimeSec = approximateDownloadSize / decompressionSpeed;
        long expectedDeleteTimeSec = approximateSizeToDelete / deletionSpeed;
        long expectedTimeOfWorkMs = ((long)((double)expectedDeleteTimeSec * magicCoefficient) + expectedDownloadTimeSec + expectedDecompressionTimeSec) * 1000L;
        LOG.info("Expected download size: " + StringUtil.formatFileSize((long)approximateDownloadSize) + ". Expected download time: " + expectedDownloadTimeSec + "sec. Expected decompression time: " + expectedDecompressionTimeSec + "sec. Expected size to delete: " + StringUtil.formatFileSize((long)approximateDownloadSize) + ". Expected delete time: " + expectedDeleteTimeSec + "sec. Total time of work: " + StringUtil.formatDuration((long)expectedTimeOfWorkMs));
        if (expectedDownloadTimeSec >= (long)this.myMaxDownloadDuration) {
            LOG.info("Downloading can consume more than 10 mins, connection speed is too small for caches usages");
            return 0L;
        }
        return expectedTimeOfWorkMs;
    }

    private void startLoadingForCommit(@NotNull String commitId) {
        if (commitId == null) {
            JpsOutputLoaderManager.$$$reportNull$$$0(13);
        }
        long startTime = System.nanoTime();
        Map<String, Map<String, BuildTargetState>> commitSourcesState = this.myMetadataLoader.loadMetadataForCommit(this.myNettyClient, commitId);
        if (commitSourcesState == null) {
            LOG.warn("Couldn't load metadata for commit: " + commitId);
            return;
        }
        Map<String, Map<String, BuildTargetState>> currentSourcesState = this.myMetadataLoader.loadCurrentProjectMetadata();
        int totalDownloads = this.getLoaders().stream().mapToInt(loader -> loader.calculateDownloads(commitSourcesState, currentSourcesState)).sum();
        try {
            ((CompletableFuture)((CompletableFuture)this.initLoaders(commitId, totalDownloads, commitSourcesState, currentSourcesState).thenAccept(loaderStatus -> {
                LOG.info("Loading finished with " + loaderStatus + " status");
                try {
                    ((CompletableFuture)CompletableFuture.allOf((CompletableFuture[])this.getLoaders().stream().map(loader -> this.applyChanges((JpsOutputLoader.LoaderStatus)((Object)loaderStatus), (JpsOutputLoader<?>)loader)).toArray(CompletableFuture[]::new)).thenRun(() -> this.saveStateAndNotify((JpsOutputLoader.LoaderStatus)((Object)loaderStatus), commitId, startTime))).get();
                }
                catch (InterruptedException | ExecutionException e) {
                    LOG.warn("Unexpected exception rollback all progress", (Throwable)e);
                    this.onFail();
                    this.getLoaders().forEach(loader -> loader.rollback());
                    this.myNettyClient.sendDescriptionStatusMessage(JpsBuildBundle.message("progress.text.rolling.back.downloaded.caches", new Object[0]));
                }
            })).handle((result, ex) -> this.handleExceptions((Void)result, (Throwable)ex))).get();
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.warn("Couldn't fetch jps compilation caches", (Throwable)e);
            this.onFail();
        }
    }

    @Nullable
    private static String getBuildDirPath(@NotNull JpsProject project) {
        JpsJavaProjectExtension projectExtension;
        if (project == null) {
            JpsOutputLoaderManager.$$$reportNull$$$0(14);
        }
        if ((projectExtension = JpsJavaExtensionService.getInstance().getProjectExtension(project)) == null) {
            return null;
        }
        String url = projectExtension.getOutputUrl();
        if (StringUtil.isEmpty((String)url)) {
            return null;
        }
        return JpsPathUtil.urlToFile((String)url).getAbsolutePath();
    }

    private synchronized boolean canRunNewLoading() {
        if (this.hasRunningTask.get()) {
            LOG.warn("Jps cache loading already in progress, can't start the new one");
            return false;
        }
        if (this.myBuildOutDir == null) {
            LOG.warn("Build output dir is not configured for the project");
            return false;
        }
        this.hasRunningTask.set(true);
        return true;
    }

    private <T> CompletableFuture<JpsOutputLoader.LoaderStatus> initLoaders(String commitId, int totalDownloads, Map<String, Map<String, BuildTargetState>> commitSourcesState, Map<String, Map<String, BuildTargetState>> currentSourcesState) {
        JpsLoaderContext loaderContext = JpsLoaderContext.createNewContext(totalDownloads, this.myCanceledStatus, commitId, this.myNettyClient, commitSourcesState, currentSourcesState);
        List<JpsOutputLoader<?>> loaders = this.getLoaders();
        loaders.forEach(loader -> loader.setContext(loaderContext));
        List completableFutures = ContainerUtil.map(loaders, loader -> CompletableFuture.supplyAsync(() -> loader.extract(loader.load()), ProcessIOExecutorService.INSTANCE));
        CompletionStage initialFuture = (CompletableFuture)completableFutures.get(0);
        if (completableFutures.size() > 1) {
            for (int i = 1; i < completableFutures.size(); ++i) {
                initialFuture = initialFuture.thenCombine((CompletionStage)completableFutures.get(i), JpsOutputLoaderManager::combine);
            }
        }
        return initialFuture;
    }

    private CompletableFuture<Void> applyChanges(JpsOutputLoader.LoaderStatus loaderStatus, JpsOutputLoader<?> loader) {
        if (loaderStatus == JpsOutputLoader.LoaderStatus.FAILED) {
            this.myNettyClient.sendDescriptionStatusMessage(JpsBuildBundle.message("progress.text.rolling.back", new Object[0]));
            return CompletableFuture.runAsync(() -> loader.rollback(), ProcessIOExecutorService.INSTANCE);
        }
        return CompletableFuture.runAsync(() -> loader.apply(), ProcessIOExecutorService.INSTANCE);
    }

    private void saveStateAndNotify(JpsOutputLoader.LoaderStatus loaderStatus, String commitId, long startTime) {
        if (loaderStatus == JpsOutputLoader.LoaderStatus.FAILED) {
            this.onFail();
            return;
        }
        this.myNettyClient.sendDownloadStatisticMessage(commitId, JpsCacheLoadingSystemStats.getDecompressionSpeedBytesPesSec(), JpsCacheLoadingSystemStats.getDeletionSpeedBytesPerSec());
        this.isCacheDownloaded = true;
        LOG.info("Loading finished");
    }

    private Void handleExceptions(Void result, Throwable ex) {
        if (ex != null) {
            Throwable cause = ex.getCause();
            if (cause instanceof ProcessCanceledException) {
                LOG.info("Jps caches download canceled");
            } else {
                LOG.warn("Couldn't fetch jps compilation caches", ex);
                this.onFail();
            }
            this.getLoaders().forEach(loader -> loader.rollback());
            this.myNettyClient.sendDescriptionStatusMessage(JpsBuildBundle.message("progress.text.rolling.back.downloaded.caches", new Object[0]));
        }
        return result;
    }

    private List<JpsOutputLoader<?>> getLoaders() {
        if (this.myJpsOutputLoadersLoaders != null) {
            return this.myJpsOutputLoadersLoaders;
        }
        this.myJpsOutputLoadersLoaders = Arrays.asList(new JpsCacheLoader(this.myServerClient, this.myProjectPath, this.isCleanupAsynchronously), new JpsCompilationOutputLoader(this.myServerClient, this.myBuildOutDir));
        return this.myJpsOutputLoadersLoaders;
    }

    private static JpsOutputLoader.LoaderStatus combine(JpsOutputLoader.LoaderStatus firstStatus, JpsOutputLoader.LoaderStatus secondStatus) {
        if (firstStatus == JpsOutputLoader.LoaderStatus.FAILED || secondStatus == JpsOutputLoader.LoaderStatus.FAILED) {
            return JpsOutputLoader.LoaderStatus.FAILED;
        }
        return JpsOutputLoader.LoaderStatus.COMPLETE;
    }

    private void onFail() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Pair<Long, Integer> estimateProjectBuildTime(BuildRunner buildRunner, List<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope> scopes) {
        ProjectDescriptor projectDescriptor = null;
        try {
            long startTime = System.currentTimeMillis();
            BuildFSState fsState = new BuildFSState(false);
            File dataStorageRoot = Utils.getDataStorageRoot(this.myProjectPath);
            if (!dataStorageRoot.exists() || !new File(dataStorageRoot, FS_STATE_FILE).exists()) {
                buildRunner.setForceCleanCaches(true);
                LOG.info("Storage files are absent");
            }
            projectDescriptor = buildRunner.load(MessageHandler.DEAF, dataStorageRoot, fsState);
            long contextInitializationTime = System.currentTimeMillis() - startTime;
            LOG.info("Time spend to context initialization: " + contextInitializationTime);
            CompileScope compilationScope = buildRunner.createCompilationScope(projectDescriptor, scopes);
            long estimatedBuildTime = IncProjectBuilder.calculateEstimatedBuildTime(projectDescriptor, t -> compilationScope.isAffected((BuildTarget<?>)t));
            BuildTargetsState targetsState = projectDescriptor.getTargetsState();
            if (JavaBuilderUtil.isForcedRecompilationAllJavaModules(compilationScope)) {
                LOG.info("Project rebuild enabled, caches will not be download");
                Pair<Long, Integer> pair = null;
                return pair;
            }
            HashMap buildTargetTypeStatistic = new HashMap();
            for (BuildTargetType<?> type : TargetTypeRegistry.getInstance().getTargetTypes()) {
                buildTargetTypeStatistic.put(type, targetsState.getAverageBuildTime(type));
            }
            this.myOriginalBuildStatistic = new ProjectBuildStatistic(targetsState.getLastSuccessfulRebuildDuration(), buildTargetTypeStatistic);
            long totalCalculationTime = System.currentTimeMillis() - startTime;
            LOG.info("Calculated build time: " + StringUtil.formatDuration((long)estimatedBuildTime));
            LOG.info("Time spend to context initialization and time calculation: " + totalCalculationTime);
            Pair pair = Pair.create((Object)estimatedBuildTime, (Object)projectDescriptor.getProject().getModules().size());
            return pair;
        }
        catch (Exception e) {
            LOG.warn("Exception at calculation approximate build time", (Throwable)e);
        }
        finally {
            if (projectDescriptor != null) {
                projectDescriptor.release();
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "canceledStatus";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectPath";
                break;
            }
            case 3: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "channel";
                break;
            }
            case 4: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sessionId";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cacheDownloadSettings";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildRunner";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopes";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beforeDownload";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectDescriptor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "status";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitId";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/jps/cache/loader/JpsOutputLoaderManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "load";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "updateBuildStatistic";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "saveLatestBuiltCommitId";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "startLoadingForCommit";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "getBuildDirPath";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

