/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.editor;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.BackspaceHandlerDelegate;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.lexer.KtTokens;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/editor/KotlinStringTemplateBackspaceHandler;", "Lcom/intellij/codeInsight/editorActions/BackspaceHandlerDelegate;", "()V", "beforeCharDeleted", "", "c", "", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "charDeleted", "", "kotlin.base.code-insight.minimal"})
public final class KotlinStringTemplateBackspaceHandler
extends BackspaceHandlerDelegate {
    public void beforeCharDeleted(char c, @NotNull PsiFile file, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        if (c != '{' || !Intrinsics.areEqual((Object)file.getFileType(), (Object)KotlinFileType.INSTANCE) || !CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET) {
            return;
        }
        int offset = editor.getCaretModel().getOffset();
        EditorHighlighter editorHighlighter = ((EditorEx)editor).getHighlighter();
        Intrinsics.checkNotNullExpressionValue((Object)editorHighlighter, (String)"getHighlighter(...)");
        EditorHighlighter highlighter = editorHighlighter;
        HighlighterIterator highlighterIterator = highlighter.createIterator(offset);
        Intrinsics.checkNotNullExpressionValue((Object)highlighterIterator, (String)"createIterator(...)");
        HighlighterIterator iterator = highlighterIterator;
        if (!Intrinsics.areEqual((Object)iterator.getTokenType(), (Object)KtTokens.LONG_TEMPLATE_ENTRY_END)) {
            return;
        }
        iterator.retreat();
        if (!Intrinsics.areEqual((Object)iterator.getTokenType(), (Object)KtTokens.LONG_TEMPLATE_ENTRY_START)) {
            return;
        }
        ((EditorEx)editor).getDocument().deleteString(offset, offset + 1);
    }

    public boolean charDeleted(char c, @NotNull PsiFile file, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        return false;
    }
}

