/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.handlers.fixers;

import com.intellij.lang.SmartEnterProcessorWithFixers;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtilKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.codeInsight.handlers.fixers.FixersUtilKt;
import org.jetbrains.kotlin.idea.codeInsight.handlers.KotlinSmartEnterHandler;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\fH\u0014\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/handlers/fixers/KotlinClassBodyFixer;", "Lcom/intellij/lang/SmartEnterProcessorWithFixers$Fixer;", "Lorg/jetbrains/kotlin/idea/codeInsight/handlers/KotlinSmartEnterHandler;", "()V", "apply", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "processor", "psiElement", "Lcom/intellij/psi/PsiElement;", "fixSuperTypeInitializer", "", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "endOffset", "kotlin.base.code-insight.minimal"})
public class KotlinClassBodyFixer
extends SmartEnterProcessorWithFixers.Fixer<KotlinSmartEnterHandler> {
    public void apply(@NotNull Editor editor, @NotNull KotlinSmartEnterHandler processor, @NotNull PsiElement psiElement) {
        KtClassBody body;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)((Object)processor), (String)"processor");
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        if (!(psiElement instanceof KtClassOrObject)) {
            return;
        }
        KtClassBody ktClassBody = body = ((KtClassOrObject)psiElement).getBody();
        CharSequence charSequence = ktClassBody != null ? ktClassBody.getText() : null;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            return;
        }
        int endOffset = 0;
        endOffset = FixersUtilKt.getEnd(FixersUtilKt.getRange(psiElement));
        if (body != null) {
            PsiElement psiElement2 = PsiUtilsKt.getPrevSiblingIgnoringWhitespaceAndComments$default((PsiElement)((PsiElement)body), (boolean)false, (int)1, null);
            if (psiElement2 != null) {
                PsiElement it = psiElement2;
                boolean bl = false;
                endOffset = PsiTreeUtilKt.getEndOffset((PsiElement)it);
            }
        }
        endOffset = this.fixSuperTypeInitializer((KtClassOrObject)psiElement, editor, endOffset);
        editor.getCaretModel().moveToOffset(endOffset - 1);
        editor.getDocument().insertString(endOffset, (CharSequence)"{\n}");
    }

    protected int fixSuperTypeInitializer(@NotNull KtClassOrObject psiElement, @NotNull Editor editor, int endOffset) {
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        return endOffset;
    }
}

