/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.execution.process.AnsiTerminalColor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.util.ClearableLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.IntConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AnsiTerminalEmulator {
    private static final Logger LOG = Logger.getInstance(AnsiTerminalEmulator.class);
    private static final AnsiTerminalEmulator EMPTY_EMULATOR = new AnsiTerminalEmulator();
    private static final int MAX_8BIT_COLOR_INDEX = 15;
    private static final int COLOR_CUBE_MIN_INDEX = 16;
    private static final int GRAY_MIN_INDEX = 232;
    @NotNull
    private TerminalFont myFont = TerminalFont.DEFAULT;
    @NotNull
    private Weight myWeight = Weight.DEFAULT;
    @NotNull
    private Underline myUnderline = Underline.DEFAULT;
    @NotNull
    private BlinkSpeed myBlink = BlinkSpeed.DEFAULT;
    @NotNull
    private FrameType myFrameType = FrameType.DEFAULT;
    private boolean myIsItalic;
    private boolean myIsInverse;
    private boolean myIsConseal;
    private boolean myIsCrossedOut;
    private boolean myIsFraktur;
    private boolean myIsOverlined;
    private AnsiTerminalColor myBackgroundColor;
    private AnsiTerminalColor myForegroundColor;
    private final ClearableLazyValue<String> mySerializedSgrStateProvider = ClearableLazyValue.create(() -> this.computeAnsiSerializedSGRState());

    AnsiTerminalEmulator() {
    }

    public void processSgr(@NotNull String sgrSequenceBody) {
        Integer command;
        if (sgrSequenceBody == null) {
            AnsiTerminalEmulator.$$$reportNull$$$0(0);
        }
        String separator = StringUtil.containsChar((String)sgrSequenceBody, (char)':') ? ":" : ";";
        List sgrSequenceParts = StringUtil.split((String)sgrSequenceBody, (String)separator, (boolean)true, (boolean)false);
        Iterator<Integer> sgrCodesIterator = ContainerUtil.map((Collection)sgrSequenceParts, it -> {
            try {
                return it.isEmpty() ? 0 : Integer.parseInt(it);
            }
            catch (NumberFormatException e) {
                LOG.warn("Could not parse integer: " + it + " in " + sgrSequenceBody);
                return null;
            }
        }).iterator();
        while (sgrCodesIterator.hasNext() && (command = (Integer)sgrCodesIterator.next()) != null) {
            this.processSgr(command, sgrCodesIterator);
        }
    }

    private void processSgr(int commandCode, Iterator<Integer> sgrCodesIterator) {
        switch (commandCode) {
            case 0: {
                this.resetTerminal();
                break;
            }
            case 1: {
                this.myWeight = Weight.BOLD;
                break;
            }
            case 2: {
                this.myWeight = Weight.FAINT;
                break;
            }
            case 3: {
                this.myIsItalic = true;
                break;
            }
            case 4: {
                this.myUnderline = Underline.SINGLE_UNDERLINE;
                break;
            }
            case 5: {
                this.myBlink = BlinkSpeed.SLOW_BLINK;
                break;
            }
            case 6: {
                this.myBlink = BlinkSpeed.RAPID_BLINK;
                break;
            }
            case 7: {
                this.myIsInverse = true;
                break;
            }
            case 8: {
                this.myIsConseal = true;
                break;
            }
            case 9: {
                this.myIsCrossedOut = true;
                break;
            }
            case 10: {
                this.myFont = TerminalFont.DEFAULT;
                break;
            }
            case 20: {
                this.myIsFraktur = true;
                break;
            }
            case 21: {
                this.myWeight = Weight.DEFAULT;
                this.myUnderline = Underline.DOUBLE_UNDERLINE;
                break;
            }
            case 22: {
                this.myWeight = Weight.DEFAULT;
                break;
            }
            case 23: {
                this.myIsFraktur = false;
                this.myIsItalic = false;
                break;
            }
            case 24: {
                this.myUnderline = Underline.DEFAULT;
                break;
            }
            case 25: {
                this.myBlink = BlinkSpeed.DEFAULT;
                break;
            }
            case 27: {
                this.myIsInverse = false;
                break;
            }
            case 28: {
                this.myIsConseal = false;
                break;
            }
            case 29: {
                this.myIsCrossedOut = false;
                break;
            }
            case 38: {
                this.myForegroundColor = AnsiTerminalEmulator.decodeColor(sgrCodesIterator);
                break;
            }
            case 39: {
                this.myForegroundColor = null;
                break;
            }
            case 48: {
                this.myBackgroundColor = AnsiTerminalEmulator.decodeColor(sgrCodesIterator);
                break;
            }
            case 49: {
                this.myBackgroundColor = null;
                break;
            }
            case 51: {
                this.myFrameType = FrameType.FRAMED;
                break;
            }
            case 52: {
                this.myFrameType = FrameType.ENCIRCLED;
                break;
            }
            case 53: {
                this.myIsOverlined = true;
                break;
            }
            case 54: {
                this.myFrameType = FrameType.NO_FRAME;
                break;
            }
            case 55: {
                this.myIsOverlined = false;
                break;
            }
            default: {
                if (commandCode >= 11 && commandCode <= 19) {
                    this.myFont = TerminalFont.values()[commandCode - 10];
                    break;
                }
                if (commandCode >= 30 && commandCode <= 37) {
                    this.myForegroundColor = new EightBitColor(commandCode - 30);
                    break;
                }
                if (commandCode >= 40 && commandCode <= 47) {
                    this.myBackgroundColor = new EightBitColor(commandCode - 40);
                    break;
                }
                if (commandCode >= 60 && commandCode <= 65) {
                    LOG.debug("Ignore no-op ideogram sequence: " + commandCode);
                    break;
                }
                if (commandCode >= 90 && commandCode <= 97) {
                    this.myForegroundColor = new EightBitColor(commandCode - 90 + 8);
                    break;
                }
                if (commandCode >= 100 && commandCode <= 107) {
                    this.myBackgroundColor = new EightBitColor(commandCode - 100 + 8);
                    break;
                }
                LOG.warn("Unknown command " + commandCode);
                return;
            }
        }
        this.mySerializedSgrStateProvider.drop();
    }

    @NotNull
    public String getAnsiSerializedSGRState() {
        String string = Objects.requireNonNull((String)this.mySerializedSgrStateProvider.getValue());
        if (string == null) {
            AnsiTerminalEmulator.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String computeAnsiSerializedSGRState() {
        ArrayList<String> state = new ArrayList<String>();
        IntConsumer codeConsumer = it -> state.add(Integer.toString(it));
        codeConsumer.accept(0);
        if (this.myFont != TerminalFont.DEFAULT) {
            codeConsumer.accept(this.myFont.sgrCode);
        }
        if (this.myWeight != Weight.DEFAULT) {
            codeConsumer.accept(this.myWeight.sgrCode);
        }
        if (this.myUnderline != Underline.DEFAULT) {
            codeConsumer.accept(this.myUnderline.sgrCode);
        }
        if (this.myFont != TerminalFont.DEFAULT) {
            codeConsumer.accept(this.myFont.sgrCode);
        }
        if (this.myBlink != BlinkSpeed.DEFAULT) {
            codeConsumer.accept(this.myBlink.sgrCode);
        }
        if (this.myIsInverse) {
            codeConsumer.accept(7);
        }
        if (this.myBackgroundColor != null) {
            codeConsumer.accept(48);
            state.add(this.myBackgroundColor.getAnsiEncodedColor());
        }
        if (this.myForegroundColor != null) {
            codeConsumer.accept(38);
            state.add(this.myForegroundColor.getAnsiEncodedColor());
        }
        if (this.myIsItalic) {
            codeConsumer.accept(3);
        }
        if (this.myIsConseal) {
            codeConsumer.accept(8);
        }
        if (this.myIsCrossedOut) {
            codeConsumer.accept(9);
        }
        if (this.myIsFraktur) {
            codeConsumer.accept(20);
        }
        if (this.myFrameType != FrameType.DEFAULT) {
            codeConsumer.accept(this.myFrameType.sgrCode);
        }
        if (this.myIsOverlined) {
            codeConsumer.accept(53);
        }
        String string = "\u001b[" + StringUtil.join(state, (String)";") + "m";
        if (string == null) {
            AnsiTerminalEmulator.$$$reportNull$$$0(2);
        }
        return string;
    }

    private void resetTerminal() {
        this.myFont = AnsiTerminalEmulator.EMPTY_EMULATOR.myFont;
        this.myWeight = AnsiTerminalEmulator.EMPTY_EMULATOR.myWeight;
        this.myUnderline = AnsiTerminalEmulator.EMPTY_EMULATOR.myUnderline;
        this.myBackgroundColor = AnsiTerminalEmulator.EMPTY_EMULATOR.myBackgroundColor;
        this.myForegroundColor = AnsiTerminalEmulator.EMPTY_EMULATOR.myForegroundColor;
        this.myFrameType = AnsiTerminalEmulator.EMPTY_EMULATOR.myFrameType;
        this.myBlink = AnsiTerminalEmulator.EMPTY_EMULATOR.myBlink;
        this.myIsInverse = AnsiTerminalEmulator.EMPTY_EMULATOR.myIsInverse;
        this.myIsItalic = AnsiTerminalEmulator.EMPTY_EMULATOR.myIsItalic;
        this.myIsConseal = AnsiTerminalEmulator.EMPTY_EMULATOR.myIsConseal;
        this.myIsCrossedOut = AnsiTerminalEmulator.EMPTY_EMULATOR.myIsCrossedOut;
        this.myIsFraktur = AnsiTerminalEmulator.EMPTY_EMULATOR.myIsFraktur;
        this.myIsOverlined = AnsiTerminalEmulator.EMPTY_EMULATOR.myIsOverlined;
        this.mySerializedSgrStateProvider.drop();
    }

    public boolean isInitialState() {
        return EMPTY_EMULATOR.equals(this);
    }

    @Nullable
    public Color getBackgroundColor() {
        return this.myBackgroundColor == null ? null : this.myBackgroundColor.getColor();
    }

    public int getBackgroundColorIndex() {
        return this.myBackgroundColor == null ? -1 : this.myBackgroundColor.getColorIndex();
    }

    @Nullable
    public Color getForegroundColor() {
        return this.myForegroundColor == null ? null : this.myForegroundColor.getColor();
    }

    public int getForegroundColorIndex() {
        return this.myForegroundColor == null ? -1 : this.myForegroundColor.getColorIndex();
    }

    public boolean isInverse() {
        return this.myIsInverse;
    }

    @NotNull
    public Underline getUnderline() {
        Underline underline = this.myUnderline;
        if (underline == null) {
            AnsiTerminalEmulator.$$$reportNull$$$0(3);
        }
        return underline;
    }

    @NotNull
    public FrameType getFrameType() {
        FrameType frameType = this.myFrameType;
        if (frameType == null) {
            AnsiTerminalEmulator.$$$reportNull$$$0(4);
        }
        return frameType;
    }

    public boolean isCrossedOut() {
        return this.myIsCrossedOut;
    }

    @NotNull
    public Weight getWeight() {
        Weight weight = this.myWeight;
        if (weight == null) {
            AnsiTerminalEmulator.$$$reportNull$$$0(5);
        }
        return weight;
    }

    public boolean isItalic() {
        return this.myIsItalic;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnsiTerminalEmulator emulator = (AnsiTerminalEmulator)o;
        if (this.myIsItalic != emulator.myIsItalic) {
            return false;
        }
        if (this.myIsInverse != emulator.myIsInverse) {
            return false;
        }
        if (this.myIsConseal != emulator.myIsConseal) {
            return false;
        }
        if (this.myIsCrossedOut != emulator.myIsCrossedOut) {
            return false;
        }
        if (this.myIsFraktur != emulator.myIsFraktur) {
            return false;
        }
        if (this.myIsOverlined != emulator.myIsOverlined) {
            return false;
        }
        if (this.myFont != emulator.myFont) {
            return false;
        }
        if (this.myWeight != emulator.myWeight) {
            return false;
        }
        if (this.myUnderline != emulator.myUnderline) {
            return false;
        }
        if (this.myBlink != emulator.myBlink) {
            return false;
        }
        if (this.myFrameType != emulator.myFrameType) {
            return false;
        }
        if (!Objects.equals(this.myBackgroundColor, emulator.myBackgroundColor)) {
            return false;
        }
        return Objects.equals(this.myForegroundColor, emulator.myForegroundColor);
    }

    public int hashCode() {
        int result2 = this.myFont.hashCode();
        result2 = 31 * result2 + this.myWeight.hashCode();
        result2 = 31 * result2 + this.myUnderline.hashCode();
        result2 = 31 * result2 + this.myBlink.hashCode();
        result2 = 31 * result2 + this.myFrameType.hashCode();
        result2 = 31 * result2 + (this.myIsItalic ? 1 : 0);
        result2 = 31 * result2 + (this.myIsInverse ? 1 : 0);
        result2 = 31 * result2 + (this.myIsConseal ? 1 : 0);
        result2 = 31 * result2 + (this.myIsCrossedOut ? 1 : 0);
        result2 = 31 * result2 + (this.myIsFraktur ? 1 : 0);
        result2 = 31 * result2 + (this.myIsOverlined ? 1 : 0);
        result2 = 31 * result2 + (this.myBackgroundColor != null ? this.myBackgroundColor.hashCode() : 0);
        result2 = 31 * result2 + (this.myForegroundColor != null ? this.myForegroundColor.hashCode() : 0);
        return result2;
    }

    private static AnsiTerminalColor decodeColor(@NotNull Iterator<Integer> encodedColorIterator) {
        if (encodedColorIterator == null) {
            AnsiTerminalEmulator.$$$reportNull$$$0(6);
        }
        if (!encodedColorIterator.hasNext()) {
            return null;
        }
        int encodingType = encodedColorIterator.next();
        if (encodingType == 2) {
            Integer blueCode;
            Integer redCode = encodedColorIterator.hasNext() ? encodedColorIterator.next() : null;
            Integer greenCode = encodedColorIterator.hasNext() ? encodedColorIterator.next() : null;
            Integer n = blueCode = encodedColorIterator.hasNext() ? encodedColorIterator.next() : null;
            if (redCode != null && greenCode != null && blueCode != null) {
                return new RGBColor(redCode, greenCode, blueCode);
            }
        } else if (encodingType == 5) {
            Integer encodedColor;
            Integer n = encodedColor = encodedColorIterator.hasNext() ? encodedColorIterator.next() : null;
            if (encodedColor != null) {
                return AnsiTerminalEmulator.decode8BitColor(encodedColor);
            }
        }
        return null;
    }

    private static AnsiTerminalColor decode8BitColor(int encodedColor) {
        if (encodedColor >= 0 && encodedColor <= 15) {
            return new EightBitColor(encodedColor);
        }
        if (encodedColor >= 16 && encodedColor <= 255) {
            return new EightBitRGBColor(encodedColor);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sgrSequenceBody";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/process/AnsiTerminalEmulator";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "encodedColorIterator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/process/AnsiTerminalEmulator";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnsiSerializedSGRState";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "computeAnsiSerializedSGRState";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnderline";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFrameType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getWeight";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processSgr";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "decodeColor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5 -> new IllegalStateException(string);
        };
    }

    static enum TerminalFont {
        DEFAULT(10),
        ALT1(11),
        ALT2(12),
        ALT3(13),
        ALT4(14),
        ALT5(15),
        ALT6(16),
        ALT7(17),
        ALT8(18),
        ALT9(19);

        public final int sgrCode;

        private TerminalFont(int sgrCode) {
            this.sgrCode = sgrCode;
        }
    }

    public static enum Weight {
        FAINT(2),
        NORMAL(22),
        BOLD(1);

        private static final Weight DEFAULT;
        public final int sgrCode;

        private Weight(int sgrCode) {
            this.sgrCode = sgrCode;
        }

        static {
            DEFAULT = NORMAL;
        }
    }

    public static enum Underline {
        NO_UNDERLINE(24, null),
        SINGLE_UNDERLINE(4, EffectType.LINE_UNDERSCORE),
        DOUBLE_UNDERLINE(21, EffectType.BOLD_LINE_UNDERSCORE);

        private static final Underline DEFAULT;
        public final int sgrCode;
        @Nullable
        public final EffectType effectType;

        private Underline(int sgrCode, EffectType effectType) {
            this.sgrCode = sgrCode;
            this.effectType = effectType;
        }

        static {
            DEFAULT = NO_UNDERLINE;
        }
    }

    public static enum BlinkSpeed {
        NO_BLINK(25),
        SLOW_BLINK(5),
        RAPID_BLINK(6);

        private static final BlinkSpeed DEFAULT;
        public final int sgrCode;

        private BlinkSpeed(int sgrCode) {
            this.sgrCode = sgrCode;
        }

        static {
            DEFAULT = NO_BLINK;
        }
    }

    public static enum FrameType {
        NO_FRAME(54, null),
        FRAMED(51, EffectType.BOXED),
        ENCIRCLED(52, EffectType.ROUNDED_BOX);

        private static final FrameType DEFAULT;
        public final int sgrCode;
        @Nullable
        public final EffectType effectType;

        private FrameType(int sgrCode, EffectType effectType) {
            this.sgrCode = sgrCode;
            this.effectType = effectType;
        }

        static {
            DEFAULT = NO_FRAME;
        }
    }

    private static final class EightBitColor
    extends IndexedAnsiTerminalColor {
        private EightBitColor(int colorIndex) {
            super(colorIndex);
            if (colorIndex < 0 || colorIndex > 15) {
                LOG.error("Wrong 8bit color index: " + colorIndex);
            }
        }

        @Override
        @Nullable
        public Color getColor() {
            return null;
        }
    }

    private static final class RGBColor
    implements AnsiTerminalColor {
        private final int myRed;
        private final int myGreen;
        private final int myBlue;

        private RGBColor(int red, int green, int blue) {
            this.myRed = red;
            this.myGreen = green;
            this.myBlue = blue;
        }

        @Override
        @NotNull
        public String getAnsiEncodedColor() {
            String string = "2;" + this.myRed + ";" + this.myGreen + ";" + this.myBlue;
            if (string == null) {
                RGBColor.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public int getColorIndex() {
            return -1;
        }

        @Override
        @NotNull
        public Color getColor() {
            return new Color(this.myRed, this.myGreen, this.myBlue);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RGBColor color = (RGBColor)o;
            if (this.myRed != color.myRed) {
                return false;
            }
            if (this.myGreen != color.myGreen) {
                return false;
            }
            return this.myBlue == color.myBlue;
        }

        public int hashCode() {
            int result2 = this.myRed;
            result2 = 31 * result2 + this.myGreen;
            result2 = 31 * result2 + this.myBlue;
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/process/AnsiTerminalEmulator$RGBColor", "getAnsiEncodedColor"));
        }
    }

    private static final class EightBitRGBColor
    extends IndexedAnsiTerminalColor {
        private static final int[] CUBE_STEPS = new int[]{0, 95, 135, 175, 215, 255};
        private static final int[] GRAYSCALE_STEPS = new int[]{8, 18, 28, 38, 48, 58, 68, 78, 88, 98, 108, 118, 128, 138, 148, 158, 168, 178, 188, 198, 208, 218, 228, 238};

        private EightBitRGBColor(int colorIndex) {
            super(colorIndex);
            if (colorIndex < 16 || colorIndex > 255) {
                LOG.error("Wrong indexed RGB color index: " + colorIndex);
            }
        }

        @Override
        @Nullable
        public Color getColor() {
            int colorIndex = this.getColorIndex();
            if (colorIndex >= 16 && colorIndex < 232) {
                int encodedColor = colorIndex - 16;
                return new Color(CUBE_STEPS[encodedColor / 36 % 6], CUBE_STEPS[encodedColor / 6 % 6], CUBE_STEPS[encodedColor % 6]);
            }
            if (colorIndex >= 232 && colorIndex <= 255) {
                int colorPart = GRAYSCALE_STEPS[colorIndex - 232];
                return new Color(colorPart, colorPart, colorPart);
            }
            return null;
        }
    }

    private static abstract class IndexedAnsiTerminalColor
    implements AnsiTerminalColor {
        private final int myColorIndex;

        protected IndexedAnsiTerminalColor(int colorIndex) {
            this.myColorIndex = colorIndex;
        }

        @Override
        public int getColorIndex() {
            return this.myColorIndex;
        }

        @Override
        @NotNull
        public String getAnsiEncodedColor() {
            String string = "5;" + this.getColorIndex();
            if (string == null) {
                IndexedAnsiTerminalColor.$$$reportNull$$$0(0);
            }
            return string;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IndexedAnsiTerminalColor color = (IndexedAnsiTerminalColor)o;
            return this.myColorIndex == color.myColorIndex;
        }

        public int hashCode() {
            return this.myColorIndex;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/process/AnsiTerminalEmulator$IndexedAnsiTerminalColor", "getAnsiEncodedColor"));
        }
    }
}

