/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.startup.importSettings.transfer.backend.providers.vscode.mappings;

import com.intellij.ide.startup.importSettings.models.BuiltInFeature;
import com.intellij.ide.startup.importSettings.models.FeatureInfo;
import com.intellij.ide.startup.importSettings.models.PluginFeature;
import com.intellij.ide.startup.importSettings.transfer.backend.providers.vscode.mappings.FeatureData;
import com.intellij.ide.startup.importSettings.transfer.backend.providers.vscode.mappings.PluginMappingsKt;
import com.intellij.ide.startup.importSettings.transfer.backend.providers.vscode.mappings.VSCodePluginMapping;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.LoggerKt;
import com.intellij.util.PlatformUtils;
import com.intellij.util.text.StringKt;
import java.io.Closeable;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.internal.ArrayListSerializer;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JvmStreamsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\fH\u0002J\u001c\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0014\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004H\u0002J$\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0016H\u0002J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0018\u001a\u00020\u0005H\u0016R'\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0019"}, d2={"Lcom/intellij/ide/startup/importSettings/transfer/backend/providers/vscode/mappings/CommonPluginMapping;", "Lcom/intellij/ide/startup/importSettings/transfer/backend/providers/vscode/mappings/VSCodePluginMapping;", "()V", "allPlugins", "", "", "Lcom/intellij/ide/startup/importSettings/models/FeatureInfo;", "getAllPlugins", "()Ljava/util/Map;", "allPlugins$delegate", "Lkotlin/Lazy;", "getResourceMappings", "", "loadFromFile", "path", "Ljava/nio/file/Path;", "loadFromResources", "loadFromStream", "", "input", "Ljava/io/InputStream;", "result", "", "mapPlugin", "pluginId", "intellij.ide.startup.importSettings"})
@SourceDebugExtension(value={"SMAP\nPluginMappings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PluginMappings.kt\ncom/intellij/ide/startup/importSettings/transfer/backend/providers/vscode/mappings/CommonPluginMapping\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 JvmStreams.kt\nkotlinx/serialization/json/JvmStreamsKt\n*L\n1#1,139:1\n1#2:140\n86#3,3:141\n80#4:144\n*S KotlinDebug\n*F\n+ 1 PluginMappings.kt\ncom/intellij/ide/startup/importSettings/transfer/backend/providers/vscode/mappings/CommonPluginMapping\n*L\n87#1:141,3\n103#1:144\n*E\n"})
public final class CommonPluginMapping
implements VSCodePluginMapping {
    @NotNull
    private final Lazy allPlugins$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Map<String, ? extends FeatureInfo>>(this){
        final /* synthetic */ CommonPluginMapping this$0;
        {
            this.this$0 = $receiver;
            super(0);
        }

        @NotNull
        public final Map<String, FeatureInfo> invoke() {
            Object object;
            block3: {
                block2: {
                    object = System.getProperty("intellij.vscode.plugin.json");
                    if (object == null || (object = StringKt.nullize((String)object, (boolean)true)) == null) break block2;
                    Object object2 = object;
                    CommonPluginMapping commonPluginMapping = this.this$0;
                    Object it = object2;
                    boolean bl = false;
                    Path path = Paths.get((String)it, new String[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
                    Map map = CommonPluginMapping.access$loadFromFile(commonPluginMapping, path);
                    object = map;
                    if (map != null) break block3;
                }
                object = CommonPluginMapping.access$loadFromResources(this.this$0);
            }
            return object;
        }
    }));

    private final List<String> getResourceMappings() {
        List list;
        if (PlatformUtils.isAqua()) {
            list = CollectionsKt.listOf((Object)"aq.json");
        } else if (PlatformUtils.isCLion()) {
            list = CollectionsKt.listOf((Object)"cl.json");
        } else if (PlatformUtils.isDataGrip()) {
            list = CollectionsKt.listOf((Object)"dg.json");
        } else if (PlatformUtils.isDataSpell()) {
            list = CollectionsKt.listOf((Object)"ds.json");
        } else if (PlatformUtils.isGoIde()) {
            list = CollectionsKt.listOf((Object)"go.json");
        } else if (PlatformUtils.isPhpStorm()) {
            list = CollectionsKt.listOf((Object)"ps.json");
        } else if (PlatformUtils.isRider()) {
            list = CollectionsKt.listOf((Object)"rd.json");
        } else if (PlatformUtils.isRubyMine()) {
            list = CollectionsKt.listOf((Object)"rm.json");
        } else if (PlatformUtils.isRustRover()) {
            list = CollectionsKt.listOf((Object)"rr.json");
        } else if (PlatformUtils.isWebStorm()) {
            list = CollectionsKt.listOf((Object)"ws.json");
        } else if (PlatformUtils.isIdeaUltimate()) {
            Object[] objectArray = new String[]{"ic.json", "iu.json"};
            list = CollectionsKt.listOf((Object[])objectArray);
        } else if (PlatformUtils.isIntelliJ()) {
            list = CollectionsKt.listOf((Object)"ic.json");
        } else if (PlatformUtils.isPyCharmPro()) {
            Object[] objectArray = new String[]{"pc.json", "pp.json"};
            list = CollectionsKt.listOf((Object[])objectArray);
        } else {
            list = PlatformUtils.isPyCharm() ? CollectionsKt.listOf((Object)"pc.json") : CollectionsKt.emptyList();
        }
        return list;
    }

    private final Map<String, FeatureInfo> getAllPlugins() {
        Lazy lazy = this.allPlugins$delegate;
        return (Map)lazy.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Map<String, FeatureInfo> loadFromFile(Path path) {
        Map result2 = new LinkedHashMap();
        OpenOption[] openOptionArray = new OpenOption[]{};
        InputStream inputStream = Files.newInputStream(path, Arrays.copyOf(openOptionArray, openOptionArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
        Closeable closeable = inputStream;
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)closeable;
            boolean bl = false;
            this.loadFromStream(it, result2);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Map<String, FeatureInfo> loadFromResources() {
        List<String> resourceNames = this.getResourceMappings();
        Map result2 = new LinkedHashMap();
        for (String resourceName : resourceNames) {
            Object object;
            Logger $this$runAndLogException$iv = PluginMappingsKt.access$getLogger$p();
            boolean $i$f$runAndLogException = false;
            Logger logger = $this$runAndLogException$iv;
            try {
                Logger $this$runAndLogException_u24lambda_u240$iv = logger;
                boolean bl = false;
                boolean bl2 = false;
                Closeable closeable = this.getClass().getClassLoader().getResourceAsStream("pluginData/" + resourceName);
                Throwable throwable = null;
                try {
                    InputStream file = (InputStream)closeable;
                    boolean bl3 = false;
                    if (file == null) {
                        PluginMappingsKt.access$getLogger$p().error("Cannot find resource " + resourceName);
                    } else {
                        this.loadFromStream(file, result2);
                        Unit unit = Unit.INSTANCE;
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            LoggerKt.getOrLogException((Object)object, (Logger)$this$runAndLogException$iv);
        }
        return result2;
    }

    private final void loadFromStream(InputStream input, Map<String, FeatureInfo> result2) {
        Json $this$decodeFromStream$iv = (Json)Json.Default;
        boolean $i$f$decodeFromStream = false;
        $this$decodeFromStream$iv.getSerializersModule();
        List features = (List)JvmStreamsKt.decodeFromStream((Json)$this$decodeFromStream$iv, (DeserializationStrategy)((DeserializationStrategy)new ArrayListSerializer(FeatureData.Companion.serializer())), (InputStream)input);
        for (FeatureData data : features) {
            FeatureInfo featureInfo;
            String key;
            Intrinsics.checkNotNullExpressionValue((Object)data.getVsCodeId().toLowerCase(Locale.ROOT), (String)"toLowerCase(...)");
            if (data.getDisabled()) {
                result2.remove(key);
                continue;
            }
            if (data.getBuiltIn()) {
                featureInfo = new BuiltInFeature(null, data.getIdeaName(), null, false, 12, null);
            } else {
                if (data.getIdeaId() == null) {
                    PluginMappingsKt.access$getLogger$p().error("Cannot determine IntelliJ plugin id for feature " + data + ".");
                    continue;
                }
                featureInfo = new PluginFeature(null, data.getIdeaId(), data.getIdeaName(), null, false, 24, null);
            }
            FeatureInfo feature = featureInfo;
            result2.put(key, feature);
        }
    }

    @Override
    @Nullable
    public FeatureInfo mapPlugin(@NotNull String pluginId) {
        Intrinsics.checkNotNullParameter((Object)pluginId, (String)"pluginId");
        Map<String, FeatureInfo> map = this.getAllPlugins();
        String string = pluginId.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        return map.get(string);
    }

    public static final /* synthetic */ Map access$loadFromResources(CommonPluginMapping $this) {
        return $this.loadFromResources();
    }

    public static final /* synthetic */ Map access$loadFromFile(CommonPluginMapping $this, Path path) {
        return $this.loadFromFile(path);
    }
}

