/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.requests;

import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.command.impl.ResetUndoHistoryToken;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.rd.ide.model.RdApplyPatchRequest;
import com.jetbrains.rd.ide.model.RdCaretStateChange;
import com.jetbrains.rd.ide.model.RdCaretStateSnapshot;
import com.jetbrains.rd.ide.model.RdPatch;
import com.jetbrains.rd.ide.model.RdRequest;
import com.jetbrains.rd.ide.model.RdSelectionChangeBase;
import com.jetbrains.rd.ide.model.TextControlId;
import com.jetbrains.rd.util.string.IPrintableKt;
import com.jetbrains.rdclient.engine.handlers.FrontendRdPatchHandlerContext;
import com.jetbrains.rdclient.patches.FrontendRdPatchHandlerRegistry;
import com.jetbrains.rdclient.requests.FrontendApplyPatchRequest;
import com.jetbrains.rdclient.requests.FrontendAsyncRequest;
import com.jetbrains.rdclient.requests.FrontendAsyncRequestWithImmediateResult;
import com.jetbrains.rdclient.requests.PatchItemOperationType;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0014J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0014H\u0002J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0016R\u001b\u0010\t\u001a\u00020\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/rdclient/requests/FrontendApplyPatchRequest;", "Lcom/jetbrains/rdclient/requests/FrontendAsyncRequestWithImmediateResult;", "p", "Lcom/jetbrains/rd/ide/model/RdPatch;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "resetUndoHistoryToken", "Lcom/intellij/openapi/command/impl/ResetUndoHistoryToken;", "(Lcom/jetbrains/rd/ide/model/RdPatch;Lcom/intellij/openapi/client/ClientAppSession;Lcom/intellij/openapi/command/impl/ResetUndoHistoryToken;)V", "patchHandlerRegistry", "Lcom/jetbrains/rdclient/patches/FrontendRdPatchHandlerRegistry;", "getPatchHandlerRegistry", "()Lcom/jetbrains/rdclient/patches/FrontendRdPatchHandlerRegistry;", "patchHandlerRegistry$delegate", "Lkotlin/Lazy;", "createModel", "Lcom/jetbrains/rd/ide/model/RdRequest;", "debugDescription", "", "mergeCaretChanges", "Lcom/jetbrains/rd/ide/model/RdSelectionChangeBase;", "old", "new", "tryMergeWith", "Lcom/jetbrains/rdclient/requests/FrontendAsyncRequest;", "nextRequest", "Companion", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nFrontendApplyPatchRequest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendApplyPatchRequest.kt\ncom/jetbrains/rdclient/requests/FrontendApplyPatchRequest\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,55:1\n65#2,4:56\n65#2,4:60\n13#2:64\n*S KotlinDebug\n*F\n+ 1 FrontendApplyPatchRequest.kt\ncom/jetbrains/rdclient/requests/FrontendApplyPatchRequest\n*L\n40#1:56,4\n48#1:60,4\n18#1:64\n*E\n"})
public final class FrontendApplyPatchRequest
extends FrontendAsyncRequestWithImmediateResult {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy patchHandlerRegistry$delegate;
    @NotNull
    private static final Logger logger;

    public FrontendApplyPatchRequest(@NotNull RdPatch p, @NotNull ClientAppSession session, @Nullable ResetUndoHistoryToken resetUndoHistoryToken) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        super(session, p, resetUndoHistoryToken);
        this.patchHandlerRegistry$delegate = LazyKt.lazy((Function0)patchHandlerRegistry.2.INSTANCE);
    }

    private final FrontendRdPatchHandlerRegistry getPatchHandlerRegistry() {
        Lazy lazy = this.patchHandlerRegistry$delegate;
        return (FrontendRdPatchHandlerRegistry)lazy.getValue();
    }

    @Override
    @NotNull
    public RdRequest createModel() {
        RdPatch rdPatch = this.getPatch();
        if (rdPatch == null) {
            throw new IllegalStateException("patch is null".toString());
        }
        return (RdRequest)new RdApplyPatchRequest(rdPatch);
    }

    @Override
    @Nullable
    public FrontendAsyncRequest tryMergeWith(@NotNull FrontendAsyncRequest nextRequest) {
        Intrinsics.checkNotNullParameter((Object)nextRequest, (String)"nextRequest");
        RdPatch rdPatch = this.getPatch();
        if (rdPatch == null) {
            return null;
        }
        RdPatch currentPatch = rdPatch;
        FrontendApplyPatchRequest frontendApplyPatchRequest = nextRequest instanceof FrontendApplyPatchRequest ? (FrontendApplyPatchRequest)nextRequest : null;
        if (frontendApplyPatchRequest == null || (frontendApplyPatchRequest = frontendApplyPatchRequest.getPatch()) == null) {
            return null;
        }
        FrontendApplyPatchRequest newPatch = frontendApplyPatchRequest;
        Object object = CollectionsKt.singleOrNull((List)currentPatch.getChanges());
        RdSelectionChangeBase rdSelectionChangeBase = object instanceof RdSelectionChangeBase ? (RdSelectionChangeBase)object : null;
        if (rdSelectionChangeBase == null) {
            return null;
        }
        RdSelectionChangeBase currentCaretChange = rdSelectionChangeBase;
        Object object2 = CollectionsKt.singleOrNull((List)newPatch.getChanges());
        RdSelectionChangeBase rdSelectionChangeBase2 = object2 instanceof RdSelectionChangeBase ? (RdSelectionChangeBase)object2 : null;
        if (rdSelectionChangeBase2 == null) {
            return null;
        }
        RdSelectionChangeBase newCaretChange = rdSelectionChangeBase2;
        RdSelectionChangeBase rdSelectionChangeBase3 = this.mergeCaretChanges(currentCaretChange, newCaretChange);
        if (rdSelectionChangeBase3 == null) {
            return null;
        }
        RdSelectionChangeBase mergedCaretChange = rdSelectionChangeBase3;
        this.getPatchHandlerRegistry().update(currentPatch.getUpdatedItemVersions(), new FrontendRdPatchHandlerContext(this.getSession(), currentPatch, nextRequest, PatchItemOperationType.Merge.INSTANCE));
        return new FrontendApplyPatchRequest(RdPatch.copy$default((RdPatch)currentPatch, (List)CollectionsKt.listOf((Object)mergedCaretChange), null, null, null, null, (int)30, null), this.getSession(), this.getResetUndoHistoryToken());
    }

    private final RdSelectionChangeBase mergeCaretChanges(RdSelectionChangeBase old, RdSelectionChangeBase rdSelectionChangeBase) {
        RdSelectionChangeBase rdSelectionChangeBase2;
        if (!Intrinsics.areEqual((Object)old.getEditorId(), (Object)rdSelectionChangeBase.getEditorId())) {
            Logger $this$trace$iv = logger;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("Failed to merge caret changes with different editorId: " + old.getEditorId() + " and " + rdSelectionChangeBase.getEditorId());
            }
            return null;
        }
        TextControlId editorId = old.getEditorId();
        if (rdSelectionChangeBase instanceof RdCaretStateSnapshot) {
            rdSelectionChangeBase2 = rdSelectionChangeBase;
        } else if (old instanceof RdCaretStateChange && rdSelectionChangeBase instanceof RdCaretStateChange) {
            rdSelectionChangeBase2 = (RdSelectionChangeBase)new RdCaretStateChange(((RdCaretStateChange)old).getOldState(), ((RdCaretStateChange)rdSelectionChangeBase).getNewState(), editorId);
        } else {
            Logger $this$trace$iv = logger;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("Failed to merge the following caret changes, old: " + old + ", new: " + rdSelectionChangeBase);
            }
            rdSelectionChangeBase2 = null;
        }
        return rdSelectionChangeBase2;
    }

    @Override
    @NotNull
    protected String debugDescription() {
        return "Patch: " + IPrintableKt.printToString((Object)this.getPatch());
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(FrontendApplyPatchRequest.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        FrontendApplyPatchRequest.logger = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/rdclient/requests/FrontendApplyPatchRequest$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rd.client"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

