/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.visible.filters;

import com.intellij.openapi.util.TextRange;
import com.intellij.vcs.log.VcsLogDetailsFilter;
import com.intellij.vcs.log.visible.filters.VcsLogTextFilterWithMatches;
import com.intellij.vcs.log.visible.filters.VcsLogTextFiltersKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u001c\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\b\u001a\u00020\u0004H\u00c2\u0003J\t\u0010\t\u001a\u00020\u0006H\u00c2\u0003J\u001d\u0010\n\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u000b\u001a\u00020\u00062\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00042\b\u0010\u0011\u001a\u0004\u0018\u00010\u000fH\u0002J\b\u0010\u0012\u001a\u00020\u0004H\u0016J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\b\u0010\u0015\u001a\u00020\u0006H\u0016J\u0010\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0004H\u0016J\b\u0010\u0017\u001a\u00020\u0006H\u0016J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00192\u0006\u0010\u0010\u001a\u00020\u0004H\u0016J\b\u0010\u001a\u001a\u00020\u0004H\u0017R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/vcs/log/visible/filters/VcsLogTextFilterImpl;", "Lcom/intellij/vcs/log/VcsLogDetailsFilter;", "Lcom/intellij/vcs/log/visible/filters/VcsLogTextFilterWithMatches;", "text", "", "isMatchCase", "", "(Ljava/lang/String;Z)V", "component1", "component2", "copy", "equals", "other", "", "findMatchingRange", "Lcom/intellij/openapi/util/TextRange;", "message", "previousRange", "getText", "hashCode", "", "isRegex", "matches", "matchesCase", "matchingRanges", "", "toString", "intellij.platform.vcs.log.impl"})
@SourceDebugExtension(value={"SMAP\nVcsLogTextFilterImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VcsLogTextFilterImpl.kt\ncom/intellij/vcs/log/visible/filters/VcsLogTextFilterImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,38:1\n1#2:39\n*E\n"})
public final class VcsLogTextFilterImpl
implements VcsLogDetailsFilter,
VcsLogTextFilterWithMatches {
    @NotNull
    private final String text;
    private final boolean isMatchCase;

    public VcsLogTextFilterImpl(@NotNull String text, boolean isMatchCase) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.text = text;
        this.isMatchCase = isMatchCase;
    }

    @Override
    public boolean matches(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return StringsKt.contains((CharSequence)message, (CharSequence)this.text, (!this.isMatchCase ? 1 : 0) != 0);
    }

    @NotNull
    public String getText() {
        return this.text;
    }

    public boolean isRegex() {
        return false;
    }

    public boolean matchesCase() {
        return this.isMatchCase;
    }

    @Override
    @NotNull
    public Iterable<TextRange> matchingRanges(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return SequencesKt.asIterable((Sequence)SequencesKt.generateSequence((Function0)((Function0)new Function0<TextRange>(this, message){
            final /* synthetic */ VcsLogTextFilterImpl this$0;
            final /* synthetic */ String $message;
            {
                this.this$0 = $receiver;
                this.$message = $message;
                super(0);
            }

            @Nullable
            public final TextRange invoke() {
                return VcsLogTextFilterImpl.access$findMatchingRange(this.this$0, this.$message, null);
            }
        }), (Function1)((Function1)new Function1<TextRange, TextRange>(this, message){
            final /* synthetic */ VcsLogTextFilterImpl this$0;
            final /* synthetic */ String $message;
            {
                this.this$0 = $receiver;
                this.$message = $message;
                super(1);
            }

            @Nullable
            public final TextRange invoke(@NotNull TextRange lastRange) {
                Intrinsics.checkNotNullParameter((Object)lastRange, (String)"lastRange");
                return VcsLogTextFilterImpl.access$findMatchingRange(this.this$0, this.$message, lastRange);
            }
        })));
    }

    private final TextRange findMatchingRange(String message, TextRange previousRange) {
        TextRange textRange = previousRange;
        int startIndex = textRange != null ? textRange.getEndOffset() : 0;
        Integer n = StringsKt.indexOf((CharSequence)message, (String)this.text, (int)startIndex, (!this.isMatchCase ? 1 : 0) != 0);
        int it = ((Number)n).intValue();
        boolean bl = false;
        Integer n2 = it >= 0 ? n : null;
        if (n2 == null) {
            return null;
        }
        int startOffset = n2;
        return new TextRange(startOffset, startOffset + this.text.length());
    }

    @NonNls
    @NotNull
    public String toString() {
        return "containing '" + this.text + "' " + VcsLogTextFiltersKt.caseSensitiveText(this);
    }

    private final String component1() {
        return this.text;
    }

    private final boolean component2() {
        return this.isMatchCase;
    }

    @NotNull
    public final VcsLogTextFilterImpl copy(@NotNull String text, boolean isMatchCase) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return new VcsLogTextFilterImpl(text, isMatchCase);
    }

    public static /* synthetic */ VcsLogTextFilterImpl copy$default(VcsLogTextFilterImpl vcsLogTextFilterImpl, String string, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            string = vcsLogTextFilterImpl.text;
        }
        if ((n & 2) != 0) {
            bl = vcsLogTextFilterImpl.isMatchCase;
        }
        return vcsLogTextFilterImpl.copy(string, bl);
    }

    public int hashCode() {
        int result2 = this.text.hashCode();
        result2 = result2 * 31 + Boolean.hashCode(this.isMatchCase);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof VcsLogTextFilterImpl)) {
            return false;
        }
        VcsLogTextFilterImpl vcsLogTextFilterImpl = (VcsLogTextFilterImpl)other;
        if (!Intrinsics.areEqual((Object)this.text, (Object)vcsLogTextFilterImpl.text)) {
            return false;
        }
        return this.isMatchCase == vcsLogTextFilterImpl.isMatchCase;
    }

    public static final /* synthetic */ TextRange access$findMatchingRange(VcsLogTextFilterImpl $this, String message, TextRange previousRange) {
        return $this.findMatchingRange(message, previousRange);
    }
}

