/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.render;

import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.vcs.log.ui.VcsBookmarkRef;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Path2D;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class BookmarkIcon
implements Icon {
    private final Color BOOKMARK_REF_TYPE_COLOR;
    public static final float WIDTH = 3.5f;
    private final int mySize;

    public BookmarkIcon(@NotNull JComponent component2, int size, @NotNull Color bgColor, @NotNull VcsBookmarkRef bookmark) {
        if (component2 == null) {
            BookmarkIcon.$$$reportNull$$$0(0);
        }
        if (bgColor == null) {
            BookmarkIcon.$$$reportNull$$$0(1);
        }
        if (bookmark == null) {
            BookmarkIcon.$$$reportNull$$$0(2);
        }
        this.BOOKMARK_REF_TYPE_COLOR = JBColor.namedColor((String)"VersionControl.RefLabel.bookmarkBackground", (Color)new JBColor(16035645, 14263107));
        this.mySize = size;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int iconX, int iconY) {
        Graphics2D g2 = (Graphics2D)g;
        GraphicsConfig config = GraphicsUtil.setupAAPainting((Graphics)g2);
        g2.setColor(this.BOOKMARK_REF_TYPE_COLOR);
        float scale = (float)this.mySize / 6.25f;
        float x = (float)iconX + scale * 0.25f;
        float y = (float)iconY + scale;
        Path2D.Float path = new Path2D.Float();
        path.moveTo(x, y);
        path.lineTo(x + 3.0f * scale, y);
        path.lineTo(x + 3.0f * scale, y + 5.0f * scale);
        path.lineTo((double)x + 1.5 * (double)scale, (double)y + 3.5 * (double)scale);
        path.lineTo(x, y + 5.0f * scale);
        path.lineTo(x, y);
        path.closePath();
        g2.fill(path);
        config.restore();
    }

    @Override
    public int getIconWidth() {
        float scale = (float)this.mySize / 6.25f;
        return Math.round(3.5f * scale);
    }

    @Override
    public int getIconHeight() {
        return this.mySize;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "component";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "bgColor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "bookmark";
                break;
            }
        }
        objectArray[1] = "com/intellij/vcs/log/ui/render/BookmarkIcon";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

