/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui;

import com.google.common.util.concurrent.SettableFuture;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.CheckedDisposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsLog;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogListener;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.ui.VcsLogImpl;
import com.intellij.vcs.log.ui.VcsLogUiEx;
import com.intellij.vcs.log.visible.VisiblePack;
import com.intellij.vcs.log.visible.VisiblePackRefresher;
import java.util.Collection;
import java.util.function.BiFunction;
import org.jetbrains.annotations.NotNull;

public abstract class VcsLogUiBase
implements VcsLogUiEx {
    @NotNull
    private final String myId;
    @NotNull
    protected final VcsLogData myLogData;
    @NotNull
    protected final VcsLog myLog;
    @NotNull
    protected final VisiblePackRefresher myRefresher;
    @NotNull
    protected final CheckedDisposable myDisposableFlag;
    @NotNull
    protected final Collection<VcsLogListener> myLogListeners;

    public VcsLogUiBase(@NotNull String id, @NotNull VcsLogData logData, @NotNull VisiblePackRefresher refresher) {
        if (id == null) {
            VcsLogUiBase.$$$reportNull$$$0(0);
        }
        if (logData == null) {
            VcsLogUiBase.$$$reportNull$$$0(1);
        }
        if (refresher == null) {
            VcsLogUiBase.$$$reportNull$$$0(2);
        }
        this.myDisposableFlag = Disposer.newCheckedDisposable();
        this.myLogListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myId = id;
        this.myLogData = logData;
        this.myRefresher = refresher;
        Disposer.register((Disposable)this, (Disposable)this.myRefresher);
        Disposer.register((Disposable)this, (Disposable)this.myDisposableFlag);
        this.myLog = new VcsLogImpl(logData, this);
    }

    @NotNull
    public String getId() {
        String string = this.myId;
        if (string == null) {
            VcsLogUiBase.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    @NotNull
    public VisiblePackRefresher getRefresher() {
        VisiblePackRefresher visiblePackRefresher = this.myRefresher;
        if (visiblePackRefresher == null) {
            VcsLogUiBase.$$$reportNull$$$0(4);
        }
        return visiblePackRefresher;
    }

    @Override
    @NotNull
    public VcsLog getVcsLog() {
        VcsLog vcsLog = this.myLog;
        if (vcsLog == null) {
            VcsLogUiBase.$$$reportNull$$$0(5);
        }
        return vcsLog;
    }

    @Override
    @NotNull
    public VcsLogData getLogData() {
        VcsLogData vcsLogData = this.myLogData;
        if (vcsLogData == null) {
            VcsLogUiBase.$$$reportNull$$$0(6);
        }
        return vcsLogData;
    }

    @RequiresEdt
    public void addLogListener(@NotNull VcsLogListener listener2) {
        if (listener2 == null) {
            VcsLogUiBase.$$$reportNull$$$0(7);
        }
        ThreadingAssertions.assertEventDispatchThread();
        this.myLogListeners.add(listener2);
    }

    @RequiresEdt
    public void removeLogListener(@NotNull VcsLogListener listener2) {
        if (listener2 == null) {
            VcsLogUiBase.$$$reportNull$$$0(8);
        }
        ThreadingAssertions.assertEventDispatchThread();
        this.myLogListeners.remove(listener2);
    }

    @RequiresEdt
    protected void fireChangeEvent(@NotNull VisiblePack visiblePack, boolean refresh) {
        if (visiblePack == null) {
            VcsLogUiBase.$$$reportNull$$$0(9);
        }
        ThreadingAssertions.assertEventDispatchThread();
        for (VcsLogListener listener2 : this.myLogListeners) {
            listener2.onChange((VcsLogDataPack)visiblePack, refresh);
        }
    }

    @Override
    public <T> void jumpTo(@NotNull T commitId2, @NotNull BiFunction<? super VisiblePack, ? super T, Integer> rowGetter, @NotNull SettableFuture<VcsLogUiEx.JumpResult> future2, boolean silently, boolean focus) {
        if (commitId2 == null) {
            VcsLogUiBase.$$$reportNull$$$0(10);
        }
        if (rowGetter == null) {
            VcsLogUiBase.$$$reportNull$$$0(11);
        }
        if (future2 == null) {
            VcsLogUiBase.$$$reportNull$$$0(12);
        }
    }

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logData";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refresher";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/ui/VcsLogUiBase";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visiblePack";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitId";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rowGetter";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "future";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/ui/VcsLogUiBase";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRefresher";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getVcsLog";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addLogListener";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "removeLogListener";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "fireChangeEvent";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "jumpTo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6 -> new IllegalStateException(string);
        };
    }
}

