/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui;

import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLog;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.impl.VcsLogNavigationUtil;
import com.intellij.vcs.log.ui.VcsLogUiEx;
import com.intellij.vcs.log.ui.table.VcsLogCommitList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class VcsLogImpl
implements VcsLog {
    @NotNull
    private final VcsLogData myLogData;
    @NotNull
    private final VcsLogUiEx myUi;

    VcsLogImpl(@NotNull VcsLogData manager, @NotNull VcsLogUiEx ui2) {
        if (manager == null) {
            VcsLogImpl.$$$reportNull$$$0(0);
        }
        if (ui2 == null) {
            VcsLogImpl.$$$reportNull$$$0(1);
        }
        this.myLogData = manager;
        this.myUi = ui2;
    }

    @NotNull
    public List<CommitId> getSelectedCommits() {
        List list = this.myUi.getTable().getSelection().getCommits();
        if (list == null) {
            VcsLogImpl.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    public List<VcsCommitMetadata> getSelectedShortDetails() {
        List list = this.myUi.getTable().getSelection().getCachedMetadata();
        if (list == null) {
            VcsLogImpl.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    public List<VcsFullCommitDetails> getSelectedDetails() {
        List list = this.myUi.getTable().getSelection().getCachedFullDetails();
        if (list == null) {
            VcsLogImpl.$$$reportNull$$$0(4);
        }
        return list;
    }

    public void requestSelectedDetails(@NotNull Consumer<? super List<? extends VcsFullCommitDetails>> consumer) {
        if (consumer == null) {
            VcsLogImpl.$$$reportNull$$$0(5);
        }
        this.getTable().getSelection().requestFullDetails(arg_0 -> consumer.consume(arg_0));
    }

    @Nullable
    public Collection<String> getContainingBranches(@NotNull Hash commitHash, @NotNull VirtualFile root) {
        if (commitHash == null) {
            VcsLogImpl.$$$reportNull$$$0(6);
        }
        if (root == null) {
            VcsLogImpl.$$$reportNull$$$0(7);
        }
        return this.myLogData.getContainingBranchesGetter().getContainingBranchesQuickly(root, commitHash);
    }

    @NotNull
    public ListenableFuture<Boolean> jumpToReference(@NotNull String reference, boolean focus) {
        if (reference == null) {
            VcsLogImpl.$$$reportNull$$$0(8);
        }
        ListenableFuture<Boolean> listenableFuture = VcsLogNavigationUtil.jumpToRefOrHash(this.myUi, reference, false, focus);
        if (listenableFuture == null) {
            VcsLogImpl.$$$reportNull$$$0(9);
        }
        return listenableFuture;
    }

    @NotNull
    public ListenableFuture<Boolean> jumpToCommit(@NotNull Hash commitHash, @NotNull VirtualFile root, boolean focus) {
        if (commitHash == null) {
            VcsLogImpl.$$$reportNull$$$0(10);
        }
        if (root == null) {
            VcsLogImpl.$$$reportNull$$$0(11);
        }
        ListenableFuture<Boolean> listenableFuture = VcsLogNavigationUtil.jumpToCommit(this.myUi, commitHash, root, false, focus);
        if (listenableFuture == null) {
            VcsLogImpl.$$$reportNull$$$0(12);
        }
        return listenableFuture;
    }

    @NotNull
    public Map<VirtualFile, VcsLogProvider> getLogProviders() {
        Map<VirtualFile, VcsLogProvider> map = this.myLogData.getLogProviders();
        if (map == null) {
            VcsLogImpl.$$$reportNull$$$0(13);
        }
        return map;
    }

    @NotNull
    private VcsLogCommitList getTable() {
        VcsLogCommitList vcsLogCommitList = this.myUi.getTable();
        if (vcsLogCommitList == null) {
            VcsLogImpl.$$$reportNull$$$0(14);
        }
        return vcsLogCommitList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 9, 12, 13, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ui";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 9: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/ui/VcsLogImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitHash";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/ui/VcsLogImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedCommits";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedShortDetails";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedDetails";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "jumpToReference";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "jumpToCommit";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogProviders";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getTable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 9: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "requestSelectedDetails";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getContainingBranches";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "jumpToReference";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "jumpToCommit";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 9, 12, 13, 14 -> new IllegalStateException(string);
        };
    }
}

