/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.vcs.log.impl.PostponableLogRefresher;
import com.intellij.vcs.log.impl.VcsLogEditorTabsWatcher;
import com.intellij.vcs.log.impl.VcsLogTabLocation;
import com.intellij.vcs.log.impl.VcsLogTabsWatcherExtension;
import com.intellij.vcs.log.impl.VcsLogToolWindowTabsWatcher;
import com.intellij.vcs.log.statistics.VcsLogUsageTriggerCollector;
import com.intellij.vcs.log.ui.VcsLogUiEx;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010\u0014\u001a\u00020\u0013H\u0016J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00162\u0006\u0010\u000f\u001a\u00020\tH\u0002J\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0016J\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00162\u0006\u0010\u000f\u001a\u00020\tJ\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00162\u0006\u0010\u000f\u001a\u00020\tJ\u0010\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\"\u0010\u0007\u001a\u0016\u0012\u0004\u0012\u00020\t\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/vcs/log/impl/VcsLogTabsWatcher;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "postponableLogRefresher", "Lcom/intellij/vcs/log/impl/PostponableLogRefresher;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/vcs/log/impl/PostponableLogRefresher;)V", "extensions", "", "Lcom/intellij/vcs/log/impl/VcsLogTabLocation;", "Lcom/intellij/vcs/log/impl/VcsLogTabsWatcherExtension;", "Lcom/intellij/vcs/log/impl/PostponableLogRefresher$VcsLogWindow;", "addTabToWatch", "ui", "Lcom/intellij/vcs/log/ui/VcsLogUiEx;", "location", "isClosedOnDispose", "", "closeLogTabs", "", "dispose", "getLogWindows", "", "getTabs", "getVisibleTabs", "selectionChanged", "tabId", "", "Companion", "intellij.platform.vcs.log.impl"})
@SourceDebugExtension(value={"SMAP\nVcsLogTabsWatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VcsLogTabsWatcher.kt\ncom/intellij/vcs/log/impl/VcsLogTabsWatcher\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,80:1\n1549#2:81\n1620#2,3:82\n766#2:85\n857#2:86\n2624#2,3:87\n858#2:90\n766#2:91\n857#2,2:92\n1549#2:94\n1620#2,3:95\n766#2:98\n857#2,2:99\n1549#2:101\n1620#2,3:102\n766#2:106\n857#2,2:107\n1#3:105\n*S KotlinDebug\n*F\n+ 1 VcsLogTabsWatcher.kt\ncom/intellij/vcs/log/impl/VcsLogTabsWatcher\n*L\n32#1:81\n32#1:82,3\n38#1:85\n38#1:86\n38#1:87,3\n38#1:90\n40#1:91\n40#1:92,2\n44#1:94\n44#1:95,3\n48#1:98\n48#1:99,2\n48#1:101\n48#1:102,3\n62#1:106\n62#1:107,2\n*E\n"})
public final class VcsLogTabsWatcher
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final PostponableLogRefresher postponableLogRefresher;
    @NotNull
    private final Map<VcsLogTabLocation, VcsLogTabsWatcherExtension<? extends PostponableLogRefresher.VcsLogWindow>> extensions;
    @NotNull
    private static final Logger LOG;

    public VcsLogTabsWatcher(@NotNull Project project, @NotNull PostponableLogRefresher postponableLogRefresher) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)postponableLogRefresher, (String)"postponableLogRefresher");
        this.project = project;
        this.postponableLogRefresher = postponableLogRefresher;
        Pair[] pairArray = new Pair[]{new Pair((Object)VcsLogTabLocation.TOOL_WINDOW, (Object)new VcsLogToolWindowTabsWatcher(this.project, "Version Control", this)), new Pair((Object)VcsLogTabLocation.EDITOR, (Object)new VcsLogEditorTabsWatcher(this.project, this))};
        this.extensions = MapsKt.mapOf((Pair[])pairArray);
        this.extensions.values().forEach(arg_0 -> VcsLogTabsWatcher._init_$lambda$0(this, arg_0));
    }

    @NotNull
    public final Disposable addTabToWatch(@NotNull VcsLogUiEx ui2, @NotNull VcsLogTabLocation location, boolean isClosedOnDispose) {
        Intrinsics.checkNotNullParameter((Object)ui2, (String)"ui");
        Intrinsics.checkNotNullParameter((Object)((Object)location), (String)"location");
        VcsLogTabsWatcherExtension<? extends PostponableLogRefresher.VcsLogWindow> extension = this.extensions.get((Object)location);
        VcsLogTabsWatcherExtension<? extends PostponableLogRefresher.VcsLogWindow> vcsLogTabsWatcherExtension = extension;
        if (vcsLogTabsWatcherExtension == null || (vcsLogTabsWatcherExtension = vcsLogTabsWatcherExtension.createLogTab(ui2, isClosedOnDispose)) == null) {
            vcsLogTabsWatcherExtension = new PostponableLogRefresher.VcsLogWindow(ui2);
        }
        VcsLogTabsWatcherExtension<? extends PostponableLogRefresher.VcsLogWindow> window = vcsLogTabsWatcherExtension;
        Disposable disposable = this.postponableLogRefresher.addLogWindow((PostponableLogRefresher.VcsLogWindow)((Object)window));
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"addLogWindow(...)");
        return disposable;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<VcsLogUiEx> getTabs() {
        void $this$mapTo$iv$iv;
        Set<PostponableLogRefresher.VcsLogWindow> set = this.postponableLogRefresher.getLogWindows();
        Intrinsics.checkNotNullExpressionValue(set, (String)"getLogWindows(...)");
        Iterable $this$map$iv = set;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PostponableLogRefresher.VcsLogWindow vcsLogWindow = (PostponableLogRefresher.VcsLogWindow)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getUi());
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<PostponableLogRefresher.VcsLogWindow> getLogWindows(VcsLogTabLocation location) {
        VcsLogTabsWatcherExtension<? extends PostponableLogRefresher.VcsLogWindow> watcherExtension = this.extensions.get((Object)location);
        if (watcherExtension == null) {
            void $this$filterTo$iv$iv;
            Set<PostponableLogRefresher.VcsLogWindow> set = this.postponableLogRefresher.getLogWindows();
            Intrinsics.checkNotNullExpressionValue(set, (String)"getLogWindows(...)");
            Iterable $this$filter$iv = set;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                boolean bl;
                block6: {
                    PostponableLogRefresher.VcsLogWindow tab = (PostponableLogRefresher.VcsLogWindow)element$iv$iv;
                    boolean bl2 = false;
                    Iterable $this$none$iv = this.extensions.values();
                    boolean $i$f$none = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$none$iv) {
                            VcsLogTabsWatcherExtension it = (VcsLogTabsWatcherExtension)element$iv;
                            boolean bl3 = false;
                            Intrinsics.checkNotNull((Object)tab);
                            if (!it.isOwnerOf(tab)) continue;
                            bl = false;
                            break block6;
                        }
                        bl = true;
                    }
                }
                if (!bl) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }
        Set<PostponableLogRefresher.VcsLogWindow> set = this.postponableLogRefresher.getLogWindows();
        Intrinsics.checkNotNullExpressionValue(set, (String)"getLogWindows(...)");
        Iterable $this$filter$iv = set;
        boolean $i$f$filter = false;
        Iterable $this$filterTo$iv$iv = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PostponableLogRefresher.VcsLogWindow p0 = (PostponableLogRefresher.VcsLogWindow)element$iv$iv;
            boolean bl = false;
            if (!watcherExtension.isOwnerOf(p0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<VcsLogUiEx> getTabs(@NotNull VcsLogTabLocation location) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)((Object)location), (String)"location");
        Iterable $this$map$iv = this.getLogWindows(location);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PostponableLogRefresher.VcsLogWindow vcsLogWindow = (PostponableLogRefresher.VcsLogWindow)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getUi());
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<VcsLogUiEx> getVisibleTabs(@NotNull VcsLogTabLocation location) {
        void $this$mapTo$iv$iv;
        PostponableLogRefresher.VcsLogWindow it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)((Object)location), (String)"location");
        Iterable $this$filter$iv = this.getLogWindows(location);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (PostponableLogRefresher.VcsLogWindow)element$iv$iv;
            boolean bl = false;
            if (!it.isVisible()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (PostponableLogRefresher.VcsLogWindow)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getUi());
        }
        return (List)destination$iv$iv;
    }

    private final void selectionChanged(String tabId) {
        Object v1;
        block2: {
            Set<PostponableLogRefresher.VcsLogWindow> set = this.postponableLogRefresher.getLogWindows();
            Intrinsics.checkNotNullExpressionValue(set, (String)"getLogWindows(...)");
            Iterable iterable = set;
            for (Object t : iterable) {
                PostponableLogRefresher.VcsLogWindow window = (PostponableLogRefresher.VcsLogWindow)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)window.getId(), (Object)tabId)) continue;
                v1 = t;
                break block2;
            }
            v1 = null;
        }
        PostponableLogRefresher.VcsLogWindow logWindow = v1;
        if (logWindow != null) {
            LOG.debug("Selected log window '" + logWindow + "'");
            VcsLogUsageTriggerCollector.triggerTabNavigated(this.project);
            this.postponableLogRefresher.refresherActivated(logWindow.getRefresher(), false);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void closeLogTabs() {
        for (VcsLogTabsWatcherExtension<? extends PostponableLogRefresher.VcsLogWindow> extension : this.extensions.values()) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            Set<PostponableLogRefresher.VcsLogWindow> set = this.postponableLogRefresher.getLogWindows();
            Intrinsics.checkNotNullExpressionValue(set, (String)"getLogWindows(...)");
            Iterable iterable = set;
            VcsLogTabsWatcherExtension<? extends PostponableLogRefresher.VcsLogWindow> vcsLogTabsWatcherExtension = extension;
            boolean $i$f$filter = false;
            void var5_5 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                PostponableLogRefresher.VcsLogWindow p0 = (PostponableLogRefresher.VcsLogWindow)element$iv$iv;
                boolean bl = false;
                if (!extension.isOwnerOf(p0)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            vcsLogTabsWatcherExtension.closeTabs((List)destination$iv$iv);
        }
    }

    public void dispose() {
        this.closeLogTabs();
    }

    private static final void _init_$lambda$0(VcsLogTabsWatcher this$0, VcsLogTabsWatcherExtension extension) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        extension.setTabSelectedCallback((Function1<String, Unit>)((Function1)new Function1<String, Unit>(this$0){
            final /* synthetic */ VcsLogTabsWatcher this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull String tabId) {
                Intrinsics.checkNotNullParameter((Object)tabId, (String)"tabId");
                VcsLogTabsWatcher.access$selectionChanged(this.this$0, tabId);
            }
        }));
    }

    public static final /* synthetic */ void access$selectionChanged(VcsLogTabsWatcher $this, String tabId) {
        $this.selectionChanged(tabId);
    }

    static {
        Logger logger = Logger.getInstance(VcsLogTabsWatcher.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/vcs/log/impl/VcsLogTabsWatcher$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.platform.vcs.log.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

