/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.history;

import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.diff.impl.DiffEditorViewer;
import com.intellij.openapi.ListSelection;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.EditorTabDiffPreview;
import com.intellij.openapi.vcs.changes.actions.diff.ChangeDiffRequestProducer;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsLogCommitSelection;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.history.FileHistoryDiffProcessor;
import com.intellij.vcs.log.history.FileHistoryPanel;
import com.intellij.vcs.log.ui.actions.history.CompareRevisionsFromFileHistoryActionProvider;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\b\u0010\f\u001a\u00020\rH\u0014J\u0012\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\rH\u0014J\b\u0010\u0011\u001a\u00020\u000bH\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/vcs/log/history/FileHistoryEditorDiffPreview;", "Lcom/intellij/openapi/vcs/changes/EditorTabDiffPreview;", "project", "Lcom/intellij/openapi/project/Project;", "fileHistoryPanel", "Lcom/intellij/vcs/log/history/FileHistoryPanel;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/vcs/log/history/FileHistoryPanel;)V", "collectDiffProducers", "Lcom/intellij/openapi/ListSelection;", "Lcom/intellij/diff/chains/DiffRequestProducer;", "selectedOnly", "", "createViewer", "Lcom/intellij/diff/impl/DiffEditorViewer;", "getEditorTabName", "", "processor", "hasContent", "updateDiffAction", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.platform.vcs.log.impl"})
public final class FileHistoryEditorDiffPreview
extends EditorTabDiffPreview {
    @NotNull
    private final FileHistoryPanel fileHistoryPanel;

    public FileHistoryEditorDiffPreview(@NotNull Project project, @NotNull FileHistoryPanel fileHistoryPanel) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)fileHistoryPanel, (String)"fileHistoryPanel");
        super(project);
        this.fileHistoryPanel = fileHistoryPanel;
    }

    @NotNull
    protected String getEditorTabName(@Nullable DiffEditorViewer processor) {
        Object[] objectArray = new Object[]{this.fileHistoryPanel.getFilePath().getName()};
        String string = VcsLogBundle.message("file.history.diff.preview.editor.tab.name", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public boolean hasContent() {
        return this.fileHistoryPanel.getSelectedChange() != null;
    }

    @NotNull
    protected DiffEditorViewer createViewer() {
        FileHistoryDiffProcessor fileHistoryDiffProcessor = this.fileHistoryPanel.createDiffPreview(true);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)fileHistoryDiffProcessor), (String)"createDiffPreview(...)");
        return (DiffEditorViewer)fileHistoryDiffProcessor;
    }

    @NotNull
    protected ListSelection<? extends DiffRequestProducer> collectDiffProducers(boolean selectedOnly) {
        List changes = CollectionsKt.listOfNotNull((Object)this.fileHistoryPanel.getSelectedChange());
        ListSelection listSelection = ListSelection.createAt((List)changes, (int)0).withExplicitSelection(selectedOnly).map(arg_0 -> FileHistoryEditorDiffPreview.collectDiffProducers$lambda$0((Function1)new Function1<Change, ChangeDiffRequestProducer>(this){
            final /* synthetic */ FileHistoryEditorDiffPreview this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final ChangeDiffRequestProducer invoke(Change change) {
                return ChangeDiffRequestProducer.create((Project)this.this$0.getProject(), (Change)change);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)listSelection, (String)"map(...)");
        return listSelection;
    }

    public void updateDiffAction(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        VcsLogCommitSelection vcsLogCommitSelection = (VcsLogCommitSelection)event.getData(VcsLogDataKeys.VCS_LOG_COMMIT_SELECTION);
        if (vcsLogCommitSelection == null) {
            return;
        }
        VcsLogCommitSelection selection = vcsLogCommitSelection;
        CompareRevisionsFromFileHistoryActionProvider.setTextAndDescription(event, selection);
    }

    private static final ChangeDiffRequestProducer collectDiffProducers$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (ChangeDiffRequestProducer)$tmp0.invoke(p0);
    }
}

