/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.permanent;

import com.intellij.vcs.log.graph.api.GraphLayout;
import com.intellij.vcs.log.graph.impl.permanent.GraphLayoutImplKt;
import com.intellij.vcs.log.graph.utils.impl.CompressedIntList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\n\u001a\u00020\u0005H\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u000bH\u0002J\u0010\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000bH\u0016J\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0002\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/vcs/log/graph/impl/permanent/GraphLayoutImpl;", "Lcom/intellij/vcs/log/graph/api/GraphLayout;", "layoutIndex", "", "headNodes", "Lit/unimi/dsi/fastutil/ints/IntList;", "([ILit/unimi/dsi/fastutil/ints/IntList;)V", "Lcom/intellij/vcs/log/graph/utils/IntList;", "Lorg/jetbrains/annotations/NotNull;", "layoutIndexForHeadNodes", "getHeadNodeIndex", "", "getHeadOrder", "getLayoutIndex", "nodeIndex", "getOneOfHeadNodeIndex", "intellij.platform.vcs.log.graph.impl"})
public final class GraphLayoutImpl
implements GraphLayout {
    @NotNull
    private final IntList headNodes;
    @NotNull
    private final int[] layoutIndexForHeadNodes;
    @NotNull
    private final com.intellij.vcs.log.graph.utils.IntList layoutIndex;

    public GraphLayoutImpl(@NotNull int[] layoutIndex, @NotNull IntList headNodes) {
        Intrinsics.checkNotNullParameter((Object)layoutIndex, (String)"layoutIndex");
        Intrinsics.checkNotNullParameter((Object)headNodes, (String)"headNodes");
        this.headNodes = headNodes;
        this.layoutIndexForHeadNodes = GraphLayoutImplKt.access$getLayoutIndexesForHeads(layoutIndex, this.headNodes);
        com.intellij.vcs.log.graph.utils.IntList intList = CompressedIntList.newInstance(layoutIndex);
        Intrinsics.checkNotNullExpressionValue((Object)intList, (String)"newInstance(...)");
        this.layoutIndex = intList;
    }

    @Override
    public int getLayoutIndex(int nodeIndex) {
        return this.layoutIndex.get(nodeIndex);
    }

    @Override
    public int getOneOfHeadNodeIndex(int nodeIndex) {
        return this.getHeadNodeIndex(this.getLayoutIndex(nodeIndex));
    }

    private final int getHeadNodeIndex(int layoutIndex) {
        return this.headNodes.getInt(this.getHeadOrder(layoutIndex));
    }

    @NotNull
    public IntList getHeadNodeIndex() {
        return this.headNodes;
    }

    private final int getHeadOrder(int layoutIndex) {
        int i = Arrays.binarySearch(this.layoutIndexForHeadNodes, layoutIndex);
        return i < 0 ? Math.max(0, -i - 2) : i;
    }
}

