/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.ui.problemsView.viewModel.impl;

import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.qodana.highlight.HighlightedReportState;
import org.jetbrains.qodana.highlight.HighlightedReportStateKt;
import org.jetbrains.qodana.highlight.QodanaHighlightedReportService;
import org.jetbrains.qodana.report.ReportDescriptor;
import org.jetbrains.qodana.stats.QodanaPluginStatsCounterCollector;
import org.jetbrains.qodana.stats.QodanaPluginStatsCounterCollectorKt;
import org.jetbrains.qodana.stats.SourceHighlight;
import org.jetbrains.qodana.ui.problemsView.viewModel.QodanaProblemsViewModel;
import org.jetbrains.qodana.ui.problemsView.viewModel.impl.ReportInteractor;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0016J\b\u0010\n\u001a\u00020\bH\u0002J\b\u0010\u000b\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/qodana/ui/problemsView/viewModel/impl/UiStateLoadingReportImpl;", "Lorg/jetbrains/qodana/ui/problemsView/viewModel/QodanaProblemsViewModel$UiState$LoadingReport;", "project", "Lcom/intellij/openapi/project/Project;", "reportInteractor", "Lorg/jetbrains/qodana/ui/problemsView/viewModel/impl/ReportInteractor;", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/qodana/ui/problemsView/viewModel/impl/ReportInteractor;)V", "cancel", "", "closeReport", "logCancelReportLoadingStats", "refreshReport", "intellij.qodana"})
public final class UiStateLoadingReportImpl
implements QodanaProblemsViewModel.UiState.LoadingReport {
    @NotNull
    private final Project project;
    @NotNull
    private final ReportInteractor reportInteractor;

    public UiStateLoadingReportImpl(@NotNull Project project, @NotNull ReportInteractor reportInteractor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)reportInteractor, (String)"reportInteractor");
        this.project = project;
        this.reportInteractor = reportInteractor;
    }

    @Override
    public void cancel() {
        this.reportInteractor.close();
        this.logCancelReportLoadingStats();
    }

    @Override
    public void refreshReport() {
        this.reportInteractor.refresh();
    }

    @Override
    public void closeReport() {
        this.reportInteractor.close();
    }

    private final void logCancelReportLoadingStats() {
        HighlightedReportState highlightedReportState = (HighlightedReportState)QodanaHighlightedReportService.Companion.getInstance(this.project).getHighlightedReportState().getValue();
        ReportDescriptor reportDescriptor = HighlightedReportStateKt.getReportDescriptorIfSelectedOrLoading(highlightedReportState);
        if (reportDescriptor == null) {
            return;
        }
        ReportDescriptor reportDescriptor2 = reportDescriptor;
        QodanaPluginStatsCounterCollector.UPDATE_HIGHLIGHTED_REPORT.log(this.project, (Object)false, (Object)QodanaPluginStatsCounterCollectorKt.toStatsReportType(reportDescriptor2), (Object)SourceHighlight.QODANA_PANEL_CANCEL_LOADING);
    }
}

