/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.staticAnalysis.profile.providers;

import com.intellij.codeInspection.InspectionApplicationException;
import com.intellij.codeInspection.ex.ToolsImpl;
import com.intellij.openapi.project.Project;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.qodana.staticAnalysis.profile.QodanaInspectionProfile;
import org.jetbrains.qodana.staticAnalysis.profile.QodanaInspectionProfileManager;
import org.jetbrains.qodana.staticAnalysis.profile.QodanaInspectionProfileProvider;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J\u001c\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/qodana/staticAnalysis/profile/providers/QodanaSingleInspectionProfileProvider;", "Lorg/jetbrains/qodana/staticAnalysis/profile/QodanaInspectionProfileProvider;", "()V", "getAllProfileNames", "", "", "project", "Lcom/intellij/openapi/project/Project;", "provideProfile", "Lorg/jetbrains/qodana/staticAnalysis/profile/QodanaInspectionProfile;", "profileName", "intellij.qodana"})
public final class QodanaSingleInspectionProfileProvider
implements QodanaInspectionProfileProvider {
    @Override
    @Nullable
    public QodanaInspectionProfile provideProfile(@NotNull String profileName, @Nullable Project project) {
        Intrinsics.checkNotNullParameter((Object)profileName, (String)"profileName");
        String inspectionId = StringsKt.removePrefix((String)profileName, (CharSequence)"qodana.single:");
        if (inspectionId == profileName) {
            return null;
        }
        QodanaInspectionProfile inspectionProfile = QodanaInspectionProfile.Companion.newWithDisabledTools(profileName, QodanaInspectionProfileManager.Companion.getInstance(project));
        ToolsImpl toolsImpl = inspectionProfile.getToolsOrNull(inspectionId, project);
        if (toolsImpl == null) {
            throw new InspectionApplicationException("Unknown inspection id '" + inspectionId + "' in qodana.single profile");
        }
        ToolsImpl tools = toolsImpl;
        tools.setEnabled(true);
        tools.getDefaultState().setEnabled(true);
        inspectionProfile.lockProfile(true);
        return inspectionProfile;
    }

    @Override
    @NotNull
    public List<String> getAllProfileNames(@Nullable Project project) {
        return CollectionsKt.emptyList();
    }
}

