/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.tooling.builder;

import com.intellij.gradle.toolingExtension.impl.util.javaPluginUtil.JavaPluginUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.SourceSetOutput;
import org.gradle.api.tasks.TaskCollection;
import org.gradle.api.tasks.testing.Test;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.tests.DefaultExternalTestSourceMapping;
import org.jetbrains.plugins.gradle.model.tests.DefaultExternalTestsModel;
import org.jetbrains.plugins.gradle.model.tests.ExternalTestSourceMapping;
import org.jetbrains.plugins.gradle.model.tests.ExternalTestsModel;
import org.jetbrains.plugins.gradle.tooling.Message;
import org.jetbrains.plugins.gradle.tooling.ModelBuilderContext;
import org.jetbrains.plugins.gradle.tooling.ModelBuilderService;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\t\u001a\u00020\n2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J4\u0010\u0015\u001a\u00020\u00162\b\b\u0001\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\b2\b\b\u0001\u0010\u0017\u001a\u00020\u00182\f\b\u0001\u0010\u0019\u001a\u00060\u001aj\u0002`\u001bH\u0016\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/plugins/gradle/tooling/builder/ExternalTestsModelBuilderImpl;", "Lorg/jetbrains/plugins/gradle/tooling/ModelBuilderService;", "()V", "buildAll", "", "modelName", "", "project", "Lorg/gradle/api/Project;", "canBuild", "", "getClassesDirs", "", "test", "Lorg/gradle/api/tasks/testing/Test;", "getMapping", "", "Lorg/jetbrains/plugins/gradle/model/tests/ExternalTestSourceMapping;", "getPaths", "files", "Lorg/gradle/api/file/FileCollection;", "reportErrorMessage", "", "context", "Lorg/jetbrains/plugins/gradle/tooling/ModelBuilderContext;", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "intellij.gradle.toolingExtension.impl"})
public final class ExternalTestsModelBuilderImpl
implements ModelBuilderService {
    public boolean canBuild(@Nullable String modelName) {
        return Intrinsics.areEqual((Object)ExternalTestsModel.class.getName(), (Object)modelName);
    }

    @NotNull
    public Object buildAll(@NotNull String modelName, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)modelName, (String)"modelName");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        DefaultExternalTestsModel defaultTestsModel = new DefaultExternalTestsModel();
        if (project.getPlugins().hasPlugin("com.android.base")) {
            return defaultTestsModel;
        }
        if (JavaPluginUtil.isJavaPluginApplied(project)) {
            defaultTestsModel.setSourceTestMappings(this.getMapping(project));
        }
        return defaultTestsModel;
    }

    private final List<ExternalTestSourceMapping> getMapping(Project project) {
        LinkedHashMap taskToClassesDirs = new LinkedHashMap();
        TaskCollection tasks = project.getTasks().withType(Test.class);
        for (Test task : tasks) {
            Map map = taskToClassesDirs;
            Intrinsics.checkNotNull((Object)task);
            map.put(task, this.getClassesDirs(task));
        }
        SourceSetContainer sourceSetContainer = JavaPluginUtil.getSourceSetContainer(project);
        if (sourceSetContainer == null) {
            return CollectionsKt.emptyList();
        }
        SourceSetContainer sourceSetContainer2 = sourceSetContainer;
        LinkedHashMap classesDirToSourceDirs = new LinkedHashMap();
        for (SourceSet sourceSet : sourceSetContainer2) {
            SourceDirectorySet sourceDirectorySet = sourceSet.getAllSource();
            List sourceFolders = new ArrayList();
            for (File dir : sourceDirectorySet.getSrcDirs()) {
                String string = dir.getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
                sourceFolders.add(string);
            }
            SourceSetOutput sourceSetOutput = sourceSet.getOutput();
            Intrinsics.checkNotNullExpressionValue((Object)sourceSetOutput, (String)"getOutput(...)");
            for (String classDirectory : this.getPaths((FileCollection)sourceSetOutput)) {
                Object storedSourceFolders = (Set)classesDirToSourceDirs.get(classDirectory);
                if (storedSourceFolders == null) {
                    storedSourceFolders = new LinkedHashSet();
                }
                storedSourceFolders.addAll(sourceFolders);
                ((Map)classesDirToSourceDirs).put(classDirectory, storedSourceFolders);
            }
        }
        ArrayList<DefaultExternalTestSourceMapping> testSourceMappings = new ArrayList<DefaultExternalTestSourceMapping>();
        for (Map.Entry entry : ((Map)taskToClassesDirs).entrySet()) {
            Test task = (Test)entry.getKey();
            Set classesDirs = (Set)entry.getValue();
            LinkedHashSet<String> sourceFolders = new LinkedHashSet<String>();
            for (String classDirectory : classesDirs) {
                Set storedSourceFolders = (Set)classesDirToSourceDirs.get(classDirectory);
                if (storedSourceFolders == null) continue;
                for (String folder : storedSourceFolders) {
                    sourceFolders.add(folder);
                }
            }
            DefaultExternalTestSourceMapping defaultExternalTestSourceMapping = new DefaultExternalTestSourceMapping();
            defaultExternalTestSourceMapping.setTestName(task.getName());
            defaultExternalTestSourceMapping.setTestTaskPath(task.getPath());
            defaultExternalTestSourceMapping.setSourceFolders((Set<String>)sourceFolders);
            testSourceMappings.add(defaultExternalTestSourceMapping);
        }
        return testSourceMappings;
    }

    private final Set<String> getClassesDirs(Test test) {
        LinkedHashSet<String> testClassesDirs = new LinkedHashSet<String>();
        if (test.hasProperty("testClassesDirs")) {
            FileCollection fileCollection = test.getTestClassesDirs();
            Intrinsics.checkNotNullExpressionValue((Object)fileCollection, (String)"getTestClassesDirs(...)");
            testClassesDirs.addAll((Collection)this.getPaths(fileCollection));
        }
        if (test.hasProperty("testClassesDir")) {
            File testClassesDir;
            Object object = test.property("testClassesDir");
            File file = testClassesDir = object instanceof File ? (File)object : null;
            if (testClassesDir != null) {
                testClassesDirs.add(testClassesDir.getAbsolutePath());
            }
        }
        return testClassesDirs;
    }

    private final Set<String> getPaths(FileCollection files) {
        LinkedHashSet<String> paths = new LinkedHashSet<String>();
        for (File file : files.getFiles()) {
            paths.add(file.getAbsolutePath());
        }
        return paths;
    }

    public void reportErrorMessage(@NotNull String modelName, @NotNull Project project, @NotNull ModelBuilderContext context, @NotNull Exception exception) {
        Intrinsics.checkNotNullParameter((Object)modelName, (String)"modelName");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        context.getMessageReporter().createMessage().withGroup("gradle.testModel.group").withKind(Message.Kind.WARNING).withTitle("Test model failure").withException(exception).reportMessage(project);
    }
}

