/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gradle.toolingExtension.impl.model.taskModel;

import com.intellij.gradle.toolingExtension.impl.model.taskIndex.GradleTaskIndex;
import com.intellij.gradle.toolingExtension.impl.model.taskModel.DefaultGradleTaskModel;
import com.intellij.gradle.toolingExtension.impl.util.GradleObjectUtil;
import com.intellij.gradle.toolingExtension.impl.util.GradleTaskUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.tasks.testing.AbstractTestTask;
import org.gradle.api.tasks.testing.Test;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.model.DefaultExternalTask;
import org.jetbrains.plugins.gradle.model.GradleTaskModel;
import org.jetbrains.plugins.gradle.tooling.AbstractModelBuilderService;
import org.jetbrains.plugins.gradle.tooling.Message;
import org.jetbrains.plugins.gradle.tooling.ModelBuilderContext;
import org.jetbrains.plugins.gradle.tooling.builder.ProjectExtensionsDataBuilderImpl;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J$\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J,\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\n\u0010\u0012\u001a\u00060\u0013j\u0002`\u0014H\u0016\u00a8\u0006\u0015"}, d2={"Lcom/intellij/gradle/toolingExtension/impl/model/taskModel/GradleTaskModelBuilder;", "Lorg/jetbrains/plugins/gradle/tooling/AbstractModelBuilderService;", "()V", "buildAll", "", "modelName", "", "project", "Lorg/gradle/api/Project;", "context", "Lorg/jetbrains/plugins/gradle/tooling/ModelBuilderContext;", "canBuild", "", "getTasks", "", "Lorg/jetbrains/plugins/gradle/model/DefaultExternalTask;", "reportErrorMessage", "", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "intellij.gradle.toolingExtension.impl"})
@ApiStatus.Internal
public final class GradleTaskModelBuilder
extends AbstractModelBuilderService {
    public boolean canBuild(@NotNull String modelName) {
        Intrinsics.checkNotNullParameter((Object)modelName, (String)"modelName");
        return Intrinsics.areEqual((Object)modelName, (Object)GradleTaskModel.class.getName());
    }

    @NotNull
    public Object buildAll(@NotNull String modelName, @NotNull Project project, @NotNull ModelBuilderContext context) {
        Intrinsics.checkNotNullParameter((Object)modelName, (String)"modelName");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        DefaultGradleTaskModel taskModel = new DefaultGradleTaskModel();
        taskModel.setTasks(this.getTasks(project, context));
        return taskModel;
    }

    private final Map<String, DefaultExternalTask> getTasks(Project project, ModelBuilderContext context) {
        Set<Task> tasks = GradleTaskIndex.getInstance(context).getAllTasks(project);
        HashMap result = new HashMap();
        for (Task task : tasks) {
            String taskName = task.getName();
            String taskPath = task.getPath();
            String projectPath = project.getPath();
            String projectTaskPath = Intrinsics.areEqual((Object)":", (Object)projectPath) ? ':' + taskName : projectPath + ':' + taskName;
            DefaultExternalTask externalTask = (DefaultExternalTask)result.get(taskName);
            if (externalTask == null) {
                externalTask = new DefaultExternalTask();
                externalTask.setName(taskName);
                externalTask.setQName(taskName);
                externalTask.setDescription(task.getDescription());
                externalTask.setGroup(GradleObjectUtil.notNull(task.getGroup(), "other"));
                boolean isInternalTest = GradleTaskUtil.getBooleanProperty(task, "idea.internal.test", false);
                boolean isEffectiveTest = Intrinsics.areEqual((Object)"check", (Object)taskName) && Intrinsics.areEqual((Object)"verification", (Object)task.getGroup());
                boolean isJvmTest = task instanceof Test;
                boolean isAbstractTest = task instanceof AbstractTestTask;
                externalTask.setTest(isJvmTest || isAbstractTest || isInternalTest || isEffectiveTest);
                externalTask.setJvmTest(isJvmTest || isAbstractTest);
                externalTask.setType(ProjectExtensionsDataBuilderImpl.Companion.getType(task));
                Map map = result;
                String string = externalTask.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                map.put(string, externalTask);
            }
            if (!Intrinsics.areEqual((Object)projectTaskPath, (Object)taskPath)) continue;
            externalTask.setQName(taskPath);
        }
        return result;
    }

    public void reportErrorMessage(@NotNull String modelName, @NotNull Project project, @NotNull ModelBuilderContext context, @NotNull Exception exception) {
        Intrinsics.checkNotNullParameter((Object)modelName, (String)"modelName");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        context.getMessageReporter().createMessage().withGroup("gradle.taskModel.group").withKind(Message.Kind.WARNING).withTitle("Gradle task model building failure").withException(exception).reportMessage(project);
    }
}

