/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.kotlin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.FindClassInModuleKt;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.NotFoundClasses;
import kotlin.reflect.jvm.internal.impl.descriptors.SourceElement;
import kotlin.reflect.jvm.internal.impl.descriptors.ValueParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationDescriptorImpl;
import kotlin.reflect.jvm.internal.impl.load.java.components.DescriptorResolverUtils;
import kotlin.reflect.jvm.internal.impl.load.kotlin.AbstractBinaryClassAnnotationAndConstantLoader;
import kotlin.reflect.jvm.internal.impl.load.kotlin.BinaryClassAnnotationAndConstantLoaderImpl;
import kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinClassFinder;
import kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinJvmBinaryClass;
import kotlin.reflect.jvm.internal.impl.metadata.ProtoBuf;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.NameResolver;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.constants.AnnotationValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ByteValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ClassLiteralValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ConstantValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ConstantValueFactory;
import kotlin.reflect.jvm.internal.impl.resolve.constants.EnumValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ErrorValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.IntValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.KClassValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.LongValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ShortValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.UByteValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.UIntValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ULongValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.UShortValue;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.AnnotationDeserializer;
import kotlin.reflect.jvm.internal.impl.storage.StorageManager;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BinaryClassAnnotationAndConstantLoaderImpl
extends AbstractBinaryClassAnnotationAndConstantLoader<AnnotationDescriptor, ConstantValue<?>> {
    @NotNull
    private final ModuleDescriptor module;
    @NotNull
    private final NotFoundClasses notFoundClasses;
    @NotNull
    private final AnnotationDeserializer annotationDeserializer;

    public BinaryClassAnnotationAndConstantLoaderImpl(@NotNull ModuleDescriptor module, @NotNull NotFoundClasses notFoundClasses, @NotNull StorageManager storageManager, @NotNull KotlinClassFinder kotlinClassFinder) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)notFoundClasses, (String)"notFoundClasses");
        Intrinsics.checkNotNullParameter((Object)storageManager, (String)"storageManager");
        Intrinsics.checkNotNullParameter((Object)kotlinClassFinder, (String)"kotlinClassFinder");
        super(storageManager, kotlinClassFinder);
        this.module = module;
        this.notFoundClasses = notFoundClasses;
        this.annotationDeserializer = new AnnotationDeserializer(this.module, this.notFoundClasses);
    }

    @Override
    @NotNull
    protected AnnotationDescriptor loadTypeAnnotation(@NotNull ProtoBuf.Annotation proto, @NotNull NameResolver nameResolver2) {
        Intrinsics.checkNotNullParameter((Object)proto, (String)"proto");
        Intrinsics.checkNotNullParameter((Object)nameResolver2, (String)"nameResolver");
        return this.annotationDeserializer.deserializeAnnotation(proto, nameResolver2);
    }

    @Override
    @Nullable
    protected ConstantValue<?> loadConstant(@NotNull String desc, @NotNull Object initializer) {
        Object object;
        block18: {
            block16: {
                Intrinsics.checkNotNullParameter((Object)desc, (String)"desc");
                Intrinsics.checkNotNullParameter((Object)initializer, (String)"initializer");
                if (!StringsKt.contains$default((CharSequence)"ZBCS", (CharSequence)desc, (boolean)false, (int)2, null)) break block16;
                int intValue = (Integer)initializer;
                switch (desc) {
                    case "Z": {
                        object = intValue != 0;
                        break block18;
                    }
                    case "B": {
                        object = (byte)intValue;
                        break block18;
                    }
                    case "C": {
                        object = Character.valueOf((char)intValue);
                        break block18;
                    }
                    case "S": {
                        object = (short)intValue;
                        break block18;
                    }
                    default: {
                        throw new AssertionError((Object)desc);
                    }
                }
            }
            object = initializer;
        }
        Object normalizedValue = object;
        return ConstantValueFactory.INSTANCE.createConstantValue(normalizedValue);
    }

    @Override
    @Nullable
    protected ConstantValue<?> transformToUnsignedConstant(@NotNull ConstantValue<?> constant) {
        Intrinsics.checkNotNullParameter(constant, (String)"constant");
        ConstantValue constantValue = constant;
        return constantValue instanceof ByteValue ? (ConstantValue)new UByteValue(((Number)((ByteValue)constant).getValue()).byteValue()) : (constantValue instanceof ShortValue ? (ConstantValue)new UShortValue(((Number)((ShortValue)constant).getValue()).shortValue()) : (constantValue instanceof IntValue ? (ConstantValue)new UIntValue(((Number)((IntValue)constant).getValue()).intValue()) : (constantValue instanceof LongValue ? (ConstantValue)new ULongValue(((Number)((LongValue)constant).getValue()).longValue()) : constant)));
    }

    @Override
    @Nullable
    protected KotlinJvmBinaryClass.AnnotationArgumentVisitor loadAnnotation(@NotNull ClassId annotationClassId, @NotNull SourceElement source, @NotNull List<AnnotationDescriptor> result2) {
        Intrinsics.checkNotNullParameter((Object)annotationClassId, (String)"annotationClassId");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        ClassDescriptor annotationClass = this.resolveClass(annotationClassId);
        return new KotlinJvmBinaryClass.AnnotationArgumentVisitor(this, annotationClass, annotationClassId, result2, source){
            @NotNull
            private final HashMap<Name, ConstantValue<?>> arguments;
            final /* synthetic */ BinaryClassAnnotationAndConstantLoaderImpl this$0;
            final /* synthetic */ ClassDescriptor $annotationClass;
            final /* synthetic */ ClassId $annotationClassId;
            final /* synthetic */ List<AnnotationDescriptor> $result;
            final /* synthetic */ SourceElement $source;
            {
                this.this$0 = $receiver;
                this.$annotationClass = $annotationClass;
                this.$annotationClassId = $annotationClassId;
                this.$result = $result;
                this.$source = $source;
                this.arguments = new HashMap<K, V>();
            }

            public void visit(@Nullable Name name2, @Nullable Object value2) {
                if (name2 != null) {
                    Map map = this.arguments;
                    ConstantValue<?> constantValue = this.createConstant(name2, value2);
                    map.put(name2, constantValue);
                }
            }

            public void visitClassLiteral(@NotNull Name name2, @NotNull ClassLiteralValue value2) {
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
                Map map = this.arguments;
                KClassValue kClassValue = new KClassValue(value2);
                map.put(name2, kClassValue);
            }

            public void visitEnum(@NotNull Name name2, @NotNull ClassId enumClassId, @NotNull Name enumEntryName) {
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                Intrinsics.checkNotNullParameter((Object)enumClassId, (String)"enumClassId");
                Intrinsics.checkNotNullParameter((Object)enumEntryName, (String)"enumEntryName");
                Map map = this.arguments;
                EnumValue enumValue = new EnumValue(enumClassId, enumEntryName);
                map.put(name2, enumValue);
            }

            @Nullable
            public KotlinJvmBinaryClass.AnnotationArrayArgumentVisitor visitArray(@NotNull Name name2) {
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                return new KotlinJvmBinaryClass.AnnotationArrayArgumentVisitor(this, name2, this.this$0, this.$annotationClass, this.$annotationClassId, this.$result){
                    @NotNull
                    private final ArrayList<ConstantValue<?>> elements;
                    final /* synthetic */ loadAnnotation.1 this$0;
                    final /* synthetic */ Name $name;
                    final /* synthetic */ BinaryClassAnnotationAndConstantLoaderImpl this$1;
                    final /* synthetic */ ClassDescriptor $annotationClass;
                    final /* synthetic */ ClassId $annotationClassId;
                    final /* synthetic */ List<AnnotationDescriptor> $result;
                    {
                        this.this$0 = $receiver;
                        this.$name = $name;
                        this.this$1 = $receiver2;
                        this.$annotationClass = $annotationClass;
                        this.$annotationClassId = $annotationClassId;
                        this.$result = $result;
                        this.elements = new ArrayList<E>();
                    }

                    public void visit(@Nullable Object value2) {
                        this.elements.add(loadAnnotation.1.access$createConstant(this.this$0, this.$name, value2));
                    }

                    public void visitEnum(@NotNull ClassId enumClassId, @NotNull Name enumEntryName) {
                        Intrinsics.checkNotNullParameter((Object)enumClassId, (String)"enumClassId");
                        Intrinsics.checkNotNullParameter((Object)enumEntryName, (String)"enumEntryName");
                        this.elements.add(new EnumValue(enumClassId, enumEntryName));
                    }

                    public void visitClassLiteral(@NotNull ClassLiteralValue value2) {
                        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
                        this.elements.add(new KClassValue(value2));
                    }

                    @Nullable
                    public KotlinJvmBinaryClass.AnnotationArgumentVisitor visitAnnotation(@NotNull ClassId classId) {
                        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
                        ArrayList<AnnotationDescriptor> list = new ArrayList<AnnotationDescriptor>();
                        SourceElement sourceElement = SourceElement.NO_SOURCE;
                        Intrinsics.checkNotNullExpressionValue((Object)sourceElement, (String)"NO_SOURCE");
                        KotlinJvmBinaryClass.AnnotationArgumentVisitor annotationArgumentVisitor = this.this$1.loadAnnotation(classId, sourceElement, (List<AnnotationDescriptor>)list);
                        Intrinsics.checkNotNull((Object)annotationArgumentVisitor);
                        KotlinJvmBinaryClass.AnnotationArgumentVisitor visitor2 = annotationArgumentVisitor;
                        return new KotlinJvmBinaryClass.AnnotationArgumentVisitor(visitor2, this, list){
                            private final /* synthetic */ KotlinJvmBinaryClass.AnnotationArgumentVisitor $$delegate_0;
                            final /* synthetic */ KotlinJvmBinaryClass.AnnotationArgumentVisitor $visitor;
                            final /* synthetic */ loadAnnotation.visitArray.1 this$0;
                            final /* synthetic */ ArrayList<AnnotationDescriptor> $list;
                            {
                                this.$visitor = $visitor;
                                this.this$0 = $receiver;
                                this.$list = $list;
                                this.$$delegate_0 = this.$visitor;
                            }

                            public void visit(@Nullable Name name2, @Nullable Object value2) {
                                this.$$delegate_0.visit(name2, value2);
                            }

                            @Nullable
                            public KotlinJvmBinaryClass.AnnotationArgumentVisitor visitAnnotation(@NotNull Name name2, @NotNull ClassId classId) {
                                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                                Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
                                return this.$$delegate_0.visitAnnotation(name2, classId);
                            }

                            @Nullable
                            public KotlinJvmBinaryClass.AnnotationArrayArgumentVisitor visitArray(@NotNull Name name2) {
                                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                                return this.$$delegate_0.visitArray(name2);
                            }

                            public void visitClassLiteral(@NotNull Name name2, @NotNull ClassLiteralValue value2) {
                                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                                Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
                                this.$$delegate_0.visitClassLiteral(name2, value2);
                            }

                            public void visitEnum(@NotNull Name name2, @NotNull ClassId enumClassId, @NotNull Name enumEntryName) {
                                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                                Intrinsics.checkNotNullParameter((Object)enumClassId, (String)"enumClassId");
                                Intrinsics.checkNotNullParameter((Object)enumEntryName, (String)"enumEntryName");
                                this.$$delegate_0.visitEnum(name2, enumClassId, enumEntryName);
                            }

                            public void visitEnd() {
                                this.$visitor.visitEnd();
                                loadAnnotation.visitArray.1.access$getElements$p(this.this$0).add(new AnnotationValue((AnnotationDescriptor)CollectionsKt.single((List)this.$list)));
                            }
                        };
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public void visitEnd() {
                        ValueParameterDescriptor parameter = DescriptorResolverUtils.getAnnotationParameterByName(this.$name, this.$annotationClass);
                        if (parameter != null) {
                            Map map = loadAnnotation.1.access$getArguments$p(this.this$0);
                            List<ConstantValue<?>> list = kotlin.reflect.jvm.internal.impl.utils.CollectionsKt.compact(this.elements);
                            KotlinType kotlinType = parameter.getType();
                            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"parameter.type");
                            map.put(this.$name, ConstantValueFactory.INSTANCE.createArrayValue(list, kotlinType));
                        } else if (this.this$1.isImplicitRepeatableContainer(this.$annotationClassId) && Intrinsics.areEqual((Object)this.$name.asString(), (Object)"value")) {
                            void $this$mapTo$iv;
                            void $this$filterIsInstanceTo$iv$iv;
                            Iterable $this$filterIsInstance$iv = this.elements;
                            boolean $i$f$filterIsInstance = false;
                            Iterable iterable = $this$filterIsInstance$iv;
                            Collection destination$iv$iv = new ArrayList<E>();
                            boolean $i$f$filterIsInstanceTo = false;
                            for (T element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                                if (!(element$iv$iv instanceof AnnotationValue)) continue;
                                destination$iv$iv.add(element$iv$iv);
                            }
                            $this$filterIsInstance$iv = (List)destination$iv$iv;
                            Collection destination$iv = this.$result;
                            boolean $i$f$mapTo = false;
                            for (T item$iv : $this$mapTo$iv) {
                                void p0;
                                AnnotationValue annotationValue = (AnnotationValue)item$iv;
                                Collection collection = destination$iv;
                                boolean bl = false;
                                AnnotationDescriptor annotationDescriptor = (AnnotationDescriptor)p0.getValue();
                                collection.add(annotationDescriptor);
                            }
                        }
                    }

                    public static final /* synthetic */ ArrayList access$getElements$p(loadAnnotation.visitArray.1 $this) {
                        return $this.elements;
                    }
                };
            }

            @Nullable
            public KotlinJvmBinaryClass.AnnotationArgumentVisitor visitAnnotation(@NotNull Name name2, @NotNull ClassId classId) {
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
                ArrayList<AnnotationDescriptor> list = new ArrayList<AnnotationDescriptor>();
                SourceElement sourceElement = SourceElement.NO_SOURCE;
                Intrinsics.checkNotNullExpressionValue((Object)sourceElement, (String)"NO_SOURCE");
                KotlinJvmBinaryClass.AnnotationArgumentVisitor annotationArgumentVisitor = this.this$0.loadAnnotation(classId, sourceElement, (List<AnnotationDescriptor>)list);
                Intrinsics.checkNotNull((Object)annotationArgumentVisitor);
                KotlinJvmBinaryClass.AnnotationArgumentVisitor visitor2 = annotationArgumentVisitor;
                return new KotlinJvmBinaryClass.AnnotationArgumentVisitor(visitor2, this, name2, list){
                    private final /* synthetic */ KotlinJvmBinaryClass.AnnotationArgumentVisitor $$delegate_0;
                    final /* synthetic */ KotlinJvmBinaryClass.AnnotationArgumentVisitor $visitor;
                    final /* synthetic */ loadAnnotation.1 this$0;
                    final /* synthetic */ Name $name;
                    final /* synthetic */ ArrayList<AnnotationDescriptor> $list;
                    {
                        this.$visitor = $visitor;
                        this.this$0 = $receiver;
                        this.$name = $name;
                        this.$list = $list;
                        this.$$delegate_0 = this.$visitor;
                    }

                    public void visit(@Nullable Name name2, @Nullable Object value2) {
                        this.$$delegate_0.visit(name2, value2);
                    }

                    @Nullable
                    public KotlinJvmBinaryClass.AnnotationArgumentVisitor visitAnnotation(@NotNull Name name2, @NotNull ClassId classId) {
                        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
                        return this.$$delegate_0.visitAnnotation(name2, classId);
                    }

                    @Nullable
                    public KotlinJvmBinaryClass.AnnotationArrayArgumentVisitor visitArray(@NotNull Name name2) {
                        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                        return this.$$delegate_0.visitArray(name2);
                    }

                    public void visitClassLiteral(@NotNull Name name2, @NotNull ClassLiteralValue value2) {
                        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
                        this.$$delegate_0.visitClassLiteral(name2, value2);
                    }

                    public void visitEnum(@NotNull Name name2, @NotNull ClassId enumClassId, @NotNull Name enumEntryName) {
                        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                        Intrinsics.checkNotNullParameter((Object)enumClassId, (String)"enumClassId");
                        Intrinsics.checkNotNullParameter((Object)enumEntryName, (String)"enumEntryName");
                        this.$$delegate_0.visitEnum(name2, enumClassId, enumEntryName);
                    }

                    public void visitEnd() {
                        this.$visitor.visitEnd();
                        ((Map)loadAnnotation.1.access$getArguments$p(this.this$0)).put(this.$name, new AnnotationValue((AnnotationDescriptor)CollectionsKt.single((List)this.$list)));
                    }
                };
            }

            public void visitEnd() {
                if (this.this$0.isRepeatableWithImplicitContainer(this.$annotationClassId, (Map)this.arguments)) {
                    return;
                }
                if (this.this$0.isImplicitRepeatableContainer(this.$annotationClassId)) {
                    return;
                }
                this.$result.add(new AnnotationDescriptorImpl(this.$annotationClass.getDefaultType(), (Map)this.arguments, this.$source));
            }

            private final ConstantValue<?> createConstant(Name name2, Object value2) {
                ConstantValue constantValue = ConstantValueFactory.INSTANCE.createConstantValue(value2);
                return constantValue == null ? (ConstantValue)ErrorValue.Companion.create(Intrinsics.stringPlus((String)"Unsupported annotation argument: ", (Object)name2)) : constantValue;
            }

            public static final /* synthetic */ ConstantValue access$createConstant(loadAnnotation.1 $this, Name name2, Object value2) {
                return $this.createConstant(name2, value2);
            }

            public static final /* synthetic */ HashMap access$getArguments$p(loadAnnotation.1 $this) {
                return $this.arguments;
            }
        };
    }

    private final ClassDescriptor resolveClass(ClassId classId) {
        return FindClassInModuleKt.findNonGenericClassAcrossDependencies(this.module, classId, this.notFoundClasses);
    }
}

