/*
 * Decompiled with CFR 0.152.
 */
package tech.units.indriya.format;

import java.io.IOException;
import java.math.BigDecimal;
import java.text.ParsePosition;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.format.ParserException;
import tech.units.indriya.AbstractQuantity;
import tech.units.indriya.AbstractUnit;
import tech.units.indriya.ComparableQuantity;
import tech.units.indriya.format.AbstractQuantityFormat;
import tech.units.indriya.format.SimpleUnitFormat;
import tech.units.indriya.quantity.NumberQuantity;
import tech.units.indriya.quantity.Quantities;

public class SimpleQuantityFormat
extends AbstractQuantityFormat {
    private static final SimpleQuantityFormat DEFAULT = new SimpleQuantityFormat();
    private static final long serialVersionUID = 2758248665095734058L;

    public Appendable format(Quantity quantity, Appendable dest) throws IOException {
        Unit unit = quantity.getUnit();
        dest.append(quantity.getValue().toString());
        if (quantity.getUnit().equals(AbstractUnit.ONE)) {
            return dest;
        }
        dest.append(' ');
        return SimpleUnitFormat.getInstance().format(unit, dest);
    }

    @Override
    public ComparableQuantity<?> parse(CharSequence csq, ParsePosition cursor) throws ParserException {
        int endDecimal;
        int startDecimal;
        for (startDecimal = cursor.getIndex(); startDecimal < csq.length() && Character.isWhitespace(csq.charAt(startDecimal)); ++startDecimal) {
        }
        for (endDecimal = startDecimal + 1; endDecimal < csq.length() && !Character.isWhitespace(csq.charAt(endDecimal)); ++endDecimal) {
        }
        BigDecimal decimal = new BigDecimal(csq.subSequence(startDecimal, endDecimal).toString());
        cursor.setIndex(endDecimal + 1);
        Unit<?> unit = SimpleUnitFormat.getInstance().parse(csq, cursor);
        return Quantities.getQuantity(decimal, unit);
    }

    AbstractQuantity<?> parse(CharSequence csq, int index) throws ParserException {
        int endDecimal;
        int startDecimal;
        for (startDecimal = index; startDecimal < csq.length() && Character.isWhitespace(csq.charAt(startDecimal)); ++startDecimal) {
        }
        for (endDecimal = startDecimal + 1; endDecimal < csq.length() && !Character.isWhitespace(csq.charAt(endDecimal)); ++endDecimal) {
        }
        Double decimal = new Double(csq.subSequence(startDecimal, endDecimal).toString());
        Unit<?> unit = SimpleUnitFormat.getInstance().parse(csq, index);
        return NumberQuantity.of(decimal, unit);
    }

    @Override
    public ComparableQuantity<?> parse(CharSequence csq) throws ParserException {
        return this.parse(csq, new ParsePosition(0));
    }

    public static SimpleQuantityFormat getInstance() {
        return DEFAULT;
    }
}

