/*
 * Decompiled with CFR 0.152.
 */
package io.kinference.core.operators.quantization.lstm;

import io.kinference.core.operators.layer.recurrent.lstm.AbstractLSTMWeights;
import io.kinference.ndarray.arrays.FloatNDArray;
import io.kinference.ndarray.arrays.NumberNDArrayCore;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000f"}, d2={"Lio/kinference/core/operators/quantization/lstm/QuantizedLSTMWeights;", "Lio/kinference/core/operators/layer/recurrent/lstm/AbstractLSTMWeights;", "data", "Lio/kinference/ndarray/arrays/NumberNDArrayCore;", "scale", "Lio/kinference/ndarray/arrays/FloatNDArray;", "zeroPoint", "(Lio/kinference/ndarray/arrays/NumberNDArrayCore;Lio/kinference/ndarray/arrays/FloatNDArray;Lio/kinference/ndarray/arrays/NumberNDArrayCore;)V", "getScale", "()Lio/kinference/ndarray/arrays/FloatNDArray;", "getZeroPoint", "()Lio/kinference/ndarray/arrays/NumberNDArrayCore;", "view", "dim", "", "inference-core"})
public final class QuantizedLSTMWeights
extends AbstractLSTMWeights {
    @NotNull
    private final FloatNDArray scale;
    @NotNull
    private final NumberNDArrayCore zeroPoint;

    public QuantizedLSTMWeights(@NotNull NumberNDArrayCore data2, @NotNull FloatNDArray scale, @NotNull NumberNDArrayCore zeroPoint) {
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        Intrinsics.checkNotNullParameter((Object)scale, (String)"scale");
        Intrinsics.checkNotNullParameter((Object)zeroPoint, (String)"zeroPoint");
        super(data2);
        this.scale = scale;
        this.zeroPoint = zeroPoint;
    }

    @NotNull
    public final FloatNDArray getScale() {
        return this.scale;
    }

    @NotNull
    public final NumberNDArrayCore getZeroPoint() {
        return this.zeroPoint;
    }

    @Override
    @NotNull
    public QuantizedLSTMWeights view(int dim) {
        QuantizedLSTMWeights quantizedLSTMWeights;
        if (this.getData().getRank() == 4) {
            int[] nArray = new int[]{dim};
            NumberNDArrayCore numberNDArrayCore = this.getData().view(nArray);
            nArray = new int[]{dim};
            FloatNDArray floatNDArray = this.scale.view(nArray);
            nArray = new int[]{dim};
            QuantizedLSTMWeights quantizedLSTMWeights2 = new QuantizedLSTMWeights(numberNDArrayCore, floatNDArray, this.zeroPoint.view(nArray));
            quantizedLSTMWeights = quantizedLSTMWeights2;
        } else {
            int[] nArray = new int[]{dim};
            QuantizedLSTMWeights quantizedLSTMWeights3 = new QuantizedLSTMWeights(this.getData().view(nArray), this.scale, this.zeroPoint);
            quantizedLSTMWeights = quantizedLSTMWeights3;
        }
        return quantizedLSTMWeights;
    }
}

