/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.ml.embeddings.search.services;

import ai.grazie.emb.FloatTextEmbedding;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.Project;
import com.intellij.platform.ml.embeddings.logging.EmbeddingSearchLogger;
import com.intellij.platform.ml.embeddings.search.indices.DiskSynchronizedEmbeddingSearchIndex;
import com.intellij.platform.ml.embeddings.search.indices.IndexType;
import com.intellij.platform.ml.embeddings.search.indices.IndexableEntity;
import com.intellij.platform.ml.embeddings.search.services.DiskSynchronizedEmbeddingsStorage;
import com.intellij.platform.ml.embeddings.search.services.EmbeddingIndexMemoryManager;
import com.intellij.platform.ml.embeddings.search.services.EmbeddingsStorage;
import com.intellij.platform.ml.embeddings.search.services.FileBasedEmbeddingStoragesManager;
import com.intellij.platform.ml.embeddings.search.utils.ScoredText;
import com.intellij.platform.ml.embeddings.services.IndexPersistedEventsCounter;
import com.intellij.platform.ml.embeddings.services.LocalEmbeddingServiceProvider;
import com.intellij.platform.ml.embeddings.utils.IndexingUtilsKt;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.channels.BufferOverflow;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import kotlinx.coroutines.sync.Mutex;
import kotlinx.coroutines.sync.MutexKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 3*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u00013B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u001c\u001a\u00020\u0013J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u000e\u0010\u001f\u001a\u00020\u0013H\u0086@\u00a2\u0006\u0002\u0010 J\u000e\u0010!\u001a\u00020\u0013H\u0082@\u00a2\u0006\u0002\u0010 J\u0006\u0010\"\u001a\u00020\u0013J\u000e\u0010#\u001a\u00020\u0013H\u0086@\u00a2\u0006\u0002\u0010 J\b\u0010$\u001a\u00020\u0013H\u0002J.\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\b\u0010,\u001a\u0004\u0018\u00010-H\u0097@\u00a2\u0006\u0002\u0010.J\u000e\u0010/\u001a\u00020\u0013H\u0086@\u00a2\u0006\u0002\u0010 J(\u00100\u001a\b\u0012\u0004\u0012\u00020'012\u0006\u0010(\u001a\u00020)2\n\b\u0002\u0010,\u001a\u0004\u0018\u00010-H\u0087@\u00a2\u0006\u0002\u00102R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00020\nX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0012\u0010\u0016\u001a\u00020\u0017X\u00a0\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/intellij/platform/ml/embeddings/search/services/DiskSynchronizedEmbeddingsStorage;", "T", "Lcom/intellij/platform/ml/embeddings/search/indices/IndexableEntity;", "Lcom/intellij/platform/ml/embeddings/search/services/EmbeddingsStorage;", "project", "Lcom/intellij/openapi/project/Project;", "cs", "Lkotlinx/coroutines/CoroutineScope;", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "index", "Lcom/intellij/platform/ml/embeddings/search/indices/DiskSynchronizedEmbeddingSearchIndex;", "getIndex", "()Lcom/intellij/platform/ml/embeddings/search/indices/DiskSynchronizedEmbeddingSearchIndex;", "indexLoadingMutex", "Lkotlinx/coroutines/sync/Mutex;", "isIndexLoaded", "", "offloadRequest", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "", "getProject", "()Lcom/intellij/openapi/project/Project;", "reportableIndex", "Lcom/intellij/platform/ml/embeddings/search/indices/IndexType;", "getReportableIndex$intellij_platform_ml_embeddings", "()Lcom/intellij/platform/ml/embeddings/search/indices/IndexType;", "usageSessionCount", "Ljava/util/concurrent/atomic/AtomicInteger;", "finishIndexingSession", "getIndexPersistedEventsCounter", "Lcom/intellij/platform/ml/embeddings/services/IndexPersistedEventsCounter;", "loadIndex", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "offloadIndex", "registerInMemoryManager", "saveIndex", "scheduleOffload", "searchNeighbours", "", "Lcom/intellij/platform/ml/embeddings/search/utils/ScoredText;", "text", "", "topK", "", "similarityThreshold", "", "(Ljava/lang/String;ILjava/lang/Double;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "startIndexingSession", "streamSearchNeighbours", "Lkotlinx/coroutines/flow/Flow;", "(Ljava/lang/String;Ljava/lang/Double;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "intellij.platform.ml.embeddings"})
@SourceDebugExtension(value={"SMAP\nDiskSynchronizedEmbeddingsStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiskSynchronizedEmbeddingsStorage.kt\ncom/intellij/platform/ml/embeddings/search/services/DiskSynchronizedEmbeddingsStorage\n+ 2 Mutex.kt\nkotlinx/coroutines/sync/MutexKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,141:1\n116#2,7:142\n124#2,2:159\n116#2,10:161\n116#2,7:171\n124#2,2:189\n58#3,5:149\n58#3,5:154\n58#3,5:179\n58#3,5:184\n1#4:178\n*S KotlinDebug\n*F\n+ 1 DiskSynchronizedEmbeddingsStorage.kt\ncom/intellij/platform/ml/embeddings/search/services/DiskSynchronizedEmbeddingsStorage\n*L\n50#1:142,7\n50#1:159,2\n61#1:161,10\n63#1:171,7\n63#1:189,2\n54#1:149,5\n57#1:154,5\n69#1:179,5\n72#1:184,5\n*E\n"})
public abstract class DiskSynchronizedEmbeddingsStorage<T extends IndexableEntity>
implements EmbeddingsStorage {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope cs;
    @NotNull
    private final MutableSharedFlow<Unit> offloadRequest;
    @NotNull
    private final AtomicInteger usageSessionCount;
    private boolean isIndexLoaded;
    @NotNull
    private final Mutex indexLoadingMutex;
    private static final long OFFLOAD_TIMEOUT = DurationKt.toDuration((int)10, (DurationUnit)DurationUnit.SECONDS);
    @NotNull
    private static final Logger logger;

    public DiskSynchronizedEmbeddingsStorage(@NotNull Project project, @NotNull CoroutineScope cs) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        this.project = project;
        this.cs = cs;
        this.offloadRequest = SharedFlowKt.MutableSharedFlow$default((int)1, (int)0, (BufferOverflow)BufferOverflow.DROP_OLDEST, (int)2, null);
        this.usageSessionCount = new AtomicInteger(0);
        this.indexLoadingMutex = MutexKt.Mutex$default((boolean)false, (int)1, null);
        BuildersKt.launch$default((CoroutineScope)this.cs, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ DiskSynchronizedEmbeddingsStorage<T> this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = FlowKt.collectLatest((Flow)FlowKt.debounce-HG0u8IE((Flow)((Flow)this.this$0.offloadRequest), (long)OFFLOAD_TIMEOUT), (Function2)((Function2)new Function2<Unit, Continuation<? super Unit>, Object>(this.this$0, null){
                            int label;
                            final /* synthetic */ DiskSynchronizedEmbeddingsStorage<T> this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             */
                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                block5: {
                                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)object);
                                            if (this.this$0.usageSessionCount.get() != 0) break;
                                            this.label = 1;
                                            Object object3 = this.this$0.offloadIndex((Continuation<Unit>)((Continuation)this));
                                            if (object3 == object2) {
                                                return object2;
                                            }
                                            break block5;
                                        }
                                        case 1: {
                                            void $result;
                                            ResultKt.throwOnFailure((Object)$result);
                                            Object object3 = $result;
                                            break block5;
                                        }
                                    }
                                    this.this$0.scheduleOffload();
                                }
                                return Unit.INSTANCE;
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull Unit p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public abstract DiskSynchronizedEmbeddingSearchIndex getIndex();

    @NotNull
    public abstract IndexType getReportableIndex$intellij_platform_ml_embeddings();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public final Object loadIndex(@NotNull Continuation<? super Unit> var1_1) {
        if (!(var1_1 instanceof loadIndex.1)) ** GOTO lbl-1000
        var13_2 = var1_1;
        if ((var13_2.label & -2147483648) != 0) {
            var13_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ DiskSynchronizedEmbeddingsStorage<T> this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.loadIndex((Continuation<Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var14_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $this$withLock_u24default$iv = this.indexLoadingMutex;
                owner$iv = null;
                $i$f$withLock = false;
                $continuation.L$0 = this;
                $continuation.L$1 = $this$withLock_u24default$iv;
                $continuation.label = 1;
                v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)$continuation);
                if (v0 == var14_4) {
                    return var14_4;
                }
                ** GOTO lbl31
            }
            case 1: {
                $i$f$withLock = false;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$1;
                this = (DiskSynchronizedEmbeddingsStorage)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl31:
                // 3 sources

                $i$a$-withLock$default-DiskSynchronizedEmbeddingsStorage$loadIndex$2 = false;
                if (this.isIndexLoaded) break;
                $continuation.L$0 = this;
                $continuation.L$1 = $this$withLock_u24default$iv;
                $continuation.label = 2;
                v1 = this.getIndex().loadFromDisk((Continuation<? super Unit>)$continuation);
                v2 = v1;
                if (v1 == var14_4) {
                    return var14_4;
                }
                ** GOTO lbl55
            }
            case 2: {
                $i$f$withLock = false;
                $i$a$-withLock$default-DiskSynchronizedEmbeddingsStorage$loadIndex$2 = false;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$1;
                this = (DiskSynchronizedEmbeddingsStorage)$continuation.L$0;
                ** try [egrp 1[TRYBLOCK] [1 : 248->365)] { 
lbl52:
                // 1 sources

                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl55:
                // 2 sources

                this.isIndexLoaded = true;
                $this$debug_u24default$iv = DiskSynchronizedEmbeddingsStorage.logger;
                e$iv = null;
                $i$f$debug = false;
                if ($this$debug_u24default$iv.isDebugEnabled() == false) return Unit.INSTANCE;
                var9_19 = $this$debug_u24default$iv;
                $i$a$-debug$default-DiskSynchronizedEmbeddingsStorage$loadIndex$2$1 = false;
                var9_19.debug("Loaded index: " + this.getReportableIndex$intellij_platform_ml_embeddings().name(), e$iv);
                return Unit.INSTANCE;
            }
        }
        $this$debug_u24default$iv = DiskSynchronizedEmbeddingsStorage.logger;
        e$iv = null;
        $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled() == false) return Unit.INSTANCE;
        var9_20 = $this$debug_u24default$iv;
        $i$a$-debug$default-DiskSynchronizedEmbeddingsStorage$loadIndex$2$2 = false;
        var9_20.debug("Canceled index loading, already loaded: " + this.getReportableIndex$intellij_platform_ml_embeddings().name(), e$iv);
        return Unit.INSTANCE;
lbl75:
        // 1 sources

        finally {
            $this$withLock_u24default$iv.unlock(owner$iv);
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Nullable
    public final Object saveIndex(@NotNull Continuation<? super Unit> var1_1) {
        if (!(var1_1 instanceof saveIndex.1)) ** GOTO lbl-1000
        var8_2 = var1_1;
        if ((var8_2.label & -2147483648) != 0) {
            var8_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ DiskSynchronizedEmbeddingsStorage<T> this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.saveIndex((Continuation<Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var9_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $this$withLock_u24default$iv = this.indexLoadingMutex;
                owner$iv = null;
                $i$f$withLock = false;
                $continuation.L$0 = this;
                $continuation.L$1 = $this$withLock_u24default$iv;
                $continuation.label = 1;
                v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)$continuation);
                if (v0 == var9_4) {
                    return var9_4;
                }
                ** GOTO lbl31
            }
            case 1: {
                $i$f$withLock = false;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$1;
                this = (DiskSynchronizedEmbeddingsStorage)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl31:
                // 3 sources

                $i$a$-withLock$default-DiskSynchronizedEmbeddingsStorage$saveIndex$2 = false;
                $continuation.L$0 = $this$withLock_u24default$iv;
                $continuation.L$1 = null;
                $continuation.label = 2;
                v1 = this.getIndex().saveToDisk((Continuation<? super Unit>)$continuation);
                ** if (v1 != var9_4) goto lbl39
lbl38:
                // 1 sources

                return var9_4;
lbl39:
                // 1 sources

                ** GOTO lbl49
            }
            case 2: {
                $i$f$withLock = false;
                $i$a$-withLock$default-DiskSynchronizedEmbeddingsStorage$saveIndex$2 = false;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl49:
                    // 2 sources

                    var6_13 = Unit.INSTANCE;
                }
                catch (Throwable var5_12) {
                    throw var5_12;
                }
                finally {
                    $this$withLock_u24default$iv.unlock(owner$iv);
                }
                return var6_13;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final Object offloadIndex(Continuation<? super Unit> var1_1) {
        block16: {
            if (!(var1_1 instanceof offloadIndex.1)) ** GOTO lbl-1000
            var13_2 = var1_1;
            if ((var13_2.label & -2147483648) != 0) {
                var13_2.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, var1_1){
                    Object L$0;
                    Object L$1;
                    /* synthetic */ Object result;
                    final /* synthetic */ DiskSynchronizedEmbeddingsStorage<T> this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return DiskSynchronizedEmbeddingsStorage.access$offloadIndex(this.this$0, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var14_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    $this$withLock_u24default$iv = this.indexLoadingMutex;
                    owner$iv = null;
                    $i$f$withLock = false;
                    $continuation.L$0 = this;
                    $continuation.L$1 = $this$withLock_u24default$iv;
                    $continuation.label = 1;
                    v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)$continuation);
                    if (v0 == var14_4) {
                        return var14_4;
                    }
                    ** GOTO lbl31
                }
                case 1: {
                    $i$f$withLock = false;
                    owner$iv = null;
                    $this$withLock_u24default$iv = (Mutex)$continuation.L$1;
                    this = (DiskSynchronizedEmbeddingsStorage)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl31:
                    // 3 sources

                    $i$a$-withLock$default-DiskSynchronizedEmbeddingsStorage$offloadIndex$2 = false;
                    if (!this.isIndexLoaded) break block16;
                    $continuation.L$0 = this;
                    $continuation.L$1 = $this$withLock_u24default$iv;
                    $continuation.label = 2;
                    v1 = this.getIndex().saveToDisk((Continuation<? super Unit>)$continuation);
                    v2 = v1;
                    if (v1 == var14_4) {
                        return var14_4;
                    }
                    ** GOTO lbl54
                }
                case 2: {
                    $i$f$withLock = false;
                    $i$a$-withLock$default-DiskSynchronizedEmbeddingsStorage$offloadIndex$2 = false;
                    owner$iv = null;
                    $this$withLock_u24default$iv = (Mutex)$continuation.L$1;
                    this = (DiskSynchronizedEmbeddingsStorage)$continuation.L$0;
                    {
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl54:
                        // 2 sources

                        $continuation.L$0 = this;
                        $continuation.L$1 = $this$withLock_u24default$iv;
                        $continuation.label = 3;
                        v3 = this.getIndex().offload((Continuation<? super Unit>)$continuation);
                        ** if (v3 != var14_4) goto lbl60
                    }
lbl59:
                    // 1 sources

                    return var14_4;
lbl60:
                    // 1 sources

                    ** GOTO lbl71
                }
                case 3: {
                    $i$f$withLock = false;
                    $i$a$-withLock$default-DiskSynchronizedEmbeddingsStorage$offloadIndex$2 = false;
                    owner$iv = null;
                    $this$withLock_u24default$iv = (Mutex)$continuation.L$1;
                    this = (DiskSynchronizedEmbeddingsStorage)$continuation.L$0;
                    ** try [egrp 2[TRYBLOCK] [2 : 323->488)] { 
lbl68:
                    // 1 sources

                    ResultKt.throwOnFailure((Object)$result);
                    v3 = $result;
lbl71:
                    // 2 sources

                    v4 = this.getIndexPersistedEventsCounter(this.project);
                    if (v4 == null) break;
                    it = v4;
                    $i$a$-let-DiskSynchronizedEmbeddingsStorage$offloadIndex$2$1 = false;
                    BuildersKt.launch$default((CoroutineScope)this.cs, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(it, this, null){
                        int label;
                        final /* synthetic */ IndexPersistedEventsCounter $it;
                        final /* synthetic */ DiskSynchronizedEmbeddingsStorage<T> this$0;
                        {
                            this.$it = $it;
                            this.this$0 = $receiver;
                            super(2, $completion);
                        }

                        /*
                         * WARNING - void declaration
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        @Nullable
                        public final Object invokeSuspend(@NotNull Object object) {
                            Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)object);
                                    this.label = 1;
                                    Object object3 = this.$it.sendPersistedCount(this.this$0.getReportableIndex$intellij_platform_ml_embeddings(), this.this$0.getProject(), (Continuation<? super Unit>)((Continuation)this));
                                    if (object3 != object2) return Unit.INSTANCE;
                                    return object2;
                                }
                                case 1: {
                                    void $result;
                                    ResultKt.throwOnFailure((Object)$result);
                                    Object object3 = $result;
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        @Nullable
                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (int)3, null);
                    break;
                }
            }
            this.isIndexLoaded = false;
            $this$debug_u24default$iv = DiskSynchronizedEmbeddingsStorage.logger;
            e$iv = null;
            $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled() == false) return Unit.INSTANCE;
            var10_23 = $this$debug_u24default$iv;
            $i$a$-debug$default-DiskSynchronizedEmbeddingsStorage$offloadIndex$2$2 = false;
            var10_23.debug("Offloaded index: " + this.getReportableIndex$intellij_platform_ml_embeddings().name(), e$iv);
            return Unit.INSTANCE;
        }
        $this$debug_u24default$iv = DiskSynchronizedEmbeddingsStorage.logger;
        e$iv = null;
        $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled() == false) return Unit.INSTANCE;
        var10_24 = $this$debug_u24default$iv;
        $i$a$-debug$default-DiskSynchronizedEmbeddingsStorage$offloadIndex$2$3 = false;
        var10_24.debug("Canceled index offloading, not loaded yet: " + this.getReportableIndex$intellij_platform_ml_embeddings().name(), e$iv);
        return Unit.INSTANCE;
lbl99:
        // 1 sources

        finally {
            $this$withLock_u24default$iv.unlock(owner$iv);
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final IndexPersistedEventsCounter getIndexPersistedEventsCounter(Project project) {
        return (IndexPersistedEventsCounter)CollectionsKt.firstOrNull((List)IndexPersistedEventsCounter.Companion.getEP_NAME().getExtensions((AreaInstance)project));
    }

    @Nullable
    public final Object startIndexingSession(@NotNull Continuation<? super Unit> $completion) {
        this.usageSessionCount.incrementAndGet();
        Object object = this.loadIndex($completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public final void finishIndexingSession() {
        this.scheduleOffload();
        this.usageSessionCount.decrementAndGet();
    }

    private final void scheduleOffload() {
        if (!this.offloadRequest.tryEmit((Object)Unit.INSTANCE)) {
            String string2 = "Check failed.";
            throw new IllegalStateException(string2.toString());
        }
    }

    @Override
    @RequiresBackgroundThread
    @Nullable
    public Object searchNeighbours(@NotNull String text2, int topK2, @Nullable Double similarityThreshold, @NotNull Continuation<? super List<ScoredText>> $completion) {
        return DiskSynchronizedEmbeddingsStorage.searchNeighbours$suspendImpl(this, text2, topK2, similarityThreshold, $completion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @RequiresBackgroundThread
    static /* synthetic */ <T extends IndexableEntity> Object searchNeighbours$suspendImpl(DiskSynchronizedEmbeddingsStorage<T> var0, String var1_1, int var2_2, Double var3_3, Continuation<? super List<ScoredText>> var4_4) {
        if (!(var4_4 instanceof searchNeighbours.1)) ** GOTO lbl-1000
        var12_5 = var4_4;
        if ((var12_5.label & -2147483648) != 0) {
            var12_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(var0, var4_4){
                Object L$0;
                Object L$1;
                Object L$2;
                int I$0;
                long J$0;
                /* synthetic */ Object result;
                final /* synthetic */ DiskSynchronizedEmbeddingsStorage<T> this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return DiskSynchronizedEmbeddingsStorage.searchNeighbours$suspendImpl(this.this$0, null, 0, null, (Continuation<? super List<ScoredText>>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var13_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                FileBasedEmbeddingStoragesManager.Companion.getInstance($this.project).triggerIndexing();
                searchStartTime = System.nanoTime();
                loadJob = BuildersKt.launch$default((CoroutineScope)$this.cs, (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>($this, null){
                    int label;
                    final /* synthetic */ DiskSynchronizedEmbeddingsStorage<T> this$0;
                    {
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                this.label = 1;
                                Object object3 = this.this$0.loadIndex((Continuation<Unit>)((Continuation)this));
                                if (object3 != object2) return Unit.INSTANCE;
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)2, null);
                $continuation.L$0 = $this;
                $continuation.L$1 = similarityThreshold;
                $continuation.L$2 = loadJob;
                $continuation.I$0 = topK;
                $continuation.J$0 = searchStartTime;
                $continuation.label = 1;
                v0 = IndexingUtilsKt.generateEmbedding$default((String)text, false, $continuation, 2, null);
                if (v0 == var13_7) {
                    return var13_7;
                }
                ** GOTO lbl34
            }
            case 1: {
                searchStartTime = $continuation.J$0;
                topK = $continuation.I$0;
                loadJob = (Job)$continuation.L$2;
                similarityThreshold = (Double)$continuation.L$1;
                $this = (DiskSynchronizedEmbeddingsStorage)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl34:
                // 2 sources

                v1 = (FloatTextEmbedding)v0;
                if (v1 == null) {
                    return CollectionsKt.emptyList();
                }
                embedding = v1;
                LocalEmbeddingServiceProvider.Companion.getInstance().scheduleCleanup();
                $this.usageSessionCount.incrementAndGet();
                $continuation.L$0 = $this;
                $continuation.L$1 = similarityThreshold;
                $continuation.L$2 = embedding;
                $continuation.I$0 = topK;
                $continuation.J$0 = searchStartTime;
                $continuation.label = 2;
                v2 = loadJob.join($continuation);
                ** if (v2 != var13_7) goto lbl52
lbl51:
                // 1 sources

                return var13_7;
lbl52:
                // 1 sources

                ** GOTO lbl63
            }
            case 2: {
                searchStartTime = $continuation.J$0;
                topK = $continuation.I$0;
                embedding = (FloatTextEmbedding)$continuation.L$2;
                similarityThreshold = (Double)$continuation.L$1;
                $this = (DiskSynchronizedEmbeddingsStorage)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl63:
                // 2 sources

                $continuation.L$0 = $this;
                $continuation.L$1 = null;
                $continuation.L$2 = null;
                $continuation.J$0 = searchStartTime;
                $continuation.label = 3;
                v3 = $this.getIndex().findClosest(embedding, topK, similarityThreshold, (Continuation<? super List<ScoredText>>)$continuation);
                ** if (v3 != var13_7) goto lbl71
lbl70:
                // 1 sources

                return var13_7;
lbl71:
                // 1 sources

                ** GOTO lbl79
            }
            case 3: {
                searchStartTime = $continuation.J$0;
                $this = (DiskSynchronizedEmbeddingsStorage)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v3 = $result;
lbl79:
                    // 2 sources

                    neighbours = (List)v3;
                    $this.scheduleOffload();
                }
                catch (Throwable var10_12) {
                    throw var10_12;
                }
                finally {
                    $this.usageSessionCount.decrementAndGet();
                }
                $continuation.L$0 = neighbours;
                $continuation.label = 4;
                v4 = EmbeddingSearchLogger.INSTANCE.searchFinished($this.project, $this.getReportableIndex$intellij_platform_ml_embeddings(), TimeoutUtil.getDurationMillis((long)searchStartTime), (Continuation<? super Unit>)$continuation);
                if (v4 == var13_7) {
                    return var13_7;
                }
                ** GOTO lbl98
            }
            case 4: {
                neighbours = (List)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v4 = $result;
lbl98:
                // 2 sources

                return neighbours;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @RequiresBackgroundThread
    @Nullable
    public final Object streamSearchNeighbours(@NotNull String var1_1, @Nullable Double var2_2, @NotNull Continuation<? super Flow<ScoredText>> var3_3) {
        if (!(var3_3 instanceof streamSearchNeighbours.1)) ** GOTO lbl-1000
        var7_4 = var3_3;
        if ((var7_4.label & -2147483648) != 0) {
            var7_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ DiskSynchronizedEmbeddingsStorage<T> this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.streamSearchNeighbours(null, null, (Continuation<Flow<ScoredText>>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var8_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                FileBasedEmbeddingStoragesManager.Companion.getInstance(this.project).triggerIndexing();
                loadJob = BuildersKt.launch$default((CoroutineScope)this.cs, (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                    int label;
                    final /* synthetic */ DiskSynchronizedEmbeddingsStorage<T> this$0;
                    {
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                this.label = 1;
                                Object object3 = this.this$0.loadIndex((Continuation<Unit>)((Continuation)this));
                                if (object3 != object2) return Unit.INSTANCE;
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)2, null);
                $continuation.L$0 = this;
                $continuation.L$1 = similarityThreshold;
                $continuation.L$2 = loadJob;
                $continuation.label = 1;
                v0 = IndexingUtilsKt.generateEmbedding$default((String)text, false, (Continuation)$continuation, 2, null);
                if (v0 == var8_6) {
                    return var8_6;
                }
                ** GOTO lbl28
            }
            case 1: {
                loadJob = (Job)$continuation.L$2;
                similarityThreshold = (Double)$continuation.L$1;
                this = (DiskSynchronizedEmbeddingsStorage)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl28:
                // 2 sources

                v1 = (FloatTextEmbedding)v0;
                if (v1 == null) {
                    return FlowKt.emptyFlow();
                }
                embedding = v1;
                LocalEmbeddingServiceProvider.Companion.getInstance().scheduleCleanup();
                return FlowKt.flow((Function2)((Function2)new Function2<FlowCollector<? super ScoredText>, Continuation<? super Unit>, Object>(this, loadJob, embedding, similarityThreshold, null){
                    int label;
                    private /* synthetic */ Object L$0;
                    final /* synthetic */ DiskSynchronizedEmbeddingsStorage<T> this$0;
                    final /* synthetic */ Job $loadJob;
                    final /* synthetic */ FloatTextEmbedding $embedding;
                    final /* synthetic */ Double $similarityThreshold;
                    {
                        this.this$0 = $receiver;
                        this.$loadJob = $loadJob;
                        this.$embedding = $embedding;
                        this.$similarityThreshold = $similarityThreshold;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Unable to fully structure code
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object var1_1) {
                        var5_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)var1_1);
                                $this$flow = (FlowCollector)this.L$0;
                                DiskSynchronizedEmbeddingsStorage.access$getUsageSessionCount$p(this.this$0).incrementAndGet();
                                this.L$0 = $this$flow;
                                this.label = 1;
                                v0 = this.$loadJob.join((Continuation)this);
                                ** if (v0 != var5_2) goto lbl15
lbl14:
                                // 1 sources

                                return var5_2;
lbl15:
                                // 1 sources

                                ** GOTO lbl22
                            }
                            case 1: {
                                $this$flow = (FlowCollector)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl22:
                                // 2 sources

                                var4_4 = $this$flow;
                                this.L$0 = var4_4;
                                this.label = 2;
                                v1 = this.this$0.getIndex().streamFindClose(this.$embedding, this.$similarityThreshold, (Continuation<? super Flow<ScoredText>>)((Continuation)this));
                                ** if (v1 != var5_2) goto lbl28
lbl27:
                                // 1 sources

                                return var5_2;
lbl28:
                                // 1 sources

                                ** GOTO lbl35
                            }
                            case 2: {
                                var4_4 = (FlowCollector)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v1 = $result;
lbl35:
                                // 2 sources

                                this.L$0 = null;
                                this.label = 3;
                                v2 = FlowKt.emitAll((FlowCollector)var4_4, (Flow)((Flow)v1), (Continuation)((Continuation)this));
                                ** if (v2 != var5_2) goto lbl40
lbl39:
                                // 1 sources

                                return var5_2;
lbl40:
                                // 1 sources

                                ** GOTO lbl46
                            }
                            case 3: {
                                try {
                                    ResultKt.throwOnFailure((Object)$result);
                                    v2 = $result;
lbl46:
                                    // 2 sources

                                    DiskSynchronizedEmbeddingsStorage.access$scheduleOffload(this.this$0);
                                }
                                catch (Throwable var3_5) {
                                    throw var3_5;
                                }
                                finally {
                                    DiskSynchronizedEmbeddingsStorage.access$getUsageSessionCount$p(this.this$0).decrementAndGet();
                                }
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        var var3_3 = new /* invalid duplicate definition of identical inner class */;
                        var3_3.L$0 = value;
                        return (Continuation)var3_3;
                    }

                    @Nullable
                    public final Object invoke(@NotNull FlowCollector<? super ScoredText> p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }));
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static /* synthetic */ Object streamSearchNeighbours$default(DiskSynchronizedEmbeddingsStorage diskSynchronizedEmbeddingsStorage, String string2, Double d, Continuation continuation, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: streamSearchNeighbours");
        }
        if ((n & 2) != 0) {
            d = null;
        }
        return diskSynchronizedEmbeddingsStorage.streamSearchNeighbours(string2, d, (Continuation<Flow<ScoredText>>)continuation);
    }

    public final void registerInMemoryManager() {
        EmbeddingIndexMemoryManager.Companion.getInstance().registerIndex(this.getIndex());
    }

    static {
        Logger logger = Logger.getInstance(DiskSynchronizedEmbeddingsStorage.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        DiskSynchronizedEmbeddingsStorage.logger = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u0005R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\t"}, d2={"Lcom/intellij/platform/ml/embeddings/search/services/DiskSynchronizedEmbeddingsStorage$Companion;", "", "()V", "OFFLOAD_TIMEOUT", "Lkotlin/time/Duration;", "J", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.platform.ml.embeddings"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

