/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.java.frontend.codeInsight.editorActions;

import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.rd.ide.model.ActionCallStrategyKind;
import com.jetbrains.rdclient.editorActions.cwm.FrontendEditorActionHandlerStrategyCustomizer;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/java/frontend/codeInsight/editorActions/JavaActionHandlerStrategyCustomizer;", "Lcom/jetbrains/rdclient/editorActions/cwm/FrontendEditorActionHandlerStrategyCustomizer;", "()V", "actions", "", "", "Lcom/jetbrains/rd/ide/model/ActionCallStrategyKind;", "getCustomStrategy", "actionId", "editor", "Lcom/intellij/openapi/editor/Editor;", "caret", "Lcom/intellij/openapi/editor/Caret;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "intellij.java.frontend"})
public final class JavaActionHandlerStrategyCustomizer
implements FrontendEditorActionHandlerStrategyCustomizer {
    @NotNull
    private final Map<String, ActionCallStrategyKind> actions;

    public JavaActionHandlerStrategyCustomizer() {
        Pair[] pairArray = new Pair[]{new Pair((Object)"EditorSelectWord", (Object)ActionCallStrategyKind.FrontendFirst), new Pair((Object)"EditorUnSelectWord", (Object)ActionCallStrategyKind.FrontendFirst), new Pair((Object)"EditorCompleteStatement", (Object)ActionCallStrategyKind.FrontendFirst), new Pair((Object)"EditorMatchBrace", (Object)ActionCallStrategyKind.FrontendFirst)};
        this.actions = MapsKt.mapOf((Pair[])pairArray);
    }

    @Nullable
    public ActionCallStrategyKind getCustomStrategy(@NotNull String actionId, @NotNull Editor editor, @Nullable Caret caret, @NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)actionId, (String)"actionId");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        if (!Registry.is((String)"java.frontend.speculative.actions.enabled")) {
            return null;
        }
        ActionCallStrategyKind actionCallStrategyKind = this.actions.get(actionId);
        if (actionCallStrategyKind == null) {
            return null;
        }
        ActionCallStrategyKind strategyKind = actionCallStrategyKind;
        VirtualFile virtualFile = editor.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile virtualFile2 = virtualFile;
        if (Intrinsics.areEqual((Object)FileTypeManager.getInstance().getFileTypeByFileName(virtualFile2.getNameSequence()), (Object)JavaFileType.INSTANCE)) {
            return strategyKind;
        }
        return null;
    }
}

