/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.config;

import com.intellij.compiler.server.BuildManager;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ExternalSystemSourceType;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemExecutionAware;
import com.intellij.openapi.externalSystem.service.execution.TargetEnvironmentConfigurationProvider;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectType;
import com.intellij.openapi.project.ProjectTypeService;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.PathMapper;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.xmlb.XmlSerializer;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.gradle.model.impl.GradleModuleResourceConfiguration;
import org.jetbrains.jps.gradle.model.impl.GradleProjectConfiguration;
import org.jetbrains.jps.gradle.model.impl.ModuleVersion;
import org.jetbrains.jps.gradle.model.impl.ResourceRootConfiguration;
import org.jetbrains.jps.gradle.model.impl.ResourceRootFilter;
import org.jetbrains.plugins.gradle.model.ExternalFilter;
import org.jetbrains.plugins.gradle.model.ExternalProject;
import org.jetbrains.plugins.gradle.model.ExternalSourceDirectorySet;
import org.jetbrains.plugins.gradle.model.ExternalSourceSet;
import org.jetbrains.plugins.gradle.service.project.data.ExternalProjectDataCache;
import org.jetbrains.plugins.gradle.util.GradleBundle;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class GradleResourceCompilerConfigurationGenerator {
    private static final Logger LOG = Logger.getInstance(GradleResourceCompilerConfigurationGenerator.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final Map<String, Integer> myModulesConfigurationHash;
    private final ExternalProjectDataCache externalProjectDataCache;

    public GradleResourceCompilerConfigurationGenerator(@NotNull Project project) {
        if (project == null) {
            GradleResourceCompilerConfigurationGenerator.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myModulesConfigurationHash = new ConcurrentHashMap<String, Integer>();
        this.externalProjectDataCache = ExternalProjectDataCache.getInstance((Project)project);
        assert (this.externalProjectDataCache != null);
        project.getMessageBus().connect().subscribe(ModuleListener.TOPIC, (Object)new ModuleListener(){

            public void moduleRemoved(@NotNull Project project, @NotNull Module module) {
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (module == null) {
                    1.$$$reportNull$$$0(1);
                }
                GradleResourceCompilerConfigurationGenerator.this.myModulesConfigurationHash.remove(module.getName());
            }

            public void modulesRenamed(@NotNull Project project, @NotNull List<? extends Module> modules, @NotNull Function<? super Module, String> oldNameProvider) {
                if (project == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (modules == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (oldNameProvider == null) {
                    1.$$$reportNull$$$0(4);
                }
                for (Module module : modules) {
                    this.moduleRemoved(project, module);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "module";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "modules";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "oldNameProvider";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/plugins/gradle/config/GradleResourceCompilerConfigurationGenerator$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "moduleRemoved";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "modulesRenamed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public void generateBuildConfiguration(@NotNull CompileContext context) {
        if (context == null) {
            GradleResourceCompilerConfigurationGenerator.$$$reportNull$$$0(1);
        }
        if (GradleResourceCompilerConfigurationGenerator.shouldBeBuiltByExternalSystem(this.myProject)) {
            return;
        }
        if (!GradleResourceCompilerConfigurationGenerator.hasGradleModules(context)) {
            return;
        }
        BuildManager buildManager = BuildManager.getInstance();
        File projectSystemDir = buildManager.getProjectSystemDirectory(this.myProject);
        File gradleConfigFile = new File(projectSystemDir, "gradle/configuration.xml");
        Map<String, GradleModuleResourceConfiguration> affectedGradleModuleConfigurations = this.generateAffectedGradleModulesConfiguration(context);
        if (affectedGradleModuleConfigurations.isEmpty()) {
            return;
        }
        boolean configurationUpdateRequired = context.isRebuild() || !gradleConfigFile.exists();
        HashMap<String, Integer> affectedConfigurationHash = new HashMap<String, Integer>();
        for (Map.Entry<String, GradleModuleResourceConfiguration> entry : affectedGradleModuleConfigurations.entrySet()) {
            Integer moduleLastConfigurationHash = this.myModulesConfigurationHash.get(entry.getKey());
            int moduleCurrentConfigurationHash = entry.getValue().computeConfigurationHash();
            if (moduleLastConfigurationHash == null || moduleLastConfigurationHash != moduleCurrentConfigurationHash) {
                configurationUpdateRequired = true;
            }
            affectedConfigurationHash.put(entry.getKey(), moduleCurrentConfigurationHash);
        }
        GradleProjectConfiguration projectConfig = this.loadLastConfiguration(gradleConfigFile);
        projectConfig.moduleConfigurations.putAll(affectedGradleModuleConfigurations);
        Element element = new Element("gradle-project-configuration");
        XmlSerializer.serializeInto((Object)projectConfig, (Element)element);
        boolean finalConfigurationUpdateRequired = configurationUpdateRequired;
        buildManager.runCommand(() -> {
            if (finalConfigurationUpdateRequired) {
                buildManager.clearState(this.myProject);
            }
            FileUtil.createIfDoesntExist((File)gradleConfigFile);
            try {
                JDOMUtil.write((Element)element, (Path)gradleConfigFile.toPath());
                this.myModulesConfigurationHash.putAll(affectedConfigurationHash);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @NotNull
    private GradleProjectConfiguration loadLastConfiguration(@NotNull File gradleConfigFile) {
        if (gradleConfigFile == null) {
            GradleResourceCompilerConfigurationGenerator.$$$reportNull$$$0(2);
        }
        GradleProjectConfiguration projectConfig = new GradleProjectConfiguration();
        if (gradleConfigFile.exists()) {
            try {
                XmlSerializer.deserializeInto((Object)projectConfig, (Element)JDOMUtil.load((File)gradleConfigFile));
                Set<String> actualModules = this.myModulesConfigurationHash.keySet();
                Iterator iterator = projectConfig.moduleConfigurations.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry configurationEntry = iterator.next();
                    if (actualModules.contains(configurationEntry.getKey())) continue;
                    iterator.remove();
                }
            }
            catch (Exception e) {
                LOG.info((Throwable)e);
            }
        }
        GradleProjectConfiguration gradleProjectConfiguration = projectConfig;
        if (gradleProjectConfiguration == null) {
            GradleResourceCompilerConfigurationGenerator.$$$reportNull$$$0(3);
        }
        return gradleProjectConfiguration;
    }

    @NotNull
    private Map<String, GradleModuleResourceConfiguration> generateAffectedGradleModulesConfiguration(@NotNull CompileContext context) {
        if (context == null) {
            GradleResourceCompilerConfigurationGenerator.$$$reportNull$$$0(4);
        }
        HashMap<String, GradleModuleResourceConfiguration> affectedGradleModuleConfigurations = new HashMap<String, GradleModuleResourceConfiguration>();
        Map lazyExternalProjectMap = FactoryMap.create(gradleProjectPath1 -> this.externalProjectDataCache.getRootExternalProject(gradleProjectPath1));
        for (Module module : context.getCompileScope().getAffectedModules()) {
            if (!ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)GradleConstants.SYSTEM_ID, (Module)module)) continue;
            String gradleProjectPath = ExternalSystemApiUtil.getExternalRootProjectPath((Module)module);
            assert (gradleProjectPath != null);
            if (GradleResourceCompilerConfigurationGenerator.shouldBeBuiltByExternalSystem(module)) continue;
            ExternalProject externalRootProject = (ExternalProject)lazyExternalProjectMap.get(gradleProjectPath);
            if (externalRootProject == null) {
                String message = GradleBundle.message((String)"compiler.build.messages.gradle.configuration.not.found", (Object[])new Object[]{module.getName()});
                context.addMessage(CompilerMessageCategory.WARNING, message, null, -1, -1, null, Collections.singleton(module.getName()));
                continue;
            }
            Map externalSourceSets = this.externalProjectDataCache.findExternalProject(externalRootProject, module);
            if (externalSourceSets.isEmpty()) {
                LOG.debug("Unable to find source sets config for module: " + module.getName());
                continue;
            }
            VirtualFile[] sourceRoots = ModuleRootManager.getInstance((Module)module).getSourceRoots(true);
            if (sourceRoots.length == 0) continue;
            GradleModuleResourceConfiguration resourceConfig = new GradleModuleResourceConfiguration();
            resourceConfig.id = new ModuleVersion(ExternalSystemApiUtil.getExternalProjectGroup((Module)module), ExternalSystemApiUtil.getExternalProjectId((Module)module), ExternalSystemApiUtil.getExternalProjectVersion((Module)module));
            PathMapper pathMapper = null;
            for (ExternalSystemExecutionAware executionAware : ExternalSystemExecutionAware.getExtensions((ProjectSystemId)GradleConstants.SYSTEM_ID)) {
                TargetEnvironmentConfigurationProvider provider = executionAware.getEnvironmentConfigurationProvider(gradleProjectPath, false, context.getProject());
                if (provider == null) continue;
                pathMapper = provider.getPathMapper();
                break;
            }
            for (ExternalSourceSet sourceSet : externalSourceSets.values()) {
                GradleResourceCompilerConfigurationGenerator.addResources(resourceConfig.resources, (ExternalSourceDirectorySet)sourceSet.getSources().get(ExternalSystemSourceType.RESOURCE), (ExternalSourceDirectorySet)sourceSet.getSources().get(ExternalSystemSourceType.SOURCE), pathMapper);
                GradleResourceCompilerConfigurationGenerator.addResources(resourceConfig.testResources, (ExternalSourceDirectorySet)sourceSet.getSources().get(ExternalSystemSourceType.TEST_RESOURCE), (ExternalSourceDirectorySet)sourceSet.getSources().get(ExternalSystemSourceType.TEST), pathMapper);
            }
            boolean useCompilerOutputForResources = PlatformUtils.isFleetBackend();
            CompilerModuleExtension compilerModuleExtension = CompilerModuleExtension.getInstance((Module)module);
            if (compilerModuleExtension != null && (useCompilerOutputForResources || compilerModuleExtension.isCompilerOutputPathInherited())) {
                String outputPath = VfsUtilCore.urlToPath((String)compilerModuleExtension.getCompilerOutputUrl());
                for (ResourceRootConfiguration resource : resourceConfig.resources) {
                    resource.targetPath = GradleResourceCompilerConfigurationGenerator.toRemote(pathMapper, outputPath);
                }
                String testOutputPath = VfsUtilCore.urlToPath((String)compilerModuleExtension.getCompilerOutputUrlForTests());
                for (ResourceRootConfiguration resource : resourceConfig.testResources) {
                    resource.targetPath = GradleResourceCompilerConfigurationGenerator.toRemote(pathMapper, testOutputPath);
                }
            }
            affectedGradleModuleConfigurations.put(module.getName(), resourceConfig);
        }
        HashMap<String, GradleModuleResourceConfiguration> hashMap = affectedGradleModuleConfigurations;
        if (hashMap == null) {
            GradleResourceCompilerConfigurationGenerator.$$$reportNull$$$0(5);
        }
        return hashMap;
    }

    private static String toRemote(PathMapper pathMapper, String outputPath) {
        return pathMapper != null ? pathMapper.convertToRemote(outputPath) : outputPath;
    }

    private static boolean shouldBeBuiltByExternalSystem(@NotNull Project project) {
        ProjectType projectType;
        if (project == null) {
            GradleResourceCompilerConfigurationGenerator.$$$reportNull$$$0(6);
        }
        return (projectType = ProjectTypeService.getProjectType((Project)project)) != null && "Android".equals(projectType.getId());
    }

    private static boolean shouldBeBuiltByExternalSystem(@NotNull Module module) {
        if (module == null) {
            GradleResourceCompilerConfigurationGenerator.$$$reportNull$$$0(7);
        }
        for (Facet facet : FacetManager.getInstance((Module)module).getAllFacets()) {
            if (!ArrayUtil.contains((String)facet.getName(), (String[])new String[]{"Android", "Android-Gradle", "Java-Gradle"})) continue;
            return true;
        }
        return false;
    }

    private static boolean hasGradleModules(@NotNull CompileContext context) {
        if (context == null) {
            GradleResourceCompilerConfigurationGenerator.$$$reportNull$$$0(8);
        }
        for (Module module : context.getCompileScope().getAffectedModules()) {
            if (!ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)GradleConstants.SYSTEM_ID, (Module)module)) continue;
            return true;
        }
        return false;
    }

    private static void addResources(@NotNull List<ResourceRootConfiguration> container, @Nullable ExternalSourceDirectorySet directorySet, @Nullable ExternalSourceDirectorySet sourcesDirectorySet, @Nullable PathMapper pathMapper) {
        if (container == null) {
            GradleResourceCompilerConfigurationGenerator.$$$reportNull$$$0(9);
        }
        if (directorySet == null) {
            return;
        }
        for (File file : directorySet.getSrcDirs()) {
            String dir = file.getPath();
            ResourceRootConfiguration rootConfiguration = new ResourceRootConfiguration();
            rootConfiguration.directory = GradleResourceCompilerConfigurationGenerator.toRemote(pathMapper, FileUtil.toSystemIndependentName((String)dir));
            String target = directorySet.getOutputDir().getPath();
            rootConfiguration.targetPath = GradleResourceCompilerConfigurationGenerator.toRemote(pathMapper, FileUtil.toSystemIndependentName((String)target));
            rootConfiguration.includes.clear();
            for (String include : directorySet.getPatterns().getIncludes()) {
                rootConfiguration.includes.add(include.trim());
            }
            rootConfiguration.excludes.clear();
            for (String exclude : directorySet.getPatterns().getExcludes()) {
                rootConfiguration.excludes.add(exclude.trim());
            }
            if (sourcesDirectorySet != null && sourcesDirectorySet.getSrcDirs().contains(file)) {
                rootConfiguration.excludes.add("**/*.java");
                rootConfiguration.excludes.add("**/*.scala");
                rootConfiguration.excludes.add("**/*.groovy");
                rootConfiguration.excludes.add("**/*.kt");
            }
            rootConfiguration.isFiltered = !directorySet.getFilters().isEmpty();
            rootConfiguration.filters.clear();
            for (ExternalFilter filter : directorySet.getFilters()) {
                ResourceRootFilter resourceRootFilter = new ResourceRootFilter();
                resourceRootFilter.filterType = filter.getFilterType();
                resourceRootFilter.properties = filter.getPropertiesAsJsonMap();
                rootConfiguration.filters.add(resourceRootFilter);
            }
            container.add(rootConfiguration);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleConfigFile";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/config/GradleResourceCompilerConfigurationGenerator";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/config/GradleResourceCompilerConfigurationGenerator";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "loadLastConfiguration";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "generateAffectedGradleModulesConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "generateBuildConfiguration";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "loadLastConfiguration";
                break;
            }
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "generateAffectedGradleModulesConfiguration";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "shouldBeBuiltByExternalSystem";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "hasGradleModules";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addResources";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5 -> new IllegalStateException(string);
        };
    }
}

