/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.block.session;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.jediterm.terminal.CursorShape;
import com.jediterm.terminal.StyledTextConsumer;
import com.jediterm.terminal.Terminal;
import com.jediterm.terminal.emulator.mouse.MouseFormat;
import com.jediterm.terminal.emulator.mouse.MouseMode;
import com.jediterm.terminal.model.TerminalLine;
import com.jediterm.terminal.model.TerminalModelListener;
import com.jediterm.terminal.model.TerminalTextBuffer;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000 k2\u00020\u0001:\u0004klmnB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020E2\n\b\u0002\u0010F\u001a\u0004\u0018\u00010GJ\u001a\u0010H\u001a\u00020C2\u0006\u0010D\u001a\u00020\u00072\n\b\u0002\u0010F\u001a\u0004\u0018\u00010GJ\u001a\u0010I\u001a\u00020C2\u0006\u0010D\u001a\u0002022\n\b\u0002\u0010F\u001a\u0004\u0018\u00010GJ\u0016\u0010J\u001a\u00020K2\u0006\u0010L\u001a\u00020\u00102\u0006\u0010M\u001a\u00020\u0010J\u0015\u0010N\u001a\u00020C2\u0006\u0010O\u001a\u00020PH\u0000\u00a2\u0006\u0002\bQJ\u001a\u0010R\u001a\u00020<2\b\b\u0002\u0010S\u001a\u00020\u00102\b\b\u0002\u0010T\u001a\u00020\u0010J\u000e\u0010U\u001a\u00020V2\u0006\u0010W\u001a\u00020\u0010J(\u0010X\u001a\u00020<2\u0006\u0010Y\u001a\u00020\u00102\u0006\u0010Z\u001a\u00020\u00102\u0006\u0010S\u001a\u00020\u00102\u0006\u0010T\u001a\u00020\u0010H\u0002J\u0006\u0010[\u001a\u00020CJ\u001e\u0010\\\u001a\u00020C2\u0006\u0010]\u001a\u00020\u00102\u0006\u0010^\u001a\u00020\u00102\u0006\u0010_\u001a\u00020`J\u001e\u0010a\u001a\u00020C2\u0006\u0010b\u001a\u00020\u00102\u0006\u0010c\u001a\u00020\u00102\u0006\u0010_\u001a\u00020`J\u0016\u0010d\u001a\u00020C2\u0006\u0010L\u001a\u00020\u00102\u0006\u0010M\u001a\u00020\u0010J\u0006\u0010e\u001a\u00020CJ%\u0010f\u001a\u0002Hg\"\u0004\b\u0000\u0010g2\f\u0010h\u001a\b\u0012\u0004\u0012\u0002Hg0iH\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010jR\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\n\u001a\u0004\u0018\u00010\t2\b\u0010\b\u001a\u0004\u0018\u00010\t@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001e\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001e\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013R\u0011\u0010\u0016\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0013R\u0011\u0010\u0018\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0013R$\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\b\u001a\u00020\u001a@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR$\u0010\u001f\u001a\u00020\u001a2\u0006\u0010\b\u001a\u00020\u001a@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u001c\"\u0004\b \u0010\u001eR$\u0010!\u001a\u00020\u001a2\u0006\u0010\b\u001a\u00020\u001a@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u001c\"\u0004\b\"\u0010\u001eR$\u0010$\u001a\u00020#2\u0006\u0010\b\u001a\u00020#@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R$\u0010*\u001a\u00020)2\u0006\u0010\b\u001a\u00020)@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\u0011\u0010/\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b0\u0010\u0013R\u001a\u00101\u001a\b\u0012\u0004\u0012\u0002020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00104R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u00106R$\u00107\u001a\u00020\u001a2\u0006\u0010\b\u001a\u00020\u001a@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u0010\u001c\"\u0004\b9\u0010\u001eR\u0011\u0010:\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b;\u0010\u0013R$\u0010=\u001a\u00020<2\u0006\u0010\b\u001a\u00020<@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b>\u0010?\"\u0004\b@\u0010A\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006o"}, d2={"Lorg/jetbrains/plugins/terminal/block/session/TerminalModel;", "", "textBuffer", "Lcom/jediterm/terminal/model/TerminalTextBuffer;", "(Lcom/jediterm/terminal/model/TerminalTextBuffer;)V", "cursorListeners", "", "Lorg/jetbrains/plugins/terminal/block/session/TerminalModel$CursorListener;", "value", "Lcom/jediterm/terminal/CursorShape;", "cursorShape", "getCursorShape", "()Lcom/jediterm/terminal/CursorShape;", "setCursorShape", "(Lcom/jediterm/terminal/CursorShape;)V", "<set-?>", "", "cursorX", "getCursorX", "()I", "cursorY", "getCursorY", "height", "getHeight", "historyLinesCount", "getHistoryLinesCount", "", "isBracketedPasteMode", "()Z", "setBracketedPasteMode", "(Z)V", "isCommandRunning", "setCommandRunning", "isCursorVisible", "setCursorVisible", "Lcom/jediterm/terminal/emulator/mouse/MouseFormat;", "mouseFormat", "getMouseFormat", "()Lcom/jediterm/terminal/emulator/mouse/MouseFormat;", "setMouseFormat", "(Lcom/jediterm/terminal/emulator/mouse/MouseFormat;)V", "Lcom/jediterm/terminal/emulator/mouse/MouseMode;", "mouseMode", "getMouseMode", "()Lcom/jediterm/terminal/emulator/mouse/MouseMode;", "setMouseMode", "(Lcom/jediterm/terminal/emulator/mouse/MouseMode;)V", "screenLinesCount", "getScreenLinesCount", "terminalListeners", "Lorg/jetbrains/plugins/terminal/block/session/TerminalModel$TerminalListener;", "getTerminalListeners$intellij_terminal", "()Ljava/util/List;", "getTextBuffer$intellij_terminal", "()Lcom/jediterm/terminal/model/TerminalTextBuffer;", "useAlternateBuffer", "getUseAlternateBuffer", "setUseAlternateBuffer", "width", "getWidth", "", "windowTitle", "getWindowTitle", "()Ljava/lang/String;", "setWindowTitle", "(Ljava/lang/String;)V", "addContentListener", "", "listener", "Lorg/jetbrains/plugins/terminal/block/session/TerminalModel$ContentListener;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "addCursorListener", "addTerminalListener", "charAt", "", "x", "y", "clearAllAndMoveCursorToTopLeftCorner", "terminal", "Lcom/jediterm/terminal/Terminal;", "clearAllAndMoveCursorToTopLeftCorner$intellij_terminal", "getAllText", "updatedCursorX", "updatedCursorY", "getLine", "Lcom/jediterm/terminal/model/TerminalLine;", "index", "getLinesText", "fromLine", "toLine", "lockContent", "processHistoryAndScreenLines", "scrollOrigin", "maxLinesToProcess", "consumer", "Lcom/jediterm/terminal/StyledTextConsumer;", "processScreenLines", "yStart", "count", "setCursor", "unlockContent", "withContentLock", "T", "callable", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "Companion", "ContentListener", "CursorListener", "TerminalListener", "intellij.terminal"})
@SourceDebugExtension(value={"SMAP\nTerminalModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalModel.kt\norg/jetbrains/plugins/terminal/block/session/TerminalModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,235:1\n1855#2,2:236\n1855#2,2:238\n1855#2,2:240\n1855#2,2:242\n1855#2,2:244\n1855#2,2:246\n1855#2,2:248\n1855#2,2:250\n1855#2,2:252\n*S KotlinDebug\n*F\n+ 1 TerminalModel.kt\norg/jetbrains/plugins/terminal/block/session/TerminalModel\n*L\n39#1:236,2\n48#1:238,2\n56#1:240,2\n64#1:242,2\n72#1:244,2\n80#1:246,2\n88#1:248,2\n96#1:250,2\n110#1:252,2\n*E\n"})
public final class TerminalModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TerminalTextBuffer textBuffer;
    private volatile int cursorX;
    private volatile int cursorY;
    private boolean isCommandRunning;
    @Nullable
    private volatile CursorShape cursorShape;
    private boolean isCursorVisible;
    private boolean isBracketedPasteMode;
    @NotNull
    private MouseMode mouseMode;
    @NotNull
    private MouseFormat mouseFormat;
    @NotNull
    private String windowTitle;
    private boolean useAlternateBuffer;
    @NotNull
    private final List<TerminalListener> terminalListeners;
    @NotNull
    private final List<CursorListener> cursorListeners;
    public static final int MIN_WIDTH = 5;
    public static final int MIN_HEIGHT = 2;

    public TerminalModel(@NotNull TerminalTextBuffer textBuffer) {
        Intrinsics.checkNotNullParameter((Object)textBuffer, (String)"textBuffer");
        this.textBuffer = textBuffer;
        this.isCursorVisible = true;
        this.mouseMode = MouseMode.MOUSE_REPORTING_NONE;
        this.mouseFormat = MouseFormat.MOUSE_FORMAT_XTERM;
        this.windowTitle = "Terminal";
        this.useAlternateBuffer = this.textBuffer.isUsingAlternateBuffer();
        this.terminalListeners = new CopyOnWriteArrayList();
        this.cursorListeners = new CopyOnWriteArrayList();
    }

    @NotNull
    public final TerminalTextBuffer getTextBuffer$intellij_terminal() {
        return this.textBuffer;
    }

    public final int getWidth() {
        return this.textBuffer.getWidth();
    }

    public final int getHeight() {
        return this.textBuffer.getHeight();
    }

    public final int getCursorX() {
        return this.cursorX;
    }

    public final int getCursorY() {
        return this.cursorY;
    }

    public final boolean isCommandRunning() {
        return this.isCommandRunning;
    }

    public final void setCommandRunning(boolean value) {
        if (value != this.isCommandRunning) {
            this.isCommandRunning = value;
            Iterable $this$forEach$iv = this.terminalListeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                TerminalListener it = (TerminalListener)element$iv;
                boolean bl = false;
                it.onCommandRunningChanged(value);
            }
        }
    }

    @Nullable
    public final CursorShape getCursorShape() {
        return this.cursorShape;
    }

    public final void setCursorShape(@Nullable CursorShape value) {
        if (value != this.cursorShape) {
            this.cursorShape = value;
            Iterable $this$forEach$iv = this.cursorListeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CursorListener it = (CursorListener)element$iv;
                boolean bl = false;
                it.onShapeChanged(value);
            }
        }
    }

    public final boolean isCursorVisible() {
        return this.isCursorVisible;
    }

    public final void setCursorVisible(boolean value) {
        if (value != this.isCursorVisible) {
            this.isCursorVisible = value;
            Iterable $this$forEach$iv = this.cursorListeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CursorListener it = (CursorListener)element$iv;
                boolean bl = false;
                it.onVisibilityChanged(value);
            }
        }
    }

    public final boolean isBracketedPasteMode() {
        return this.isBracketedPasteMode;
    }

    public final void setBracketedPasteMode(boolean value) {
        if (value != this.isBracketedPasteMode) {
            this.isBracketedPasteMode = value;
            Iterable $this$forEach$iv = this.terminalListeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                TerminalListener it = (TerminalListener)element$iv;
                boolean bl = false;
                it.onBracketedPasteModeChanged(value);
            }
        }
    }

    @NotNull
    public final MouseMode getMouseMode() {
        return this.mouseMode;
    }

    public final void setMouseMode(@NotNull MouseMode value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (value != this.mouseMode) {
            this.mouseMode = value;
            Iterable $this$forEach$iv = this.cursorListeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CursorListener it = (CursorListener)element$iv;
                boolean bl = false;
                it.onMouseModeChanged(value);
            }
        }
    }

    @NotNull
    public final MouseFormat getMouseFormat() {
        return this.mouseFormat;
    }

    public final void setMouseFormat(@NotNull MouseFormat value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (value != this.mouseFormat) {
            this.mouseFormat = value;
            Iterable $this$forEach$iv = this.cursorListeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CursorListener it = (CursorListener)element$iv;
                boolean bl = false;
                it.onMouseFormatChanged(value);
            }
        }
    }

    @NotNull
    public final String getWindowTitle() {
        return this.windowTitle;
    }

    public final void setWindowTitle(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (!Intrinsics.areEqual((Object)value, (Object)this.windowTitle)) {
            this.windowTitle = value;
            Iterable $this$forEach$iv = this.terminalListeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                TerminalListener it = (TerminalListener)element$iv;
                boolean bl = false;
                it.onWindowTitleChanged(value);
            }
        }
    }

    public final boolean getUseAlternateBuffer() {
        return this.useAlternateBuffer;
    }

    public final void setUseAlternateBuffer(boolean value) {
        if (this.useAlternateBuffer != value) {
            this.useAlternateBuffer = value;
            Iterable $this$forEach$iv = this.terminalListeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                TerminalListener it = (TerminalListener)element$iv;
                boolean bl = false;
                it.onAlternateBufferChanged(value);
            }
        }
    }

    public final int getHistoryLinesCount() {
        return this.textBuffer.getHistoryLinesCount();
    }

    public final int getScreenLinesCount() {
        return this.textBuffer.getScreenLinesCount();
    }

    public final void setCursor(int x, int y) {
        if (x != this.cursorX || y != this.cursorY) {
            this.cursorX = x;
            this.cursorY = y;
            Iterable $this$forEach$iv = this.cursorListeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CursorListener it = (CursorListener)element$iv;
                boolean bl = false;
                it.onPositionChanged(x, y);
            }
        }
    }

    public final char charAt(int x, int y) {
        return this.textBuffer.getCharAt(x, y);
    }

    @NotNull
    public final TerminalLine getLine(int index) {
        TerminalLine terminalLine = this.textBuffer.getLine(index);
        Intrinsics.checkNotNullExpressionValue((Object)terminalLine, (String)"getLine(...)");
        return terminalLine;
    }

    public final void processHistoryAndScreenLines(int scrollOrigin, int maxLinesToProcess, @NotNull StyledTextConsumer consumer2) {
        Intrinsics.checkNotNullParameter((Object)consumer2, (String)"consumer");
        this.textBuffer.processHistoryAndScreenLines(scrollOrigin, maxLinesToProcess, consumer2);
    }

    public final void processScreenLines(int yStart, int count, @NotNull StyledTextConsumer consumer2) {
        Intrinsics.checkNotNullParameter((Object)consumer2, (String)"consumer");
        this.textBuffer.processScreenLines(yStart, count, consumer2);
    }

    @NotNull
    public final String getAllText(int updatedCursorX, int updatedCursorY) {
        return this.getLinesText(-this.getHistoryLinesCount(), this.getScreenLinesCount(), updatedCursorX, updatedCursorY);
    }

    public static /* synthetic */ String getAllText$default(TerminalModel terminalModel, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = terminalModel.cursorX;
        }
        if ((n3 & 2) != 0) {
            n2 = terminalModel.cursorY;
        }
        return terminalModel.getAllText(n, n2);
    }

    private final String getLinesText(int fromLine, int toLine, int updatedCursorX, int updatedCursorY) {
        String string;
        StringBuilder builder = new StringBuilder();
        for (int ind = fromLine; ind < toLine; ++ind) {
            String text;
            Intrinsics.checkNotNullExpressionValue((Object)this.getLine(ind).getText(), (String)"getText(...)");
            if (ind == updatedCursorY - 1) {
                String string2 = text.substring(0, Math.min(updatedCursorX, text.length()));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                text = string2;
            }
            builder.append(text);
            if (!(((CharSequence)text).length() > 0)) continue;
            builder.append('\n');
        }
        if (((CharSequence)builder).length() > 0) {
            string = ((Object)StringsKt.dropLast((CharSequence)builder, (int)1)).toString();
        } else {
            String string3 = builder.toString();
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
        }
        return string;
    }

    public final void clearAllAndMoveCursorToTopLeftCorner$intellij_terminal(@NotNull Terminal terminal) {
        Intrinsics.checkNotNullParameter((Object)terminal, (String)"terminal");
        terminal.eraseInDisplay(3);
        terminal.cursorPosition(1, 1);
    }

    public final void lockContent() {
        this.textBuffer.lock();
    }

    public final void unlockContent() {
        this.textBuffer.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T withContentLock(@NotNull Function0<? extends T> callable) {
        Object object;
        Intrinsics.checkNotNullParameter(callable, (String)"callable");
        boolean $i$f$withContentLock = false;
        this.lockContent();
        try {
            object = callable.invoke();
        }
        finally {
            InlineMarker.finallyStart((int)1);
            this.unlockContent();
            InlineMarker.finallyEnd((int)1);
        }
        return (T)object;
    }

    @NotNull
    public final List<TerminalListener> getTerminalListeners$intellij_terminal() {
        return this.terminalListeners;
    }

    public final void addContentListener(@NotNull ContentListener listener, @Nullable Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        TerminalModelListener terminalListener = () -> TerminalModel.addContentListener$lambda$9(listener);
        this.textBuffer.addModelListener(terminalListener);
        if (parentDisposable != null) {
            Disposer.register((Disposable)parentDisposable, () -> TerminalModel.addContentListener$lambda$10(this, terminalListener));
        }
    }

    public static /* synthetic */ void addContentListener$default(TerminalModel terminalModel, ContentListener contentListener, Disposable disposable, int n, Object object) {
        if ((n & 2) != 0) {
            disposable = null;
        }
        terminalModel.addContentListener(contentListener, disposable);
    }

    public final void addTerminalListener(@NotNull TerminalListener listener, @Nullable Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.terminalListeners.add(listener);
        if (parentDisposable != null) {
            Disposer.register((Disposable)parentDisposable, () -> TerminalModel.addTerminalListener$lambda$11(this, listener));
        }
    }

    public static /* synthetic */ void addTerminalListener$default(TerminalModel terminalModel, TerminalListener terminalListener, Disposable disposable, int n, Object object) {
        if ((n & 2) != 0) {
            disposable = null;
        }
        terminalModel.addTerminalListener(terminalListener, disposable);
    }

    public final void addCursorListener(@NotNull CursorListener listener, @Nullable Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.cursorListeners.add(listener);
        if (parentDisposable != null) {
            Disposer.register((Disposable)parentDisposable, () -> TerminalModel.addCursorListener$lambda$12(this, listener));
        }
    }

    public static /* synthetic */ void addCursorListener$default(TerminalModel terminalModel, CursorListener cursorListener, Disposable disposable, int n, Object object) {
        if ((n & 2) != 0) {
            disposable = null;
        }
        terminalModel.addCursorListener(cursorListener, disposable);
    }

    private static final void addContentListener$lambda$9(ContentListener $listener) {
        Intrinsics.checkNotNullParameter((Object)$listener, (String)"$listener");
        $listener.onContentChanged();
    }

    private static final void addContentListener$lambda$10(TerminalModel this$0, TerminalModelListener $terminalListener) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$terminalListener, (String)"$terminalListener");
        this$0.textBuffer.removeModelListener($terminalListener);
    }

    private static final void addTerminalListener$lambda$11(TerminalModel this$0, TerminalListener $listener) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$listener, (String)"$listener");
        this$0.terminalListeners.remove($listener);
    }

    private static final void addCursorListener$lambda$12(TerminalModel this$0, CursorListener $listener) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$listener, (String)"$listener");
        this$0.cursorListeners.remove($listener);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/plugins/terminal/block/session/TerminalModel$Companion;", "", "()V", "MIN_HEIGHT", "", "MIN_WIDTH", "intellij.terminal"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0004\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/plugins/terminal/block/session/TerminalModel$ContentListener;", "", "onContentChanged", "", "intellij.terminal"})
    public static interface ContentListener {
        default public void onContentChanged() {
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0016J\u0012\u0010\r\u001a\u00020\u00032\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0012H\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0013\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/plugins/terminal/block/session/TerminalModel$CursorListener;", "", "onMouseFormatChanged", "", "format", "Lcom/jediterm/terminal/emulator/mouse/MouseFormat;", "onMouseModeChanged", "mode", "Lcom/jediterm/terminal/emulator/mouse/MouseMode;", "onPositionChanged", "cursorX", "", "cursorY", "onShapeChanged", "shape", "Lcom/jediterm/terminal/CursorShape;", "onVisibilityChanged", "visible", "", "intellij.terminal"})
    public static interface CursorListener {
        default public void onPositionChanged(int cursorX, int cursorY) {
        }

        default public void onShapeChanged(@Nullable CursorShape shape) {
        }

        default public void onVisibilityChanged(boolean visible) {
        }

        default public void onMouseModeChanged(@NotNull MouseMode mode) {
            Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        }

        default public void onMouseFormatChanged(@NotNull MouseFormat format) {
            Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0005H\u0016J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0005H\u0016J\u0018\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0016J\u0010\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0011\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/plugins/terminal/block/session/TerminalModel$TerminalListener;", "", "onAlternateBufferChanged", "", "enabled", "", "onBracketedPasteModeChanged", "bracketed", "onCommandRunningChanged", "isRunning", "onSizeChanged", "width", "", "height", "onWindowTitleChanged", "title", "", "intellij.terminal"})
    public static interface TerminalListener {
        default public void onSizeChanged(int width, int height) {
        }

        default public void onWindowTitleChanged(@NotNull String title) {
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        }

        default public void onCommandRunningChanged(boolean isRunning) {
        }

        default public void onAlternateBufferChanged(boolean enabled) {
        }

        default public void onBracketedPasteModeChanged(boolean bracketed) {
        }
    }
}

