/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.block.output;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterClient;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.block.output.TerminalOutputHighlightingsSnapshot;
import org.jetbrains.plugins.terminal.block.output.TerminalOutputModel;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0013B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0010\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u0015\b\u0002\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/plugins/terminal/block/output/TerminalTextHighlighter;", "Lcom/intellij/openapi/editor/highlighter/EditorHighlighter;", "model", "Lorg/jetbrains/plugins/terminal/block/output/TerminalOutputModel;", "(Lorg/jetbrains/plugins/terminal/block/output/TerminalOutputModel;)V", "highlightingsSnapshot", "Lorg/jetbrains/plugins/terminal/block/output/TerminalOutputHighlightingsSnapshot;", "(Lorg/jetbrains/plugins/terminal/block/output/TerminalOutputHighlightingsSnapshot;)V", "highlightingsSnapshotProvider", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)V", "editor", "Lcom/intellij/openapi/editor/highlighter/HighlighterClient;", "createIterator", "Lcom/intellij/openapi/editor/highlighter/HighlighterIterator;", "startOffset", "", "setEditor", "", "MyHighlighterIterator", "intellij.terminal"})
public final class TerminalTextHighlighter
implements EditorHighlighter {
    @NotNull
    private final Function0<TerminalOutputHighlightingsSnapshot> highlightingsSnapshotProvider;
    @Nullable
    private HighlighterClient editor;

    private TerminalTextHighlighter(Function0<TerminalOutputHighlightingsSnapshot> highlightingsSnapshotProvider) {
        this.highlightingsSnapshotProvider = highlightingsSnapshotProvider;
    }

    public TerminalTextHighlighter(final @NotNull TerminalOutputModel model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        this((Function0<TerminalOutputHighlightingsSnapshot>)((Function0)new Function0<TerminalOutputHighlightingsSnapshot>(){

            @NotNull
            public final TerminalOutputHighlightingsSnapshot invoke() {
                return model.getHighlightingsSnapshot();
            }
        }));
    }

    public TerminalTextHighlighter(final @NotNull TerminalOutputHighlightingsSnapshot highlightingsSnapshot) {
        Intrinsics.checkNotNullParameter((Object)highlightingsSnapshot, (String)"highlightingsSnapshot");
        this((Function0<TerminalOutputHighlightingsSnapshot>)((Function0)new Function0<TerminalOutputHighlightingsSnapshot>(){

            @NotNull
            public final TerminalOutputHighlightingsSnapshot invoke() {
                return highlightingsSnapshot;
            }
        }));
    }

    @NotNull
    public HighlighterIterator createIterator(int startOffset) {
        TerminalOutputHighlightingsSnapshot highlightingsSnapshot = (TerminalOutputHighlightingsSnapshot)this.highlightingsSnapshotProvider.invoke();
        int curInd = highlightingsSnapshot.findHighlightingIndex(startOffset);
        HighlighterClient highlighterClient = this.editor;
        return new MyHighlighterIterator((Document)(highlighterClient != null ? highlighterClient.getDocument() : null), highlightingsSnapshot, curInd);
    }

    public void setEditor(@NotNull HighlighterClient editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.editor = editor;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\n\u0010\r\u001a\u0004\u0018\u00010\u0003H\u0016J\b\u0010\u000e\u001a\u00020\u0007H\u0016J\b\u0010\u000f\u001a\u00020\u0007H\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\n\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\b\u0010\u0014\u001a\u00020\nH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/plugins/terminal/block/output/TerminalTextHighlighter$MyHighlighterIterator;", "Lcom/intellij/openapi/editor/highlighter/HighlighterIterator;", "document", "Lcom/intellij/openapi/editor/Document;", "highlightings", "Lorg/jetbrains/plugins/terminal/block/output/TerminalOutputHighlightingsSnapshot;", "curInd", "", "(Lcom/intellij/openapi/editor/Document;Lorg/jetbrains/plugins/terminal/block/output/TerminalOutputHighlightingsSnapshot;I)V", "advance", "", "atEnd", "", "getDocument", "getEnd", "getStart", "getTextAttributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "getTokenType", "Lcom/intellij/psi/tree/IElementType;", "retreat", "intellij.terminal"})
    private static final class MyHighlighterIterator
    implements HighlighterIterator {
        @Nullable
        private final Document document;
        @NotNull
        private final TerminalOutputHighlightingsSnapshot highlightings;
        private int curInd;

        public MyHighlighterIterator(@Nullable Document document, @NotNull TerminalOutputHighlightingsSnapshot highlightings2, int curInd) {
            Intrinsics.checkNotNullParameter((Object)highlightings2, (String)"highlightings");
            this.document = document;
            this.highlightings = highlightings2;
            this.curInd = curInd;
        }

        public int getStart() {
            return this.highlightings.get(this.curInd).getStartOffset();
        }

        public int getEnd() {
            return this.highlightings.get(this.curInd).getEndOffset();
        }

        @NotNull
        public TextAttributes getTextAttributes() {
            return this.highlightings.get(this.curInd).getTextAttributesProvider().getTextAttributes();
        }

        @Nullable
        public IElementType getTokenType() {
            return null;
        }

        public void advance() {
            if (this.curInd < this.highlightings.getSize()) {
                int n = this.curInd;
                this.curInd = n + 1;
            }
        }

        public void retreat() {
            if (this.curInd > -1) {
                int n = this.curInd;
                this.curInd = n + -1;
            }
        }

        public boolean atEnd() {
            return this.curInd < 0 || this.curInd >= this.highlightings.getSize();
        }

        @Nullable
        public Document getDocument() {
            return this.document;
        }
    }
}

