/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.devkit.toolwindow;

import com.intellij.ide.actions.NonEmptyActionGroup;
import com.intellij.internal.statistic.devkit.PlatformStatisticsDevkitIcons;
import com.intellij.internal.statistic.devkit.toolwindow.StatisticsEventLogToolWindowFactoryKt;
import com.intellij.internal.statistic.utils.StatisticsRecorderUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000bH\u0096@\u00a2\u0006\u0002\u0010\u0010R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/intellij/internal/statistic/devkit/toolwindow/StatisticsEventLogToolWindowFactory;", "Lcom/intellij/openapi/wm/ToolWindowFactory;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "createToolWindowContent", "", "project", "Lcom/intellij/openapi/project/Project;", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "isApplicableAsync", "", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.platform.statistics.devkit"})
final class StatisticsEventLogToolWindowFactory
implements ToolWindowFactory,
DumbAware {
    public void createToolWindowContent(@NotNull Project project, @NotNull ToolWindow toolWindow) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        List list = StatisticsRecorderUtil.getRecordersInTestMode();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getRecordersInTestMode(...)");
        List recorders = list;
        if (recorders.isEmpty()) {
            return;
        }
        String mainTab = recorders.contains("FUS") ? "FUS" : (String)recorders.get(0);
        Intrinsics.checkNotNull((Object)mainTab);
        StatisticsEventLogToolWindowFactoryKt.access$createNewTab(project, toolWindow, mainTab);
        toolWindow.setToHideOnEmptyContent(true);
        if (toolWindow instanceof ToolWindowEx) {
            NonEmptyActionGroup newSessionActionGroup = StatisticsEventLogToolWindowFactoryKt.access$createNewSessionActionGroup(project);
            AnAction[] anActionArray = new AnAction[]{newSessionActionGroup};
            ((ToolWindowEx)toolWindow).setTabActions(anActionArray);
        }
        MessageBusConnection messageBusConnection = project.getMessageBus().connect();
        Topic topic = ToolWindowManagerListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)new ToolWindowManagerListener(project, mainTab){
            final /* synthetic */ Project $project;
            final /* synthetic */ String $mainTab;
            {
                this.$project = $project;
                this.$mainTab = $mainTab;
            }

            public void toolWindowShown(@NotNull ToolWindow toolWindow) {
                Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
                if (Intrinsics.areEqual((Object)"Statistics Event Log", (Object)toolWindow.getId()) && toolWindow.isVisible() && toolWindow.getContentManager().getContentCount() == 0) {
                    String string = this.$mainTab;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"$mainTab");
                    StatisticsEventLogToolWindowFactoryKt.access$createNewTab(this.$project, toolWindow, string);
                }
            }
        });
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = PlatformStatisticsDevkitIcons.StatisticsEventLog;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"StatisticsEventLog");
        return icon;
    }

    @Nullable
    public Object isApplicableAsync(@NotNull Project project, @NotNull Continuation<? super Boolean> $completion) {
        return Boxing.boxBoolean((boolean)StatisticsRecorderUtil.isAnyTestModeEnabled());
    }
}

