/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.repository.WorkspaceReader;
import org.eclipse.aether.repository.WorkspaceRepository;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.model.MavenWorkspaceMap;
import org.jetbrains.idea.maven.model.MavenWorkspaceMapWrapper;

public class Maven3WorkspaceMapReader
implements WorkspaceReader {
    private final WorkspaceRepository myRepository = new WorkspaceRepository();
    private final MavenWorkspaceMapWrapper myWorkspaceMap;

    public Maven3WorkspaceMapReader(MavenWorkspaceMap workspaceMap) {
        this.myWorkspaceMap = new MavenWorkspaceMapWrapper(workspaceMap);
    }

    public WorkspaceRepository getRepository() {
        return this.myRepository;
    }

    public File findArtifact(Artifact artifact) {
        MavenWorkspaceMap.Data resolved = this.myWorkspaceMap.findFileAndOriginalId(new MavenId(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion()));
        if (resolved == null) {
            return null;
        }
        return resolved.getFile(artifact.getExtension());
    }

    public List<String> findVersions(Artifact artifact) {
        ArrayList<String> res = new ArrayList<String>();
        Set ids = this.myWorkspaceMap.getAvailableIdsForArtifactId(artifact.getArtifactId());
        for (MavenId id : ids) {
            String version;
            if (!Objects.equals(id.getGroupId(), artifact.getGroupId()) || (version = id.getVersion()) == null) continue;
            res.add(version);
        }
        return res;
    }
}

