/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ui.callusage;

import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.profiler.CommonProfilerBundleKt;
import com.intellij.profiler.CommonProfilerUISettings;
import com.intellij.profiler.CommonProfilerUiOptions;
import com.intellij.profiler.api.BaseCallStackElement;
import com.intellij.profiler.api.HtmlWrappingValueMetricPrinter;
import com.intellij.profiler.api.ValueMetric;
import com.intellij.profiler.api.ValueMetricPrinter;
import com.intellij.profiler.api.ValueMetricPrinterWithUnits;
import com.intellij.profiler.model.CallTreeNode;
import com.intellij.profiler.model.CallWithValue;
import com.intellij.profiler.ui.BaseCallStackElementRenderer;
import com.intellij.profiler.ui.callusage.FlameChartColorsRenderer;
import com.intellij.profiler.ui.callusage.UIVisibleCallTreeNode;
import com.intellij.profiler.ui.callusage.UIVisibleCallTreeNodeInfo;
import com.intellij.profiler.ui.flamechart.ColorType;
import com.intellij.profiler.ui.flamechart.FlameChartColorScheme;
import com.intellij.profiler.ui.flamechart.FlameChartColors;
import com.intellij.profiler.ui.flamegraph.CallUsageNodeFlameGraphModel;
import com.intellij.profiler.ui.flamegraph.DefaultFlameGraphRenderer;
import com.intellij.profiler.ui.flamegraph.FlameGraphModel;
import com.intellij.profiler.ui.flamegraph.FlameGraphNode;
import com.intellij.profiler.ui.flamegraph.FlameGraphPanel;
import com.intellij.profiler.ui.flamegraph.FlameGraphTooltipColors;
import com.intellij.profiler.ui.flamegraph.GroupRootFlameGraphNode;
import com.intellij.profiler.ui.grouping.FoldingNodesGroup;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00c4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0010\u0018\u0000 S2\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u00040\u0001:\u0003STUB\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ8\u0010\u0018\u001a\u00020\u00192\u0016\u0010\u001a\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u00040\u001b2\u0016\u0010\u001c\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u00040\u001dH\u0004J(\u0010\u001e\u001a\u00020\u001f2\u0016\u0010\u001a\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u00040\u001b2\u0006\u0010 \u001a\u00020!H\u0016J-\u0010\"\u001a\u0002H#\"\b\b\u0000\u0010#*\u00020$2\u0006\u0010%\u001a\u00020\u000b2\f\u0010&\u001a\b\u0012\u0004\u0012\u0002H#0'H\u0002\u00a2\u0006\u0002\u0010(J\u0010\u0010)\u001a\u00020$2\u0006\u0010*\u001a\u00020\u0003H\u0002J\u0010\u0010+\u001a\u00020$2\u0006\u0010,\u001a\u00020-H\u0016J?\u0010.\u001a\u0004\u0018\u00010\u000b2\u0006\u0010 \u001a\u00020!2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\u000b2\u0006\u00104\u001a\u00020\u000b2\u0006\u00105\u001a\u000206H\u0002\u00a2\u0006\u0002\u00107J8\u00108\u001a\u00020\u00192\u0016\u0010\u001a\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u00040\u001b2\u0016\u0010\u001c\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u00040\u001dH\u0002J8\u00109\u001a\u00020\r2\u0016\u0010\u001a\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u00040\u001b2\u0016\u0010:\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u00040\u001dH\u0002J8\u0010;\u001a\u0002062\u0016\u0010\u001a\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u00040\u001b2\u0016\u0010\u001c\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u00040\u001dH\u0014J:\u0010<\u001a\u0004\u0018\u0001062\u0016\u0010\u001a\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u00040\u001b2\u0016\u0010\u001c\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u00040\u001dH\u0014J8\u0010=\u001a\u0004\u0018\u0001062\u0016\u0010:\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u00040\u001d2\u0014\u0010>\u001a\u0010\u0012\u0004\u0012\u00020@\u0012\u0006\u0012\u0004\u0018\u0001060?H\u0014J4\u0010A\u001a\u0004\u0018\u0001002\u0016\u0010B\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u00040C2\u0010\u0010:\u001a\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u0004H\u0017J2\u0010D\u001a\u0004\u0018\u00010$2\u0016\u0010B\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u00040C2\u0010\u0010:\u001a\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u0004J\u0015\u0010E\u001a\u000700\u00a2\u0006\u0002\bF2\u0006\u0010,\u001a\u00020-H\u0014J2\u0010E\u001a\u0004\u0018\u0001002\u0016\u0010B\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u00040C2\u0010\u0010:\u001a\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u0004J8\u0010G\u001a\u00020H2\u0016\u0010\u001a\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u00040\u001b2\u0016\u0010\u001c\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u00040\u001dH\u0002J\u0015\u0010I\u001a\u00020J2\u000b\u0010K\u001a\u000700\u00a2\u0006\u0002\bLH\u0004JH\u0010M\u001a\u00020\u001f2\u0016\u0010\u001a\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u00040\u001b2\u0006\u0010 \u001a\u00020!2\u0016\u0010\u001c\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u00040\u001d2\u0006\u0010N\u001a\u00020OH\u0014J8\u0010P\u001a\u00020H2\u0016\u0010\u001a\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u00040\u001b2\u0016\u0010\u001c\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u00040\u001dH\u0004J\u001c\u0010Q\u001a\u000206*\u0004\u0018\u0001062\f\u0010&\u001a\b\u0012\u0004\u0012\u0002060'H\u0002J\u0011\u0010R\u001a\u000700\u00a2\u0006\u0002\bF*\u000200H\u0004R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006V"}, d2={"Lcom/intellij/profiler/ui/callusage/FlameChartColorsRenderer;", "Lcom/intellij/profiler/ui/flamegraph/DefaultFlameGraphRenderer;", "Lcom/intellij/profiler/model/CallTreeNode;", "Lcom/intellij/profiler/api/BaseCallStackElement;", "Lcom/intellij/profiler/ui/callusage/CallUsageNode;", "baseRenderer", "Lcom/intellij/profiler/ui/BaseCallStackElementRenderer;", "metric", "Lcom/intellij/profiler/api/ValueMetric;", "(Lcom/intellij/profiler/ui/BaseCallStackElementRenderer;Lcom/intellij/profiler/api/ValueMetric;)V", "ellipsisStringWidth", "", "filterValue", "", "getFilterValue", "()D", "setFilterValue", "(D)V", "htmlMetricPrinter", "Lcom/intellij/profiler/api/ValueMetricPrinter;", "getMetric", "()Lcom/intellij/profiler/api/ValueMetric;", "metricPrinter", "Lcom/intellij/profiler/api/ValueMetricPrinterWithUnits;", "backgroundType", "Lcom/intellij/profiler/ui/flamechart/ColorType;", "component", "Lcom/intellij/profiler/ui/flamegraph/FlameGraphPanel;", "bounds", "Lcom/intellij/profiler/ui/flamegraph/FlameGraphNode;", "beforePaint", "", "g", "Ljava/awt/Graphics2D;", "componentWithBorder", "T", "Ljavax/swing/JComponent;", "rightBorder", "producer", "Lkotlin/Function0;", "(ILkotlin/jvm/functions/Function0;)Ljavax/swing/JComponent;", "createFrameMainInfoComponent", "call", "createFrameMetricsComponent", "uiInfo", "Lcom/intellij/profiler/ui/callusage/UIVisibleCallTreeNodeInfo;", "drawAdditionalString", "str", "", "r", "Ljava/awt/Rectangle;", "offsetX", "offsetY", "color", "Ljava/awt/Color;", "(Ljava/awt/Graphics2D;Ljava/lang/String;Ljava/awt/Rectangle;IILjava/awt/Color;)Ljava/lang/Integer;", "foregroundType", "fractionOfAllCallsForGraphNode", "node", "getBackgroundColor", "getBorderColor", "getColor", "colorFunction", "Lkotlin/Function1;", "Lcom/intellij/profiler/ui/flamechart/FlameChartColorScheme;", "getDisplayableText", "model", "Lcom/intellij/profiler/ui/flamegraph/FlameGraphModel;", "getTooltipComponent", "getTooltipText", "Lorg/jetbrains/annotations/Nls;", "isShadowed", "", "label", "Lcom/intellij/ui/components/JBLabel;", "text", "Lcom/intellij/openapi/util/NlsContexts$Label;", "paintText", "realShape", "Ljava/awt/geom/RectangularShape;", "shouldBeFilteredOut", "orDefault", "toHtml", "Companion", "FractionBar", "HtmlValueMetricPrinter", "intellij.profiler.common"})
@SourceDebugExtension(value={"SMAP\nFlameChartColorsRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FlameChartColorsRenderer.kt\ncom/intellij/profiler/ui/callusage/FlameChartColorsRenderer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,316:1\n1#2:317\n*E\n"})
public class FlameChartColorsRenderer
extends DefaultFlameGraphRenderer<CallTreeNode<? extends BaseCallStackElement>> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BaseCallStackElementRenderer baseRenderer;
    @NotNull
    private final ValueMetric metric;
    private double filterValue;
    private int ellipsisStringWidth;
    @NotNull
    private final ValueMetricPrinterWithUnits metricPrinter;
    @NotNull
    private final ValueMetricPrinter htmlMetricPrinter;
    @NotNull
    private static final Color TRANSPARENT = new Color(0, 0, 0, 0);
    private static final int VERTICAL_GAP = 6;

    public FlameChartColorsRenderer(@NotNull BaseCallStackElementRenderer baseRenderer, @NotNull ValueMetric metric) {
        Intrinsics.checkNotNullParameter((Object)baseRenderer, (String)"baseRenderer");
        Intrinsics.checkNotNullParameter((Object)metric, (String)"metric");
        this.baseRenderer = baseRenderer;
        this.metric = metric;
        this.metricPrinter = new ValueMetricPrinterWithUnits(ValueMetricPrinter.Default.INSTANCE);
        this.htmlMetricPrinter = new HtmlWrappingValueMetricPrinter(new ValueMetricPrinterWithUnits(new HtmlValueMetricPrinter()));
    }

    @NotNull
    protected final ValueMetric getMetric() {
        return this.metric;
    }

    public final double getFilterValue() {
        return this.filterValue;
    }

    public final void setFilterValue(double d) {
        this.filterValue = d;
    }

    @Override
    @Nls
    @Nullable
    public String getDisplayableText(@NotNull FlameGraphModel<CallTreeNode<BaseCallStackElement>> model2, @NotNull CallTreeNode<? extends BaseCallStackElement> node2) {
        String string;
        Intrinsics.checkNotNullParameter(model2, (String)"model");
        Intrinsics.checkNotNullParameter(node2, (String)"node");
        Object object = (CallWithValue)node2.getData();
        if (object != null && (object = (BaseCallStackElement)object.getCall()) != null) {
            Object object2 = object;
            BaseCallStackElementRenderer baseCallStackElementRenderer = this.baseRenderer;
            Object p0 = object2;
            boolean bl = false;
            string = baseCallStackElementRenderer.getText((BaseCallStackElement)p0);
        } else {
            string = null;
        }
        return string;
    }

    @Override
    public void beforePaint(@NotNull FlameGraphPanel<CallTreeNode<BaseCallStackElement>> component, @NotNull Graphics2D g) {
        Intrinsics.checkNotNullParameter(component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        super.beforePaint(component, g);
        this.ellipsisStringWidth = g.getFontMetrics().stringWidth("...");
    }

    @Override
    protected void paintText(@NotNull FlameGraphPanel<CallTreeNode<BaseCallStackElement>> component, @NotNull Graphics2D g, @NotNull FlameGraphNode<CallTreeNode<BaseCallStackElement>> bounds2, @NotNull RectangularShape realShape) {
        boolean shouldDrawContent;
        Object object;
        Rectangle r;
        int y;
        int x;
        int contentStart;
        BaseCallStackElement callStackElement;
        int boundsHeight;
        block15: {
            block14: {
                Intrinsics.checkNotNullParameter(component, (String)"component");
                Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                Intrinsics.checkNotNullParameter(bounds2, (String)"bounds");
                Intrinsics.checkNotNullParameter((Object)realShape, (String)"realShape");
                int boundsWidth = FlameGraphPanel.calculateWidth$default(component, bounds2, 0, 2, null);
                boundsHeight = component.calculateHeight(bounds2);
                if (boundsWidth < this.ellipsisStringWidth) {
                    return;
                }
                ColorType foregroundType = this.foregroundType(component, bounds2);
                g.setColor(this.shouldBeFilteredOut(component, bounds2) ? (Color)FlameChartColors.PALE.INSTANCE.color(foregroundType) : this.orDefault(this.getColor(bounds2, (Function1<? super FlameChartColorScheme, ? extends Color>)((Function1)new Function1<FlameChartColorScheme, Color>(foregroundType){
                    final /* synthetic */ ColorType $foregroundType;
                    {
                        this.$foregroundType = $foregroundType;
                        super(1);
                    }

                    @Nullable
                    public final Color invoke(@NotNull FlameChartColorScheme it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return (Color)it.color(this.$foregroundType);
                    }
                })), (Function0<? extends Color>)((Function0)new Function0<Color>(foregroundType){
                    final /* synthetic */ ColorType $foregroundType;
                    {
                        this.$foregroundType = $foregroundType;
                        super(0);
                    }

                    @NotNull
                    public final Color invoke() {
                        return (Color)FlameChartColors.PARENT.INSTANCE.color(this.$foregroundType);
                    }
                })));
                CallWithValue callWithValue = (CallWithValue)bounds2.getContent().getData();
                BaseCallStackElement baseCallStackElement = callStackElement = callWithValue != null ? (BaseCallStackElement)callWithValue.getCall() : null;
                if (component.getSearchResultNode() == bounds2) {
                    g.setFont(g.getFont().deriveFont(1));
                }
                FontMetrics fm = g.getFontMetrics(g.getFont());
                x = contentStart = (((CommonProfilerUiOptions)CommonProfilerUISettings.Companion.getInstance().getState()).getFlameGraphState().getStickyText() ? g.getClipBounds().x + 1 : 0) + 6;
                y = boundsHeight / 2 + fm.getAscent() * 2 / 5;
                if (bounds2 instanceof GroupRootFlameGraphNode) {
                    x += ((GroupRootFlameGraphNode)bounds2).getIconWidth() + 4;
                }
                r = new Rectangle(x, y, boundsWidth - x, component.getHeight());
                object = callStackElement;
                if (object == null) break block14;
                BaseCallStackElement it = object;
                boolean bl = false;
                Rectangle2D rectangle2D = r;
                FontMetrics fontMetrics = g.getFontMetrics();
                Intrinsics.checkNotNullExpressionValue((Object)fontMetrics, (String)"getFontMetrics(...)");
                String string = this.baseRenderer.fillTextInsideNode(it, rectangle2D, fontMetrics);
                object = string;
                if (string != null) break block15;
            }
            object = bounds2.getDepth() <= 1 ? "all" : "";
        }
        Object str = object;
        g.clip(realShape);
        g.drawString((String)str, x, y);
        boolean bl = shouldDrawContent = !StringsKt.isBlank((CharSequence)((CharSequence)str)) && ((String)str).length() >= 3;
        if (bounds2 instanceof GroupRootFlameGraphNode) {
            ((GroupRootFlameGraphNode)bounds2).setIconVisible(shouldDrawContent);
        }
        if (shouldDrawContent) {
            String comment;
            int offset = x + g.getFontMetrics().stringWidth((String)str);
            if (bounds2 instanceof GroupRootFlameGraphNode) {
                ((GroupRootFlameGraphNode)bounds2).drawIcon(component, g, contentStart, boundsHeight);
                if (((GroupRootFlameGraphNode)bounds2).getGroup().isFolded()) {
                    CallTreeNode<BaseCallStackElement> callTreeNode = bounds2.getContent();
                    Intrinsics.checkNotNull(callTreeNode, (String)"null cannot be cast to non-null type com.intellij.profiler.ui.grouping.FoldingNodesGroup<*>");
                    String string = ((FoldingNodesGroup)callTreeNode).getExpandLabelText();
                    Color color2 = g.getColor();
                    Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"getColor(...)");
                    Integer stringWidth = this.drawAdditionalString(g, string, r, offset + 5, y, color2);
                    if (stringWidth != null) {
                        offset += stringWidth + 5;
                    }
                }
            }
            BaseCallStackElement baseCallStackElement = callStackElement;
            if (baseCallStackElement != null) {
                BaseCallStackElement baseCallStackElement2 = baseCallStackElement;
                BaseCallStackElementRenderer baseCallStackElementRenderer = this.baseRenderer;
                BaseCallStackElement p0 = baseCallStackElement2;
                boolean bl2 = false;
                v11 = baseCallStackElementRenderer.getCommentInfo(p0);
            } else {
                v11 = comment = null;
            }
            if (comment != null) {
                Color color3 = g.getColor().brighter().brighter();
                Intrinsics.checkNotNullExpressionValue((Object)color3, (String)"brighter(...)");
                this.drawAdditionalString(g, comment, r, offset + 5, y, color3);
            }
        }
    }

    private final Integer drawAdditionalString(Graphics2D g, String str, Rectangle r, int offsetX, int offsetY, Color color2) {
        int width = g.getFontMetrics().stringWidth(str);
        if (offsetX + width < r.width) {
            Color oldColor = g.getColor();
            g.setColor(color2);
            g.drawString(str, offsetX, offsetY);
            g.setColor(oldColor);
            return width;
        }
        return null;
    }

    @Nullable
    protected Color getColor(@NotNull FlameGraphNode<CallTreeNode<BaseCallStackElement>> node2, @NotNull Function1<? super FlameChartColorScheme, ? extends Color> colorFunction) {
        Intrinsics.checkNotNullParameter(node2, (String)"node");
        Intrinsics.checkNotNullParameter(colorFunction, (String)"colorFunction");
        CallWithValue data = (CallWithValue)node2.getContent().getData();
        if (data == null) {
            return (Color)colorFunction.invoke((Object)this.baseRenderer.getRootColorScheme());
        }
        return (Color)colorFunction.invoke((Object)this.baseRenderer.getColorScheme((BaseCallStackElement)data.getCall()));
    }

    private final Color orDefault(Color $this$orDefault, Function0<? extends Color> producer) {
        Color color2 = $this$orDefault;
        if (color2 == null) {
            color2 = (Color)producer.invoke();
        }
        return color2;
    }

    @Override
    @Nullable
    public final String getTooltipText(@NotNull FlameGraphModel<CallTreeNode<BaseCallStackElement>> model2, @NotNull CallTreeNode<? extends BaseCallStackElement> node2) {
        String string;
        HtmlChunk[] htmlChunkArray;
        Intrinsics.checkNotNullParameter(model2, (String)"model");
        Intrinsics.checkNotNullParameter(node2, (String)"node");
        String string2 = this.getDisplayableText(model2, node2);
        if (string2 == null) {
            return null;
        }
        String text2 = string2;
        Object object = (CallWithValue)node2.getData();
        if (object != null && (object = (BaseCallStackElement)object.getCall()) != null) {
            Object object2 = object;
            htmlChunkArray = this.baseRenderer;
            Object p0 = object2;
            boolean bl = false;
            string = htmlChunkArray.getCommentInfo((BaseCallStackElement)p0);
        } else {
            string = null;
        }
        String comment = string;
        UIVisibleCallTreeNode<? extends BaseCallStackElement> uiVisibleNode = ((CallUsageNodeFlameGraphModel)model2).getUIVisibleNode(node2);
        HtmlChunk.Element element2 = HtmlChunk.div().child((HtmlChunk)HtmlChunk.text((String)text2).bold());
        Intrinsics.checkNotNullExpressionValue((Object)element2, (String)"child(...)");
        HtmlChunk.Element firstLine = element2;
        if (comment != null) {
            htmlChunkArray = new HtmlChunk[]{HtmlChunk.nbsp((int)2), HtmlChunk.text((String)comment)};
            HtmlChunk.Element element3 = firstLine.children(htmlChunkArray);
            Intrinsics.checkNotNullExpressionValue((Object)element3, (String)"children(...)");
            firstLine = element3;
        }
        return new HtmlBuilder().append((HtmlChunk)firstLine).append((HtmlChunk)HtmlChunk.div().addText(this.getTooltipText(uiVisibleNode.getUiInfo()))).wrapWithHtmlBody().toString();
    }

    @NotNull
    protected String getTooltipText(@NotNull UIVisibleCallTreeNodeInfo uiInfo2) {
        Intrinsics.checkNotNullParameter((Object)uiInfo2, (String)"uiInfo");
        Object[] objectArray = new Object[]{this.metricPrinter.print(this.metric, uiInfo2.getValue()), Float.valueOf((float)((int)(uiInfo2.getFractionOfParentCall().asDouble() * (double)10000)) / 100.0f), Float.valueOf((float)((int)(uiInfo2.getFractionOfAllCalls().asDouble() * (double)10000)) / 100.0f)};
        return CommonProfilerBundleKt.profilerMessage("ui.flamechart.tooltip.parentAndAll", objectArray);
    }

    @Override
    @Nullable
    public final JComponent getTooltipComponent(@NotNull FlameGraphModel<CallTreeNode<BaseCallStackElement>> model2, @NotNull CallTreeNode<? extends BaseCallStackElement> node2) {
        FoldingNodesGroup group2;
        BorderLayoutPanel borderLayoutPanel;
        Intrinsics.checkNotNullParameter(model2, (String)"model");
        Intrinsics.checkNotNullParameter(node2, (String)"node");
        Object object = (CallWithValue)node2.getData();
        if (object == null || (object = (BaseCallStackElement)object.getCall()) == null) {
            return null;
        }
        Object call = object;
        BorderLayoutPanel $this$getTooltipComponent_u24lambda_u243 = borderLayoutPanel = new BorderLayoutPanel(0, 8);
        boolean bl = false;
        $this$getTooltipComponent_u24lambda_u243.addToTop((Component)this.createFrameMainInfoComponent((BaseCallStackElement)call));
        $this$getTooltipComponent_u24lambda_u243.addToCenter((Component)this.createFrameMetricsComponent(((CallUsageNodeFlameGraphModel)model2).getUIVisibleNode(node2).getUiInfo()));
        BorderLayoutPanel result2 = borderLayoutPanel;
        FoldingNodesGroup foldingNodesGroup = group2 = node2 instanceof FoldingNodesGroup ? (FoldingNodesGroup)node2 : null;
        if (group2 != null) {
            Object[] objectArray = new Object[]{group2.getSize()};
            Object[] $this$getTooltipComponent_u24lambda_u244 = objectArray = new JBLabel(CommonProfilerBundleKt.profilerMessage("ui.flamechart.tooltip.calls.grouped", objectArray));
            boolean bl2 = false;
            $this$getTooltipComponent_u24lambda_u244.setFont((Font)JBFont.medium());
            $this$getTooltipComponent_u24lambda_u244.setForeground(JBUI.CurrentTheme.ContextHelp.FOREGROUND);
            Object[] groupLabel = objectArray;
            result2.addToBottom((Component)groupLabel);
        }
        return (JComponent)result2;
    }

    private final JComponent createFrameMainInfoComponent(BaseCallStackElement call) {
        SimpleColoredComponent simpleColoredComponent;
        SimpleColoredComponent $this$createFrameMainInfoComponent_u24lambda_u245 = simpleColoredComponent = new SimpleColoredComponent();
        boolean bl = false;
        $this$createFrameMainInfoComponent_u24lambda_u245.setMyBorder(null);
        $this$createFrameMainInfoComponent_u24lambda_u245.setIpad((Insets)JBInsets.emptyInsets());
        $this$createFrameMainInfoComponent_u24lambda_u245.append(this.baseRenderer.getText(call));
        String comment = this.baseRenderer.getCommentInfo(call);
        if (comment != null) {
            $this$createFrameMainInfoComponent_u24lambda_u245.append("  ");
            $this$createFrameMainInfoComponent_u24lambda_u245.append(comment, SimpleTextAttributes.GRAYED_ATTRIBUTES);
        }
        return (JComponent)simpleColoredComponent;
    }

    @NotNull
    public JComponent createFrameMetricsComponent(@NotNull UIVisibleCallTreeNodeInfo uiInfo2) {
        JPanel jPanel;
        Intrinsics.checkNotNullParameter((Object)uiInfo2, (String)"uiInfo");
        JPanel $this$createFrameMetricsComponent_u24lambda_u247 = jPanel = new JPanel(new FlowLayout(0, 0, 0));
        boolean bl = false;
        double fractionOfAllCalls = uiInfo2.getFractionOfAllCalls().asDouble();
        float fractionOfAll = (float)((int)(fractionOfAllCalls * (double)10000)) / 100.0f;
        Object t = this.componentWithBorder(16, createFrameMetricsComponent.1.fractionBar.1.INSTANCE);
        BorderLayoutPanel $this$createFrameMetricsComponent_u24lambda_u247_u24lambda_u246 = (BorderLayoutPanel)t;
        boolean bl2 = false;
        $this$createFrameMetricsComponent_u24lambda_u247_u24lambda_u246.addToCenter((Component)((Object)new FractionBar((JBLabel)this.componentWithBorder(0, (Function0)new Function0<JBLabel>(this, fractionOfAll){
            final /* synthetic */ FlameChartColorsRenderer this$0;
            final /* synthetic */ float $fractionOfAll;
            {
                this.this$0 = $receiver;
                this.$fractionOfAll = $fractionOfAll;
                super(0);
            }

            @NotNull
            public final JBLabel invoke() {
                Object[] objectArray = new Object[]{Float.valueOf(this.$fractionOfAll)};
                return this.this$0.label(this.this$0.toHtml(CommonProfilerBundleKt.profilerMessage("ui.flamechart.tooltip.all", objectArray)));
            }
        }), fractionOfAllCalls)));
        BorderLayoutPanel fractionBar2 = (BorderLayoutPanel)t;
        $this$createFrameMetricsComponent_u24lambda_u247.add((Component)fractionBar2);
        $this$createFrameMetricsComponent_u24lambda_u247.add((Component)this.componentWithBorder(16, (Function0)new Function0<JBLabel>(this, uiInfo2){
            final /* synthetic */ FlameChartColorsRenderer this$0;
            final /* synthetic */ UIVisibleCallTreeNodeInfo $uiInfo;
            {
                this.this$0 = $receiver;
                this.$uiInfo = $uiInfo;
                super(0);
            }

            @NotNull
            public final JBLabel invoke() {
                Object[] objectArray = new Object[]{Float.valueOf((float)((int)(this.$uiInfo.getFractionOfParentCall().asDouble() * (double)10000)) / 100.0f)};
                return this.this$0.label(this.this$0.toHtml(CommonProfilerBundleKt.profilerMessage("ui.flamechart.tooltip.parent", objectArray)));
            }
        }));
        $this$createFrameMetricsComponent_u24lambda_u247.add((Component)this.componentWithBorder(0, (Function0)new Function0<JBLabel>(this, uiInfo2){
            final /* synthetic */ FlameChartColorsRenderer this$0;
            final /* synthetic */ UIVisibleCallTreeNodeInfo $uiInfo;
            {
                this.this$0 = $receiver;
                this.$uiInfo = $uiInfo;
                super(0);
            }

            @NotNull
            public final JBLabel invoke() {
                return this.this$0.label(FlameChartColorsRenderer.access$getHtmlMetricPrinter$p(this.this$0).print(this.this$0.getMetric(), this.$uiInfo.getValue()));
            }
        }));
        return jPanel;
    }

    @Override
    @NotNull
    protected Color getBackgroundColor(@NotNull FlameGraphPanel<CallTreeNode<BaseCallStackElement>> component, @NotNull FlameGraphNode<CallTreeNode<BaseCallStackElement>> bounds2) {
        Intrinsics.checkNotNullParameter(component, (String)"component");
        Intrinsics.checkNotNullParameter(bounds2, (String)"bounds");
        ColorType backgroundType = this.backgroundType(component, bounds2);
        return this.shouldBeFilteredOut(component, bounds2) ? (Color)FlameChartColors.PALE.INSTANCE.color(backgroundType) : this.orDefault(this.getColor(bounds2, (Function1<? super FlameChartColorScheme, ? extends Color>)((Function1)new Function1<FlameChartColorScheme, Color>(backgroundType){
            final /* synthetic */ ColorType $backgroundType;
            {
                this.$backgroundType = $backgroundType;
                super(1);
            }

            @Nullable
            public final Color invoke(@NotNull FlameChartColorScheme it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return (Color)it.color(this.$backgroundType);
            }
        })), (Function0<? extends Color>)((Function0)new Function0<Color>(backgroundType){
            final /* synthetic */ ColorType $backgroundType;
            {
                this.$backgroundType = $backgroundType;
                super(0);
            }

            @NotNull
            public final Color invoke() {
                return (Color)FlameChartColors.PARENT.INSTANCE.color(this.$backgroundType);
            }
        }));
    }

    protected final boolean shouldBeFilteredOut(@NotNull FlameGraphPanel<CallTreeNode<BaseCallStackElement>> component, @NotNull FlameGraphNode<CallTreeNode<BaseCallStackElement>> bounds2) {
        Intrinsics.checkNotNullParameter(component, (String)"component");
        Intrinsics.checkNotNullParameter(bounds2, (String)"bounds");
        return this.filterValue > 0.0 && this.fractionOfAllCallsForGraphNode(component, bounds2) <= this.filterValue;
    }

    private final double fractionOfAllCallsForGraphNode(FlameGraphPanel<CallTreeNode<BaseCallStackElement>> component, FlameGraphNode<CallTreeNode<BaseCallStackElement>> node2) {
        FlameGraphModel<CallTreeNode<BaseCallStackElement>> flameGraphModel = component.getModel();
        Intrinsics.checkNotNull(flameGraphModel, (String)"null cannot be cast to non-null type com.intellij.profiler.ui.flamegraph.CallUsageNodeFlameGraphModel<com.intellij.profiler.api.BaseCallStackElement>");
        UIVisibleCallTreeNode<BaseCallStackElement> uiVisibleNode = ((CallUsageNodeFlameGraphModel)flameGraphModel).getUIVisibleNode(node2.getContent());
        return uiVisibleNode.getFractionOfAllCallsDouble();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @Nullable
    protected Color getBorderColor(@NotNull FlameGraphPanel<CallTreeNode<BaseCallStackElement>> component, @NotNull FlameGraphNode<CallTreeNode<BaseCallStackElement>> bounds2) {
        Color color2;
        Intrinsics.checkNotNullParameter(component, (String)"component");
        Intrinsics.checkNotNullParameter(bounds2, (String)"bounds");
        Color color3 = this.getColor(bounds2, (Function1<? super FlameChartColorScheme, ? extends Color>)((Function1)new Function1<FlameChartColorScheme, Color>(component, bounds2){
            final /* synthetic */ FlameGraphPanel<CallTreeNode<BaseCallStackElement>> $component;
            final /* synthetic */ FlameGraphNode<CallTreeNode<BaseCallStackElement>> $bounds;
            {
                this.$component = $component;
                this.$bounds = $bounds;
                super(1);
            }

            @Nullable
            public final Color invoke(@NotNull FlameChartColorScheme it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                ColorType colorType = this.$component.getSearchResultNode() == this.$bounds ? ColorType.SEARCH_FOCUSED_BORDER : ColorType.BORDER;
                return (Color)it.color(colorType);
            }
        }));
        if (color3 != null) {
            Color color4;
            Color color5;
            Color it = color5 = color3;
            boolean bl = false;
            Color color6 = color4 = it != TRANSPARENT ? color5 : null;
            if (color4 != null) {
                color2 = color4;
                return color2;
            }
        }
        color2 = super.getBorderColor(component, bounds2);
        return color2;
    }

    private final ColorType foregroundType(FlameGraphPanel<CallTreeNode<BaseCallStackElement>> component, FlameGraphNode<CallTreeNode<BaseCallStackElement>> bounds2) {
        boolean search2 = component.isSearchActive();
        boolean search_ok = search2 && component.isMatchingSearch(bounds2);
        return ColorType.Companion.findForegroundType(component.getHighlightedNode() == bounds2, this.isShadowed(component, bounds2), search2, search_ok);
    }

    @NotNull
    protected final ColorType backgroundType(@NotNull FlameGraphPanel<CallTreeNode<BaseCallStackElement>> component, @NotNull FlameGraphNode<CallTreeNode<BaseCallStackElement>> bounds2) {
        Intrinsics.checkNotNullParameter(component, (String)"component");
        Intrinsics.checkNotNullParameter(bounds2, (String)"bounds");
        boolean search2 = component.isSearchActive();
        boolean search_ok = search2 && component.isMatchingSearch(bounds2);
        boolean focus = component.getHighlightedNode() == bounds2;
        boolean focusGroup = ArraysKt.contains((Object[])component.getHighlightedGroup(), bounds2);
        boolean shadow = this.isShadowed(component, bounds2);
        return ColorType.Companion.findBackgroundType(search2, search_ok, focus, focusGroup, shadow);
    }

    private final boolean isShadowed(FlameGraphPanel<CallTreeNode<BaseCallStackElement>> component, FlameGraphNode<CallTreeNode<BaseCallStackElement>> bounds2) {
        FlameGraphNode<CallTreeNode<BaseCallStackElement>> flameGraphNode = component.getSelectedNode();
        if (flameGraphNode == null) {
            return false;
        }
        FlameGraphNode<CallTreeNode<BaseCallStackElement>> selectedNode = flameGraphNode;
        boolean isDepthIsNotLess = selectedNode.getDepth() <= bounds2.getDepth();
        boolean isBoundsAreInIt = bounds2.getStart() >= selectedNode.getStart() && bounds2.getEnd() <= selectedNode.getEnd();
        return !isDepthIsNotLess || !isBoundsAreInIt;
    }

    @NotNull
    protected final JBLabel label(@NotNull String text2) {
        JBLabel jBLabel;
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        JBLabel $this$label_u24lambda_u249 = jBLabel = new JBLabel(text2);
        boolean bl = false;
        $this$label_u24lambda_u249.setForeground((Color)FlameGraphTooltipColors.INSTANCE.getForeground());
        return jBLabel;
    }

    private final <T extends JComponent> T componentWithBorder(int rightBorder, Function0<? extends T> producer) {
        Object object = producer.invoke();
        JComponent $this$componentWithBorder_u24lambda_u2410 = (JComponent)object;
        boolean bl = false;
        $this$componentWithBorder_u24lambda_u2410.setBorder((Border)JBUI.Borders.empty((int)0, (int)0, (int)0, (int)rightBorder));
        return (T)((JComponent)object);
    }

    @NotNull
    protected final String toHtml(@NotNull String $this$toHtml) {
        Intrinsics.checkNotNullParameter((Object)$this$toHtml, (String)"<this>");
        String string = new HtmlBuilder().appendRaw($this$toHtml).wrapWithHtmlBody().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public static final /* synthetic */ ValueMetricPrinter access$getHtmlMetricPrinter$p(FlameChartColorsRenderer $this) {
        return $this.htmlMetricPrinter;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/profiler/ui/callusage/FlameChartColorsRenderer$Companion;", "", "()V", "TRANSPARENT", "Ljava/awt/Color;", "VERTICAL_GAP", "", "intellij.profiler.common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/profiler/ui/callusage/FlameChartColorsRenderer$FractionBar;", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "label", "Lcom/intellij/ui/components/JBLabel;", "fraction", "", "(Lcom/intellij/ui/components/JBLabel;D)V", "paintComponent", "", "g", "Ljava/awt/Graphics;", "Companion", "intellij.profiler.common"})
    private static final class FractionBar
    extends BorderLayoutPanel {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final double fraction;
        private static final int SCALE_TOTAL_WIDTH = 100;
        private static final int MIN_SCALE_WIDTH = 3;

        public FractionBar(@NotNull JBLabel label, double fraction) {
            Intrinsics.checkNotNullParameter((Object)label, (String)"label");
            this.fraction = fraction;
            this.addToCenter((Component)label);
            this.setBorder((Border)JBUI.Borders.empty((int)3, (int)5, (int)3, (int)0));
            this.setPreferredSize(new Dimension(JBUI.scale((int)100), this.getPreferredSize().height));
        }

        protected void paintComponent(@Nullable Graphics g) {
            super.paintComponent(g);
            Intrinsics.checkNotNull((Object)g, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
            Graphics2D g2d = (Graphics2D)g;
            Rectangle clipBounds = g2d.getClipBounds();
            int fractionWidth = Math.max((int)((double)clipBounds.width * this.fraction), JBUI.scale((int)3));
            Color oldColor = g2d.getColor();
            g2d.setColor((Color)FlameGraphTooltipColors.INSTANCE.getScaleColor());
            g2d.fillRect(clipBounds.x, clipBounds.y, fractionWidth, clipBounds.height);
            g2d.setColor((Color)FlameGraphTooltipColors.INSTANCE.getScaleBackground());
            g2d.fillRect(clipBounds.x + fractionWidth, clipBounds.y, clipBounds.width - fractionWidth, clipBounds.height);
            g2d.setColor(oldColor);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/profiler/ui/callusage/FlameChartColorsRenderer$FractionBar$Companion;", "", "()V", "MIN_SCALE_WIDTH", "", "SCALE_TOTAL_WIDTH", "intellij.profiler.common"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/profiler/ui/callusage/FlameChartColorsRenderer$HtmlValueMetricPrinter;", "Lcom/intellij/profiler/api/ValueMetricPrinter;", "()V", "print", "", "metric", "Lcom/intellij/profiler/api/ValueMetric;", "value", "", "intellij.profiler.common"})
    private static final class HtmlValueMetricPrinter
    implements ValueMetricPrinter {
        @Override
        @NotNull
        public String print(@NotNull ValueMetric metric, long value) {
            Intrinsics.checkNotNullParameter((Object)metric, (String)"metric");
            String string = ValueMetricPrinter.Default.INSTANCE.print(metric, value);
            return "<b>" + string + "</b>";
        }
    }
}

