/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ui;

import com.intellij.execution.ui.layout.impl.JBRunnerTabs;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.profiler.CommonProfilerBundleKt;
import com.intellij.ui.ScrollableContentBorder;
import com.intellij.ui.SideBorder;
import com.intellij.ui.tabs.JBTabsBorder;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.TabsListener;
import com.intellij.ui.tabs.impl.JBDefaultTabsBorder;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.ui.NamedColorUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00142\u00020\u0001:\u0002\u0013\u0014B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\fJ\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\nH\u0014J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0014\u00a8\u0006\u0015"}, d2={"Lcom/intellij/profiler/ui/JBRunnerClosableTabs;", "Lcom/intellij/execution/ui/layout/impl/JBRunnerTabs;", "project", "Lcom/intellij/openapi/project/Project;", "parent", "Lcom/intellij/openapi/Disposable;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/Disposable;)V", "addClosableTab", "", "tab", "Lcom/intellij/ui/tabs/TabInfo;", "select", "", "adjust", "tabInfo", "createCloseGroup", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "createTabBorder", "Lcom/intellij/ui/tabs/JBTabsBorder;", "CloseTabLabelAction", "Companion", "intellij.profiler.common"})
public final class JBRunnerClosableTabs
extends JBRunnerTabs {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public JBRunnerClosableTabs(@NotNull Project project, @NotNull Disposable parent) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        super(project, parent);
        this.setPopupGroup((ActionGroup)this.createCloseGroup(), "RunnerClosableTabsCloseGroup", true);
        this.setTabDraggingEnabled(true);
        this.addTabMouseListener(new MouseAdapter(){
            @Nullable
            private TabInfo tabToRemove;

            @Override
            public void mousePressed(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (SwingUtilities.isMiddleMouseButton(e)) {
                    this.tabToRemove = this.findInfo(e);
                }
            }

            @Override
            public void mouseReleased(@Nullable MouseEvent e) {
                Object object = this.tabToRemove;
                if (object != null) {
                    TabInfo tabInfo;
                    TabInfo it = tabInfo = object;
                    boolean bl = false;
                    object = Companion.isClosable(it) ? tabInfo : null;
                    if (object != null) {
                        tabInfo = object;
                        JBRunnerClosableTabs jBRunnerClosableTabs = this;
                        TabInfo p0 = tabInfo;
                        boolean bl2 = false;
                        jBRunnerClosableTabs.removeTab(p0);
                    }
                }
                this.tabToRemove = null;
            }
        });
        this.addListener(new TabsListener(){

            public void tabRemoved(@NotNull TabInfo tabToRemove) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)tabToRemove, (String)"tabToRemove");
                    JComponent jComponent = tabToRemove.getComponent();
                    Disposable disposable = jComponent instanceof Disposable ? (Disposable)jComponent : null;
                    if (disposable == null) break block0;
                    Disposable p0 = disposable;
                    boolean bl = false;
                    Disposer.dispose((Disposable)p0);
                }
            }
        });
    }

    @NotNull
    protected JBTabsBorder createTabBorder() {
        return (JBTabsBorder)new JBDefaultTabsBorder((JBTabsImpl)this);
    }

    public final void addClosableTab(@NotNull TabInfo tab, boolean select2) {
        Intrinsics.checkNotNullParameter((Object)tab, (String)"tab");
        AnAction[] anActionArray = new AnAction[]{new CloseTabLabelAction(tab)};
        DefaultActionGroup tabLabelActions = new DefaultActionGroup(anActionArray);
        if (tab.getTabLabelActions() != null) {
            tabLabelActions.addSeparator();
            ActionGroup actionGroup = tab.getTabLabelActions();
            if (actionGroup != null) {
                ActionGroup it = actionGroup;
                boolean bl = false;
                tabLabelActions.addAll(it);
            }
        }
        tab.setTabLabelActions((ActionGroup)tabLabelActions, "unknown");
        this.addTab(tab);
        if (select2) {
            this.select(tab, true);
        }
    }

    public static /* synthetic */ void addClosableTab$default(JBRunnerClosableTabs jBRunnerClosableTabs, TabInfo tabInfo, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        jBRunnerClosableTabs.addClosableTab(tabInfo, bl);
    }

    protected void adjust(@NotNull TabInfo tabInfo) {
        Intrinsics.checkNotNullParameter((Object)tabInfo, (String)"tabInfo");
        JComponent c = tabInfo.getComponent();
        JBIterable jBIterable = ((JBTreeTraverser)UIUtil.uiTraverser((Component)c).expand(arg_0 -> JBRunnerClosableTabs.adjust$lambda$1((Function1)new Function1<Component, Boolean>(c){
            final /* synthetic */ JComponent $c;
            {
                this.$c = $c;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Component o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                return o == this.$c || o instanceof JPanel || o instanceof JLayeredPane;
            }
        }, arg_0))).filter(JScrollPane.class);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filter(...)");
        JBIterable scrollPanes2 = jBIterable;
        for (JScrollPane scrollPane : scrollPanes2) {
            if (scrollPane.getBorder() instanceof ScrollableContentBorder) continue;
            scrollPane.setBorder((Border)new SideBorder(NamedColorUtil.getBoundsColor(), 0));
        }
    }

    private final DefaultActionGroup createCloseGroup() {
        AnAction[] anActionArray = new AnAction[2];
        String string = CommonProfilerBundleKt.profilerMessage("ui.tabs.close", new Object[0]);
        Icon icon = AllIcons.Actions.Close;
        anActionArray[0] = new DumbAwareAction(this, string, icon){
            final /* synthetic */ JBRunnerClosableTabs this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, null, $super_call_param$2);
                this.registerCustomShortcutSet(KeymapUtil.getActiveKeymapShortcuts((String)"CloseContent"), $receiver.getComponent());
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                TabInfo tabInfo = this.this$0.getTargetInfo();
                boolean bl = tabInfo != null ? com.intellij.profiler.ui.JBRunnerClosableTabs$Companion.access$isClosable(JBRunnerClosableTabs.Companion, tabInfo) : false;
                if (bl) {
                    this.this$0.removeTab(this.this$0.getTargetInfo());
                }
            }

            public void update(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                TabInfo tabInfo = this.this$0.getTargetInfo();
                e.getPresentation().setEnabledAndVisible(tabInfo != null ? com.intellij.profiler.ui.JBRunnerClosableTabs$Companion.access$isClosable(JBRunnerClosableTabs.Companion, tabInfo) : false);
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                return ActionUpdateThread.EDT;
            }
        };
        string = CommonProfilerBundleKt.profilerMessage("ui.tabs.closeOthers", new Object[0]);
        anActionArray[1] = new DumbAwareAction(this, string){
            final /* synthetic */ JBRunnerClosableTabs this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            /*
             * WARNING - void declaration
             */
            public void actionPerformed(@NotNull AnActionEvent e) {
                void $this$forEach$iv;
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Iterable iterable = this.this$0.getTabs();
                JBRunnerClosableTabs jBRunnerClosableTabs = this.this$0;
                boolean $i$f$filter = false;
                Iterator<T> iterator2 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    TabInfo it = (TabInfo)element$iv$iv;
                    boolean bl = false;
                    if (!(com.intellij.profiler.ui.JBRunnerClosableTabs$Companion.access$isClosable(JBRunnerClosableTabs.Companion, it) && !Intrinsics.areEqual((Object)it, (Object)jBRunnerClosableTabs.getTargetInfo()))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                jBRunnerClosableTabs = this.this$0;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    TabInfo it = (TabInfo)element$iv;
                    boolean bl = false;
                    jBRunnerClosableTabs.removeTab(it);
                }
            }

            /*
             * WARNING - void declaration
             */
            public void update(@NotNull AnActionEvent e) {
                boolean bl;
                Presentation presentation;
                block3: {
                    void $this$any$iv;
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    Iterable iterable = this.this$0.getTabs();
                    JBRunnerClosableTabs jBRunnerClosableTabs = this.this$0;
                    presentation = e.getPresentation();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            TabInfo it = (TabInfo)element$iv;
                            boolean bl2 = false;
                            if (!(com.intellij.profiler.ui.JBRunnerClosableTabs$Companion.access$isClosable(JBRunnerClosableTabs.Companion, it) && !Intrinsics.areEqual((Object)it, (Object)jBRunnerClosableTabs.getTargetInfo()))) continue;
                            bl = true;
                            break block3;
                        }
                        bl = false;
                    }
                }
                boolean bl3 = bl;
                presentation.setVisible(bl3);
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                return ActionUpdateThread.EDT;
            }
        };
        return new DefaultActionGroup(anActionArray);
    }

    private static final boolean adjust$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/profiler/ui/JBRunnerClosableTabs$CloseTabLabelAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "tabInfo", "Lcom/intellij/ui/tabs/TabInfo;", "(Lcom/intellij/profiler/ui/JBRunnerClosableTabs;Lcom/intellij/ui/tabs/TabInfo;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "intellij.profiler.common"})
    private final class CloseTabLabelAction
    extends DumbAwareAction {
        @NotNull
        private final TabInfo tabInfo;

        public CloseTabLabelAction(TabInfo tabInfo) {
            Intrinsics.checkNotNullParameter((Object)tabInfo, (String)"tabInfo");
            super(CommonProfilerBundleKt.profilerMessage("ui.tabs.close", new Object[0]), null, AllIcons.Actions.Close);
            this.tabInfo = tabInfo;
            this.getTemplatePresentation().setHoveredIcon(AllIcons.Actions.CloseHovered);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            JBRunnerClosableTabs.this.removeTab(this.tabInfo);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.EDT;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\f\u0010\u0003\u001a\u00020\u0004*\u00020\u0005H\u0002\u00a8\u0006\u0006"}, d2={"Lcom/intellij/profiler/ui/JBRunnerClosableTabs$Companion;", "", "()V", "isClosable", "", "Lcom/intellij/ui/tabs/TabInfo;", "intellij.profiler.common"})
    @SourceDebugExtension(value={"SMAP\nJBRunnerClosableTabs.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JBRunnerClosableTabs.kt\ncom/intellij/profiler/ui/JBRunnerClosableTabs$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,135:1\n12474#2,2:136\n*S KotlinDebug\n*F\n+ 1 JBRunnerClosableTabs.kt\ncom/intellij/profiler/ui/JBRunnerClosableTabs$Companion\n*L\n133#1:136,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isClosable(TabInfo $this$isClosable) {
            boolean bl;
            AnAction[] anActionArray = $this$isClosable.getTabLabelActions();
            if (anActionArray != null && (anActionArray = anActionArray.getChildren(null)) != null) {
                boolean bl2;
                block3: {
                    AnAction[] $this$any$iv = anActionArray;
                    boolean $i$f$any = false;
                    int n = $this$any$iv.length;
                    for (int i = 0; i < n; ++i) {
                        AnAction element$iv;
                        AnAction it = element$iv = $this$any$iv[i];
                        boolean bl3 = false;
                        if (!(it instanceof CloseTabLabelAction)) continue;
                        bl2 = true;
                        break block3;
                    }
                    bl2 = false;
                }
                bl = bl2;
            } else {
                bl = false;
            }
            return bl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

