/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.compressed;

import com.intellij.profiler.compressed.CompressedDumpDescriptor;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0003\u0015\u0016\u0017B\u0017\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\n\u0010\u000b\u001a\u0004\u0018\u00010\fH&JG\u0010\r\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u000f\u0018\u00010\u000e\"\u0010\b\u0000\u0010\u0010*\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u000e2\u0006\u0010\u0011\u001a\u0002H\u00102\u0014\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u0002H\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u0013H\u0004\u00a2\u0006\u0002\u0010\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u0082\u0001\u0003\u0018\u0019\u001a\u00a8\u0006\u001b"}, d2={"Lcom/intellij/profiler/compressed/CompressedDumpDescriptor;", "", "file", "Ljava/io/File;", "compressorName", "", "(Ljava/io/File;Ljava/lang/String;)V", "getCompressorName", "()Ljava/lang/String;", "getFile", "()Ljava/io/File;", "createUnderlyingSingleFileInputStream", "Ljava/io/InputStream;", "navigatedToEntry", "Lorg/apache/commons/compress/archivers/ArchiveInputStream;", "Lorg/apache/commons/compress/archivers/ArchiveEntry;", "T", "stream", "nextEntry", "Lkotlin/Function1;", "(Lorg/apache/commons/compress/archivers/ArchiveInputStream;Lkotlin/jvm/functions/Function1;)Lorg/apache/commons/compress/archivers/ArchiveInputStream;", "Commons", "Gz", "TarGz", "Lcom/intellij/profiler/compressed/CompressedDumpDescriptor$Commons;", "Lcom/intellij/profiler/compressed/CompressedDumpDescriptor$Gz;", "Lcom/intellij/profiler/compressed/CompressedDumpDescriptor$TarGz;", "intellij.profiler.common"})
public abstract class CompressedDumpDescriptor {
    @NotNull
    private final File file;
    @NotNull
    private final String compressorName;

    private CompressedDumpDescriptor(File file2, String compressorName) {
        this.file = file2;
        this.compressorName = compressorName;
    }

    @NotNull
    public final File getFile() {
        return this.file;
    }

    @NotNull
    public final String getCompressorName() {
        return this.compressorName;
    }

    @Nullable
    public abstract InputStream createUnderlyingSingleFileInputStream();

    @Nullable
    protected final <T extends ArchiveInputStream<? extends ArchiveEntry>> ArchiveInputStream<? extends ArchiveEntry> navigatedToEntry(@NotNull T stream, @NotNull Function1<? super T, ? extends ArchiveEntry> nextEntry) {
        Intrinsics.checkNotNullParameter(stream, (String)"stream");
        Intrinsics.checkNotNullParameter(nextEntry, (String)"nextEntry");
        ArchiveEntry entry = (ArchiveEntry)nextEntry.invoke(stream);
        while (entry != null) {
            if (stream.canReadEntryData(entry) && !entry.isDirectory()) {
                return stream;
            }
            entry = (ArchiveEntry)nextEntry.invoke(stream);
        }
        return null;
    }

    public /* synthetic */ CompressedDumpDescriptor(File file2, String compressorName, DefaultConstructorMarker $constructor_marker) {
        this(file2, compressorName);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\n\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/profiler/compressed/CompressedDumpDescriptor$Commons;", "Lcom/intellij/profiler/compressed/CompressedDumpDescriptor;", "file", "Ljava/io/File;", "compressorName", "", "(Ljava/io/File;Ljava/lang/String;)V", "createUnderlyingSingleFileInputStream", "Ljava/io/InputStream;", "intellij.profiler.common"})
    public static final class Commons
    extends CompressedDumpDescriptor {
        public Commons(@NotNull File file2, @NotNull String compressorName) {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            Intrinsics.checkNotNullParameter((Object)compressorName, (String)"compressorName");
            super(file2, compressorName, null);
        }

        @Override
        @Nullable
        public InputStream createUnderlyingSingleFileInputStream() {
            return (InputStream)this.navigatedToEntry(new ArchiveStreamFactory().createArchiveInputStream(this.getCompressorName(), (InputStream)new FileInputStream(this.getFile())), createUnderlyingSingleFileInputStream.1.INSTANCE);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/profiler/compressed/CompressedDumpDescriptor$Gz;", "Lcom/intellij/profiler/compressed/CompressedDumpDescriptor;", "file", "Ljava/io/File;", "(Ljava/io/File;)V", "createUnderlyingSingleFileInputStream", "Ljava/io/InputStream;", "intellij.profiler.common"})
    public static final class Gz
    extends CompressedDumpDescriptor {
        public Gz(@NotNull File file2) {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            super(file2, "gz", null);
        }

        @Override
        @NotNull
        public InputStream createUnderlyingSingleFileInputStream() {
            return new GZIPInputStream(new FileInputStream(this.getFile()));
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\n\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/profiler/compressed/CompressedDumpDescriptor$TarGz;", "Lcom/intellij/profiler/compressed/CompressedDumpDescriptor;", "file", "Ljava/io/File;", "(Ljava/io/File;)V", "createUnderlyingSingleFileInputStream", "Ljava/io/InputStream;", "intellij.profiler.common"})
    public static final class TarGz
    extends CompressedDumpDescriptor {
        public TarGz(@NotNull File file2) {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            super(file2, "tar.gz", null);
        }

        @Override
        @Nullable
        public InputStream createUnderlyingSingleFileInputStream() {
            return (InputStream)this.navigatedToEntry((ArchiveInputStream)new TarArchiveInputStream((InputStream)new GzipCompressorInputStream((InputStream)new FileInputStream(this.getFile()))), createUnderlyingSingleFileInputStream.1.INSTANCE);
        }
    }
}

