/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang;

import com.intellij.util.lang.Access;
import com.intellij.util.lang.Xxh3Impl;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.ByteOrder;

class InputStreamAccess
implements Access<InputStream> {
    private static final VarHandle LONG_HANDLE = MethodHandles.byteArrayViewVarHandle(long[].class, ByteOrder.LITTLE_ENDIAN);
    private static final VarHandle INT_HANDLE = MethodHandles.byteArrayViewVarHandle(int[].class, ByteOrder.LITTLE_ENDIAN);
    private byte[] buffer = new byte[Xxh3Impl.getBlockLength()];
    private int currentBlock = -1;
    private final int totalStreamLength;
    private final int totalBlocks;

    InputStreamAccess(int streamLength) {
        this.totalStreamLength = streamLength;
        this.totalBlocks = streamLength / Xxh3Impl.getBlockLength();
    }

    @Override
    public long i64(InputStream input, int offset) {
        int positionInBuffer = this.actualizeBufferAndGetPosition(input, offset);
        return LONG_HANDLE.get(this.buffer, positionInBuffer);
    }

    @Override
    public int i32(InputStream input, int offset) {
        int positionInBuffer = this.actualizeBufferAndGetPosition(input, offset);
        return INT_HANDLE.get(this.buffer, positionInBuffer);
    }

    @Override
    public int i8(InputStream input, int offset) {
        int positionInBuffer = this.actualizeBufferAndGetPosition(input, offset);
        return this.buffer[positionInBuffer];
    }

    private int actualizeBufferAndGetPosition(InputStream input, int offset) {
        int requestedBlock = offset / Xxh3Impl.getBlockLength();
        int positionInBuffer = offset % Xxh3Impl.getBlockLength();
        if (requestedBlock == this.currentBlock) {
            return positionInBuffer;
        }
        if (requestedBlock > this.currentBlock) {
            if (requestedBlock + 1 == this.totalBlocks) {
                int remainingBufferSize = this.totalStreamLength - requestedBlock * Xxh3Impl.getBlockLength();
                this.buffer = new byte[remainingBufferSize];
            }
            try {
                input.read(this.buffer);
                ++this.currentBlock;
                return positionInBuffer;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        throw new IllegalStateException("Unexpected state at InputStream hashing");
    }
}

