/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.plugincomponents;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.BaseProjectDirectories;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootModificationTracker;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.KotlinUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.ec4j.core.ResourceProperties;
import org.ec4j.core.parser.ParseException;
import org.editorconfig.EditorConfigRegistry;
import org.editorconfig.plugincomponents.EditorConfigPropertiesService;
import org.editorconfig.plugincomponents.EditorConfigPropertiesServiceKt;
import org.editorconfig.plugincomponents.InvalidEditorConfig;
import org.editorconfig.plugincomponents.LoadEditorConfigResult;
import org.editorconfig.plugincomponents.ValidEditorConfig;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\r\u0010\t\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b\u000bJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ \u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u00120\u00112\u0006\u0010\u000e\u001a\u00020\u000fJ\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0014J\u0010\u0010\u0015\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00172\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u00122\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/editorconfig/plugincomponents/EditorConfigPropertiesService;", "Lcom/intellij/openapi/util/SimpleModificationTracker;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "editorConfigsCache", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lorg/editorconfig/plugincomponents/LoadEditorConfigResult;", "clearCache", "", "clearCache$intellij_editorconfig", "getProperties", "Lorg/ec4j/core/ResourceProperties;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getPropertiesAndEditorConfigs", "Lkotlin/Pair;", "", "getRootDirs", "", "loadEditorConfig", "parentDirsFrom", "Lkotlin/sequences/Sequence;", "relevantEditorConfigsFor", "Lorg/editorconfig/plugincomponents/ValidEditorConfig;", "Companion", "intellij.editorconfig"})
@SourceDebugExtension(value={"SMAP\nEditorConfigPropertiesService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorConfigPropertiesService.kt\norg/editorconfig/plugincomponents/EditorConfigPropertiesService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,163:1\n1#2:164\n58#3,5:165\n58#3,5:170\n23#3:179\n1549#4:175\n1620#4,3:176\n*S KotlinDebug\n*F\n+ 1 EditorConfigPropertiesService.kt\norg/editorconfig/plugincomponents/EditorConfigPropertiesService\n*L\n67#1:165,5\n101#1:170,5\n38#1:179\n118#1:175\n118#1:176,3\n*E\n"})
public final class EditorConfigPropertiesService
extends SimpleModificationTracker {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final Project project;
    @NotNull
    private final ConcurrentHashMap<String, LoadEditorConfigResult> editorConfigsCache;
    @NotNull
    private static final Logger LOG;

    public EditorConfigPropertiesService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.editorConfigsCache = new ConcurrentHashMap();
    }

    @NotNull
    public final Set<VirtualFile> getRootDirs() {
        if (!EditorConfigRegistry.shouldStopAtProjectRoot()) {
            return SetsKt.emptySet();
        }
        Object object = CachedValuesManager.getManager((Project)this.project).getCachedValue((UserDataHolder)this.project, () -> EditorConfigPropertiesService.getRootDirs$lambda$2(this));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
        return (Set)object;
    }

    private final LoadEditorConfigResult loadEditorConfig(VirtualFile file) {
        LoadEditorConfigResult loadEditorConfigResult;
        try {
            ValidEditorConfig it = loadEditorConfigResult = new ValidEditorConfig(file, EditorConfigPropertiesServiceKt.access$parseEditorConfig(VirtualFileUtil.readText((VirtualFile)file)));
            boolean bl = false;
            Logger $this$debug_u24default$iv = LOG;
            Throwable e$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger = $this$debug_u24default$iv;
                boolean bl2 = false;
                logger.debug("found config: " + file.getParent().getUrl(), e$iv);
            }
            loadEditorConfigResult = loadEditorConfigResult;
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            loadEditorConfigResult = new InvalidEditorConfig(file);
        }
        catch (ParseException e) {
            LOG.debug((Throwable)e);
            loadEditorConfigResult = new InvalidEditorConfig(file);
        }
        return loadEditorConfigResult;
    }

    private final Sequence<VirtualFile> parentDirsFrom(VirtualFile file) {
        Set<VirtualFile> rootDirs = this.getRootDirs();
        return KotlinUtils.takeWhileInclusive((Sequence)SequencesKt.generateSequence((Object)(file.isDirectory() ? file : file.getParent()), (Function1)parentDirsFrom.1.INSTANCE), (Function1)((Function1)new Function1<VirtualFile, Boolean>(rootDirs){
            final /* synthetic */ Set<VirtualFile> $rootDirs;
            {
                this.$rootDirs = $rootDirs;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull VirtualFile it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return !this.$rootDirs.contains(it);
            }
        }));
    }

    private final List<ValidEditorConfig> relevantEditorConfigsFor(VirtualFile file) {
        VirtualFile dir;
        LoadEditorConfigResult cachedEditorConfig2;
        LoadEditorConfigResult loadEditorConfigResult;
        List result2 = new ArrayList();
        Iterator iterator = this.parentDirsFrom(file).iterator();
        while (iterator.hasNext() && !((loadEditorConfigResult = (cachedEditorConfig2 = this.editorConfigsCache.compute((dir = (VirtualFile)iterator.next()).getUrl(), (arg_0, arg_1) -> EditorConfigPropertiesService.relevantEditorConfigsFor$lambda$5((Function2)new Function2<String, LoadEditorConfigResult, LoadEditorConfigResult>(dir, this){
            final /* synthetic */ VirtualFile $dir;
            final /* synthetic */ EditorConfigPropertiesService this$0;
            {
                this.$dir = $dir;
                this.this$0 = $receiver;
                super(2);
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final LoadEditorConfigResult invoke(@NotNull String string, @Nullable LoadEditorConfigResult cached) {
                LoadEditorConfigResult loadEditorConfigResult;
                Intrinsics.checkNotNullParameter((Object)string, (String)"<anonymous parameter 0>");
                if (cached != null) {
                    void $this$debug_u24default$iv;
                    Logger logger = EditorConfigPropertiesService.access$getLOG$cp();
                    VirtualFile virtualFile = this.$dir;
                    Throwable e$iv = null;
                    boolean $i$f$debug = false;
                    if ($this$debug_u24default$iv.isDebugEnabled()) {
                        void var8_10 = $this$debug_u24default$iv;
                        boolean bl = false;
                        var8_10.debug("cached config: " + virtualFile.getUrl(), e$iv);
                    }
                    return cached;
                }
                VirtualFile virtualFile = this.$dir.findChild(".editorconfig");
                if (virtualFile != null) {
                    VirtualFile virtualFile2 = virtualFile;
                    EditorConfigPropertiesService editorConfigPropertiesService = this.this$0;
                    VirtualFile it = virtualFile2;
                    boolean bl = false;
                    loadEditorConfigResult = EditorConfigPropertiesService.access$loadEditorConfig(editorConfigPropertiesService, it);
                } else {
                    loadEditorConfigResult = null;
                }
                return loadEditorConfigResult;
            }
        }, arg_0, arg_1)))) instanceof InvalidEditorConfig)) {
            if (loadEditorConfigResult instanceof ValidEditorConfig) {
                ((Collection)result2).add(cachedEditorConfig2);
                if (!((ValidEditorConfig)cachedEditorConfig2).getParsed().isRoot()) continue;
                Logger $this$debug_u24default$iv = LOG;
                Throwable e$iv = null;
                boolean $i$f$debug = false;
                if (!$this$debug_u24default$iv.isDebugEnabled()) break;
                Logger logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug("reached root config: " + dir.getUrl(), e$iv);
                break;
            }
            if (loadEditorConfigResult != null) continue;
        }
        return result2;
    }

    @NotNull
    public final ResourceProperties getProperties(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string = file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        return EditorConfigPropertiesServiceKt.access$mergeEditorConfigs(string, this.relevantEditorConfigsFor(file));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Pair<ResourceProperties, List<VirtualFile>> getPropertiesAndEditorConfigs(@NotNull VirtualFile file) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        List<ValidEditorConfig> editorConfigs2 = this.relevantEditorConfigsFor(file);
        String string = file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        ResourceProperties properties = EditorConfigPropertiesServiceKt.access$mergeEditorConfigs(string, editorConfigs2);
        Iterable iterable = editorConfigs2;
        ResourceProperties resourceProperties = properties;
        boolean $i$f$map = false;
        void var6_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            ValidEditorConfig validEditorConfig = (ValidEditorConfig)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.getFile());
        }
        List list = (List)destination$iv$iv;
        ResourceProperties resourceProperties2 = resourceProperties;
        return new Pair((Object)resourceProperties2, (Object)list);
    }

    public final void clearCache$intellij_editorconfig() {
        this.editorConfigsCache.clear();
    }

    private static final void getRootDirs$lambda$2$lambda$0(Set $dirs, EditorConfigPropertiesService this$0) {
        Intrinsics.checkNotNullParameter((Object)$dirs, (String)"$dirs");
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        $dirs.addAll(BaseProjectDirectories.Companion.getBaseDirectories(this$0.project));
    }

    private static final CachedValueProvider.Result getRootDirs$lambda$2(EditorConfigPropertiesService this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Set dirs = new HashSet();
        ReadAction.run(() -> EditorConfigPropertiesService.getRootDirs$lambda$2$lambda$0(dirs, this$0));
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(PathManager.getConfigPath());
        if (virtualFile != null) {
            VirtualFile it = virtualFile;
            boolean bl = false;
            dirs.add(it);
        }
        Object[] objectArray = new Object[]{ProjectRootModificationTracker.getInstance((Project)this$0.project)};
        return new CachedValueProvider.Result((Object)dirs, objectArray);
    }

    private static final LoadEditorConfigResult relevantEditorConfigsFor$lambda$5(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (LoadEditorConfigResult)$tmp0.invoke(p0, p1);
    }

    @JvmStatic
    @NotNull
    public static final EditorConfigPropertiesService getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    public static final /* synthetic */ LoadEditorConfigResult access$loadEditorConfig(EditorConfigPropertiesService $this, VirtualFile file) {
        return $this.loadEditorConfig(file);
    }

    static {
        Companion $this$thisLogger$iv = Companion = new Companion(null);
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/editorconfig/plugincomponents/EditorConfigPropertiesService$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getInstance", "Lorg/editorconfig/plugincomponents/EditorConfigPropertiesService;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.editorconfig"})
    @SourceDebugExtension(value={"SMAP\nEditorConfigPropertiesService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorConfigPropertiesService.kt\norg/editorconfig/plugincomponents/EditorConfigPropertiesService$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,163:1\n31#2,2:164\n*S KotlinDebug\n*F\n+ 1 EditorConfigPropertiesService.kt\norg/editorconfig/plugincomponents/EditorConfigPropertiesService$Companion\n*L\n41#1:164,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final EditorConfigPropertiesService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<EditorConfigPropertiesService> serviceClass$iv = EditorConfigPropertiesService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (EditorConfigPropertiesService)((Object)object);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

