/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.language.codeinsight.quickfixes;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.editorconfig.language.messages.EditorConfigBundle;
import org.editorconfig.language.psi.EditorConfigHeader;
import org.editorconfig.language.services.EditorConfigElementFactory;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\r\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/editorconfig/language/codeinsight/quickfixes/EditorConfigInsertStarQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "Lorg/jetbrains/annotations/Nls;", "intellij.editorconfig"})
public final class EditorConfigInsertStarQuickFix
implements LocalQuickFix {
    @NotNull
    public String getFamilyName() {
        return EditorConfigBundle.INSTANCE.get("quickfix.header.insert.star.description");
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        PsiElement psiElement = descriptor2.getPsiElement();
        EditorConfigHeader editorConfigHeader = psiElement instanceof EditorConfigHeader ? (EditorConfigHeader)psiElement : null;
        if (editorConfigHeader == null) {
            return;
        }
        EditorConfigHeader header = editorConfigHeader;
        EditorConfigElementFactory factory = EditorConfigElementFactory.Companion.getInstance(project);
        EditorConfigHeader newHeader = factory.createHeader("[*]");
        CodeStyleManager.getInstance((Project)project).performActionWithFormatterDisabled(() -> EditorConfigInsertStarQuickFix.applyFix$lambda$0(header, newHeader));
    }

    private static final void applyFix$lambda$0(EditorConfigHeader $header, EditorConfigHeader $newHeader) {
        Intrinsics.checkNotNullParameter((Object)$header, (String)"$header");
        Intrinsics.checkNotNullParameter((Object)$newHeader, (String)"$newHeader");
        $header.replace($newHeader);
    }
}

