/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh.ui;

import com.intellij.codeWithMe.ClientId;
import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ssh.AuthFailSshTransportException;
import com.intellij.ssh.SshBundle;
import com.intellij.ssh.SshConnectionService;
import com.intellij.ssh.SshSession;
import com.intellij.ssh.ui.SshConnectionStateListener;
import com.intellij.ssh.ui.SshLoginDialog;
import com.intellij.ssh.ui.SshPasswordPrompt;
import com.intellij.ssh.ui.SshUIUtil;
import com.intellij.ssh.ui.SshUiExtensions;
import com.intellij.ssh.ui.UISshPasswordPrompt;
import com.intellij.ssh.ui.UISshPasswordPromptKt;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.messages.MessageBusConnection;
import java.awt.Component;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000fH\u0002J\b\u0010\u0015\u001a\u00020\u0013H\u0002J\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0014\u001a\u00020\u000fH\u0016J\u0010\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u0006H\u0002J\u0010\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000fH\u0002J\b\u0010\u001d\u001a\u00020\u0011H\u0002J\u001e\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000f2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00130 H\u0002J\u0010\u0010!\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000fH\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R4\u0010\u0007\u001a(\u0012\t\u0012\u00070\u0006\u00a2\u0006\u0002\b\t \u000b*\u0012\u0012\t\u0012\u00070\u0006\u00a2\u0006\u0002\b\t0\n\u00a2\u0006\u0002\b\t0\b\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/ssh/ui/UISshPasswordPrompt;", "Lcom/intellij/ssh/ui/SshPasswordPrompt;", "()V", "currentDialog", "Lcom/intellij/ssh/ui/SshLoginDialog;", "currentUserHostPort", "Lcom/intellij/ssh/ui/SshPasswordPrompt$UserHostPort;", "ignoredConnections", "", "Lorg/jetbrains/annotations/NotNull;", "", "kotlin.jvm.PlatformType", "requests", "Ljava/util/LinkedHashMap;", "Ljava/util/Deque;", "Lcom/intellij/ssh/ui/SshPasswordPrompt$Request;", "canShowBalloons", "", "closeCurrentServerDialog", "", "request", "findAndExecuteRequest", "handleRequest", "", "project", "Lcom/intellij/openapi/project/Project;", "ignoreUntilRestart", "userHostPort", "initAndShowCurrentDialog", "isNotNonModal", "showBalloon", "dialog", "Lkotlin/Function0;", "updateCurrentDialog", "intellij.platform.ssh.ui"})
@SourceDebugExtension(value={"SMAP\nUISshPasswordPrompt.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UISshPasswordPrompt.kt\ncom/intellij/ssh/ui/UISshPasswordPrompt\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,210:1\n40#2,3:211\n40#2,3:214\n288#3,2:217\n1#4:219\n*S KotlinDebug\n*F\n+ 1 UISshPasswordPrompt.kt\ncom/intellij/ssh/ui/UISshPasswordPrompt\n*L\n107#1:211,3\n125#1:214,3\n183#1:217,2\n*E\n"})
public final class UISshPasswordPrompt
implements SshPasswordPrompt {
    @NotNull
    private final LinkedHashMap<SshPasswordPrompt.UserHostPort, Deque<SshPasswordPrompt.Request>> requests;
    @NotNull
    private final Set<SshPasswordPrompt.UserHostPort> ignoredConnections;
    @Nullable
    private volatile SshPasswordPrompt.UserHostPort currentUserHostPort;
    @Nullable
    private volatile SshLoginDialog currentDialog;

    public UISshPasswordPrompt() {
        MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect();
        connection.subscribe(SshConnectionStateListener.Companion.getAUTH_TOPIC(), (Object)new SshConnectionStateListener(){

            @Override
            public void authenticationFinished(@NotNull String user2, @NotNull String host2, int port2) {
                Intrinsics.checkNotNullParameter((Object)user2, (String)"user");
                Intrinsics.checkNotNullParameter((Object)host2, (String)"host");
                ActionsKt.invokeLater((ModalityState)ModalityState.any(), (Function0)((Function0)new Function0<Unit>(user2, host2, port2, this){
                    final /* synthetic */ String $user;
                    final /* synthetic */ String $host;
                    final /* synthetic */ int $port;
                    final /* synthetic */ UISshPasswordPrompt this$0;
                    {
                        this.$user = $user;
                        this.$host = $host;
                        this.$port = $port;
                        this.this$0 = $receiver;
                        super(0);
                    }

                    public final void invoke() {
                        SshPasswordPrompt.UserHostPort uhp = new SshPasswordPrompt.UserHostPort(this.$user, this.$host, this.$port);
                        Deque deque = (Deque)UISshPasswordPrompt.access$getRequests$p(this.this$0).get(uhp);
                        if (deque != null) {
                            deque.add(new SshPasswordPrompt.Request.Done(uhp));
                            UISshPasswordPrompt.access$findAndExecuteRequest(this.this$0);
                        }
                    }
                }));
            }

            @Override
            public void connectionCreated(@NotNull SshSession session) {
                Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            }
        });
        connection.subscribe(SshConnectionService.Companion.getTOPIC(), (Object)new SshConnectionService.Listener(){

            @Override
            public void sessionOrChannelRequested(@NotNull String userName, @NotNull String host2, int port2) {
                Intrinsics.checkNotNullParameter((Object)userName, (String)"userName");
                Intrinsics.checkNotNullParameter((Object)host2, (String)"host");
                ActionsKt.invokeLater((ModalityState)ModalityState.any(), (Function0)((Function0)new Function0<Unit>(userName, host2, port2, this){
                    final /* synthetic */ String $userName;
                    final /* synthetic */ String $host;
                    final /* synthetic */ int $port;
                    final /* synthetic */ UISshPasswordPrompt this$0;
                    {
                        this.$userName = $userName;
                        this.$host = $host;
                        this.$port = $port;
                        this.this$0 = $receiver;
                        super(0);
                    }

                    public final void invoke() {
                        SshPasswordPrompt.UserHostPort uhp = new SshPasswordPrompt.UserHostPort(this.$userName, this.$host, this.$port);
                        if (UISshPasswordPrompt.access$getCurrentDialog$p(this.this$0) == null && UISshPasswordPrompt.access$getCurrentUserHostPort$p(this.this$0) == null && UISshPasswordPrompt.access$isNotNonModal(this.this$0)) {
                            SshPasswordPrompt.Request request;
                            Deque deque = (Deque)UISshPasswordPrompt.access$getRequests$p(this.this$0).get(uhp);
                            SshPasswordPrompt.Request request2 = request = deque != null ? (SshPasswordPrompt.Request)deque.poll() : null;
                            if (request != null) {
                                UISshPasswordPrompt.access$setCurrentUserHostPort$p(this.this$0, uhp);
                                UISshPasswordPrompt.access$initAndShowCurrentDialog(this.this$0, request);
                            }
                        }
                    }
                }));
            }
        });
        this.requests = new LinkedHashMap();
        Set set = ConcurrentCollectionFactory.createConcurrentSet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"createConcurrentSet(...)");
        this.ignoredConnections = set;
    }

    private final void initAndShowCurrentDialog(SshPasswordPrompt.Request request) {
        block0: {
            SshLoginDialog sshLoginDialog;
            ThreadingAssertions.assertEventDispatchThread();
            UISshPasswordPromptKt.access$getLOG$p().debug("Showing password prompt dialog for " + request);
            SshPasswordPrompt.UserHostPort userHostPort = request.getUserHostPort();
            SshLoginDialog sshLoginDialog2 = this.currentDialog = new SshLoginDialog(null, userHostPort, (Function0<Unit>)((Function0)new Function0<Unit>(this, userHostPort){
                final /* synthetic */ UISshPasswordPrompt this$0;
                final /* synthetic */ SshPasswordPrompt.UserHostPort $userHostPort;
                {
                    this.this$0 = $receiver;
                    this.$userHostPort = $userHostPort;
                    super(0);
                }

                public final void invoke() {
                    UISshPasswordPrompt.access$ignoreUntilRestart(this.this$0, this.$userHostPort);
                }
            }));
            Intrinsics.checkNotNull((Object)((Object)sshLoginDialog2));
            SshLoginDialog dialog = sshLoginDialog = sshLoginDialog2;
            boolean bl = false;
            dialog.repaintOnRequest$intellij_platform_ssh_ui(request);
            dialog.show();
            JComponent jComponent = dialog.getPreferredFocusedComponent();
            if (jComponent == null) break block0;
            JComponent component = jComponent;
            boolean bl2 = false;
            IdeFocusManager.getGlobalInstance().requestFocus((Component)component, true);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void showBalloon(SshPasswordPrompt.Request request, Function0<Unit> dialog) {
        Notification notification;
        void $this$showBalloon_u24lambda_u242;
        NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup("SSH Connections");
        SshPasswordPrompt.UserHostPort userHostPort = request.getUserHostPort();
        String string = notificationGroup.getDisplayId();
        boolean bl = false;
        Object[] objectArray = new Object[]{$this$showBalloon_u24lambda_u242.getUser(), $this$showBalloon_u24lambda_u242.getHost() + ":" + $this$showBalloon_u24lambda_u242.getPort()};
        NotificationType notificationType = NotificationType.WARNING;
        String string2 = SshBundle.message("ssh.connection.prompt.message", new Object[0]);
        String string3 = SshBundle.message("ssh.connection.notification.title", objectArray);
        String string4 = string;
        Notification $this$showBalloon_u24lambda_u245 = notification = new Notification(string4, string3, string2, notificationType).setCollapseDirection(Notification.CollapseActionsDirection.KEEP_LEFTMOST).setDropDownText(SshBundle.message("ssh.connection.notification.more.actions", new Object[0])).addAction((AnAction)NotificationAction.createSimpleExpiring((String)SshBundle.message("ssh.connection.notification.enter.password", new Object[0]), () -> UISshPasswordPrompt.showBalloon$lambda$3(dialog)));
        boolean bl2 = false;
        boolean $i$f$service = false;
        Class<SshUiExtensions> serviceClass$iv = SshUiExtensions.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        if (((SshUiExtensions)object).allowIgnoreLoginUntilRestart()) {
            $this$showBalloon_u24lambda_u245.addAction((AnAction)NotificationAction.createSimpleExpiring((String)SshBundle.message("ssh.connection.ignore.until.restart", new Object[0]), () -> UISshPasswordPrompt.showBalloon$lambda$5$lambda$4(this, request)));
        }
        Notification notification2 = notification.addAction((AnAction)NotificationAction.createSimple((String)SshBundle.message("ssh.connection.notification.manage.ssh.configurations", new Object[0]), UISshPasswordPrompt::showBalloon$lambda$6));
        Intrinsics.checkNotNullExpressionValue((Object)notification2, (String)"addAction(...)");
        Notification msg = notification2;
        UISshPasswordPromptKt.access$getLOG$p().debug("Showing password prompt balloon for " + request);
        ActionsKt.invokeLater$default(null, (Function0)((Function0)new Function0<Unit>(msg){
            final /* synthetic */ Notification $msg;
            {
                this.$msg = $msg;
                super(0);
            }

            public final void invoke() {
                this.$msg.notify(null);
            }
        }), (int)1, null);
    }

    private final boolean canShowBalloons() {
        boolean $i$f$service = false;
        Class<SshUiExtensions> serviceClass$iv = SshUiExtensions.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        return ((SshUiExtensions)object).doesSupportShowingBalloons();
    }

    @Override
    @Nullable
    public String handleRequest(@Nullable Project project2, @NotNull SshPasswordPrompt.Request request) {
        String string;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (this.ignoredConnections.contains(request.getUserHostPort())) {
            UISshPasswordPromptKt.access$getLOG$p().info("Ignoring " + request + " which credentials were marked as ignored until restart");
            throw new AuthFailSshTransportException("Still ignoring " + request.getUserHostPort() + " until IDE restart", new Attachment[0]);
        }
        boolean showDialogImmediately = !this.canShowBalloons() || this.isNotNonModal();
        ActionsKt.invokeLater((ModalityState)ModalityState.any(), (Function0)((Function0)new Function0<Unit>(this, request, showDialogImmediately){
            final /* synthetic */ UISshPasswordPrompt this$0;
            final /* synthetic */ SshPasswordPrompt.Request $request;
            final /* synthetic */ boolean $showDialogImmediately;
            {
                this.this$0 = $receiver;
                this.$request = $request;
                this.$showDialogImmediately = $showDialogImmediately;
                super(0);
            }

            public final void invoke() {
                UISshPasswordPrompt.access$getRequests$p(this.this$0).computeIfAbsent(this.$request.getUserHostPort(), arg_0 -> handleRequest.1.invoke$lambda$0(handleRequest.1.INSTANCE, arg_0)).add(this.$request);
                if (this.$showDialogImmediately) {
                    UISshPasswordPrompt.access$findAndExecuteRequest(this.this$0);
                } else {
                    UISshPasswordPrompt.access$showBalloon(this.this$0, this.$request, (Function0)new Function0<Unit>(this.this$0){
                        final /* synthetic */ UISshPasswordPrompt this$0;
                        {
                            this.this$0 = $receiver;
                            super(0);
                        }

                        public final void invoke() {
                            UISshPasswordPrompt.access$findAndExecuteRequest(this.this$0);
                        }
                    });
                }
            }

            private static final Deque invoke$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                return (Deque)$tmp0.invoke(p0);
            }
        }));
        while (!request.getLatch().await(500L, TimeUnit.MILLISECONDS)) {
            ProgressIndicator progressIndicator2 = request.getProgressIndicator();
            if (progressIndicator2 == null) continue;
            progressIndicator2.checkCanceled();
        }
        String password = request.getResult().get();
        if (password == null) {
            this.closeCurrentServerDialog(request);
            UISshPasswordPromptKt.access$getLOG$p().info("Password request is cancelled: " + request);
            throw new AuthFailSshTransportException("Cancelled by user", new Attachment[0]);
        }
        if (Intrinsics.areEqual((Object)password, (Object)"")) {
            UISshPasswordPromptKt.access$getLOG$p().info("Password request is skipped: " + request);
            string = null;
        } else {
            UISshPasswordPromptKt.access$getLOG$p().debug("Provided a password: " + request);
            string = password;
        }
        return string;
    }

    private final void ignoreUntilRestart(SshPasswordPrompt.UserHostPort userHostPort) {
        UISshPasswordPromptKt.access$getLOG$p().info(userHostPort + " is marked as ignored until restart. Will not ask any password for the server anymore.");
        ((Collection)this.ignoredConnections).add(userHostPort);
    }

    private final void closeCurrentServerDialog(SshPasswordPrompt.Request request) {
        SwingUtilities.invokeLater(() -> UISshPasswordPrompt.closeCurrentServerDialog$lambda$7(this, request));
    }

    private final boolean isNotNonModal() {
        return (Boolean)ActionsKt.invokeAndWaitIfNeeded((ModalityState)ModalityState.any(), (Function0)isNotNonModal.1.INSTANCE);
    }

    private final void findAndExecuteRequest() {
        block3: {
            block2: {
                Object v3;
                block1: {
                    ThreadingAssertions.assertEventDispatchThread();
                    if (this.currentUserHostPort != null) break block2;
                    Set<Map.Entry<SshPasswordPrompt.UserHostPort, Deque<SshPasswordPrompt.Request>>> set = this.requests.entrySet();
                    Intrinsics.checkNotNullExpressionValue(set, (String)"<get-entries>(...)");
                    Iterable $this$firstOrNull$iv = set;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        Map.Entry it = (Map.Entry)element$iv;
                        boolean bl = false;
                        Object v = it.getValue();
                        Intrinsics.checkNotNullExpressionValue(v, (String)"<get-value>(...)");
                        boolean bl2 = !((Collection)v).isEmpty();
                        if (!bl2) continue;
                        v3 = element$iv;
                        break block1;
                    }
                    v3 = null;
                }
                Map.Entry entry = v3;
                if (entry == null) break block3;
                SshPasswordPrompt.Request request = (SshPasswordPrompt.Request)((Deque)entry.getValue()).poll();
                this.currentUserHostPort = (SshPasswordPrompt.UserHostPort)entry.getKey();
                Intrinsics.checkNotNull((Object)request);
                this.initAndShowCurrentDialog(request);
                break block3;
            }
            SshPasswordPrompt.UserHostPort userHostPort = this.currentUserHostPort;
            Object object = (Deque)((Map)this.requests).get(userHostPort);
            if (object == null || (object = (SshPasswordPrompt.Request)object.poll()) == null) break block3;
            Object it = object;
            boolean bl = false;
            this.updateCurrentDialog((SshPasswordPrompt.Request)it);
        }
    }

    private final void updateCurrentDialog(SshPasswordPrompt.Request request) {
        block2: {
            block1: {
                ThreadingAssertions.assertEventDispatchThread();
                if (!(request instanceof SshPasswordPrompt.Request.Done)) break block1;
                SshLoginDialog sshLoginDialog = this.currentDialog;
                if (sshLoginDialog != null) {
                    sshLoginDialog.close(0);
                }
                this.currentDialog = null;
                this.requests.remove(request.getUserHostPort());
                this.currentUserHostPort = null;
                this.findAndExecuteRequest();
                break block2;
            }
            SshLoginDialog sshLoginDialog = this.currentDialog;
            if (sshLoginDialog == null) break block2;
            sshLoginDialog.repaintOnRequest$intellij_platform_ssh_ui(request);
        }
    }

    private static final void showBalloon$lambda$3(Function0 $dialog) {
        Intrinsics.checkNotNullParameter((Object)$dialog, (String)"$dialog");
        $dialog.invoke();
    }

    private static final void showBalloon$lambda$5$lambda$4(UISshPasswordPrompt this$0, SshPasswordPrompt.Request $request) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$request, (String)"$request");
        this$0.ignoreUntilRestart($request.getUserHostPort());
        $request.getResult().set(null);
        $request.getLatch().countDown();
    }

    private static final void showBalloon$lambda$6() {
        SshUIUtil.manageSshConfiguration();
    }

    private static final void closeCurrentServerDialog$lambda$7(UISshPasswordPrompt this$0, SshPasswordPrompt.Request $request) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$request, (String)"$request");
        this$0.updateCurrentDialog(new SshPasswordPrompt.Request.Done($request.getUserHostPort()));
    }

    public static final /* synthetic */ void access$ignoreUntilRestart(UISshPasswordPrompt $this, SshPasswordPrompt.UserHostPort userHostPort) {
        $this.ignoreUntilRestart(userHostPort);
    }

    public static final /* synthetic */ LinkedHashMap access$getRequests$p(UISshPasswordPrompt $this) {
        return $this.requests;
    }

    public static final /* synthetic */ void access$findAndExecuteRequest(UISshPasswordPrompt $this) {
        $this.findAndExecuteRequest();
    }

    public static final /* synthetic */ void access$showBalloon(UISshPasswordPrompt $this, SshPasswordPrompt.Request request, Function0 dialog) {
        $this.showBalloon(request, (Function0<Unit>)dialog);
    }

    public static final /* synthetic */ SshLoginDialog access$getCurrentDialog$p(UISshPasswordPrompt $this) {
        return $this.currentDialog;
    }

    public static final /* synthetic */ SshPasswordPrompt.UserHostPort access$getCurrentUserHostPort$p(UISshPasswordPrompt $this) {
        return $this.currentUserHostPort;
    }

    public static final /* synthetic */ boolean access$isNotNonModal(UISshPasswordPrompt $this) {
        return $this.isNotNonModal();
    }

    public static final /* synthetic */ void access$setCurrentUserHostPort$p(UISshPasswordPrompt $this, SshPasswordPrompt.UserHostPort userHostPort) {
        $this.currentUserHostPort = userHostPort;
    }

    public static final /* synthetic */ void access$initAndShowCurrentDialog(UISshPasswordPrompt $this, SshPasswordPrompt.Request request) {
        $this.initAndShowCurrentDialog(request);
    }
}

