/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh.impl.sshj.tunnels;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ssh.SshTunnelListener;
import com.intellij.ssh.impl.sshj.UtilKt;
import com.intellij.ssh.impl.sshj.channels.EofSendingOutputStream;
import com.intellij.ssh.impl.sshj.tunnels.ShutdowningSocketInputStream;
import com.intellij.ssh.impl.sshj.tunnels.ShutdowningSocketOutputStream;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.schmizz.sshj.connection.ConnectionException;
import net.schmizz.sshj.connection.channel.Channel;
import net.schmizz.sshj.transport.Transport;
import net.schmizz.sshj.transport.TransportException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000r\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0018\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a6\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002\u001a\u0018\u0010\u001e\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020 H\u0002\u001a>\u0010!\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00170#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00190#2\b\b\u0002\u0010%\u001a\u00020\u0001H\u0000\u001a0\u0010&\u001a\u00020\u0012\"\b\b\u0000\u0010'*\u00020(*\u0002H'2\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u0002H'\u0012\u0004\u0012\u00020\u00120*H\u0082\b\u00a2\u0006\u0002\u0010+\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0015\u0010\b\u001a\u00020\t*\u00020\u00038G\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006,"}, d2={"SO_TIMEOUT_MILLIS", "", "successMarker", "Ljava/io/IOException;", "threadSocketExceptionHandler", "Ljava/lang/Thread$UncaughtExceptionHandler;", "getThreadSocketExceptionHandler", "()Ljava/lang/Thread$UncaughtExceptionHandler;", "causedByConnectionLoss", "", "getCausedByConnectionLoss", "(Ljava/io/IOException;)Z", "copier", "input", "Ljava/io/InputStream;", "output", "Ljava/io/OutputStream;", "launchCopiersAndWait", "", "threads", "", "Ljava/lang/Thread;", "socket", "Ljava/net/Socket;", "channel", "Lnet/schmizz/sshj/connection/channel/Channel;", "sshjTransport", "Lnet/schmizz/sshj/transport/Transport;", "brokerName", "", "readHandlingTimeout", "buffer", "", "singleTunnelBroker", "socketSupplier", "Lkotlin/Function0;", "channelSupplier", "soTimeout", "useEatingExceptions", "T", "Ljava/io/Closeable;", "handler", "Lkotlin/Function1;", "(Ljava/io/Closeable;Lkotlin/jvm/functions/Function1;)V", "intellij.platform.ssh"})
@SourceDebugExtension(value={"SMAP\nSingleTunnelBroker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SingleTunnelBroker.kt\ncom/intellij/ssh/impl/sshj/tunnels/SingleTunnelBrokerKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,263:1\n134#1,2:264\n134#1,16:266\n138#1,12:282\n1855#2,2:294\n1855#2,2:296\n1855#2,2:298\n65#3,4:300\n*S KotlinDebug\n*F\n+ 1 SingleTunnelBroker.kt\ncom/intellij/ssh/impl/sshj/tunnels/SingleTunnelBrokerKt\n*L\n43#1:264,2\n59#1:266,16\n43#1:282,12\n67#1:294,2\n116#1:296,2\n130#1:298,2\n163#1:300,4\n*E\n"})
public final class SingleTunnelBrokerKt {
    @NotNull
    private static final Thread.UncaughtExceptionHandler threadSocketExceptionHandler = SingleTunnelBrokerKt::threadSocketExceptionHandler$lambda$2;
    @NotNull
    private static final IOException successMarker = new IOException("<success singleton>");
    private static final int SO_TIMEOUT_MILLIS = 20000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void singleTunnelBroker(@NotNull String brokerName, @NotNull Transport sshjTransport, @NotNull Function0<? extends Socket> socketSupplier, @NotNull Function0<? extends Channel> channelSupplier, int soTimeout) {
        block25: {
            Intrinsics.checkNotNullParameter((Object)brokerName, (String)"brokerName");
            Intrinsics.checkNotNullParameter((Object)sshjTransport, (String)"sshjTransport");
            Intrinsics.checkNotNullParameter(socketSupplier, (String)"socketSupplier");
            Intrinsics.checkNotNullParameter(channelSupplier, (String)"channelSupplier");
            List threads = new ArrayList();
            try {
                Socket socket;
                Socket socket2;
                try {
                    socket2 = (Socket)socketSupplier.invoke();
                }
                catch (SocketException e) {
                    UtilKt.getSSHJ_LOG().warn("Error in `" + Thread.currentThread().getName() + "`", (Throwable)e);
                    socket2 = null;
                }
                Socket socket3 = socket = socket2;
                if (socket3 == null) break block25;
                Closeable $this$useEatingExceptions$iv = socket3;
                boolean $i$f$useEatingExceptions = false;
                try {
                    Channel channel2;
                    Channel channel3;
                    Socket it = (Socket)$this$useEatingExceptions$iv;
                    boolean bl = false;
                    socket.setSoTimeout(soTimeout);
                    try {
                        channel3 = (Channel)channelSupplier.invoke();
                    }
                    catch (IOException e) {
                        MessageBus messageBus = ApplicationManager.getApplication().getMessageBus();
                        Topic<SshTunnelListener> topic = SshTunnelListener.TOPIC;
                        Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
                        ((SshTunnelListener)messageBus.syncPublisher(topic)).onError(socket.getLocalPort(), e);
                        if (!SingleTunnelBrokerKt.getCausedByConnectionLoss(e)) {
                            throw e;
                        }
                        UtilKt.getSSHJ_LOG().info("Error in `" + Thread.currentThread().getName() + "`: " + e.getClass().getName() + ": " + e.getMessage());
                        channel3 = null;
                    }
                    Channel channel4 = channel2 = channel3;
                    if (channel4 == null) break block25;
                    Closeable $this$useEatingExceptions$iv2 = (Closeable)channel4;
                    boolean $i$f$useEatingExceptions2 = false;
                    try {
                        Channel it2 = (Channel)$this$useEatingExceptions$iv2;
                        boolean bl2 = false;
                        socket.setSendBufferSize(channel2.getLocalMaxPacketSize());
                        socket.setReceiveBufferSize(channel2.getRemoteMaxPacketSize());
                        SingleTunnelBrokerKt.launchCopiersAndWait(threads, socket, channel2, sshjTransport, brokerName);
                    }
                    finally {
                        try {
                            $this$useEatingExceptions$iv2.close();
                        }
                        catch (Throwable e$iv) {
                            if (e$iv instanceof IOException && SingleTunnelBrokerKt.getCausedByConnectionLoss((IOException)e$iv)) {
                                UtilKt.getSSHJ_LOG().info("Error from " + Thread.currentThread().getName() + " while was closing " + $this$useEatingExceptions$iv2, e$iv);
                            }
                            UtilKt.getSSHJ_LOG().error("Error from " + Thread.currentThread().getName(), e$iv);
                        }
                    }
                }
                finally {
                    try {
                        $this$useEatingExceptions$iv.close();
                    }
                    catch (Throwable e$iv) {
                        if (e$iv instanceof IOException && SingleTunnelBrokerKt.getCausedByConnectionLoss((IOException)e$iv)) {
                            UtilKt.getSSHJ_LOG().info("Error from " + Thread.currentThread().getName() + " while was closing " + $this$useEatingExceptions$iv, e$iv);
                        }
                        UtilKt.getSSHJ_LOG().error("Error from " + Thread.currentThread().getName(), e$iv);
                    }
                }
            }
            finally {
                Iterable $this$forEach$iv = threads;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Thread p0 = (Thread)element$iv;
                    boolean bl = false;
                    p0.join();
                }
                UtilKt.getSSHJ_LOG().debug("Finished " + Thread.currentThread().getName());
            }
        }
    }

    public static /* synthetic */ void singleTunnelBroker$default(String string, Transport transport, Function0 function0, Function0 function02, int n, int n2, Object object) {
        if ((n2 & 0x10) != 0) {
            n = 20000;
        }
        SingleTunnelBrokerKt.singleTunnelBroker(string, transport, (Function0<? extends Socket>)function0, (Function0<? extends Channel>)function02, n);
    }

    @NotNull
    public static final Thread.UncaughtExceptionHandler getThreadSocketExceptionHandler() {
        return threadSocketExceptionHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final void launchCopiersAndWait(List<Thread> threads, Socket socket, Channel channel2, Transport sshjTransport, String brokerName) {
        boolean $i$f$forEach;
        try {
            void $this$launchCopiersAndWait_u24lambda_u246;
            Thread $this$launchCopiersAndWait_u24lambda_u244;
            Thread thread;
            ArrayBlockingQueue resultQueue = new ArrayBlockingQueue(2);
            Thread thread2 = thread = new Thread(() -> SingleTunnelBrokerKt.launchCopiersAndWait$lambda$3(socket, sshjTransport, channel2, resultQueue));
            List<Thread> list2 = threads;
            boolean bl = false;
            $this$launchCopiersAndWait_u24lambda_u244.setName(brokerName + ": local to remote copier");
            $this$launchCopiersAndWait_u24lambda_u244.setDaemon(true);
            $this$launchCopiersAndWait_u24lambda_u244.setUncaughtExceptionHandler(threadSocketExceptionHandler);
            list2.add(thread);
            $this$launchCopiersAndWait_u24lambda_u244 = thread = new Thread(() -> SingleTunnelBrokerKt.launchCopiersAndWait$lambda$5(channel2, socket, resultQueue));
            list2 = threads;
            boolean bl2 = false;
            $this$launchCopiersAndWait_u24lambda_u246.setName(brokerName + ": remote to local copier");
            $this$launchCopiersAndWait_u24lambda_u246.setDaemon(true);
            $this$launchCopiersAndWait_u24lambda_u246.setUncaughtExceptionHandler(threadSocketExceptionHandler);
            list2.add(thread);
            Iterable $this$forEach$iv = threads;
            boolean $i$f$forEach22 = false;
            for (Object element$iv : $this$forEach$iv) {
                Thread p0 = (Thread)element$iv;
                boolean bl3 = false;
                p0.start();
            }
            for (int ignored = 0; ignored < 2; ++ignored) {
                Pair $i$f$forEach22 = (Pair)resultQueue.take();
                Thread thread3 = (Thread)$i$f$forEach22.component1();
                IOException result2 = (IOException)$i$f$forEach22.component2();
                if (result2 == successMarker) continue;
                UtilKt.getSSHJ_LOG().error("Error from " + thread3.getName(), (Throwable)result2);
                break;
            }
        }
        catch (InterruptedException e) {
            boolean bl = $i$f$forEach = !Thread.currentThread().isInterrupted();
            if (_Assertions.ENABLED) {
                if (!$i$f$forEach) {
                    String $i$f$forEach22 = "Assertion failed";
                    throw new AssertionError((Object)$i$f$forEach22);
                }
            }
        }
        finally {
            Iterable $this$forEach$iv = threads;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Thread p0 = (Thread)element$iv;
                boolean bl = false;
                p0.interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final <T extends Closeable> void useEatingExceptions(T $this$useEatingExceptions, Function1<? super T, Unit> handler) {
        boolean $i$f$useEatingExceptions = false;
        try {
            handler.invoke($this$useEatingExceptions);
        }
        finally {
            InlineMarker.finallyStart((int)1);
            try {
                $this$useEatingExceptions.close();
            }
            catch (Throwable e) {
                if (e instanceof IOException && SingleTunnelBrokerKt.getCausedByConnectionLoss((IOException)e)) {
                    UtilKt.getSSHJ_LOG().info("Error from " + Thread.currentThread().getName() + " while was closing " + $this$useEatingExceptions, e);
                }
                UtilKt.getSSHJ_LOG().error("Error from " + Thread.currentThread().getName(), e);
            }
            InlineMarker.finallyEnd((int)1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final IOException copier(InputStream input, OutputStream output) {
        Object object;
        try {
            IOException iOException;
            object = input;
            Throwable throwable = null;
            try {
                IOException iOException2;
                InputStream it = (InputStream)object;
                boolean bl = false;
                Closeable closeable = output;
                Throwable throwable2 = null;
                try {
                    OutputStream it2 = (OutputStream)closeable;
                    boolean bl2 = false;
                    byte[] buffer = new byte[8192];
                    int bytes = 0;
                    bytes = SingleTunnelBrokerKt.readHandlingTimeout(input, buffer);
                    while (bytes >= 0 && !Thread.currentThread().isInterrupted()) {
                        Logger $this$trace$iv = UtilKt.getSSHJ_LOG();
                        boolean $i$f$trace = false;
                        if ($this$trace$iv.isTraceEnabled()) {
                            Logger logger = $this$trace$iv;
                            boolean bl3 = false;
                            logger.trace("Copier: " + input + " -> " + output + ": `" + UtilKt.escapeLikeStrace$default(buffer, 0, bytes, 1, null) + "`");
                        }
                        output.write(buffer, 0, bytes);
                        if (input.available() == 0) {
                            output.flush();
                        }
                        bytes = SingleTunnelBrokerKt.readHandlingTimeout(input, buffer);
                    }
                    iOException2 = successMarker;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable2);
                }
                iOException = iOException2;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            object = iOException;
        }
        catch (IOException e) {
            IOException iOException;
            if (SingleTunnelBrokerKt.getCausedByConnectionLoss(e)) {
                UtilKt.getSSHJ_LOG().info("Error from " + Thread.currentThread().getName() + ": " + e.getClass().getName() + ": " + e.getMessage());
                iOException = successMarker;
            } else {
                iOException = e;
            }
            object = iOException;
        }
        catch (Throwable e) {
            object = new IOException(e);
        }
        finally {
            UtilKt.getSSHJ_LOG().debug("Finished " + Thread.currentThread().getName());
        }
        return object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @VisibleForTesting
    public static final boolean getCausedByConnectionLoss(@NotNull IOException $this$causedByConnectionLoss) {
        Intrinsics.checkNotNullParameter((Object)$this$causedByConnectionLoss, (String)"<this>");
        if (ExceptionUtil.causedBy((Throwable)$this$causedByConnectionLoss, SocketException.class)) return true;
        if ($this$causedByConnectionLoss instanceof ConnectionException) return true;
        TransportException transportException = (TransportException)((Object)ExceptionUtil.findCause((Throwable)$this$causedByConnectionLoss, TransportException.class));
        String it = transportException != null ? transportException.getMessage() : null;
        boolean bl = false;
        if (Intrinsics.areEqual((Object)it, (Object)"Broken transport; encountered EOF")) return true;
        if (Intrinsics.areEqual((Object)it, (Object)"Stream Closed")) {
            return true;
        }
        boolean bl2 = false;
        if (bl2) return true;
        if (!Intrinsics.areEqual((Object)$this$causedByConnectionLoss.getMessage(), (Object)"Stream closed.")) return false;
        return true;
    }

    private static final int readHandlingTimeout(InputStream input, byte[] buffer) {
        int n;
        try {
            n = input.read(buffer);
        }
        catch (SocketTimeoutException e) {
            n = 0;
        }
        return n;
    }

    private static final void threadSocketExceptionHandler$lambda$2(Thread thread, Throwable error2) {
        if (error2 instanceof IOException && SingleTunnelBrokerKt.getCausedByConnectionLoss((IOException)error2)) {
            UtilKt.getSSHJ_LOG().info("Error from `" + thread.getName() + "``: " + error2.getClass().getName() + ": " + error2.getMessage());
        } else {
            UtilKt.getSSHJ_LOG().error("Error from `" + thread.getName() + "`", error2);
        }
    }

    private static final void launchCopiersAndWait$lambda$3(Socket $socket, Transport $sshjTransport, Channel $channel, ArrayBlockingQueue $resultQueue) {
        Intrinsics.checkNotNullParameter((Object)$socket, (String)"$socket");
        Intrinsics.checkNotNullParameter((Object)$sshjTransport, (String)"$sshjTransport");
        Intrinsics.checkNotNullParameter((Object)$channel, (String)"$channel");
        Intrinsics.checkNotNullParameter((Object)$resultQueue, (String)"$resultQueue");
        ShutdowningSocketInputStream input = new ShutdowningSocketInputStream($socket);
        OutputStream outputStream2 = $channel.getOutputStream();
        Intrinsics.checkNotNullExpressionValue((Object)outputStream2, (String)"getOutputStream(...)");
        EofSendingOutputStream output = new EofSendingOutputStream($sshjTransport, $channel, outputStream2);
        $resultQueue.add(TuplesKt.to((Object)Thread.currentThread(), (Object)SingleTunnelBrokerKt.copier(input, output)));
    }

    private static final void launchCopiersAndWait$lambda$5(Channel $channel, Socket $socket, ArrayBlockingQueue $resultQueue) {
        Intrinsics.checkNotNullParameter((Object)$channel, (String)"$channel");
        Intrinsics.checkNotNullParameter((Object)$socket, (String)"$socket");
        Intrinsics.checkNotNullParameter((Object)$resultQueue, (String)"$resultQueue");
        InputStream input = $channel.getInputStream();
        ShutdowningSocketOutputStream output = new ShutdowningSocketOutputStream($socket);
        Thread thread = Thread.currentThread();
        Intrinsics.checkNotNull((Object)input);
        $resultQueue.add(TuplesKt.to((Object)thread, (Object)SingleTunnelBrokerKt.copier(input, output)));
    }
}

