/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh.impl;

import com.intellij.execution.process.ProcessIOExecutorService;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressWrapper;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ssh.AuthFailSshTransportException;
import com.intellij.ssh.ChannelSshTransportException;
import com.intellij.ssh.SessionConfig;
import com.intellij.ssh.Ssh;
import com.intellij.ssh.SshBundle;
import com.intellij.ssh.SshConnectionService;
import com.intellij.ssh.SshException;
import com.intellij.ssh.SshSession;
import com.intellij.ssh.SshSessionChannelFactory;
import com.intellij.ssh.channels.SshChannel;
import com.intellij.ssh.impl.SshConnection;
import com.intellij.ssh.impl.sshj.SshjConnectionUtilKt;
import com.intellij.ssh.impl.sshj.SshjSshConnection;
import com.intellij.ssh.ui.SshConnectionStateListener;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0081\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005*\u0001\n\b\u0000\u0018\u0000 52\u00020\u0001:\u00044567B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0017\u001a\u00020\u0018H\u0002J\u001a\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u001b2\b\b\u0002\u0010\u001c\u001a\u00020\fH\u0007J\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001a\u001a\u00020\u001bJ\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0006\u0010!\u001a\u00020\u0018J\u0010\u0010\"\u001a\u00020 2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002JL\u0010#\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u0001H%\u0012\u0004\u0012\u00020\f0$\"\b\b\u0000\u0010%*\u00020&2\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020 0\u00122\u0014\u0010(\u001a\u0010\u0012\u0004\u0012\u00020 \u0012\u0006\u0012\u0004\u0018\u0001H%0)H\u0002J\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u001e0+J\u000e\u0010,\u001a\u00020\u001e2\u0006\u0010\u001a\u001a\u00020\u001bJ1\u0010-\u001a\u0002H%\"\b\b\u0000\u0010%*\u00020&2\u0006\u0010\u001a\u001a\u00020\u001b2\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u0002H%0)\u00a2\u0006\u0002\u0010/JC\u0010-\u001a\u0004\u0018\u0001H%\"\b\b\u0000\u0010%*\u00020&2\u0006\u00100\u001a\u00020 2\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u0002H%0)2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020 0\u0012H\u0002\u00a2\u0006\u0002\u00101J\u0014\u00102\u001a\u000203*\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u0018\u0010\b\u001a\f\u0012\u0004\u0012\u00020\n0\tR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0014\u001a\f\u0012\u0004\u0012\u00020\u00150\tR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u000e\u00a8\u00068"}, d2={"Lcom/intellij/ssh/impl/SshConnection;", "", "userName", "", "host", "port", "", "(Ljava/lang/String;Ljava/lang/String;I)V", "disposeCriticalSection", "Lcom/intellij/ssh/impl/SshConnection$LockCriticalSection;", "com/intellij/ssh/impl/SshConnection$disposeCriticalSection$1", "disposed", "", "getHost", "()Ljava/lang/String;", "getPort", "()I", "progressIndicatorOfInstantiatingConnections", "", "Lcom/intellij/openapi/progress/ProgressIndicator;", "serveCriticalSection", "Lcom/intellij/ssh/impl/SshConnection$ServeCriticalSection;", "getUserName", "assertNotDisposed", "", "checkCanAuthenticate", "sessionConfig", "Lcom/intellij/ssh/SessionConfig;", "addToPool", "connect", "Lcom/intellij/ssh/SshSession;", "createSshSessionForSshj", "Lcom/intellij/ssh/SshSessionChannelFactory;", "dispose", "doSshjSshConnection", "getOrCreateSessionWithChannelsAvailable", "Lkotlin/Pair;", "R", "Lcom/intellij/ssh/channels/SshChannel;", "faultySessions", "invokeChannelFactory", "Lkotlin/Function1;", "getSessions", "", "getSshSession", "openChannel", "channelCreator", "(Lcom/intellij/ssh/SessionConfig;Lkotlin/jvm/functions/Function1;)Lcom/intellij/ssh/channels/SshChannel;", "session", "(Lcom/intellij/ssh/SshSessionChannelFactory;Lkotlin/jvm/functions/Function1;Ljava/util/Set;)Lcom/intellij/ssh/channels/SshChannel;", "createSession", "Lcom/intellij/ssh/impl/SshConnection$ChannelFactoryWithSemaphore;", "ChannelFactoryWithSemaphore", "Companion", "LockCriticalSection", "ServeCriticalSection", "intellij.platform.ssh"})
@SourceDebugExtension(value={"SMAP\nSshConnection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SshConnection.kt\ncom/intellij/ssh/impl/SshConnection\n+ 2 SshConnection.kt\ncom/intellij/ssh/impl/SshConnection$LockCriticalSection\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,381:1\n372#2,5:382\n351#2,10:387\n363#2,15:405\n346#2,3:420\n346#2,3:423\n346#2,2:426\n348#2:432\n766#3:397\n857#3,2:398\n1549#3:428\n1620#3,3:429\n58#4,5:400\n*S KotlinDebug\n*F\n+ 1 SshConnection.kt\ncom/intellij/ssh/impl/SshConnection\n*L\n123#1:382,5\n123#1:387,10\n123#1:405,15\n294#1:420,3\n306#1:423,3\n325#1:426,2\n325#1:432\n136#1:397\n136#1:398,2\n325#1:428\n325#1:429,3\n141#1:400,5\n*E\n"})
public final class SshConnection {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String userName;
    @NotNull
    private final String host;
    private final int port;
    @NotNull
    private final LockCriticalSection<ServeCriticalSection> serveCriticalSection;
    @NotNull
    private final LockCriticalSection<disposeCriticalSection.1> disposeCriticalSection;
    @NotNull
    private final Set<ProgressIndicator> progressIndicatorOfInstantiatingConnections;
    private volatile boolean disposed;
    @NotNull
    private static final Logger LOG;

    public SshConnection(@NotNull String userName, @NotNull String host2, int port2) {
        Intrinsics.checkNotNullParameter((Object)userName, (String)"userName");
        Intrinsics.checkNotNullParameter((Object)host2, (String)"host");
        this.userName = userName;
        this.host = host2;
        this.port = port2;
        this.serveCriticalSection = new LockCriticalSection<ServeCriticalSection>(new ServeCriticalSection(null, 1, null));
        this.disposeCriticalSection = new LockCriticalSection<disposeCriticalSection.1>(new Object(){
            @NotNull
            private final List<SshSession> allSessions;
            {
                this.allSessions = new ArrayList<E>();
            }

            @NotNull
            public final List<SshSession> getAllSessions() {
                return this.allSessions;
            }
        });
        Set set = Collections.newSetFromMap(ContainerUtil.createConcurrentWeakMap());
        Intrinsics.checkNotNullExpressionValue(set, (String)"newSetFromMap(...)");
        this.progressIndicatorOfInstantiatingConnections = set;
    }

    @NotNull
    public final String getUserName() {
        return this.userName;
    }

    @NotNull
    public final String getHost() {
        return this.host;
    }

    public final int getPort() {
        return this.port;
    }

    @NotNull
    public final <R extends SshChannel> R openChannel(@NotNull SessionConfig sessionConfig, @NotNull Function1<? super SshSessionChannelFactory, ? extends R> channelCreator) throws SshException {
        Intrinsics.checkNotNullParameter((Object)sessionConfig, (String)"sessionConfig");
        Intrinsics.checkNotNullParameter(channelCreator, (String)"channelCreator");
        return (R)((SshChannel)Ssh.wrapBlockingSshCall$default(null, false, new Function0<R>(this, sessionConfig, channelCreator){
            final /* synthetic */ SshConnection this$0;
            final /* synthetic */ SessionConfig $sessionConfig;
            final /* synthetic */ Function1<SshSessionChannelFactory, R> $channelCreator;
            {
                this.this$0 = $receiver;
                this.$sessionConfig = $sessionConfig;
                this.$channelCreator = $channelCreator;
                super(0);
            }

            @NotNull
            public final R invoke() {
                boolean isNewSession;
                ((SshConnectionService.Listener)ApplicationManager.getApplication().getMessageBus().syncPublisher(SshConnectionService.Companion.getTOPIC())).sessionOrChannelRequested(this.this$0.getUserName(), this.this$0.getHost(), this.this$0.getPort());
                SshConnection.access$assertNotDisposed(this.this$0);
                ProgressIndicator progressIndicator2 = this.$sessionConfig.getProgressIndicator();
                if (progressIndicator2 != null) {
                    progressIndicator2.checkCanceled();
                }
                Set faultySessions = new LinkedHashSet<E>();
                do {
                    Pair pair = SshConnection.access$getOrCreateSessionWithChannelsAvailable(this.this$0, this.$sessionConfig, faultySessions, (Function1)new Function1<SshSessionChannelFactory, R>(this.this$0, this.$channelCreator, (Set<SshSessionChannelFactory>)faultySessions){
                        final /* synthetic */ SshConnection this$0;
                        final /* synthetic */ Function1<SshSessionChannelFactory, R> $channelCreator;
                        final /* synthetic */ Set<SshSessionChannelFactory> $faultySessions;
                        {
                            this.this$0 = $receiver;
                            this.$channelCreator = $channelCreator;
                            this.$faultySessions = $faultySessions;
                            super(1);
                        }

                        @Nullable
                        public final R invoke(@NotNull SshSessionChannelFactory sessionFactory) {
                            Intrinsics.checkNotNullParameter((Object)sessionFactory, (String)"sessionFactory");
                            return (R)SshConnection.access$openChannel(this.this$0, sessionFactory, this.$channelCreator, this.$faultySessions);
                        }
                    });
                    SshChannel channel2 = (SshChannel)pair.component1();
                    isNewSession = (Boolean)pair.component2();
                    if (channel2 == null) continue;
                    return (R)channel2;
                } while (!isNewSession);
                throw new SshException("Failed to open SSH channel in a just created TCP session for " + this.this$0.getUserName() + "@" + this.this$0.getHost() + ":" + this.this$0.getPort(), new Attachment[0]);
            }
        }, 3, null));
    }

    private final <R extends SshChannel> R openChannel(SshSessionChannelFactory session, Function1<? super SshSessionChannelFactory, ? extends R> channelCreator, Set<SshSessionChannelFactory> faultySessions) {
        try {
            return session.openChannel(channelCreator);
        }
        catch (SshException e) {
            if (e instanceof ChannelSshTransportException) {
                LOG.debug(session + " refused to create a new channel", (Throwable)((Object)e));
                faultySessions.add(session);
            } else if (ExceptionUtil.causedBy((Throwable)((Throwable)((Object)e)), SocketException.class)) {
                LOG.warn("Got error when tried to acquire a channel in session " + session + ". Probably connection was lost.", (Throwable)((Object)e));
                faultySessions.add(session);
            } else {
                throw e;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final <R extends SshChannel> Pair<R, Boolean> getOrCreateSessionWithChannelsAvailable(SessionConfig sessionConfig, Set<SshSessionChannelFactory> faultySessions, Function1<? super SshSessionChannelFactory, ? extends R> invokeChannelFactory) {
        Pair pair;
        Triple triple;
        LockCriticalSection<ServeCriticalSection> lockCriticalSection = this.serveCriticalSection;
        ProgressIndicator progressIndicator$iv = sessionConfig.getProgressIndicator();
        boolean $i$f$withLockInterruptible = false;
        do {
            Triple result$iv;
            Triple triple2;
            void timeout$iv$iv;
            void this_$iv$iv;
            void this_$iv;
            ((LockCriticalSection)this_$iv).SshConnection.this.assertNotDisposed();
            ProgressIndicator progressIndicator2 = progressIndicator$iv;
            if (progressIndicator2 != null) {
                progressIndicator2.checkCanceled();
            }
            pair = this_$iv;
            long l = DurationKt.toDuration((int)500, (DurationUnit)DurationUnit.MILLISECONDS);
            boolean bl = false;
            boolean locked$iv$iv = ((LockCriticalSection)this_$iv$iv).lock.tryLock(Duration.getInWholeMilliseconds-impl((long)timeout$iv$iv), TimeUnit.MILLISECONDS);
            if (locked$iv$iv) {
                Triple triple3;
                try {
                    Triple triple4;
                    Collection<Object> collection;
                    ServeCriticalSection $this$getOrCreateSessionWithChannelsAvailable_u24lambda_u243;
                    block16: {
                        Iterator $this$filterTo$iv$iv;
                        $this$getOrCreateSessionWithChannelsAvailable_u24lambda_u243 = (ServeCriticalSection)this_$iv$iv.get_hidden();
                        boolean bl2 = false;
                        CollectionsKt.removeAll($this$getOrCreateSessionWithChannelsAvailable_u24lambda_u243.getSessions(), (Function1)((Function1)new Function1<ChannelFactoryWithSemaphore, Boolean>(this){
                            final /* synthetic */ SshConnection this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @NotNull
                            public final Boolean invoke(@NotNull ChannelFactoryWithSemaphore session) {
                                boolean bl;
                                Intrinsics.checkNotNullParameter((Object)session, (String)"session");
                                if (session.getChannelFactory().isConnected()) {
                                    bl = false;
                                } else {
                                    LockCriticalSection this_$iv = SshConnection.access$getDisposeCriticalSection$p(this.this$0);
                                    boolean $i$f$invoke = false;
                                    Lock lock = LockCriticalSection.access$getLock$p(this_$iv);
                                    lock.lock();
                                    try {
                                        boolean bl2 = false;
                                        disposeCriticalSection.1 $this$invoke_u24lambda_u240 = this_$iv.get_hidden();
                                        boolean bl3 = false;
                                        boolean bl4 = $this$invoke_u24lambda_u240.getAllSessions().remove(session.getChannelFactory());
                                    }
                                    finally {
                                        lock.unlock();
                                    }
                                    bl = true;
                                }
                                return bl;
                            }
                        }));
                        Iterable $this$filter$iv = $this$getOrCreateSessionWithChannelsAvailable_u24lambda_u243.getSessions();
                        boolean $i$f$filter22 = false;
                        Iterable iterable = $this$filter$iv;
                        Collection<Object> destination$iv$iv = new ArrayList();
                        boolean $i$f$filterTo = false;
                        Iterator iterator = $this$filterTo$iv$iv.iterator();
                        while (iterator.hasNext()) {
                            Object element$iv$iv = iterator.next();
                            ChannelFactoryWithSemaphore it = (ChannelFactoryWithSemaphore)element$iv$iv;
                            boolean bl3 = false;
                            if (!(!faultySessions.contains(it.getChannelFactory()))) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        Iterable $i$f$filter22 = (List)destination$iv$iv;
                        $this$filterTo$iv$iv = $i$f$filter22.iterator();
                        while ($this$filterTo$iv$iv.hasNext()) {
                            destination$iv$iv = $this$filterTo$iv$iv.next();
                            ChannelFactoryWithSemaphore it = (ChannelFactoryWithSemaphore)((Object)destination$iv$iv);
                            boolean bl4 = false;
                            if (!(it.getChannelFactory().isConnected() && it.getChannelOpenSemaphore().tryAcquire())) continue;
                            collection = destination$iv$iv;
                            break block16;
                        }
                        collection = null;
                    }
                    ChannelFactoryWithSemaphore sessionCandidate = (ChannelFactoryWithSemaphore)((Object)collection);
                    if (sessionCandidate == null) {
                        Logger $this$debug_u24default$iv = LOG;
                        Throwable e$iv = null;
                        boolean $i$f$debug = false;
                        if ($this$debug_u24default$iv.isDebugEnabled()) {
                            Logger logger = $this$debug_u24default$iv;
                            boolean bl5 = false;
                            logger.debug("Not found a candidate for opening a channel. Faulty sessions number: " + faultySessions.size() + ", total active sessions number: " + $this$getOrCreateSessionWithChannelsAvailable_u24lambda_u243.getSessions().size(), e$iv);
                        }
                        ChannelFactoryWithSemaphore newSession = this.createSession($this$getOrCreateSessionWithChannelsAvailable_u24lambda_u243, sessionConfig);
                        newSession.getChannelOpenSemaphore().acquire();
                        triple4 = new Triple((Object)newSession.getChannelFactory(), (Object)true, (Object)newSession.getChannelOpenSemaphore());
                    } else {
                        triple4 = new Triple((Object)sessionCandidate.getChannelFactory(), (Object)false, (Object)sessionCandidate.getChannelOpenSemaphore());
                    }
                    triple3 = triple4;
                }
                finally {
                    ((LockCriticalSection)this_$iv$iv).lock.unlock();
                }
                triple2 = triple3;
            } else {
                triple2 = null;
            }
            triple = result$iv = triple2;
        } while (triple == null);
        Triple triple5 = triple;
        SshSessionChannelFactory channelFactory = (SshSessionChannelFactory)triple5.component1();
        boolean isNewSession = (Boolean)triple5.component2();
        Semaphore acquiredSemaphore = (Semaphore)triple5.component3();
        try {
            pair = TuplesKt.to((Object)invokeChannelFactory.invoke((Object)channelFactory), (Object)isNewSession);
        }
        finally {
            acquiredSemaphore.release();
            if (isNewSession) {
                ((SshConnectionStateListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(SshConnectionStateListener.Companion.getAUTH_TOPIC())).connectionCreated(channelFactory);
            }
        }
        return pair;
    }

    @NotNull
    public final SshSession connect(@NotNull SessionConfig sessionConfig) throws SshException {
        Intrinsics.checkNotNullParameter((Object)sessionConfig, (String)"sessionConfig");
        return this.getSshSession(sessionConfig);
    }

    @NotNull
    public final SshSession getSshSession(@NotNull SessionConfig sessionConfig) throws SshException {
        Intrinsics.checkNotNullParameter((Object)sessionConfig, (String)"sessionConfig");
        return (SshSession)Ssh.wrapBlockingSshCall$default(null, false, (Function0)new Function0<SshSessionChannelFactory>(this, sessionConfig){
            final /* synthetic */ SshConnection this$0;
            final /* synthetic */ SessionConfig $sessionConfig;
            {
                this.this$0 = $receiver;
                this.$sessionConfig = $sessionConfig;
                super(0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            @NotNull
            public final SshSessionChannelFactory invoke() {
                Pair pair;
                ((SshConnectionService.Listener)ApplicationManager.getApplication().getMessageBus().syncPublisher(SshConnectionService.Companion.getTOPIC())).sessionOrChannelRequested(this.this$0.getUserName(), this.this$0.getHost(), this.this$0.getPort());
                LockCriticalSection lockCriticalSection = SshConnection.access$getServeCriticalSection$p(this.this$0);
                ProgressIndicator progressIndicator2 = this.$sessionConfig.getProgressIndicator();
                SshConnection sshConnection = this.this$0;
                SessionConfig sessionConfig = this.$sessionConfig;
                boolean $i$f$withLockInterruptible = false;
                do {
                    Pair result$iv;
                    Pair pair2;
                    void timeout$iv$iv;
                    void this_$iv$iv;
                    void progressIndicator$iv;
                    void this_$iv;
                    SshConnection.access$assertNotDisposed(LockCriticalSection.access$getThis$0$p((LockCriticalSection)this_$iv));
                    void v0 = progressIndicator$iv;
                    if (v0 != null) {
                        v0.checkCanceled();
                    }
                    void var7_7 = this_$iv;
                    long l = DurationKt.toDuration((int)500, (DurationUnit)DurationUnit.MILLISECONDS);
                    boolean bl = false;
                    boolean locked$iv$iv = LockCriticalSection.access$getLock$p((LockCriticalSection)this_$iv$iv).tryLock(Duration.getInWholeMilliseconds-impl((long)timeout$iv$iv), TimeUnit.MILLISECONDS);
                    if (locked$iv$iv) {
                        Pair pair3;
                        try {
                            Pair pair4;
                            block13: {
                                ServeCriticalSection $this$invoke_u24lambda_u241 = (ServeCriticalSection)this_$iv$iv.get_hidden();
                                boolean bl2 = false;
                                Iterator<ChannelFactoryWithSemaphore> iterator = $this$invoke_u24lambda_u241.getSessions().iterator();
                                while (iterator.hasNext()) {
                                    ChannelFactoryWithSemaphore factoryWithSemaphore = iterator.next();
                                    if (factoryWithSemaphore.getChannelFactory().isConnected()) {
                                        pair4 = TuplesKt.to((Object)factoryWithSemaphore.getChannelFactory(), (Object)false);
                                        break block13;
                                    }
                                    iterator.remove();
                                    LockCriticalSection this_$iv2 = SshConnection.access$getDisposeCriticalSection$p(sshConnection);
                                    boolean $i$f$invoke = false;
                                    Lock lock = LockCriticalSection.access$getLock$p(this_$iv2);
                                    lock.lock();
                                    try {
                                        boolean bl3 = false;
                                        disposeCriticalSection.1 $this$invoke_u24lambda_u241_u24lambda_u240 = this_$iv2.get_hidden();
                                        boolean bl4 = false;
                                        boolean bl5 = $this$invoke_u24lambda_u241_u24lambda_u240.getAllSessions().remove(factoryWithSemaphore.getChannelFactory());
                                    }
                                    finally {
                                        lock.unlock();
                                    }
                                }
                                SshConnection.access$getLOG$cp().debug("No opened sessions to " + sshConnection.getUserName() + "@" + sshConnection.getHost() + ":" + sshConnection.getPort() + " found");
                                pair4 = TuplesKt.to((Object)SshConnection.access$createSession(sshConnection, $this$invoke_u24lambda_u241, sessionConfig).getChannelFactory(), (Object)true);
                            }
                            pair3 = pair4;
                        }
                        finally {
                            LockCriticalSection.access$getLock$p((LockCriticalSection)this_$iv$iv).unlock();
                        }
                        pair2 = pair3;
                    } else {
                        pair2 = null;
                    }
                    pair = result$iv = pair2;
                } while (pair == null);
                Pair pair5 = pair;
                SshSessionChannelFactory session = (SshSessionChannelFactory)pair5.component1();
                boolean justCreated = (Boolean)pair5.component2();
                if (justCreated) {
                    ((SshConnectionStateListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(SshConnectionStateListener.Companion.getAUTH_TOPIC())).connectionCreated(session);
                }
                return session;
            }
        }, 3, null);
    }

    @JvmOverloads
    public final boolean checkCanAuthenticate(@NotNull SessionConfig sessionConfig, boolean addToPool) throws SshException {
        Intrinsics.checkNotNullParameter((Object)sessionConfig, (String)"sessionConfig");
        return (Boolean)Ssh.wrapBlockingSshCall$default(null, false, (Function0)new Function0<Boolean>(this, sessionConfig, addToPool){
            final /* synthetic */ SshConnection this$0;
            final /* synthetic */ SessionConfig $sessionConfig;
            final /* synthetic */ boolean $addToPool;
            {
                this.this$0 = $receiver;
                this.$sessionConfig = $sessionConfig;
                this.$addToPool = $addToPool;
                super(0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            @NotNull
            public final Boolean invoke() {
                boolean bl;
                SshSessionChannelFactory sshSessionChannelFactory;
                SshConnection.access$getLOG$cp().debug("Checking that can authenticate " + this.this$0.getUserName() + "@" + this.this$0.getHost() + ":" + this.this$0.getPort());
                if (checkCanAuthenticate.WhenMappings.$EnumSwitchMapping$0[this.$sessionConfig.getSshBackendLibrary().ordinal()] == 1) {
                    try {
                        sshSessionChannelFactory = SshConnection.access$createSshSessionForSshj(this.this$0, this.$sessionConfig);
                    }
                    catch (AuthFailSshTransportException e) {
                        sshSessionChannelFactory = null;
                    }
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                SshSessionChannelFactory session = sshSessionChannelFactory;
                if (session != null) {
                    if (this.$addToPool) {
                        Unit unit;
                        void $this$iv;
                        LockCriticalSection lockCriticalSection = SshConnection.access$getServeCriticalSection$p(this.this$0);
                        SshConnection sshConnection = this.this$0;
                        Object timeout$iv = null;
                        boolean bl2 = false;
                        boolean locked$iv = LockCriticalSection.access$getLock$p((LockCriticalSection)$this$iv).tryLock();
                        if (locked$iv) {
                            Unit unit2;
                            try {
                                ServeCriticalSection $this$invoke_u24lambda_u242 = (ServeCriticalSection)$this$iv.get_hidden();
                                boolean bl3 = false;
                                checkCanAuthenticate.1.invoke$addToThePool(sshConnection, session);
                                unit2 = Unit.INSTANCE;
                            }
                            finally {
                                LockCriticalSection.access$getLock$p((LockCriticalSection)$this$iv).unlock();
                            }
                            unit = unit2;
                        } else {
                            unit = null;
                        }
                        if (unit == null) {
                            ProcessIOExecutorService.INSTANCE.execute(() -> checkCanAuthenticate.1.invoke$addToThePool(this.this$0, session));
                        }
                    }
                    bl = true;
                } else {
                    bl = false;
                }
                return bl;
            }

            private static final void invoke$addToThePool$lambda$1(SshSessionChannelFactory $session) {
                try {
                    $session.disconnect();
                }
                catch (Throwable err) {
                    SshConnection.access$getLOG$cp().info("Error on disconnection while checked if can authenticate. Unlikely it's sufficient.", err);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private static final void invoke$addToThePool(SshConnection this$0, SshSessionChannelFactory session) {
                boolean bl;
                LockCriticalSection this_$iv = SshConnection.access$getServeCriticalSection$p(this$0);
                boolean $i$f$invoke = false;
                Lock lock = LockCriticalSection.access$getLock$p(this_$iv);
                lock.lock();
                try {
                    boolean bl2;
                    boolean bl3 = false;
                    ServeCriticalSection $this$invoke_u24addToThePool_u24lambda_u240 = (ServeCriticalSection)this_$iv.get_hidden();
                    boolean bl4 = false;
                    if ($this$invoke_u24addToThePool_u24lambda_u240.getSessions().isEmpty()) {
                        $this$invoke_u24addToThePool_u24lambda_u240.getSessions().add(new ChannelFactoryWithSemaphore(session, null, 2, null));
                        bl2 = false;
                    } else {
                        bl2 = true;
                    }
                    bl = bl2;
                }
                finally {
                    lock.unlock();
                }
                boolean disconnect2 = bl;
                if (disconnect2) {
                    ProcessIOExecutorService.INSTANCE.execute(() -> checkCanAuthenticate.1.invoke$addToThePool$lambda$1(session));
                } else {
                    ((SshConnectionStateListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(SshConnectionStateListener.Companion.getAUTH_TOPIC())).connectionCreated(session);
                }
            }
        }, 3, null);
    }

    public static /* synthetic */ boolean checkCanAuthenticate$default(SshConnection sshConnection, SessionConfig sessionConfig, boolean bl, int n, Object object) throws SshException {
        if ((n & 2) != 0) {
            bl = false;
        }
        return sshConnection.checkCanAuthenticate(sessionConfig, bl);
    }

    private final ChannelFactoryWithSemaphore createSession(ServeCriticalSection $this$createSession, SessionConfig sessionConfig) throws SshException {
        return (ChannelFactoryWithSemaphore)Ssh.wrapBlockingSshCall$default(null, false, (Function0)new Function0<ChannelFactoryWithSemaphore>(this, sessionConfig, $this$createSession){
            final /* synthetic */ SshConnection this$0;
            final /* synthetic */ SessionConfig $sessionConfig;
            final /* synthetic */ ServeCriticalSection $this_createSession;
            {
                this.this$0 = $receiver;
                this.$sessionConfig = $sessionConfig;
                this.$this_createSession = $receiver2;
                super(0);
            }

            @NotNull
            public final ChannelFactoryWithSemaphore invoke() {
                SshConnection.access$getLOG$cp().debug("Establishing new SSH session to " + this.this$0.getUserName() + "@" + this.this$0.getHost() + ":" + this.this$0.getPort());
                if (createSession.WhenMappings.$EnumSwitchMapping$0[this.$sessionConfig.getSshBackendLibrary().ordinal()] != 1) {
                    throw new NoWhenBranchMatchedException();
                }
                ChannelFactoryWithSemaphore channelFactoryWithSemaphore = new ChannelFactoryWithSemaphore(SshConnection.access$createSshSessionForSshj(this.this$0, this.$sessionConfig), null, 2, null);
                SshConnection.access$getLOG$cp().debug("SSH session @" + Integer.toHexString(channelFactoryWithSemaphore.getChannelFactory().hashCode()) + " established to " + this.this$0.getUserName() + "@" + this.this$0.getHost() + ":" + this.this$0.getPort());
                SshConnection.access$assertNotDisposed(this.this$0);
                this.$this_createSession.getSessions().add(channelFactoryWithSemaphore);
                return channelFactoryWithSemaphore;
            }
        }, 3, null);
    }

    private final SshSessionChannelFactory createSshSessionForSshj(SessionConfig sessionConfig) {
        Object[] objectArray = new Object[]{sessionConfig.getConnectionConfig().getUser(), sessionConfig.getConnectionConfig().getHost()};
        String string = SshBundle.message("ssh.connecting.to.background.task.title", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return (SshSessionChannelFactory)Ssh.wrapBlockingSshCall$default(string, false, (Function0)new Function0<SshSessionChannelFactory>(this, sessionConfig){
            final /* synthetic */ SshConnection this$0;
            final /* synthetic */ SessionConfig $sessionConfig;
            {
                this.this$0 = $receiver;
                this.$sessionConfig = $sessionConfig;
                super(0);
            }

            @NotNull
            public final SshSessionChannelFactory invoke() {
                return SshConnection.access$doSshjSshConnection(this.this$0, this.$sessionConfig);
            }
        }, 2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final SshSessionChannelFactory doSshjSshConnection(SessionConfig sessionConfig) {
        ProgressIndicator progressIndicator2 = sessionConfig.getProgressIndicator();
        if (progressIndicator2 == null) {
            progressIndicator2 = (ProgressIndicator)new EmptyProgressIndicator();
        }
        ProgressIndicator progressIndicator3 = progressIndicator2;
        ProgressWrapper progressIndicator4 = new ProgressWrapper(progressIndicator3){};
        ((Collection)this.progressIndicatorOfInstantiatingConnections).add(progressIndicator4);
        SshjSshConnection sshSession = SshjConnectionUtilKt.setUpSessionForSshJ(sessionConfig, (ProgressIndicator)progressIndicator4);
        LockCriticalSection<disposeCriticalSection.1> this_$iv = this.disposeCriticalSection;
        boolean $i$f$invoke = false;
        Lock lock = ((LockCriticalSection)this_$iv).lock;
        lock.lock();
        try {
            boolean bl = false;
            var $this$doSshjSshConnection_u24lambda_u244 = this_$iv.get_hidden();
            boolean bl2 = false;
            this.assertNotDisposed();
            boolean bl3 = $this$doSshjSshConnection_u24lambda_u244.getAllSessions().add(sshSession);
        }
        finally {
            lock.unlock();
        }
        return sshSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dispose() {
        LockCriticalSection<disposeCriticalSection.1> this_$iv = this.disposeCriticalSection;
        boolean $i$f$invoke = false;
        Lock lock = ((LockCriticalSection)this_$iv).lock;
        lock.lock();
        try {
            boolean bl = false;
            disposeCriticalSection.1 $this$dispose_u24lambda_u245 = this_$iv.get_hidden();
            boolean bl2 = false;
            if (!this.disposed) {
                this.disposed = true;
                LOG.debug("Disconnecting SSH sessions to " + this.userName + "@" + this.host + ":" + this.port);
                for (ProgressIndicator progressIndicator2 : CollectionsKt.toList((Iterable)this.progressIndicatorOfInstantiatingConnections)) {
                    progressIndicator2.cancel();
                }
                for (SshSession session : $this$dispose_u24lambda_u245.getAllSessions()) {
                    session.disconnect();
                }
                $this$dispose_u24lambda_u245.getAllSessions().clear();
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final List<SshSession> getSessions() {
        List list2;
        LockCriticalSection<ServeCriticalSection> this_$iv = this.serveCriticalSection;
        boolean $i$f$invoke = false;
        Lock lock = ((LockCriticalSection)this_$iv).lock;
        lock.lock();
        try {
            void $this$mapTo$iv$iv;
            boolean bl = false;
            ServeCriticalSection $this$getSessions_u24lambda_u247 = this_$iv.get_hidden();
            boolean bl2 = false;
            Iterable $this$map$iv = $this$getSessions_u24lambda_u247.getSessions();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ChannelFactoryWithSemaphore channelFactoryWithSemaphore = (ChannelFactoryWithSemaphore)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl3 = false;
                collection.add(it.getChannelFactory());
            }
            list2 = (List)destination$iv$iv;
        }
        finally {
            lock.unlock();
        }
        return list2;
    }

    private final void assertNotDisposed() {
        if (this.disposed) {
            throw new IllegalStateException("SSH connection to " + this.userName + "@" + this.host + ":" + this.port + " disposed");
        }
    }

    @JvmOverloads
    public final boolean checkCanAuthenticate(@NotNull SessionConfig sessionConfig) throws SshException {
        Intrinsics.checkNotNullParameter((Object)sessionConfig, (String)"sessionConfig");
        return SshConnection.checkCanAuthenticate$default(this, sessionConfig, false, 2, null);
    }

    public static final /* synthetic */ Pair access$getOrCreateSessionWithChannelsAvailable(SshConnection $this, SessionConfig sessionConfig, Set faultySessions, Function1 invokeChannelFactory) {
        return $this.getOrCreateSessionWithChannelsAvailable(sessionConfig, faultySessions, invokeChannelFactory);
    }

    public static final /* synthetic */ SshChannel access$openChannel(SshConnection $this, SshSessionChannelFactory session, Function1 channelCreator, Set faultySessions) {
        return $this.openChannel(session, channelCreator, faultySessions);
    }

    public static final /* synthetic */ LockCriticalSection access$getServeCriticalSection$p(SshConnection $this) {
        return $this.serveCriticalSection;
    }

    public static final /* synthetic */ LockCriticalSection access$getDisposeCriticalSection$p(SshConnection $this) {
        return $this.disposeCriticalSection;
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    public static final /* synthetic */ ChannelFactoryWithSemaphore access$createSession(SshConnection $this, ServeCriticalSection $receiver, SessionConfig sessionConfig) {
        return $this.createSession($receiver, sessionConfig);
    }

    public static final /* synthetic */ SshSessionChannelFactory access$createSshSessionForSshj(SshConnection $this, SessionConfig sessionConfig) {
        return $this.createSshSessionForSshj(sessionConfig);
    }

    public static final /* synthetic */ SshSessionChannelFactory access$doSshjSshConnection(SshConnection $this, SessionConfig sessionConfig) {
        return $this.doSshjSshConnection(sessionConfig);
    }

    static {
        Logger logger = Logger.getInstance(SshConnection.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/intellij/ssh/impl/SshConnection$ChannelFactoryWithSemaphore;", "", "channelFactory", "Lcom/intellij/ssh/SshSessionChannelFactory;", "channelOpenSemaphore", "Ljava/util/concurrent/Semaphore;", "(Lcom/intellij/ssh/SshSessionChannelFactory;Ljava/util/concurrent/Semaphore;)V", "getChannelFactory", "()Lcom/intellij/ssh/SshSessionChannelFactory;", "getChannelOpenSemaphore", "()Ljava/util/concurrent/Semaphore;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.platform.ssh"})
    private static final class ChannelFactoryWithSemaphore {
        @NotNull
        private final SshSessionChannelFactory channelFactory;
        @NotNull
        private final Semaphore channelOpenSemaphore;

        public ChannelFactoryWithSemaphore(@NotNull SshSessionChannelFactory channelFactory, @NotNull Semaphore channelOpenSemaphore) {
            Intrinsics.checkNotNullParameter((Object)channelFactory, (String)"channelFactory");
            Intrinsics.checkNotNullParameter((Object)channelOpenSemaphore, (String)"channelOpenSemaphore");
            this.channelFactory = channelFactory;
            this.channelOpenSemaphore = channelOpenSemaphore;
        }

        public /* synthetic */ ChannelFactoryWithSemaphore(SshSessionChannelFactory sshSessionChannelFactory, Semaphore semaphore, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                semaphore = new Semaphore(Companion.getMAX_OPENING_CHANNELS_PER_SESSION());
            }
            this(sshSessionChannelFactory, semaphore);
        }

        @NotNull
        public final SshSessionChannelFactory getChannelFactory() {
            return this.channelFactory;
        }

        @NotNull
        public final Semaphore getChannelOpenSemaphore() {
            return this.channelOpenSemaphore;
        }

        @NotNull
        public final SshSessionChannelFactory component1() {
            return this.channelFactory;
        }

        @NotNull
        public final Semaphore component2() {
            return this.channelOpenSemaphore;
        }

        @NotNull
        public final ChannelFactoryWithSemaphore copy(@NotNull SshSessionChannelFactory channelFactory, @NotNull Semaphore channelOpenSemaphore) {
            Intrinsics.checkNotNullParameter((Object)channelFactory, (String)"channelFactory");
            Intrinsics.checkNotNullParameter((Object)channelOpenSemaphore, (String)"channelOpenSemaphore");
            return new ChannelFactoryWithSemaphore(channelFactory, channelOpenSemaphore);
        }

        public static /* synthetic */ ChannelFactoryWithSemaphore copy$default(ChannelFactoryWithSemaphore channelFactoryWithSemaphore, SshSessionChannelFactory sshSessionChannelFactory, Semaphore semaphore, int n, Object object) {
            if ((n & 1) != 0) {
                sshSessionChannelFactory = channelFactoryWithSemaphore.channelFactory;
            }
            if ((n & 2) != 0) {
                semaphore = channelFactoryWithSemaphore.channelOpenSemaphore;
            }
            return channelFactoryWithSemaphore.copy(sshSessionChannelFactory, semaphore);
        }

        @NotNull
        public String toString() {
            return "ChannelFactoryWithSemaphore(channelFactory=" + this.channelFactory + ", channelOpenSemaphore=" + this.channelOpenSemaphore + ")";
        }

        public int hashCode() {
            int result2 = this.channelFactory.hashCode();
            result2 = result2 * 31 + this.channelOpenSemaphore.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ChannelFactoryWithSemaphore)) {
                return false;
            }
            ChannelFactoryWithSemaphore channelFactoryWithSemaphore = (ChannelFactoryWithSemaphore)other;
            if (!Intrinsics.areEqual((Object)this.channelFactory, (Object)channelFactoryWithSemaphore.channelFactory)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.channelOpenSemaphore, (Object)channelFactoryWithSemaphore.channelOpenSemaphore);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/ssh/impl/SshConnection$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "MAX_OPENING_CHANNELS_PER_SESSION", "", "getMAX_OPENING_CHANNELS_PER_SESSION", "()I", "intellij.platform.ssh"})
    public static final class Companion {
        private Companion() {
        }

        private final int getMAX_OPENING_CHANNELS_PER_SESSION() {
            return Registry.intValue((String)"ssh.max.concurrent.channel.creations.per.session");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0004J0\u0010\n\u001a\u0002H\u000b\"\u0004\b\u0001\u0010\u000b2\u0017\u0010\f\u001a\u0013\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002H\u000b0\r\u00a2\u0006\u0002\b\u000eH\u0086\n\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000fJG\u0010\u0010\u001a\u0004\u0018\u0001H\u000b\"\b\b\u0001\u0010\u000b*\u00020\u00022\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0017\u0010\u0013\u001a\u0013\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002H\u000b0\r\u00a2\u0006\u0002\b\u000eH\u0086\b\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0014\u0010\u0015J>\u0010\u0016\u001a\u0002H\u000b\"\b\b\u0001\u0010\u000b*\u00020\u00022\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0017\u0010\u0019\u001a\u0013\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002H\u000b0\r\u00a2\u0006\u0002\b\u000eH\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001aR\u0013\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u0007\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000e\n\u0005\b\u009920\u0001\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\u001b"}, d2={"Lcom/intellij/ssh/impl/SshConnection$LockCriticalSection;", "Hidden", "", "_hidden", "(Lcom/intellij/ssh/impl/SshConnection;Ljava/lang/Object;)V", "get_hidden", "()Ljava/lang/Object;", "Ljava/lang/Object;", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "invoke", "T", "block", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "tryUse", "timeout", "Lkotlin/time/Duration;", "body", "tryUse-dnQKTGw", "(Lkotlin/time/Duration;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "withLockInterruptible", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "handler", "(Lcom/intellij/openapi/progress/ProgressIndicator;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "intellij.platform.ssh"})
    @SourceDebugExtension(value={"SMAP\nSshConnection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SshConnection.kt\ncom/intellij/ssh/impl/SshConnection$LockCriticalSection\n*L\n1#1,381:1\n351#1,17:382\n*S KotlinDebug\n*F\n+ 1 SshConnection.kt\ncom/intellij/ssh/impl/SshConnection$LockCriticalSection\n*L\n376#1:382,17\n*E\n"})
    private final class LockCriticalSection<Hidden> {
        @NotNull
        private final Hidden _hidden;
        @NotNull
        private final ReentrantLock lock;

        public LockCriticalSection(Hidden _hidden) {
            Intrinsics.checkNotNullParameter(_hidden, (String)"_hidden");
            this._hidden = _hidden;
            this.lock = new ReentrantLock();
        }

        @NotNull
        public final Hidden get_hidden() {
            return this._hidden;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final <T> T invoke(@NotNull Function1<? super Hidden, ? extends T> block) {
            Object object;
            Intrinsics.checkNotNullParameter(block, (String)"block");
            boolean $i$f$invoke = false;
            Lock lock = this.lock;
            lock.lock();
            try {
                boolean bl = false;
                object = block.invoke(this.get_hidden());
            }
            finally {
                InlineMarker.finallyStart((int)1);
                lock.unlock();
                InlineMarker.finallyEnd((int)1);
            }
            return (T)object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public final <T> T tryUse-dnQKTGw(@Nullable Duration timeout, @NotNull Function1<? super Hidden, ? extends T> body) {
            Object object;
            boolean locked;
            Intrinsics.checkNotNullParameter(body, (String)"body");
            boolean bl = false;
            boolean bl2 = locked = timeout == null ? this.lock.tryLock() : this.lock.tryLock(Duration.getInWholeMilliseconds-impl((long)timeout.unbox-impl()), TimeUnit.MILLISECONDS);
            if (locked) {
                Object object2;
                try {
                    object2 = body.invoke(this.get_hidden());
                }
                finally {
                    InlineMarker.finallyStart((int)1);
                    this.lock.unlock();
                    InlineMarker.finallyEnd((int)1);
                }
                object = object2;
            } else {
                object = null;
            }
            return (T)object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static /* synthetic */ Object tryUse-dnQKTGw$default(LockCriticalSection $this, Duration timeout, Function1 body, int n, Object object) {
            Object object2;
            boolean locked;
            if ((n & 1) != 0) {
                timeout = null;
            }
            Intrinsics.checkNotNullParameter((Object)body, (String)"body");
            boolean bl = false;
            boolean bl2 = locked = timeout == null ? $this.lock.tryLock() : $this.lock.tryLock(Duration.getInWholeMilliseconds-impl((long)timeout.unbox-impl()), TimeUnit.MILLISECONDS);
            if (locked) {
                Object object3;
                try {
                    object3 = body.invoke($this.get_hidden());
                }
                finally {
                    InlineMarker.finallyStart((int)1);
                    $this.lock.unlock();
                    InlineMarker.finallyEnd((int)1);
                }
                object2 = object3;
            } else {
                object2 = null;
            }
            return object2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @NotNull
        public final <T> T withLockInterruptible(@Nullable ProgressIndicator progressIndicator2, @NotNull Function1<? super Hidden, ? extends T> handler) {
            Intrinsics.checkNotNullParameter(handler, (String)"handler");
            boolean $i$f$withLockInterruptible = false;
            while (true) {
                Object result2;
                Object object;
                void timeout$iv;
                void this_$iv;
                SshConnection.this.assertNotDisposed();
                ProgressIndicator progressIndicator3 = progressIndicator2;
                if (progressIndicator3 != null) {
                    progressIndicator3.checkCanceled();
                }
                LockCriticalSection lockCriticalSection = this;
                long l = DurationKt.toDuration((int)500, (DurationUnit)DurationUnit.MILLISECONDS);
                boolean bl = false;
                boolean locked$iv = ((LockCriticalSection)this_$iv).lock.tryLock(Duration.getInWholeMilliseconds-impl((long)timeout$iv), TimeUnit.MILLISECONDS);
                if (locked$iv) {
                    Object object2;
                    try {
                        object2 = handler.invoke(this_$iv.get_hidden());
                    }
                    finally {
                        InlineMarker.finallyStart((int)1);
                        ((LockCriticalSection)this_$iv).lock.unlock();
                        InlineMarker.finallyEnd((int)1);
                    }
                    object = object2;
                } else {
                    object = null;
                }
                Object object3 = result2 = object;
                if (object3 == null) continue;
                return (T)object3;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/ssh/impl/SshConnection$ServeCriticalSection;", "", "sessions", "", "Lcom/intellij/ssh/impl/SshConnection$ChannelFactoryWithSemaphore;", "(Ljava/util/List;)V", "getSessions", "()Ljava/util/List;", "intellij.platform.ssh"})
    private static final class ServeCriticalSection {
        @NotNull
        private final List<ChannelFactoryWithSemaphore> sessions;

        public ServeCriticalSection(@NotNull List<ChannelFactoryWithSemaphore> sessions) {
            Intrinsics.checkNotNullParameter(sessions, (String)"sessions");
            this.sessions = sessions;
        }

        public /* synthetic */ ServeCriticalSection(List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                list2 = new ArrayList();
            }
            this(list2);
        }

        @NotNull
        public final List<ChannelFactoryWithSemaphore> getSessions() {
            return this.sessions;
        }

        public ServeCriticalSection() {
            this(null, 1, null);
        }
    }
}

