/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh.config;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.execution.process.KillableProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.remote.SshConnectionConfigPatch;
import com.intellij.ssh.OpenSshLikeHostKeyVerifier;
import com.intellij.ssh.SshHostKeyVerifier;
import com.intellij.ssh.X11Forwarding;
import com.intellij.ssh.config.AuthMethod;
import com.intellij.ssh.config.AuthMethods;
import com.intellij.ssh.config.EnvironmentVariable;
import com.intellij.ssh.config.IdentityAgent;
import com.intellij.ssh.config.OpenSSHConfigUtil;
import com.intellij.ssh.config.OpenSshConfigForwardInfo;
import com.intellij.ssh.config.OpenSshConfigViaToolServiceKt;
import com.intellij.ssh.config.ParsingError;
import com.intellij.ssh.config.ProxyJumpOptions;
import com.intellij.ssh.config.ServerAlive;
import com.intellij.ssh.config.SshConfigParseException;
import com.intellij.ssh.config.SshConnectionConfig;
import com.intellij.ssh.config.SshConnectionConfigKt;
import com.intellij.ssh.config.SshProxyConfig;
import com.intellij.ssh.config.ToolResult;
import com.intellij.util.SmartList;
import com.intellij.util.SystemProperties;
import java.io.File;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.Grouping;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\\\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0007\u001a(\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\tH\u0007\u001a*\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\t2\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u000b2\b\b\u0002\u0010\f\u001a\u00020\tH\u0002\u001a\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\tH\u0002\u001a\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\tH\u0002\u001a$\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u00172\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002\u001a\u001c\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u00172\u0006\u0010\u0012\u001a\u00020\tH\u0002\u001a1\u0010\u001b\u001a\u0004\u0018\u00010\u001c*\u0018\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u000b0\u001dj\u0002`\u001e2\u0006\u0010\u001f\u001a\u00020\tH\u0002\u00a2\u0006\u0002\u0010 \u001a8\u0010!\u001a\b\u0012\u0004\u0012\u00020\t0\u000b*\u0018\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u000b0\u001dj\u0002`\u001e2\u0006\u0010\u001f\u001a\u00020\t2\u0006\u0010\"\u001a\u00020#H\u0002\u001a:\u0010$\u001a\b\u0012\u0004\u0012\u00020\t0\u000b*\u0018\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u000b0\u001dj\u0002`\u001e2\u0006\u0010\u001f\u001a\u00020\t2\b\b\u0002\u0010\"\u001a\u00020#H\u0002\u001a*\u0010%\u001a\u00020\t*\u0018\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u000b0\u001dj\u0002`\u001e2\u0006\u0010\u001f\u001a\u00020\tH\u0002\u001a;\u0010&\u001a\u00020#*\u0018\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u000b0\u001dj\u0002`\u001e2\u0006\u0010\u001f\u001a\u00020\t2\n\b\u0002\u0010'\u001a\u0004\u0018\u00010#H\u0002\u00a2\u0006\u0002\u0010(\"\u001b\u0010\u0000\u001a\u00020\u00018BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0005\u001a\u0004\b\u0002\u0010\u0003*0\b\u0002\u0010)\"\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u000b0\u001d2\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u000b0\u001d\u00a8\u0006*"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "LOG$delegate", "Lkotlin/Lazy;", "openSshConfigViaTool", "Lcom/intellij/ssh/config/SshConnectionConfig;", "host", "", "customSshCommand", "", "userHome", "openSshConfigViaToolImpl", "Lcom/intellij/ssh/config/ToolResult;", "initialHost", "parseForward", "Lcom/intellij/ssh/config/OpenSshConfigForwardInfo;", "raw", "parsePath", "Ljava/nio/file/Path;", "path", "runToolAndGetStdio", "Lkotlin/Pair;", "sshGCommandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "splitEq", "longOrNone", "", "", "Lcom/intellij/ssh/config/MultiMap;", "key", "(Ljava/util/Map;Ljava/lang/String;)Ljava/lang/Long;", "singleCommaDelimited", "obligatory", "", "singleSpaceDelimited", "singleString", "yesNo", "default", "(Ljava/util/Map;Ljava/lang/String;Ljava/lang/Boolean;)Z", "MultiMap", "intellij.platform.ssh"})
@SourceDebugExtension(value={"SMAP\nOpenSshConfigViaToolService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OpenSshConfigViaToolService.kt\ncom/intellij/ssh/config/OpenSshConfigViaToolServiceKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 Grouping.kt\nkotlin/collections/GroupingKt__GroupingKt\n+ 5 extensions.kt\ncom/intellij/openapi/util/ExtensionsKt\n+ 6 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,493:1\n1#2:494\n1055#3:495\n80#4,6:496\n22#5,2:502\n26#5,2:513\n58#6,5:504\n65#6,4:509\n*S KotlinDebug\n*F\n+ 1 OpenSshConfigViaToolService.kt\ncom/intellij/ssh/config/OpenSshConfigViaToolServiceKt\n*L\n154#1:495\n155#1:496,6\n379#1:502,2\n379#1:513,2\n404#1:504,5\n409#1:509,4\n*E\n"})
public final class OpenSshConfigViaToolServiceKt {
    @NotNull
    private static final Lazy LOG$delegate = LazyKt.lazy((Function0)LOG.2.INSTANCE);

    @TestOnly
    @NotNull
    public static final SshConnectionConfig openSshConfigViaTool(@NotNull String host2, @Nullable List<String> customSshCommand, @NotNull String userHome) {
        Intrinsics.checkNotNullParameter((Object)host2, (String)"host");
        Intrinsics.checkNotNullParameter((Object)userHome, (String)"userHome");
        return OpenSshConfigViaToolServiceKt.openSshConfigViaToolImpl(host2, customSshCommand, userHome).getResult();
    }

    /*
     * WARNING - void declaration
     */
    private static final ToolResult openSshConfigViaToolImpl(String initialHost, List<String> customSshCommand, String userHome) {
        Object v;
        CharSequence charSequence;
        Object object;
        int port2;
        List<String> macs2;
        List<String> kexAlgorithms2;
        List<OpenSshConfigForwardInfo> initialRemoteTcpForwardings2;
        List<OpenSshConfigForwardInfo> initialLocalTcpForwardings2;
        SshHostKeyVerifier hostKeyVerifier2;
        List<String> hostKeyAlgorithms2;
        boolean forwardAgent2;
        List environmentVariables2;
        Duration connectTimeout2;
        boolean compression2;
        List<String> ciphers2;
        AuthMethods authMethods2;
        IdentityAgent identityAgent;
        String host2;
        String user2;
        SshConnectionConfig fallback;
        Set errors;
        void keyValue2;
        String rawStderr;
        String rawStdout;
        GeneralCommandLine sshGCommandLine;
        block14: {
            block13: {
                IdentityAgent identityAgent2;
                void destination$iv;
                void $this$aggregateTo$iv;
                Grouping $this$groupingBy$iv;
                String p0;
                boolean bl = false;
                List cmd = new ArrayList();
                Collection collection = cmd;
                List<String> list2 = customSshCommand;
                if (list2 == null) {
                    List<String> list3;
                    String string;
                    Object object2 = PathEnvironmentVariableUtil.findInPath((String)"ssh");
                    if (object2 != null && (object2 = (string = ((File)object2).getAbsolutePath())) != null) {
                        Intrinsics.checkNotNull((Object)object2);
                        p0 = string;
                        boolean bl2 = false;
                        list3 = CollectionsKt.listOf((Object)p0);
                    } else {
                        list3 = list2 = null;
                    }
                    if (list3 == null) {
                        throw new SshConfigParseException("Can't find 'ssh' tool");
                    }
                }
                Iterable iterable = list2;
                CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
                ((Collection)cmd).add("-G");
                ((Collection)cmd).add("-vvv");
                ((Collection)cmd).add(initialHost);
                sshGCommandLine = new GeneralCommandLine(cmd);
                Pair<String, String> pair = OpenSshConfigViaToolServiceKt.runToolAndGetStdio(initialHost, sshGCommandLine);
                rawStdout = (String)pair.component1();
                rawStderr = (String)pair.component2();
                p0 = SequencesKt.mapNotNull((Sequence)StringsKt.lineSequence((CharSequence)rawStdout), (Function1)openSshConfigViaToolImpl.keyValue.1.INSTANCE);
                boolean $i$f$groupingBy22 = false;
                $this$groupingBy$iv = (Grouping)new Grouping<Pair<? extends String, ? extends String>, String>((Sequence)$this$groupingBy$iv){
                    final /* synthetic */ Sequence $this_groupingBy;
                    {
                        this.$this_groupingBy = $receiver;
                    }

                    @NotNull
                    public Iterator<Pair<? extends String, ? extends String>> sourceIterator() {
                        return this.$this_groupingBy.iterator();
                    }

                    /*
                     * Ignored method signature, as it can't be verified against descriptor
                     */
                    public Object keyOf(Object element) {
                        Pair pair = (Pair)element;
                        boolean bl = false;
                        String key = (String)pair.component1();
                        String string = key.toLowerCase(Locale.ROOT);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                        return string;
                    }
                };
                Map $i$f$groupingBy22 = new HashMap();
                boolean $i$f$aggregateTo = false;
                Iterator iterator = $this$aggregateTo$iv.sourceIterator();
                while (iterator.hasNext()) {
                    void var21_26;
                    void accumulator;
                    Object e$iv = iterator.next();
                    Object key$iv = $this$aggregateTo$iv.keyOf(e$iv);
                    Object accumulator$iv = destination$iv.get(key$iv);
                    if (accumulator$iv != null || !destination$iv.containsKey(key$iv)) {
                        // empty if block
                    }
                    Pair pair2 = (Pair)e$iv;
                    SmartList smartList = (SmartList)accumulator$iv;
                    String cfr_ignored_0 = (String)key$iv;
                    Object object3 = key$iv;
                    void var32_30 = destination$iv;
                    boolean bl3 = false;
                    String element = (String)pair2.component2();
                    SmartList smartList2 = accumulator;
                    if (smartList2 == null) {
                        smartList2 = new SmartList();
                    }
                    void $this$openSshConfigViaToolImpl_u24lambda_u243_u24lambda_u242 = var21_26 = smartList2;
                    boolean bl4 = false;
                    $this$openSshConfigViaToolImpl_u24lambda_u243_u24lambda_u242.add((Object)element);
                    void var34_32 = var21_26;
                    var32_30.put(object3, var34_32);
                }
                keyValue2 = destination$iv;
                errors = new LinkedHashSet();
                fallback = new SshConnectionConfig(initialHost);
                user2 = OpenSshConfigViaToolServiceKt.openSshConfigViaToolImpl$catching(errors, fallback.getUser(), (Function0)new Function0<String>((Map<String, ? extends List<String>>)keyValue2){
                    final /* synthetic */ Map<String, List<String>> $keyValue;
                    {
                        this.$keyValue = $keyValue;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return OpenSshConfigViaToolServiceKt.access$singleString(this.$keyValue, "user");
                    }
                });
                host2 = OpenSshConfigViaToolServiceKt.openSshConfigViaToolImpl$catching(errors, fallback.getHost(), (Function0)new Function0<String>((Map<String, ? extends List<String>>)keyValue2){
                    final /* synthetic */ Map<String, List<String>> $keyValue;
                    {
                        this.$keyValue = $keyValue;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return OpenSshConfigViaToolServiceKt.access$singleString(this.$keyValue, "hostname");
                    }
                });
                Object object4 = (List)keyValue2.get("identityagent");
                if (object4 != null && (object4 = (String)CollectionsKt.singleOrNull((List)object4)) != null) {
                    Object p02 = object4;
                    boolean bl5 = false;
                    identityAgent2 = new IdentityAgent((String)p02);
                } else {
                    identityAgent2 = null;
                }
                identityAgent = identityAgent2;
                authMethods2 = OpenSshConfigViaToolServiceKt.openSshConfigViaToolImpl$catching(errors, fallback.getAuthMethods(), (Function0)new Function0<AuthMethods>((Map<String, ? extends List<String>>)keyValue2, identityAgent, userHome){
                    final /* synthetic */ Map<String, List<String>> $keyValue;
                    final /* synthetic */ IdentityAgent $identityAgent;
                    final /* synthetic */ String $userHome;
                    {
                        this.$keyValue = $keyValue;
                        this.$identityAgent = $identityAgent;
                        this.$userHome = $userHome;
                        super(0);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @NotNull
                    public final AuthMethods invoke() {
                        List preferredAuthentications;
                        List methods = new ArrayList<E>();
                        if (OpenSshConfigViaToolServiceKt.access$yesNo(this.$keyValue, "gssapiauthentication", false)) {
                            ((Collection)methods).add(AuthMethod.GssApi.INSTANCE);
                        }
                        if (OpenSshConfigViaToolServiceKt.yesNo$default(this.$keyValue, "pubkeyauthentication", null, 2, null)) {
                            List list2;
                            List<String> list3 = this.$keyValue.get("identityfile");
                            if (list3 != null) {
                                void $this$mapNotNullTo$iv$iv;
                                void $this$mapNotNull$iv;
                                Iterable iterable = list3;
                                String string = this.$userHome;
                                boolean $i$f$mapNotNull = false;
                                void var8_5 = $this$mapNotNull$iv;
                                Collection destination$iv$iv = new ArrayList<E>();
                                boolean $i$f$mapNotNullTo = false;
                                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                                boolean $i$f$forEach = false;
                                Iterator<T> iterator = $this$forEach$iv$iv$iv.iterator();
                                while (iterator.hasNext()) {
                                    Path it$iv$iv;
                                    T element$iv$iv$iv;
                                    T element$iv$iv = element$iv$iv$iv = iterator.next();
                                    boolean bl = false;
                                    String it = (String)element$iv$iv;
                                    boolean bl2 = false;
                                    if (OpenSshConfigViaToolServiceKt.access$parsePath(it, string) == null) continue;
                                    boolean bl3 = false;
                                    destination$iv$iv.add(it$iv$iv);
                                }
                                list2 = (List)destination$iv$iv;
                            } else {
                                list2 = CollectionsKt.emptyList();
                            }
                            List identityFiles = list2;
                            Collection collection = methods;
                            IdentityAgent identityAgent = this.$identityAgent;
                            collection.add(new AuthMethod.PublicKey(identityFiles, (identityAgent != null ? identityAgent.getType() : null) == IdentityAgent.Type.NONE ? AuthMethod.PublicKey.Agent.NO : (OpenSshConfigViaToolServiceKt.yesNo$default(this.$keyValue, "identitiesonly", null, 2, null) ? AuthMethod.PublicKey.Agent.ONLY_MENTIONED : AuthMethod.PublicKey.Agent.ALL)));
                        }
                        if (OpenSshConfigViaToolServiceKt.yesNo$default(this.$keyValue, "passwordauthentication", null, 2, null)) {
                            ((Collection)methods).add(AuthMethod.Password.INSTANCE);
                        }
                        if (OpenSshConfigViaToolServiceKt.yesNo$default(this.$keyValue, "kbdinteractiveauthentication", null, 2, null)) {
                            ((Collection)methods).add(AuthMethod.KeyboardInteractive.INSTANCE);
                        }
                        if (!((Collection)(preferredAuthentications = OpenSshConfigViaToolServiceKt.access$singleCommaDelimited(this.$keyValue, "preferredauthentications", false))).isEmpty()) {
                            methods.removeIf(arg_0 -> openSshConfigViaToolImpl.authMethods.1.invoke$lambda$1((Function1)new Function1<AuthMethod, Boolean>((List<String>)preferredAuthentications){
                                final /* synthetic */ List<String> $preferredAuthentications;
                                {
                                    this.$preferredAuthentications = $preferredAuthentications;
                                    super(1);
                                }

                                @NotNull
                                public final Boolean invoke(@NotNull AuthMethod it) {
                                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                    return !this.$preferredAuthentications.contains(SshConnectionConfigKt.getOpenSshLabel(it));
                                }
                            }, arg_0));
                            List $this$sortBy$iv = methods;
                            boolean $i$f$sortBy = false;
                            if ($this$sortBy$iv.size() > 1) {
                                CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(preferredAuthentications){
                                    final /* synthetic */ List $preferredAuthentications$inlined;
                                    {
                                        this.$preferredAuthentications$inlined = list2;
                                    }

                                    public final int compare(T a, T b) {
                                        AuthMethod it = (AuthMethod)a;
                                        boolean bl = false;
                                        Comparable comparable = Integer.valueOf(this.$preferredAuthentications$inlined.indexOf(SshConnectionConfigKt.getOpenSshLabel(it)));
                                        it = (AuthMethod)b;
                                        Comparable comparable2 = comparable;
                                        bl = false;
                                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(this.$preferredAuthentications$inlined.indexOf(SshConnectionConfigKt.getOpenSshLabel(it))));
                                    }
                                });
                            }
                        }
                        return AuthMethods.Companion.create(methods);
                    }

                    private static final boolean invoke$lambda$1(Function1 $tmp0, Object p0) {
                        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                        return (Boolean)$tmp0.invoke(p0);
                    }
                });
                ciphers2 = OpenSshConfigViaToolServiceKt.openSshConfigViaToolImpl$catching(errors, fallback.getCiphers(), (Function0)new Function0<List<? extends String>>((Map<String, ? extends List<String>>)keyValue2){
                    final /* synthetic */ Map<String, List<String>> $keyValue;
                    {
                        this.$keyValue = $keyValue;
                        super(0);
                    }

                    @NotNull
                    public final List<String> invoke() {
                        return OpenSshConfigViaToolServiceKt.access$singleCommaDelimited(this.$keyValue, "ciphers", true);
                    }
                });
                compression2 = OpenSshConfigViaToolServiceKt.openSshConfigViaToolImpl$catching(errors, fallback.getCompression(), (Function0)new Function0<Boolean>((Map<String, ? extends List<String>>)keyValue2){
                    final /* synthetic */ Map<String, List<String>> $keyValue;
                    {
                        this.$keyValue = $keyValue;
                        super(0);
                    }

                    @NotNull
                    public final Boolean invoke() {
                        return OpenSshConfigViaToolServiceKt.yesNo$default(this.$keyValue, "compression", null, 2, null);
                    }
                });
                connectTimeout2 = OpenSshConfigViaToolServiceKt.openSshConfigViaToolImpl$catching(errors, fallback.getConnectTimeout(), (Function0)new Function0<Duration>((Map<String, ? extends List<String>>)keyValue2){
                    final /* synthetic */ Map<String, List<String>> $keyValue;
                    {
                        this.$keyValue = $keyValue;
                        super(0);
                    }

                    @Nullable
                    public final Duration invoke() {
                        Duration duration;
                        Long l = OpenSshConfigViaToolServiceKt.access$longOrNone(this.$keyValue, "connecttimeout");
                        if (l != null) {
                            long p0 = ((Number)l).longValue();
                            boolean bl = false;
                            duration = Duration.ofSeconds(p0);
                        } else {
                            duration = null;
                        }
                        return duration;
                    }
                });
                environmentVariables2 = OpenSshConfigViaToolServiceKt.openSshConfigViaToolImpl$catching(errors, CollectionsKt.emptyList(), (Function0)new Function0<List<? extends EnvironmentVariable>>((Map<String, ? extends List<String>>)keyValue2, (Set<String>)errors){
                    final /* synthetic */ Map<String, List<String>> $keyValue;
                    final /* synthetic */ Set<String> $errors;
                    {
                        this.$keyValue = $keyValue;
                        this.$errors = $errors;
                        super(0);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @NotNull
                    public final List<EnvironmentVariable> invoke() {
                        void $this$mapNotNullTo$iv$iv;
                        void $this$mapNotNull$iv;
                        Collection collection;
                        void $this$mapTo$iv$iv;
                        List list2 = this.$keyValue.get("sendenv");
                        if (list2 == null) {
                            list2 = CollectionsKt.emptyList();
                        }
                        Iterable $this$map$iv = list2;
                        boolean $i$f$map = false;
                        Iterable iterable = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            void sendEnvRaw;
                            String string = (String)item$iv$iv;
                            collection = destination$iv$iv;
                            boolean bl = false;
                            collection.add(new EnvironmentVariable.Inherit((String)sendEnvRaw));
                        }
                        Collection collection2 = (List)destination$iv$iv;
                        List list3 = this.$keyValue.get("setenv");
                        if (list3 == null) {
                            list3 = CollectionsKt.emptyList();
                        }
                        $this$map$iv = list3;
                        Set<String> set = this.$errors;
                        collection = collection2;
                        boolean $i$f$mapNotNull = false;
                        destination$iv$iv = $this$mapNotNull$iv;
                        Collection destination$iv$iv2 = new ArrayList<E>();
                        boolean $i$f$mapNotNullTo = false;
                        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                        boolean $i$f$forEach = false;
                        Iterator<T> iterator = $this$forEach$iv$iv$iv.iterator();
                        while (iterator.hasNext()) {
                            EnvironmentVariable.Certain it$iv$iv;
                            T element$iv$iv$iv;
                            T element$iv$iv = element$iv$iv$iv = iterator.next();
                            boolean bl = false;
                            String setEnvRaw = (String)element$iv$iv;
                            boolean bl2 = false;
                            if ((EnvironmentVariable.Certain)OpenSshConfigViaToolServiceKt.access$openSshConfigViaToolImpl$catching(set, null, (Function0)new Function0<EnvironmentVariable.Certain>(setEnvRaw){
                                final /* synthetic */ String $setEnvRaw;
                                {
                                    this.$setEnvRaw = $setEnvRaw;
                                    super(0);
                                }

                                @Nullable
                                public final EnvironmentVariable.Certain invoke() {
                                    Pair pair = OpenSshConfigViaToolServiceKt.access$splitEq(this.$setEnvRaw);
                                    String name = (String)pair.component1();
                                    String value = (String)pair.component2();
                                    return new EnvironmentVariable.Certain(name, value);
                                }
                            }) == null) continue;
                            boolean bl3 = false;
                            destination$iv$iv2.add(it$iv$iv);
                        }
                        return CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv2));
                    }
                });
                forwardAgent2 = OpenSshConfigViaToolServiceKt.openSshConfigViaToolImpl$catching(errors, fallback.getForwardAgent(), (Function0)new Function0<Boolean>((Map<String, ? extends List<String>>)keyValue2){
                    final /* synthetic */ Map<String, List<String>> $keyValue;
                    {
                        this.$keyValue = $keyValue;
                        super(0);
                    }

                    @NotNull
                    public final Boolean invoke() {
                        return OpenSshConfigViaToolServiceKt.yesNo$default(this.$keyValue, "forwardagent", null, 2, null);
                    }
                });
                hostKeyAlgorithms2 = OpenSshConfigViaToolServiceKt.openSshConfigViaToolImpl$catching(errors, fallback.getHostKeyAlgorithms(), (Function0)new Function0<List<? extends String>>((Map<String, ? extends List<String>>)keyValue2){
                    final /* synthetic */ Map<String, List<String>> $keyValue;
                    {
                        this.$keyValue = $keyValue;
                        super(0);
                    }

                    @NotNull
                    public final List<String> invoke() {
                        return OpenSshConfigViaToolServiceKt.access$singleCommaDelimited(this.$keyValue, "hostkeyalgorithms", true);
                    }
                });
                hostKeyVerifier2 = OpenSshConfigViaToolServiceKt.openSshConfigViaToolImpl$catching(errors, fallback.getHostKeyVerifier(), (Function0)new Function0<SshHostKeyVerifier>((Map<String, ? extends List<String>>)keyValue2, userHome){
                    final /* synthetic */ Map<String, List<String>> $keyValue;
                    final /* synthetic */ String $userHome;
                    {
                        this.$keyValue = $keyValue;
                        this.$userHome = $userHome;
                        super(0);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @NotNull
                    public final SshHostKeyVerifier invoke() {
                        void $this$mapTo$iv$iv;
                        void $this$map$iv;
                        void $this$mapNotNullTo$iv$iv;
                        Iterable $this$mapNotNull$iv;
                        Map<String, List<String>> map = this.$keyValue;
                        Object object = this.$userHome;
                        boolean bl = false;
                        String globalKey = "globalknownhostsfile";
                        String userKey = "userknownhostsfile";
                        List knownHostsFiles = CollectionsKt.plus((Collection)OpenSshConfigViaToolServiceKt.access$singleSpaceDelimited(map, userKey, false), (Iterable)OpenSshConfigViaToolServiceKt.access$singleSpaceDelimited(map, globalKey, false));
                        Iterable<T> iterable = knownHostsFiles;
                        boolean $i$f$mapNotNull = false;
                        void var10_10 = $this$mapNotNull$iv;
                        Collection destination$iv$iv = new ArrayList<E>();
                        boolean $i$f$mapNotNullTo = false;
                        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                        boolean $i$f$forEach = false;
                        Object object2 = $this$forEach$iv$iv$iv.iterator();
                        while (object2.hasNext()) {
                            Path it$iv$iv;
                            T element$iv$iv$iv;
                            T element$iv$iv = element$iv$iv$iv = object2.next();
                            boolean bl2 = false;
                            String it = (String)element$iv$iv;
                            boolean bl3 = false;
                            if (OpenSshConfigViaToolServiceKt.access$parsePath(it, (String)object) == null) continue;
                            boolean bl4 = false;
                            destination$iv$iv.add(it$iv$iv);
                        }
                        $this$mapNotNull$iv = (List)destination$iv$iv;
                        boolean $i$f$map = false;
                        $this$mapNotNullTo$iv$iv = $this$map$iv;
                        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            void p0;
                            object2 = (Path)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            boolean bl5 = false;
                            collection.add(p0.toFile());
                        }
                        Iterable<T> it = iterable = (List)destination$iv$iv;
                        boolean bl6 = false;
                        Iterable<T> iterable2 = !((Collection)it).isEmpty() ? iterable : null;
                        if (iterable2 == null) {
                            throw new ParsingError("Both `" + globalKey + "` and `" + userKey + "` are empty");
                        }
                        Iterable<T> knownHostsFiles2 = iterable2;
                        object = this.$keyValue;
                        boolean bl7 = false;
                        String key = "stricthostkeychecking";
                        String string = OpenSshConfigViaToolServiceKt.access$singleString((Map)object, key).toLowerCase(Locale.ROOT);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                        SshConnectionConfigPatch.HostKeyVerifier.StrictHostKeyChecking strictHostKeyChecking = switch (string) {
                            case "yes", "true" -> SshConnectionConfigPatch.HostKeyVerifier.StrictHostKeyChecking.YES;
                            case "ask" -> SshConnectionConfigPatch.HostKeyVerifier.StrictHostKeyChecking.ASK;
                            case "no", "false", "off" -> SshConnectionConfigPatch.HostKeyVerifier.StrictHostKeyChecking.NO;
                            case "accept-new" -> SshConnectionConfigPatch.HostKeyVerifier.StrictHostKeyChecking.ACCEPT_NEW;
                            default -> {
                                String v;
                                throw new ParsingError("Unexpected value for `" + key + "`: `" + v + "`");
                            }
                        };
                        return new OpenSshLikeHostKeyVerifier((List)knownHostsFiles2, strictHostKeyChecking, OpenSshConfigViaToolServiceKt.yesNo$default(this.$keyValue, "hashknownhosts", null, 2, null), false, 8, null);
                    }
                });
                initialLocalTcpForwardings2 = OpenSshConfigViaToolServiceKt.openSshConfigViaToolImpl$catching(errors, fallback.getInitialLocalTcpForwardings(), (Function0)new Function0<List<? extends OpenSshConfigForwardInfo>>((Map<String, ? extends List<String>>)keyValue2){
                    final /* synthetic */ Map<String, List<String>> $keyValue;
                    {
                        this.$keyValue = $keyValue;
                        super(0);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @NotNull
                    public final List<OpenSshConfigForwardInfo> invoke() {
                        List list2;
                        List<String> list3 = this.$keyValue.get("localforward");
                        if (list3 != null) {
                            void $this$mapTo$iv$iv;
                            Iterable $this$map$iv = list3;
                            boolean $i$f$map = false;
                            Iterable iterable = $this$map$iv;
                            Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                            boolean $i$f$mapTo = false;
                            for (T item$iv$iv : $this$mapTo$iv$iv) {
                                void p0;
                                String string = (String)item$iv$iv;
                                Collection collection = destination$iv$iv;
                                boolean bl = false;
                                collection.add(OpenSshConfigViaToolServiceKt.access$parseForward((String)p0));
                            }
                            list2 = (List)destination$iv$iv;
                        } else {
                            list2 = CollectionsKt.emptyList();
                        }
                        return list2;
                    }
                });
                initialRemoteTcpForwardings2 = OpenSshConfigViaToolServiceKt.openSshConfigViaToolImpl$catching(errors, fallback.getInitialRemoteTcpForwardings(), (Function0)new Function0<List<? extends OpenSshConfigForwardInfo>>((Map<String, ? extends List<String>>)keyValue2){
                    final /* synthetic */ Map<String, List<String>> $keyValue;
                    {
                        this.$keyValue = $keyValue;
                        super(0);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @NotNull
                    public final List<OpenSshConfigForwardInfo> invoke() {
                        List list2;
                        List<String> list3 = this.$keyValue.get("remoteforward");
                        if (list3 != null) {
                            void $this$mapTo$iv$iv;
                            Iterable $this$map$iv = list3;
                            boolean $i$f$map = false;
                            Iterable iterable = $this$map$iv;
                            Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                            boolean $i$f$mapTo = false;
                            for (T item$iv$iv : $this$mapTo$iv$iv) {
                                void p0;
                                String string = (String)item$iv$iv;
                                Collection collection = destination$iv$iv;
                                boolean bl = false;
                                collection.add(OpenSshConfigViaToolServiceKt.access$parseForward((String)p0));
                            }
                            list2 = (List)destination$iv$iv;
                        } else {
                            list2 = CollectionsKt.emptyList();
                        }
                        return list2;
                    }
                });
                kexAlgorithms2 = OpenSshConfigViaToolServiceKt.openSshConfigViaToolImpl$catching(errors, fallback.getKexAlgorithms(), (Function0)new Function0<List<? extends String>>((Map<String, ? extends List<String>>)keyValue2){
                    final /* synthetic */ Map<String, List<String>> $keyValue;
                    {
                        this.$keyValue = $keyValue;
                        super(0);
                    }

                    @NotNull
                    public final List<String> invoke() {
                        return OpenSshConfigViaToolServiceKt.access$singleCommaDelimited(this.$keyValue, "kexalgorithms", true);
                    }
                });
                macs2 = OpenSshConfigViaToolServiceKt.openSshConfigViaToolImpl$catching(errors, fallback.getMacs(), (Function0)new Function0<List<? extends String>>((Map<String, ? extends List<String>>)keyValue2){
                    final /* synthetic */ Map<String, List<String>> $keyValue;
                    {
                        this.$keyValue = $keyValue;
                        super(0);
                    }

                    @NotNull
                    public final List<String> invoke() {
                        return OpenSshConfigViaToolServiceKt.access$singleCommaDelimited(this.$keyValue, "macs", true);
                    }
                });
                port2 = ((Number)OpenSshConfigViaToolServiceKt.openSshConfigViaToolImpl$catching(errors, fallback.getPort(), (Function0)new Function0<Integer>((Map<String, ? extends List<String>>)keyValue2){
                    final /* synthetic */ Map<String, List<String>> $keyValue;
                    {
                        this.$keyValue = $keyValue;
                        super(0);
                    }

                    @NotNull
                    public final Integer invoke() {
                        String it = OpenSshConfigViaToolServiceKt.access$singleString(this.$keyValue, "port");
                        boolean bl = false;
                        Integer n = StringsKt.toIntOrNull((String)it);
                        if (n == null) {
                            throw new ParsingError("Value of `port` is `" + it + "`, which is not a positive integer");
                        }
                        return (int)n;
                    }
                })).intValue();
                boolean bl6 = false;
                object = (List)keyValue2.get("proxyjump");
                if (object == null || (object = (String)CollectionsKt.singleOrNull((List)object)) == null) break block13;
                Object p03 = object;
                boolean bl7 = false;
                ProxyJumpOptions proxyJumpOptions = OpenSSHConfigUtil.parseJump((String)p03);
                object = proxyJumpOptions;
                if (proxyJumpOptions != null && (object = OpenSSHConfigUtil.toProxyCommand((ProxyJumpOptions)object)) != null) break block14;
            }
            List list4 = (List)keyValue2.get("proxycommand");
            object = list4 != null ? (String)CollectionsKt.singleOrNull((List)list4) : null;
        }
        SshProxyConfig.Command proxyConfig = (charSequence = (CharSequence)(v = object)) == null || charSequence.length() == 0 ? null : new SshProxyConfig.Command((String)v);
        ServerAlive serverAlive2 = OpenSshConfigViaToolServiceKt.openSshConfigViaToolImpl$catching(errors, fallback.getServerAlive(), (Function0)new Function0<ServerAlive>((Map<String, ? extends List<String>>)keyValue2){
            final /* synthetic */ Map<String, List<String>> $keyValue;
            {
                this.$keyValue = $keyValue;
                super(0);
            }

            @Nullable
            public final ServerAlive invoke() {
                ServerAlive serverAlive2;
                String countMaxKey = "serveralivecountmax";
                String it = OpenSshConfigViaToolServiceKt.access$singleString(this.$keyValue, countMaxKey);
                boolean bl = false;
                Integer n = StringsKt.toIntOrNull((String)it);
                if (n == null) {
                    throw new ParsingError("Value of `" + countMaxKey + " is `" + it + "`, which is not an integer");
                }
                int countMax = n;
                String intervalKey = "serveraliveinterval";
                String it2 = OpenSshConfigViaToolServiceKt.access$singleString(this.$keyValue, intervalKey);
                boolean bl2 = false;
                Long l = StringsKt.toLongOrNull((String)it2);
                if (l == null) {
                    throw new ParsingError("Value of `" + intervalKey + " is `" + it2 + "`, which is not an integer");
                }
                long interval = l;
                if (countMax <= 0 || interval <= 0L) {
                    serverAlive2 = null;
                } else {
                    Duration duration = Duration.ofSeconds(interval);
                    Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds(...)");
                    serverAlive2 = new ServerAlive(duration, countMax);
                }
                return serverAlive2;
            }
        });
        X11Forwarding x11Forwarding2 = OpenSshConfigViaToolServiceKt.openSshConfigViaToolImpl$catching(errors, fallback.getX11Forwarding(), (Function0)new Function0<X11Forwarding>((Map<String, ? extends List<String>>)keyValue2){
            final /* synthetic */ Map<String, List<String>> $keyValue;
            {
                this.$keyValue = $keyValue;
                super(0);
            }

            @Nullable
            public final X11Forwarding invoke() {
                return OpenSshConfigViaToolServiceKt.yesNo$default(this.$keyValue, "forwardx11", null, 2, null) ? new X11Forwarding(OpenSshConfigViaToolServiceKt.yesNo$default(this.$keyValue, "forwardx11trusted", null, 2, null), OpenSshConfigViaToolServiceKt.access$singleString(this.$keyValue, "xauthlocation"), null, 4, null) : null;
            }
        });
        if (!((Collection)errors).isEmpty()) {
            String string = "Got errors while was parsing output of `" + sshGCommandLine.getCommandLineString() + "`\n";
            String string2 = CollectionsKt.joinToString$default((Iterable)errors, (CharSequence)"\n", (CharSequence)string, null, (int)0, null, null, (int)60, null);
            string = new Attachment[]{new Attachment("stdout.txt", rawStdout), new Attachment("stderr.txt", rawStderr)};
            OpenSshConfigViaToolServiceKt.getLOG().error(string2, (Attachment[])string);
        }
        SshConnectionConfig sshConnectionConfig = new SshConnectionConfig(authMethods2, ciphers2, compression2, connectTimeout2, forwardAgent2, environmentVariables2, host2, hostKeyAlgorithms2, hostKeyVerifier2, identityAgent, initialLocalTcpForwardings2, initialRemoteTcpForwardings2, kexAlgorithms2, macs2, port2, proxyConfig, serverAlive2, user2, x11Forwarding2);
        String string = sshGCommandLine.getCommandLineString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCommandLineString(...)");
        return new ToolResult(sshConnectionConfig, rawStdout, rawStderr, string);
    }

    static /* synthetic */ ToolResult openSshConfigViaToolImpl$default(String string, List list2, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            String string3 = SystemProperties.getUserHome();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getUserHome(...)");
            string2 = string3;
        }
        return OpenSshConfigViaToolServiceKt.openSshConfigViaToolImpl(string, list2, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Pair<String, String> runToolAndGetStdio(String host2, GeneralCommandLine sshGCommandLine) {
        Pair pair;
        Disposable $this$use$iv = Disposer.newDisposable((String)("Read ssh_config for " + host2 + " via OpenSSH"));
        boolean $i$f$use = false;
        try {
            Integer exitCode;
            String string;
            Logger logger;
            String string2;
            Disposable disposable = $this$use$iv;
            boolean bl = false;
            StringBuilder stdoutBuilder = new StringBuilder();
            KillableProcessHandler process2 = new KillableProcessHandler(sshGCommandLine);
            StringBuilder stderrBuilder = new StringBuilder();
            process2.addProcessListener((ProcessListener)new ProcessAdapter(stdoutBuilder, stderrBuilder){
                final /* synthetic */ StringBuilder $stdoutBuilder;
                final /* synthetic */ StringBuilder $stderrBuilder;
                {
                    this.$stdoutBuilder = $stdoutBuilder;
                    this.$stderrBuilder = $stderrBuilder;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key<?> outputType) {
                    StringBuilder destination;
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
                    Object object = outputType;
                    StringBuilder stringBuilder = Intrinsics.areEqual(object, (Object)ProcessOutputTypes.STDOUT) ? this.$stdoutBuilder : (destination = Intrinsics.areEqual(object, (Object)ProcessOutputTypes.STDERR) ? this.$stderrBuilder : null);
                    if (destination != null) {
                        object = destination;
                        synchronized (object) {
                            boolean bl = false;
                            StringBuilder stringBuilder2 = destination.append(event.getText());
                        }
                    }
                }
            }, disposable);
            process2.startNotify();
            int durationSeconds = 10;
            process2.waitFor((long)durationSeconds * 1000L);
            StringBuilder stringBuilder = stderrBuilder;
            synchronized (stringBuilder) {
                boolean $i$a$-synchronized-OpenSshConfigViaToolServiceKt$runToolAndGetStdio$1$stderr$22 = false;
                String $i$a$-synchronized-OpenSshConfigViaToolServiceKt$runToolAndGetStdio$1$stderr$22 = stderrBuilder.toString();
                // MONITOREXIT @DISABLED, blocks:[0, 1, 3] lbl21 : MonitorExitStatement: MONITOREXIT : var10_10
                string2 = $i$a$-synchronized-OpenSshConfigViaToolServiceKt$runToolAndGetStdio$1$stderr$22;
            }
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"synchronized(...)");
            String stderr = string2;
            if (!StringsKt.isBlank((CharSequence)stderr)) {
                Logger $this$debug_u24default$iv = OpenSshConfigViaToolServiceKt.getLOG();
                Throwable e$iv = null;
                boolean $i$f$debug = false;
                if ($this$debug_u24default$iv.isDebugEnabled()) {
                    logger = $this$debug_u24default$iv;
                    boolean bl2 = false;
                    logger.debug("stderr of " + process2.getCommandLine() + ":\n" + stderr, e$iv);
                }
            }
            StringBuilder $i$f$debug = stdoutBuilder;
            synchronized ($i$f$debug) {
                boolean $i$a$-synchronized-OpenSshConfigViaToolServiceKt$runToolAndGetStdio$1$stdout$22 = false;
                String $i$a$-synchronized-OpenSshConfigViaToolServiceKt$runToolAndGetStdio$1$stdout$22 = stdoutBuilder.toString();
                // MONITOREXIT @DISABLED, blocks:[0, 2, 4] lbl44 : MonitorExitStatement: MONITOREXIT : $i$f$debug
                string = $i$a$-synchronized-OpenSshConfigViaToolServiceKt$runToolAndGetStdio$1$stdout$22;
            }
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"synchronized(...)");
            String stdout = string;
            Logger $this$trace$iv = OpenSshConfigViaToolServiceKt.getLOG();
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                logger = $this$trace$iv;
                boolean bl3 = false;
                logger.trace("stdout of " + process2.getCommandLine() + ":\n" + stdout);
            }
            Integer n = process2.getExitCode();
            if (n != null && n == 0) {
                TuplesKt.to((Object)stdout, (Object)stderr);
            }
            Integer n2 = exitCode = process2.getExitCode();
            if (n2 == null || n2 != 0) {
                if (exitCode == null) {
                    process2.killProcess();
                    String string3 = process2.getCommandLine();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getCommandLine(...)");
                    throw new SshConfigParseException(string3, null, stderr);
                }
                String string4 = process2.getCommandLine();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getCommandLine(...)");
                throw new SshConfigParseException(string4, exitCode, stderr);
            }
            pair = TuplesKt.to((Object)stdout, (Object)stderr);
        }
        finally {
            if ($this$use$iv != null) {
                Disposer.dispose((Disposable)$this$use$iv);
            }
        }
        return pair;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean yesNo(Map<String, ? extends List<String>> $this$yesNo, String key, Boolean bl) {
        String value;
        String string;
        List<String> list2 = $this$yesNo.get(key);
        if (list2 != null && (list2 = (String)CollectionsKt.singleOrNull(list2)) != null) {
            String string2 = ((String)((Object)list2)).toLowerCase(Locale.ROOT);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        } else {
            string = null;
        }
        String string3 = value = string;
        if (string3 != null) {
            switch (string3.hashCode()) {
                case 3521: {
                    if (value.equals("no")) return false;
                    throw new ParsingError("Value of `" + key + "` is `" + value + "`, which is neither `yes`, nor `no`");
                }
                case 119527: {
                    if (value.equals("yes")) return true;
                    throw new ParsingError("Value of `" + key + "` is `" + value + "`, which is neither `yes`, nor `no`");
                }
                case 3569038: {
                    if (value.equals("true")) return true;
                    throw new ParsingError("Value of `" + key + "` is `" + value + "`, which is neither `yes`, nor `no`");
                }
                case 97196323: {
                    if (value.equals("false")) return false;
                    throw new ParsingError("Value of `" + key + "` is `" + value + "`, which is neither `yes`, nor `no`");
                }
            }
            throw new ParsingError("Value of `" + key + "` is `" + value + "`, which is neither `yes`, nor `no`");
        }
        Boolean bl2 = bl;
        if (bl2 == null) throw new ParsingError("Value of `" + key + "` is not set, while expected `yes` or `no`");
        boolean bl3 = bl2;
        return bl3;
    }

    static /* synthetic */ boolean yesNo$default(Map map, String string, Boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = null;
        }
        return OpenSshConfigViaToolServiceKt.yesNo(map, string, bl);
    }

    private static final String singleString(Map<String, ? extends List<String>> $this$singleString, String key) {
        List<String> list2 = $this$singleString.get(key);
        if (list2 == null || (list2 = (String)CollectionsKt.singleOrNull(list2)) == null) {
            throw new ParsingError("No single `" + key + "` in output");
        }
        return list2;
    }

    private static final List<String> singleCommaDelimited(Map<String, ? extends List<String>> $this$singleCommaDelimited, String key, boolean obligatory) {
        char[] cArray;
        List<String> list2 = $this$singleCommaDelimited.get(key);
        if (list2 == null || (list2 = (String)CollectionsKt.singleOrNull(list2)) == null || (list2 = StringsKt.split$default((CharSequence)((CharSequence)((Object)list2)), (char[])(cArray = new char[]{','}), (boolean)false, (int)0, (int)6, null)) == null) {
            List list3;
            List it = list3 = CollectionsKt.emptyList();
            boolean bl = false;
            list2 = !obligatory ? list3 : null;
            if (list2 == null) {
                throw new ParsingError("No single `" + key + "` in output");
            }
        }
        return list2;
    }

    private static final List<String> singleSpaceDelimited(Map<String, ? extends List<String>> $this$singleSpaceDelimited, String key, boolean obligatory) {
        char[] cArray;
        List<String> list2 = $this$singleSpaceDelimited.get(key);
        if (list2 == null || (list2 = (String)CollectionsKt.singleOrNull(list2)) == null || (list2 = StringsKt.split$default((CharSequence)((CharSequence)((Object)list2)), (char[])(cArray = new char[]{' '}), (boolean)false, (int)0, (int)6, null)) == null) {
            List list3;
            List it = list3 = CollectionsKt.emptyList();
            boolean bl = false;
            list2 = !obligatory ? list3 : null;
            if (list2 == null) {
                throw new ParsingError("No single `" + key + "` in output");
            }
        }
        return list2;
    }

    static /* synthetic */ List singleSpaceDelimited$default(Map map, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return OpenSshConfigViaToolServiceKt.singleSpaceDelimited(map, string, bl);
    }

    private static final Long longOrNone(Map<String, ? extends List<String>> $this$longOrNone, String key) {
        Long l;
        List<String> list2;
        block7: {
            block6: {
                list2 = $this$longOrNone.get(key);
                if (list2 == null || (list2 = (String)CollectionsKt.singleOrNull(list2)) == null) break block6;
                String string = ((String)((Object)list2)).toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                list2 = string;
                if (string != null) break block7;
            }
            throw new ParsingError("No single `" + key + "` in output");
        }
        List<String> raw = list2;
        if (Intrinsics.areEqual((Object)raw, (Object)"none")) {
            l = null;
        } else {
            Long l2 = StringsKt.toLongOrNull((String)((Object)raw));
            if (l2 == null) {
                throw new ParsingError("Key `" + key + "` doesn't contain a long");
            }
            l = (long)l2;
        }
        return l;
    }

    private static final Path parsePath(String path, String userHome) {
        Path path2;
        try {
            Object object;
            if (StringsKt.startsWith$default((String)path, (String)"~/", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)path, (String)"~\\", (boolean)false, (int)2, null)) {
                String string = path.substring(1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                object = userHome + string;
            } else {
                object = path;
            }
            path2 = Path.of((String)object, new String[0]);
        }
        catch (IllegalArgumentException err) {
            OpenSshConfigViaToolServiceKt.getLOG().warn("Failed to parse path " + path);
            path2 = null;
        }
        return path2;
    }

    private static final OpenSshConfigForwardInfo parseForward(String raw) {
        Object object;
        try {
            OpenSshConfigForwardInfo openSshConfigForwardInfo;
            List list2;
            boolean bl = false;
            MatchResult matchResult = new Regex("(?:\\[(.*)]:)?(\\d+) \\[(.*)]:?(\\d+)").matchEntire((CharSequence)raw);
            if (matchResult != null && (list2 = matchResult.getGroupValues()) != null) {
                String string;
                List list3 = list2;
                boolean bl2 = false;
                String bindHost = (String)list3.get(1);
                String bindPort = (String)list3.get(2);
                String host2 = (String)list3.get(3);
                String port2 = (String)list3.get(4);
                String p0 = string = bindHost;
                boolean bl3 = false;
                String string2 = ((CharSequence)p0).length() > 0 ? string : null;
                if (string2 == null) {
                    string2 = "127.0.0.1";
                }
                p0 = string = host2;
                int n = Integer.parseInt(bindPort);
                String string3 = string2;
                boolean bl4 = false;
                boolean bl5 = ((CharSequence)p0).length() > 0;
                String string4 = bl5 ? string : null;
                if (string4 == null) {
                    string4 = "127.0.0.1";
                }
                int n2 = Integer.parseInt(port2);
                String string5 = string4;
                int n3 = n;
                String string6 = string3;
                openSshConfigForwardInfo = new OpenSshConfigForwardInfo(string6, n3, string5, n2);
            } else {
                openSshConfigForwardInfo = null;
            }
            object = Result.constructor-impl(openSshConfigForwardInfo);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        OpenSshConfigForwardInfo openSshConfigForwardInfo = (OpenSshConfigForwardInfo)(Result.isFailure-impl((Object)object) ? null : object);
        if (openSshConfigForwardInfo == null) {
            throw new ParsingError("Failed to parse port forwarding `" + raw + "`");
        }
        return openSshConfigForwardInfo;
    }

    private static final Pair<String, String> splitEq(String raw) {
        Object object = new char[]{'='};
        char[] it = object = (Object)StringsKt.split$default((CharSequence)raw, (char[])object, (boolean)false, (int)2, (int)2, null);
        boolean bl = false;
        char[] cArray = it.size() == 2 ? object : null;
        if (cArray == null) {
            throw new ParsingError("Failed to find '=' in " + raw);
        }
        char[] cArray2 = cArray;
        String k = (String)cArray2.get(0);
        String v = (String)cArray2.get(1);
        return TuplesKt.to((Object)k, (Object)v);
    }

    private static final Logger getLOG() {
        Lazy lazy = LOG$delegate;
        return (Logger)lazy.getValue();
    }

    private static final <T> T openSshConfigViaToolImpl$catching(Set<String> errors, T fallbackValue, Function0<? extends T> handler) {
        Object object;
        try {
            object = handler.invoke();
        }
        catch (ParsingError err) {
            Collection collection = errors;
            String string = err.getMessage();
            Intrinsics.checkNotNull((Object)string);
            collection.add(string);
            object = fallbackValue;
        }
        return (T)object;
    }

    public static final /* synthetic */ ToolResult access$openSshConfigViaToolImpl(String initialHost, List customSshCommand, String userHome) {
        return OpenSshConfigViaToolServiceKt.openSshConfigViaToolImpl(initialHost, customSshCommand, userHome);
    }

    public static final /* synthetic */ Logger access$getLOG() {
        return OpenSshConfigViaToolServiceKt.getLOG();
    }

    public static final /* synthetic */ String access$singleString(Map $receiver, String key) {
        return OpenSshConfigViaToolServiceKt.singleString($receiver, key);
    }

    public static final /* synthetic */ boolean access$yesNo(Map $receiver, String key, Boolean bl) {
        return OpenSshConfigViaToolServiceKt.yesNo($receiver, key, bl);
    }

    public static final /* synthetic */ List access$singleCommaDelimited(Map $receiver, String key, boolean obligatory) {
        return OpenSshConfigViaToolServiceKt.singleCommaDelimited($receiver, key, obligatory);
    }

    public static final /* synthetic */ Path access$parsePath(String path, String userHome) {
        return OpenSshConfigViaToolServiceKt.parsePath(path, userHome);
    }

    public static final /* synthetic */ Long access$longOrNone(Map $receiver, String key) {
        return OpenSshConfigViaToolServiceKt.longOrNone($receiver, key);
    }

    public static final /* synthetic */ Object access$openSshConfigViaToolImpl$catching(Set errors, Object fallbackValue, Function0 handler) {
        return OpenSshConfigViaToolServiceKt.openSshConfigViaToolImpl$catching(errors, fallbackValue, handler);
    }

    public static final /* synthetic */ Pair access$splitEq(String raw) {
        return OpenSshConfigViaToolServiceKt.splitEq(raw);
    }

    public static final /* synthetic */ List access$singleSpaceDelimited(Map $receiver, String key, boolean obligatory) {
        return OpenSshConfigViaToolServiceKt.singleSpaceDelimited($receiver, key, obligatory);
    }

    public static final /* synthetic */ OpenSshConfigForwardInfo access$parseForward(String raw) {
        return OpenSshConfigViaToolServiceKt.parseForward(raw);
    }
}

