/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.tasks;

import com.intellij.execution.BeforeRunTaskProvider;
import com.intellij.execution.Executor;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.impl.DefaultJavaProgramRunner;
import com.intellij.execution.impl.RunConfigurationBeforeRunProvider;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.execution.ParametersListUtil;
import icons.OpenapiIcons;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.execution.MavenEditGoalDialog;
import org.jetbrains.idea.maven.execution.MavenRunConfigurationType;
import org.jetbrains.idea.maven.execution.MavenRunnerParameters;
import org.jetbrains.idea.maven.model.MavenExplicitProfiles;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.tasks.MavenBeforeRunTask;
import org.jetbrains.idea.maven.tasks.TasksBundle;
import org.jetbrains.idea.maven.utils.MavenLog;

public final class MavenBeforeRunTasksProvider
extends BeforeRunTaskProvider<MavenBeforeRunTask> {
    public static final Key<MavenBeforeRunTask> ID = Key.create((String)"Maven.BeforeRunTask");
    private final Project myProject;

    public MavenBeforeRunTasksProvider(Project project2) {
        this.myProject = project2;
    }

    public Key<MavenBeforeRunTask> getId() {
        return ID;
    }

    public String getName() {
        return TasksBundle.message("maven.tasks.before.run.empty", new Object[0]);
    }

    public Icon getIcon() {
        return OpenapiIcons.RepositoryLibraryLogo;
    }

    @Nullable
    public Icon getTaskIcon(MavenBeforeRunTask task) {
        return OpenapiIcons.RepositoryLibraryLogo;
    }

    public String getDescription(MavenBeforeRunTask task) {
        MavenProject mavenProject2 = this.getMavenProject(task);
        if (mavenProject2 == null) {
            return TasksBundle.message("maven.tasks.before.run.empty", new Object[0]);
        }
        String desc = mavenProject2.getDisplayName() + ": " + StringUtil.notNullize((String)task.getGoal()).trim();
        return TasksBundle.message("maven.tasks.before.run", desc);
    }

    @Nullable
    private MavenProject getMavenProject(MavenBeforeRunTask task) {
        String pomXmlPath = task.getProjectPath();
        if (StringUtil.isEmpty((String)pomXmlPath)) {
            return null;
        }
        VirtualFile file = LocalFileSystem.getInstance().findFileByPath(pomXmlPath);
        if (file == null) {
            return null;
        }
        return MavenProjectsManager.getInstance(this.myProject).findProject(file);
    }

    public boolean isConfigurable() {
        return true;
    }

    public MavenBeforeRunTask createTask(@NotNull RunConfiguration runConfiguration) {
        if (runConfiguration == null) {
            MavenBeforeRunTasksProvider.$$$reportNull$$$0(0);
        }
        return new MavenBeforeRunTask();
    }

    public boolean configureTask(@NotNull RunConfiguration runConfiguration, @NotNull MavenBeforeRunTask task) {
        if (runConfiguration == null) {
            MavenBeforeRunTasksProvider.$$$reportNull$$$0(1);
        }
        if (task == null) {
            MavenBeforeRunTasksProvider.$$$reportNull$$$0(2);
        }
        MavenEditGoalDialog dialog = new MavenEditGoalDialog(this.myProject);
        dialog.setTitle(TasksBundle.message("maven.tasks.select.goal.title", new Object[0]));
        if (task.getGoal() == null) {
            MavenProjectsManager projectsManager = MavenProjectsManager.getInstance(this.myProject);
            List<MavenProject> rootProjects2 = projectsManager.getRootProjects();
            if (rootProjects2.size() > 0) {
                dialog.setSelectedMavenProject(rootProjects2.get(0));
            } else {
                dialog.setSelectedMavenProject(null);
            }
        } else {
            String goals = (String)MavenBeforeRunTasksProvider.splitToGoalsAndPomFileName((String)task.getGoal()).first;
            MavenProject mavenProject2 = this.getMavenProject(task);
            if (mavenProject2 != null) {
                String pomFileName = mavenProject2.getFile().getName();
                if (FileUtil.namesEqual((String)pomFileName, (String)"pom.xml")) {
                    dialog.setGoals(goals);
                } else {
                    dialog.setGoals(goals + " -f " + ParametersListUtil.join((String[])new String[]{pomFileName}));
                }
                dialog.setSelectedMavenProject(mavenProject2);
            } else {
                dialog.setGoals(goals);
                dialog.setSelectedMavenProject(null);
            }
        }
        if (!dialog.showAndGet()) {
            return false;
        }
        Pair<String, String> goalsAndPomFileName = MavenBeforeRunTasksProvider.splitToGoalsAndPomFileName(dialog.getGoals());
        task.setProjectPath(dialog.getWorkDirectory() + "/" + (String)goalsAndPomFileName.second);
        task.setGoal((String)goalsAndPomFileName.first);
        return true;
    }

    public boolean canExecuteTask(@NotNull RunConfiguration configuration, @NotNull MavenBeforeRunTask task) {
        if (configuration == null) {
            MavenBeforeRunTasksProvider.$$$reportNull$$$0(3);
        }
        if (task == null) {
            MavenBeforeRunTasksProvider.$$$reportNull$$$0(4);
        }
        return task.getGoal() != null && task.getProjectPath() != null;
    }

    public boolean executeTask(@NotNull DataContext context2, @NotNull RunConfiguration configuration, @NotNull ExecutionEnvironment env, @NotNull MavenBeforeRunTask task) {
        if (context2 == null) {
            MavenBeforeRunTasksProvider.$$$reportNull$$$0(5);
        }
        if (configuration == null) {
            MavenBeforeRunTasksProvider.$$$reportNull$$$0(6);
        }
        if (env == null) {
            MavenBeforeRunTasksProvider.$$$reportNull$$$0(7);
        }
        if (task == null) {
            MavenBeforeRunTasksProvider.$$$reportNull$$$0(8);
        }
        ApplicationManager.getApplication().invokeAndWait(() -> FileDocumentManager.getInstance().saveAllDocuments());
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(context2);
        if (((Boolean)ReadAction.compute(() -> project2 == null || project2.isDisposed())).booleanValue()) {
            return false;
        }
        return this.doRunMavenTask(project2, task, env);
    }

    private boolean doRunMavenTask(Project project2, MavenBeforeRunTask task, ExecutionEnvironment env) {
        MavenProject mavenProject2 = this.getMavenProject(task);
        if (mavenProject2 == null) {
            return false;
        }
        MavenExplicitProfiles explicitProfiles2 = MavenProjectsManager.getInstance(project2).getExplicitProfiles();
        MavenRunnerParameters params = new MavenRunnerParameters(true, mavenProject2.getDirectory(), mavenProject2.getFile().getName(), ParametersListUtil.parse((String)task.getGoal()), explicitProfiles2.getEnabledProfiles(), explicitProfiles2.getDisabledProfiles());
        RunnerAndConfigurationSettings configuration = MavenRunConfigurationType.createRunnerAndConfigurationSettings(null, null, params, this.myProject);
        ProgramRunner runner = DefaultJavaProgramRunner.getInstance();
        Executor executor = DefaultRunExecutor.getRunExecutorInstance();
        ExecutionEnvironment environment = new ExecutionEnvironment(executor, runner, configuration, project2);
        environment.setExecutionId(env.getExecutionId());
        if (!environment.getRunner().canRun(executor.getId(), environment.getRunProfile())) {
            MavenLog.LOG.warn("Can't run " + task.getGoal() + " on runner=" + runner.getRunnerId() + ", executorId=" + executor.getId());
            return false;
        }
        return RunConfigurationBeforeRunProvider.doRunTask((String)executor.getId(), (ExecutionEnvironment)environment, (ProgramRunner)runner);
    }

    @NotNull
    private static Pair<String, String> splitToGoalsAndPomFileName(@Nullable String goals) {
        if (goals == null) {
            Pair pair = Pair.pair(null, (Object)"pom.xml");
            if (pair == null) {
                MavenBeforeRunTasksProvider.$$$reportNull$$$0(9);
            }
            return pair;
        }
        List commandLine = ParametersListUtil.parse((String)goals);
        int pomFileNameIndex = 1 + commandLine.indexOf("-f");
        if (pomFileNameIndex != 0 && pomFileNameIndex < commandLine.size()) {
            String pomFileName = (String)commandLine.remove(pomFileNameIndex);
            commandLine.remove(pomFileNameIndex - 1);
            Pair pair = Pair.pair((Object)ParametersListUtil.join((List)commandLine), (Object)pomFileName);
            if (pair == null) {
                MavenBeforeRunTasksProvider.$$$reportNull$$$0(10);
            }
            return pair;
        }
        Pair pair = Pair.pair((Object)goals, (Object)"pom.xml");
        if (pair == null) {
            MavenBeforeRunTasksProvider.$$$reportNull$$$0(11);
        }
        return pair;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 2: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/tasks/MavenBeforeRunTasksProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/tasks/MavenBeforeRunTasksProvider";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "splitToGoalsAndPomFileName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createTask";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "configureTask";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "canExecuteTask";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "executeTask";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9, 10, 11 -> new IllegalStateException(string);
        };
    }
}

