/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.navigator.structure;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.ui.UiUtils;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.util.ObjectUtils;
import icons.MavenIcons;
import java.awt.Color;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.idea.maven.model.MavenProjectProblem;
import org.jetbrains.idea.maven.navigator.MavenProjectsNavigator;
import org.jetbrains.idea.maven.navigator.structure.DependenciesNode;
import org.jetbrains.idea.maven.navigator.structure.LifecycleNode;
import org.jetbrains.idea.maven.navigator.structure.MavenProjectNode;
import org.jetbrains.idea.maven.navigator.structure.MavenProjectsStructure;
import org.jetbrains.idea.maven.navigator.structure.MavenSimpleNode;
import org.jetbrains.idea.maven.navigator.structure.PluginsNode;
import org.jetbrains.idea.maven.navigator.structure.ProjectsGroupNode;
import org.jetbrains.idea.maven.navigator.structure.RepositoriesNode;
import org.jetbrains.idea.maven.navigator.structure.RepositoryNode;
import org.jetbrains.idea.maven.navigator.structure.RunConfigurationsNode;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectBundle;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenUtil;

class ProjectNode
extends ProjectsGroupNode
implements MavenProjectNode {
    private static final URL ERROR_ICON_URL = MavenProjectsStructure.class.getResource("/general/error.png");
    private final MavenProject myMavenProject;
    private final LifecycleNode myLifecycleNode;
    private final PluginsNode myPluginsNode;
    private final DependenciesNode myDependenciesNode;
    private final RunConfigurationsNode myRunConfigurationsNode;
    private final RepositoriesNode myRepositoriesNode;
    private @NlsContexts.Tooltip String myTooltipCache;

    ProjectNode(MavenProjectsStructure structure, @NotNull MavenProject mavenProject2) {
        if (mavenProject2 == null) {
            ProjectNode.$$$reportNull$$$0(0);
        }
        super(structure, null);
        this.myMavenProject = mavenProject2;
        this.myLifecycleNode = new LifecycleNode(structure, this);
        this.myPluginsNode = new PluginsNode(structure, this);
        this.myRepositoriesNode = new RepositoriesNode(structure, this);
        this.myDependenciesNode = new DependenciesNode(structure, this, mavenProject2);
        this.myRunConfigurationsNode = new RunConfigurationsNode(structure, this);
        this.getTemplatePresentation().setIcon(MavenIcons.MavenProject);
    }

    @Override
    public MavenSimpleNode.MavenNodeType getType() {
        return MavenSimpleNode.MavenNodeType.PROJECT;
    }

    @Override
    public MavenProject getMavenProject() {
        return this.myMavenProject;
    }

    public ProjectsGroupNode getGroup() {
        return (ProjectsGroupNode)super.getParent();
    }

    @Override
    public boolean isVisible() {
        if (!this.getProjectsNavigator().getShowIgnored() && this.getProjectsManager().isIgnored(this.myMavenProject)) {
            return false;
        }
        return super.isVisible();
    }

    private MavenProjectsManager getProjectsManager() {
        return this.myMavenProjectsStructure.getProjectsManager();
    }

    private MavenProjectsNavigator getProjectsNavigator() {
        return this.myMavenProjectsStructure.getProjectsNavigator();
    }

    @Override
    protected List<? extends MavenSimpleNode> doGetChildren() {
        CopyOnWriteArrayList<DependenciesNode> children = new CopyOnWriteArrayList<DependenciesNode>(List.of(this.myLifecycleNode, this.myPluginsNode, this.myRunConfigurationsNode, this.myDependenciesNode));
        if (this.isRoot()) {
            children.add((DependenciesNode)((Object)this.myRepositoriesNode));
        }
        children.addAll(super.doGetChildren());
        return children;
    }

    void updateProject() {
        this.setErrorLevel(this.myMavenProject.getCacheProblems().isEmpty() ? MavenProjectsStructure.ErrorLevel.NONE : MavenProjectsStructure.ErrorLevel.ERROR);
        this.myLifecycleNode.updateGoalsList();
        this.myPluginsNode.updatePlugins(this.myMavenProject);
        if (this.isRoot()) {
            this.myRepositoriesNode.updateRepositories(this.myProject);
        }
        if (this.myMavenProjectsStructure.getDisplayMode() == MavenProjectsStructure.MavenStructureDisplayMode.SHOW_ALL) {
            this.myDependenciesNode.updateDependencies();
        }
        this.myRunConfigurationsNode.updateRunConfigurations(this.myMavenProject);
        this.myTooltipCache = this.makeDescription();
        this.myMavenProjectsStructure.updateFrom(this.getParent());
    }

    public void updateIgnored() {
        this.getGroup().childrenChanged();
    }

    public void updateGoals() {
        this.myMavenProjectsStructure.updateFrom((SimpleNode)this.myLifecycleNode);
        this.myMavenProjectsStructure.updateFrom((SimpleNode)this.myPluginsNode);
    }

    public void updateRunConfigurations() {
        this.myRunConfigurationsNode.updateRunConfigurations(this.myMavenProject);
        this.myMavenProjectsStructure.updateFrom((SimpleNode)this.myRunConfigurationsNode);
    }

    public String getName() {
        if (this.getProjectsNavigator().getAlwaysShowArtifactId()) {
            return this.myMavenProject.getMavenId().getArtifactId();
        }
        return this.myMavenProject.getDisplayName();
    }

    @Override
    protected void doUpdate(@NotNull PresentationData presentation) {
        if (presentation == null) {
            ProjectNode.$$$reportNull$$$0(1);
        }
        String hint = null;
        if (!this.getProjectsNavigator().getGroupModules() && this.isRoot() && this.getProjectsManager().getProjects().size() > this.getProjectsManager().getRootProjects().size()) {
            hint = "root";
        }
        this.setNameAndTooltip(presentation, this.getName(), this.myTooltipCache, hint);
    }

    private boolean isRoot() {
        return this.getProjectsManager().findAggregator(this.myMavenProject) == null;
    }

    protected SimpleTextAttributes getPlainAttributes() {
        if (this.getProjectsManager().isIgnored(this.myMavenProject)) {
            return new SimpleTextAttributes(0, (Color)JBColor.GRAY);
        }
        return super.getPlainAttributes();
    }

    @NlsContexts.DetailedDescription
    private String makeDescription() {
        StringBuilder desc = new StringBuilder();
        desc.append("<html>").append("<table>");
        desc.append("<tr>").append("<td nowrap>").append("<table>").append("<tr>").append("<td nowrap>").append(MavenProjectBundle.message("detailed.description.project", new Object[0])).append("</td>").append("<td nowrap>").append(this.myMavenProject.getMavenId()).append("</td>").append("</tr>").append("<tr>").append("<td nowrap>").append(MavenProjectBundle.message("detailed.description.location", new Object[0])).append("</td>").append("<td nowrap>").append(UiUtils.getPresentablePath((String)this.myMavenProject.getPath())).append("</td>").append("</tr>").append("</table>").append("</td>").append("</tr>");
        this.appendProblems(desc);
        desc.append("</table>").append("</html>");
        return desc.toString();
    }

    private void appendProblems(StringBuilder desc) {
        List<MavenProjectProblem> problems = this.myMavenProject.getCacheProblems();
        if (problems.isEmpty()) {
            return;
        }
        desc.append("<tr><td nowrap><table>");
        boolean first = true;
        for (MavenProjectProblem each : problems) {
            desc.append("<tr>");
            if (first) {
                desc.append("<td nowrap valign=top>").append(MavenUtil.formatHtmlImage(ERROR_ICON_URL)).append("</td>");
                desc.append("<td nowrap valign=top>").append(MavenProjectBundle.message("detailed.description.problems", new Object[0])).append("</td>");
                first = false;
            } else {
                desc.append("<td nowrap colspan=2></td>");
            }
            desc.append("<td nowrap valign=top>").append(ProjectNode.wrappedText(each)).append("</td>");
            desc.append("</tr>");
        }
        desc.append("</table></td></tr>");
    }

    RepositoriesNode getRepositoriesNode() {
        return this.myRepositoriesNode;
    }

    private static String wrappedText(MavenProjectProblem each) {
        String description = (String)ObjectUtils.chooseNotNull((Object)each.getDescription(), (Object)each.getPath());
        if (description == null) {
            return "";
        }
        String text2 = StringUtil.replace((String)description, Arrays.asList("<", ">"), Arrays.asList("&lt;", "&gt;"));
        StringBuilder result2 = new StringBuilder();
        int count = 0;
        for (int i2 = 0; i2 < text2.length(); ++i2) {
            char ch = text2.charAt(i2);
            result2.append(ch);
            if (count++ <= 80 || ch != ' ') continue;
            count = 0;
            result2.append("<br>");
        }
        return result2.toString();
    }

    @Override
    public VirtualFile getVirtualFile() {
        return this.myMavenProject.getFile();
    }

    @Override
    protected void setNameAndTooltip(@NotNull PresentationData presentation, String name, @Nullable String tooltip, SimpleTextAttributes attributes) {
        if (presentation == null) {
            ProjectNode.$$$reportNull$$$0(2);
        }
        super.setNameAndTooltip(presentation, name, tooltip, attributes);
        if (this.getProjectsNavigator().getShowVersions()) {
            presentation.addText(":" + this.myMavenProject.getMavenId().getVersion(), new SimpleTextAttributes(0, (Color)JBColor.GRAY));
        }
    }

    @TestOnly
    public PluginsNode getPluginsNode() {
        return this.myPluginsNode;
    }

    @TestOnly
    public List<RepositoryNode> getListOfRepositoryNodes() {
        return this.myRepositoriesNode.doGetChildren();
    }

    @Override
    @Nullable
    @NonNls
    protected String getMenuId() {
        return "Maven.NavigatorProjectMenu";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mavenProject";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/maven/navigator/structure/ProjectNode";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "doUpdate";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setNameAndTooltip";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

