/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.indices;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.messages.Topic;
import java.io.File;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.indices.MavenRepositoryIndex;
import org.jetbrains.idea.maven.model.MavenArtifactInfo;
import org.jetbrains.idea.maven.model.MavenRepositoryInfo;
import org.jetbrains.idea.maven.model.RepositoryKind;

public interface MavenSearchIndex
extends MavenRepositoryIndex {
    @Topic.AppLevel
    public static final Topic<IndexListener> INDEX_IS_BROKEN = new Topic("Maven Index Broken Listener", IndexListener.class);

    @NlsSafe
    default public String getRepositoryId() {
        return this.getRepository().getId();
    }

    @Nullable
    default public File getRepositoryFile() {
        MavenRepositoryInfo repository2 = this.getRepository();
        if (repository2.getKind() == RepositoryKind.LOCAL) {
            return new File(repository2.getUrl());
        }
        return null;
    }

    @NlsSafe
    default public String getRepositoryUrl() {
        MavenRepositoryInfo repository2 = this.getRepository();
        if (repository2.getKind() == RepositoryKind.REMOTE) {
            return repository2.getUrl();
        }
        return null;
    }

    @NlsSafe
    default public String getRepositoryPathOrUrl() {
        return this.getRepository().getUrl();
    }

    @NlsSafe
    public String getFailureMessage();

    public Set<MavenArtifactInfo> search(String var1, int var2);

    public static interface IndexListener {
        public void indexIsBroken(@NotNull MavenSearchIndex var1);
    }
}

